/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.TwipsConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ColumnStyle
extends Style
implements Cloneable {
    private int colWidth = 0;

    public ColumnStyle(Node node, StyleCatalog styleCatalog) {
        super(node, styleCatalog);
        int n;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                Node node2 = namedNodeMap.item(n);
                this.handleAttribute(node2.getNodeName(), node2.getNodeValue());
            }
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                NamedNodeMap namedNodeMap2;
                Node node3 = nodeList.item(i);
                String string = node3.getNodeName();
                if (!string.equals("style:properties") || (namedNodeMap2 = node3.getAttributes()) == null) continue;
                int n3 = namedNodeMap2.getLength();
                for (int j = 0; j < n3; ++j) {
                    Node node4 = namedNodeMap2.item(j);
                    this.handleAttribute(node4.getNodeName(), node4.getNodeValue());
                }
            }
        }
    }

    public ColumnStyle(String string, String string2, String string3, int n, StyleCatalog styleCatalog) {
        super(string, string2, string3, styleCatalog);
        this.colWidth = n;
    }

    public int getColWidth() {
        return this.colWidth;
    }

    public void setColWidth(int n) {
        this.colWidth = n;
    }

    private int parseColWidth(String string) {
        return TwipsConverter.convert2twips(string, 255);
    }

    private void handleAttribute(String string, String string2) {
        if (string.equals("style:column-width")) {
            this.colWidth = this.parseColWidth(string2);
        } else {
            Debug.log(1, "ColumnStyle Unhandled: " + string + "=" + string2);
        }
    }

    public Style getResolved() {
        ColumnStyle columnStyle = null;
        try {
            columnStyle = (ColumnStyle)this.clone();
        }
        catch (Exception exception) {
            Debug.log(2, "Can't clone", exception);
        }
        ColumnStyle columnStyle2 = null;
        if (this.sc != null) {
            if (this.parent != null) {
                columnStyle2 = (ColumnStyle)this.sc.lookup(this.parent, this.family, null, this.getClass());
                if (columnStyle2 == null) {
                    Debug.log(2, "parent style lookup of " + this.parent + " failed!");
                } else {
                    columnStyle2 = (ColumnStyle)columnStyle2.getResolved();
                }
            } else if (!this.name.equals("DEFAULT_STYLE")) {
                columnStyle2 = (ColumnStyle)this.sc.lookup("DEFAULT_STYLE", null, null, this.getClass());
            }
        }
        if (columnStyle2 != null) {
            columnStyle2 = (ColumnStyle)columnStyle2.getResolved();
            if (this.colWidth == 0 && columnStyle2.getColWidth() != 0) {
                columnStyle.setColWidth(columnStyle2.getColWidth());
            }
        }
        return columnStyle;
    }

    public Node createNode(Document document, String string) {
        Element element = document.createElement(string);
        this.writeAttributes(element);
        return element;
    }

    public boolean isSubset(Style style) {
        if (style.getClass() != this.getClass()) {
            return false;
        }
        ColumnStyle columnStyle = (ColumnStyle)style;
        return this.colWidth == columnStyle.getColWidth();
    }

    private void writeAttributes(Element element) {
        if (this.colWidth != 0) {
            String string = TwipsConverter.twips2cm(this.colWidth) + "cm";
            element.setAttribute("style:column-width", string);
        }
    }
}

