/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.servlet.JspServletWrapper;

public final class JspRuntimeContext
implements Runnable {
    private ServletContext context;
    private Options options;
    private URLClassLoader parentClassLoader;
    private PermissionCollection permissionCollection;
    private CodeSource codeSource;
    private String classpath;
    private Map jsps = Collections.synchronizedMap(new HashMap());
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "JspRuntimeContext";

    public JspRuntimeContext(ServletContext context, Options options) {
        this.context = context;
        this.options = options;
        this.parentClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        if (this.parentClassLoader == null) {
            this.parentClassLoader = (URLClassLoader)this.getClass().getClassLoader();
        }
        if (this.parentClassLoader != null) {
            Constants.message((String)"jsp.message.parent_class_loader_is", (Object[])new Object[]{this.parentClassLoader.toString()}, (int)4);
        } else {
            Constants.message((String)"jsp.message.parent_class_loader_is", (Object[])new Object[]{"<none>"}, (int)4);
        }
        this.initSecurity();
        this.initClassPath();
        String appBase = context.getRealPath("/");
        if (!options.getDevelopment() && appBase != null && options.getReloading()) {
            if (appBase.endsWith(File.separator)) {
                appBase = appBase.substring(0, appBase.length() - 1);
            }
            String directory = appBase.substring(appBase.lastIndexOf(File.separator));
            this.threadName = this.threadName + "[" + directory + "]";
            this.threadStart();
        }
    }

    public void addWrapper(String jspUri, JspServletWrapper jsw) {
        this.jsps.remove(jspUri);
        this.jsps.put(jspUri, jsw);
    }

    public JspServletWrapper getWrapper(String jspUri) {
        return (JspServletWrapper)this.jsps.get(jspUri);
    }

    public void removeWrapper(String jspUri) {
        this.jsps.remove(jspUri);
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public URLClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public PermissionCollection getPermissionCollection() {
        return this.permissionCollection;
    }

    public void destroy() {
        this.threadStop();
        Iterator servlets = this.jsps.values().iterator();
        while (servlets.hasNext()) {
            ((JspServletWrapper)servlets.next()).destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCompile() {
        Object[] wrappers = this.jsps.values().toArray();
        for (int i = 0; i < wrappers.length; ++i) {
            JspServletWrapper jsw = (JspServletWrapper)wrappers[i];
            JspCompilationContext ctxt = jsw.getJspEngineContext();
            JspServletWrapper jspServletWrapper = jsw;
            synchronized (jspServletWrapper) {
                try {
                    ctxt.compile();
                }
                catch (FileNotFoundException ex) {
                    ctxt.incrementRemoved();
                }
                catch (Throwable t) {
                    jsw.getServletContext().log("Background compile failed", t);
                }
                continue;
            }
        }
    }

    public String getClassPath() {
        return this.classpath;
    }

    private void initClassPath() {
        URL[] urls = this.parentClassLoader.getURLs();
        StringBuffer cpath = new StringBuffer();
        String sep = System.getProperty("path.separator");
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].getProtocol().equals("file")) continue;
            cpath.append(urls[i].getFile() + sep);
        }
        String cp = (String)this.context.getAttribute("org.apache.catalina.jsp_classpath");
        if (cp == null || cp.equals("")) {
            cp = this.options.getClassPath();
        }
        this.classpath = cpath.toString() + cp;
    }

    private void initSecurity() {
        Policy policy = Policy.getPolicy();
        if (policy != null) {
            try {
                String codeBase;
                String docBase = this.context.getRealPath("/");
                if (docBase == null) {
                    docBase = this.options.getScratchDir().toString();
                }
                if (!(codeBase = docBase).endsWith(File.separator)) {
                    codeBase = codeBase + File.separator;
                }
                File contextDir = new File(codeBase);
                URL url = contextDir.getCanonicalFile().toURL();
                this.codeSource = new CodeSource(url, null);
                this.permissionCollection = policy.getPermissions(this.codeSource);
                if (!docBase.endsWith(File.separator)) {
                    this.permissionCollection.add(new FilePermission(docBase, "read"));
                    docBase = docBase + File.separator;
                } else {
                    this.permissionCollection.add(new FilePermission(docBase.substring(0, docBase.length() - 1), "read"));
                }
                docBase = docBase + "-";
                this.permissionCollection.add(new FilePermission(docBase, "read"));
                String workDir = this.options.getScratchDir().toString();
                if (!workDir.endsWith(File.separator)) {
                    this.permissionCollection.add(new FilePermission(workDir, "read"));
                    workDir = workDir + File.separator;
                }
                workDir = workDir + "-";
                this.permissionCollection.add(new FilePermission(workDir, "read"));
                this.permissionCollection.add(new RuntimePermission("accessClassInPackage.org.apache.jasper.runtime"));
                if (this.parentClassLoader instanceof URLClassLoader) {
                    URL[] urls = this.parentClassLoader.getURLs();
                    String jarUrl = null;
                    String jndiUrl = null;
                    for (int i = 0; i < urls.length; ++i) {
                        if (jndiUrl == null && urls[i].toString().startsWith("jndi:")) {
                            jndiUrl = urls[i].toString() + "-";
                        }
                        if (jarUrl != null || !urls[i].toString().startsWith("jar:jndi:")) continue;
                        jarUrl = urls[i].toString();
                        jarUrl = jarUrl.substring(0, jarUrl.length() - 2);
                        jarUrl = jarUrl.substring(0, jarUrl.lastIndexOf(47)) + "/-";
                    }
                    if (jarUrl != null) {
                        this.permissionCollection.add(new FilePermission(jarUrl, "read"));
                        this.permissionCollection.add(new FilePermission(jarUrl.substring(4), "read"));
                    }
                    if (jndiUrl != null) {
                        this.permissionCollection.add(new FilePermission(jndiUrl, "read"));
                    }
                }
            }
            catch (Exception e) {
                this.context.log("Security Init for context failed", (Throwable)e);
            }
        }
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    protected void threadSleep() {
        try {
            Thread.sleep((long)this.options.getCheckInterval() * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            try {
                this.checkCompile();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static {
        JspFactoryImpl factory = new JspFactoryImpl();
        if (System.getSecurityManager() != null) {
            String basePackage = "org.apache.jasper.";
            try {
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedGetPageContext");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedReleasePageContext");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary$PrivilegedIntrospectHelper");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.ServletResponseWrapperInclude");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.TagHandlerPool");
                factory.getClass().getClassLoader().loadClass(basePackage + "servlet.JspServletWrapper");
            }
            catch (ClassNotFoundException ex) {
                System.out.println("Jasper JspRuntimeContext preload of class failed: " + ex.getMessage());
            }
        }
        JspFactory.setDefaultFactory((JspFactory)factory);
    }
}

