/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifierOperation;
import org.eclipse.jdt.internal.corext.buildpath.IClasspathInformationProvider;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;

public class IncludeOperation
extends ClasspathModifierOperation {
    public IncludeOperation(ClasspathModifier.IClasspathModifierListener listener, IClasspathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Include_tooltip, 10);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            List elements = this.getSelectedElements();
            IJavaProject project = this.fInformationProvider.getJavaProject();
            result = this.include(elements, project, monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    public boolean isValid(List elements, int[] types) throws JavaModelException {
        if (elements.size() == 0) {
            return false;
        }
        IJavaProject project = this.fInformationProvider.getJavaProject();
        int i = 0;
        while (i < elements.size()) {
            Object element = elements.get(i);
            switch (types[i]) {
                case 3: {
                    break;
                }
                case 6: {
                    if (this.isValidFolder((IResource)element, project)) break;
                    return false;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean isValidFolder(IResource resource, IJavaProject project) throws JavaModelException {
        if (project.isOnClasspath((IJavaElement)project) && resource.getProjectRelativePath().segmentCount() == 1) {
            IPackageFragmentRoot root1 = ClasspathModifier.getFragmentRoot(resource, project, null);
            IPackageFragmentRoot root2 = ClasspathModifier.getFragmentRoot(project.getResource(), project, null);
            if (root1 != null && root1.equals(root2)) {
                return true;
            }
        }
        return false;
    }

    public String getDescription(int type) {
        if (type == 3) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Include;
        }
        if (type == 4) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Include;
        }
        if (type == 6) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Include;
        }
        if (type == 7) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Include;
        }
        if (type == 8) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Include;
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Include;
    }
}

