/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.operations.IInstallFeatureOperation;

public class FeatureSorter
extends ViewerSorter {
    public static final int FEATURE_VERSION = 1;
    public static final int FEATURE_LABEL = 2;
    public static final int FEATURE_PROVIDER = 3;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    private int key = 2;
    private int labelOrder;
    private int versionOrder;
    private int providerOrder;

    public FeatureSorter() {
        this(2, 1, 1, 1);
    }

    public FeatureSorter(int key, int labelOrder, int versionOrder, int providerOrder) {
        this.key = key;
        this.labelOrder = labelOrder;
        this.versionOrder = versionOrder;
        this.providerOrder = providerOrder;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!(e1 instanceof IInstallFeatureOperation) || !(e2 instanceof IInstallFeatureOperation)) {
            return super.compare(viewer, e1, e2);
        }
        IFeature f1 = ((IInstallFeatureOperation)e1).getFeature();
        IFeature f2 = ((IInstallFeatureOperation)e2).getFeature();
        PluginVersionIdentifier v1 = f1.getVersionedIdentifier().getVersion();
        PluginVersionIdentifier v2 = f2.getVersionedIdentifier().getVersion();
        String label1 = f1.getLabel() == null ? "" : f1.getLabel();
        String label2 = f2.getLabel() == null ? "" : f2.getLabel();
        String provider1 = f1.getProvider() == null ? "" : f1.getProvider();
        String provider2 = f2.getProvider() == null ? "" : f2.getProvider();
        int result = 0;
        if (this.key == 1) {
            result = this.compareVersions(v1, v2) * this.versionOrder;
            if (result == 0 && (result = this.collator.compare(label1, label2) * this.labelOrder) == 0) {
                result = this.collator.compare(provider1, provider2) * this.providerOrder;
            }
        } else if (this.key == 2) {
            result = this.collator.compare(label1, label2) * this.labelOrder;
            if (result == 0 && (result = this.compareVersions(v1, v2) * this.versionOrder) == 0) {
                result = this.collator.compare(provider1, provider2) * this.providerOrder;
            }
        } else if (this.key == 3 && (result = this.collator.compare(provider1, provider2) * this.providerOrder) == 0 && (result = this.collator.compare(label1, label2) * this.labelOrder) == 0) {
            result = this.compareVersions(v1, v2) * this.versionOrder;
        }
        return result;
    }

    private int compareVersions(PluginVersionIdentifier v1, PluginVersionIdentifier v2) {
        if (v1.equals((Object)v2)) {
            return 0;
        }
        return v2.isGreaterThan(v1) ? -1 : 1;
    }
}

