/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.ui.extract;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.wst.rdb.data.internal.core.extract.ExtractData;
import org.eclipse.wst.rdb.data.internal.ui.FileFormatWizardPage;
import org.eclipse.wst.rdb.data.internal.ui.OutputItemAdapter;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputViewAPI;


public class ExtractDataWizard extends Wizard
{

    protected Table table;
    
    protected FileFormatWizardPage page;
    
    public ExtractDataWizard(Table table)
    {
        this.table = table;
        setWindowTitle(Messages.getString("ExtractDataWizard.ExtractData")); //$NON-NLS-1$
    }
    
    public void addPages() {
        page = new ExtractDataWizardPage("org.eclipse.wst.rdb.data.ui.extractData"); //$NON-NLS-1$
        addPage(page);
    }

    public boolean performFinish()
    {
        page.saveSettings();
        
        String colDelim = page.getColumnDelimiter();
        String stringDelim = page.getStringDelimiter();
        String filePath = page.getFilePath();
        
        final ExtractData extract = new ExtractData(table, filePath);
        extract.setDelims(colDelim, stringDelim);
        
        final OutputItem item = initDbOutputItem();
        
        Job job = new Job(Messages.getString("ExtractDataWizard.DataExtraction")) { //$NON-NLS-1$
            protected IStatus run(IProgressMonitor monitor) {
                  int ret = extract.doExtract(new OutputItemAdapter(item));
                  OutputViewAPI.getInstance().updateStatus(item, ret, true);
                  return Status.OK_STATUS;
               }
            };
        job.setPriority(Job.SHORT);
        job.schedule();
        
         return true;
    }
    
    protected OutputItem initDbOutputItem()
    {
        OutputItem item = OutputViewAPI.getInstance().findOutputItem(getFullyQualifiedName(), OutputItem.ACTION_EXPORT, true);        
        if (item==null) {
            item = new OutputItem(OutputItem.STATUS_IN_PROGRESS, OutputItem.ACTION_EXTRACT, table.getName(), getFullyQualifiedName());
            OutputViewAPI.getInstance().addOutputItem(item, true);            
        } else {            
            OutputViewAPI.getInstance().resetOutputItem(item, true);
            OutputViewAPI.getInstance().updateStatus(item,OutputItem.STATUS_IN_PROGRESS, true);            
        }
        
        return item;
    }

    protected String getFullyQualifiedName() {
    	return "\"" + table.getSchema().getName() + "\".\"" + table.getName() + "\""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
    }

    
}
