/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.ModuleFactoryDelegate;

public abstract class ProjectModuleFactoryDelegate
extends ModuleFactoryDelegate {
    private static List factories = new ArrayList();
    private List modules;

    public ProjectModuleFactoryDelegate() {
        factories.add(this);
    }

    private final void cacheModules() {
        if (this.modules != null) {
            return;
        }
        try {
            this.clearCache();
            IProject[] projects2 = ProjectModuleFactoryDelegate.getWorkspaceRoot().getProjects();
            int size = projects2.length;
            this.modules = new ArrayList(size);
            int i = 0;
            while (i < size) {
                if (projects2[i].isAccessible()) {
                    try {
                        IModule[] modules2 = this.createModules(projects2[i]);
                        if (modules2 != null) {
                            int size2 = modules2.length;
                            int j = 0;
                            while (j < size2) {
                                if (modules2[j] != null) {
                                    this.modules.add(modules2[j]);
                                }
                                ++j;
                            }
                        }
                    }
                    catch (Throwable t) {
                        Trace.trace(Trace.SEVERE, "Error creating module", t);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error caching modules", e);
        }
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final IModule[] getModules() {
        this.cacheModules();
        IModule[] modules2 = new IModule[this.modules.size()];
        this.modules.toArray(modules2);
        return modules2;
    }

    public static final void handleGlobalProjectChange(IProject project, IResourceDelta delta) {
        ModuleFactory[] factories2 = ServerPlugin.getModuleFactories();
        int size = factories2.length;
        int i = 0;
        while (i < size) {
            ProjectModuleFactoryDelegate pmfd;
            if (factories2[i].delegate != null && factories2[i].delegate instanceof ProjectModuleFactoryDelegate && (pmfd = (ProjectModuleFactoryDelegate)factories2[i].delegate).deltaAffectsModules(delta)) {
                pmfd.modules = null;
                factories2[i].clearModuleCache();
            }
            ++i;
        }
    }

    private final boolean deltaAffectsModules(IResourceDelta delta) {
        final boolean[] b = new boolean[1];
        final IPath[] listenerPaths = this.getListenerPaths();
        if (listenerPaths == null || listenerPaths.length == 0) {
            return false;
        }
        final int size = listenerPaths.length;
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta2) throws CoreException {
                    if (b[0]) {
                        return false;
                    }
                    boolean ok = false;
                    IPath path = delta2.getProjectRelativePath();
                    int i = 0;
                    while (i < size) {
                        if (listenerPaths[i].equals((Object)path)) {
                            b[0] = true;
                            return false;
                        }
                        if (path.isPrefixOf(listenerPaths[i])) {
                            ok = true;
                        }
                        ++i;
                    }
                    return ok;
                }
            });
        }
        catch (Exception exception) {}
        return b[0];
    }

    protected void clearCache() {
    }

    protected IModule createModule(IProject project) {
        return null;
    }

    protected IModule[] createModules(IProject project) {
        IModule module = this.createModule(project);
        if (module == null) {
            return new IModule[0];
        }
        return new IModule[]{module};
    }

    protected IPath[] getListenerPaths() {
        return null;
    }
}

