/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.ModuleArtifactAdapterDelegate;

public class ModuleArtifactAdapter {
    private IConfigurationElement element;
    private Expression fContextualLaunchExpr = null;
    private ModuleArtifactAdapterDelegate delegate;

    public ModuleArtifactAdapter(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public int getPriority() {
        try {
            return Integer.parseInt(this.element.getAttribute("priority"));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean isPluginActivated() {
        String name = this.element.getDeclaringExtension().getContributor().getName();
        return Platform.getBundle((String)name).getState() == 32;
    }

    public Expression getContextualLaunchEnablementExpression() throws CoreException {
        if (this.fContextualLaunchExpr == null) {
            IConfigurationElement enablement;
            IConfigurationElement[] elements = this.element.getChildren("enablement");
            IConfigurationElement iConfigurationElement = enablement = elements.length > 0 ? elements[0] : null;
            if (enablement != null) {
                this.fContextualLaunchExpr = ExpressionConverter.getDefault().perform(enablement);
            }
        }
        return this.fContextualLaunchExpr;
    }

    protected boolean evalEnablementExpression(IEvaluationContext context, Expression exp) throws CoreException {
        return exp != null ? exp.evaluate(context) != EvaluationResult.FALSE : false;
    }

    public boolean isEnabled(Object obj) throws CoreException {
        EvaluationContext context = new EvaluationContext(null, obj);
        context.addVariable("selection", obj);
        return this.evalEnablementExpression((IEvaluationContext)context, this.getContextualLaunchEnablementExpression());
    }

    public ModuleArtifactAdapterDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (ModuleArtifactAdapterDelegate)this.element.createExecutableExtension("class");
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "Could not create delegate" + this.toString() + ": " + t.getMessage());
            }
        }
        return this.delegate;
    }

    public boolean isDelegateLoaded() {
        return this.delegate != null;
    }

    public IModuleArtifact getModuleArtifact(Object obj) {
        try {
            return this.getDelegate().getModuleArtifact(obj);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate " + this.toString() + ": " + e.getMessage());
            return null;
        }
    }

    public String toString() {
        return "ModuleArtifactAdapter[" + this.getId() + "]";
    }
}

