/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.util;

import org.eclipse.wst.xml.core.internal.contentmodel.CMAnyElement;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;

public class CMVisitor {
    protected int indent = 0;

    public void visitCMNode(CMNode node) {
        if (node != null) {
            this.indent += 2;
            int nodeType = node.getNodeType();
            switch (nodeType) {
                case 1: {
                    this.visitCMAnyElement((CMAnyElement)node);
                    break;
                }
                case 2: {
                    this.visitCMAttributeDeclaration((CMAttributeDeclaration)node);
                    break;
                }
                case 3: {
                    this.visitCMDataType((CMDataType)node);
                    break;
                }
                case 4: {
                    this.visitCMDocument((CMDocument)node);
                    break;
                }
                case 5: {
                    this.visitCMElementDeclaration((CMElementDeclaration)node);
                    break;
                }
                case 7: {
                    this.visitCMGroup((CMGroup)node);
                }
            }
            this.indent -= 2;
        }
    }

    public void visitCMAnyElement(CMAnyElement anyElement) {
    }

    public void visitCMAttributeDeclaration(CMAttributeDeclaration ad) {
    }

    public void visitCMDataType(CMDataType dataType) {
    }

    public void visitCMDocument(CMDocument document) {
        CMNamedNodeMap map = document.getElements();
        int size = map.getLength();
        int i = 0;
        while (i < size) {
            this.visitCMNode(map.item(i));
            ++i;
        }
    }

    public void visitCMGroup(CMGroup group) {
        CMNodeList nodeList = group.getChildNodes();
        int size = nodeList.getLength();
        int i = 0;
        while (i < size) {
            this.visitCMNode(nodeList.item(i));
            ++i;
        }
    }

    public void visitCMElementDeclaration(CMElementDeclaration ed) {
        CMNamedNodeMap nodeMap = ed.getAttributes();
        int size = nodeMap.getLength();
        int i = 0;
        while (i < size) {
            this.visitCMNode(nodeMap.item(i));
            ++i;
        }
        this.visitCMNode(ed.getContent());
        this.visitCMDataType(ed.getDataType());
    }
}

