/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.connection;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.ResourceUtil;
import org.eclipse.wst.rdb.internal.core.connection.CachedConnectionResource;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilterListener;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerImpl;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionSharingListener;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;

public class ConnectionInfoImpl
implements ConnectionInfo {
    private static final String PASSWORD = "password";
    private static final String USER = "user";
    private DatabaseDefinition definition;
    private String loadingPath = "";
    private String driverClassName = "";
    private String url = "";
    private Properties properties = new Properties();
    private String name;
    private String databaseName = null;
    private String identifierQuoteString = null;
    private String databaseProductVersion = null;
    private Connection sharedConnection = null;
    private Database sharedDatabase = null;
    private Collection listeners = new LinkedList();
    private Hashtable filters = null;
    private Collection filterListeners = new LinkedList();
    private Properties customProperties = new Properties();
    private Collection projects = null;
    private boolean detectDefinition = false;

    ConnectionInfoImpl(DatabaseDefinition definition, String name) {
        this.definition = definition;
        this.name = name;
    }

    ConnectionInfoImpl(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name == null) {
            throw new IllegalStateException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        ConnectionManagerImpl mgr = (ConnectionManagerImpl)RDBCorePlugin.getDefault().getConnectionManager();
        if (mgr.getConnectionInfo(name) != null) {
            throw new IllegalArgumentException();
        }
        mgr.rename(this.name, name);
        this.name = name;
    }

    public DatabaseDefinition getDatabaseDefinition() {
        return this.definition;
    }

    public String getLoadingPath() {
        return this.loadingPath;
    }

    public void setLoadingPath(String path) {
        this.loadingPath = path;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String className) {
        this.driverClassName = className;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Properties getCustomProperties() {
        return this.customProperties;
    }

    public Connection connect() throws Exception {
        Connection cnn = ((ConnectionManagerImpl)RDBCorePlugin.getDefault().getConnectionManager()).connect(this);
        if (cnn != null && this.detectDefinition) {
            this.detectDefinition = false;
            DatabaseDefinition def = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().recognize(cnn);
            if (def != null) {
                this.definition = def;
            }
        }
        return cnn;
    }

    public void saveConnectionInfo() throws IOException, FileNotFoundException {
        IPath path = this.initConnectionDirectory();
        String filename = String.valueOf(this.definition.getProduct()) + " " + this.definition.getVersion() + "." + "info";
        if (this.name != null) {
            filename = "connection.info";
        }
        path = path.append(filename);
        File file = path.toFile();
        Properties p = new Properties();
        p.setProperty("Product", this.definition.getProduct());
        p.setProperty("Version", this.definition.getVersion());
        p.setProperty("LoadingPath", this.loadingPath);
        p.setProperty("DriverClassName", this.driverClassName);
        p.setProperty("URL", this.url);
        if (this.databaseName != null) {
            p.setProperty("DatabaseNameInternal", this.databaseName);
        }
        if (this.identifierQuoteString != null) {
            p.setProperty("IdentiferQuoteString", this.identifierQuoteString);
        }
        if (this.databaseProductVersion != null) {
            p.setProperty("DatabaseProductVersion", this.databaseProductVersion);
        }
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equalsIgnoreCase(PASSWORD)) continue;
            p.setProperty(name, this.properties.getProperty(name));
        }
        Enumeration<?> customProperties = this.customProperties.propertyNames();
        while (customProperties.hasMoreElements()) {
            String name = (String)customProperties.nextElement();
            p.setProperty("@@_CUSTOMPROPERTY_" + name, this.customProperties.getProperty(name));
        }
        FileOutputStream output = new FileOutputStream(file);
        p.store(output, null);
        ((OutputStream)output).close();
    }

    public String getUserName() {
        return (String)this.properties.get(USER);
    }

    public void setUserName(String id) {
        this.properties.put(USER, id);
    }

    public String getPassword() {
        return (String)this.properties.get(PASSWORD);
    }

    public void setPassword(String password) {
        this.properties.put(PASSWORD, password);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databasename) {
        this.databaseName = databasename;
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public void setIdentifierQuoteString(String quote) {
        this.identifierQuoteString = quote;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String prodVersion) {
        this.databaseProductVersion = prodVersion;
    }

    public void setSharedConnection(Connection connection) {
        if (connection == null) {
            this.removeSharedConnection();
        } else {
            try {
                if (connection.isClosed()) {
                    throw new IllegalStateException();
                }
            }
            catch (Throwable throwable) {
                throw new IllegalStateException();
            }
            if (this.sharedConnection == null) {
                this.sharedConnection = connection;
                LinkedList c = new LinkedList();
                c.addAll(this.listeners);
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    ConnectionSharingListener l = (ConnectionSharingListener)it.next();
                    try {
                        l.sharedConnectionAdded(this, connection);
                    }
                    catch (Throwable throwable) {
                        this.removeConnectionSharingListener(l);
                    }
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }

    public Connection getSharedConnection() {
        return this.sharedConnection;
    }

    public void removeSharedConnection() {
        if (this.sharedConnection == null) {
            throw new IllegalStateException();
        }
        Connection connection = this.sharedConnection;
        this.sharedConnection = null;
        LinkedList c = new LinkedList();
        c.addAll(this.listeners);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ConnectionSharingListener l = (ConnectionSharingListener)it.next();
            try {
                l.sharedConnectionRemove(this, connection);
            }
            catch (Throwable throwable) {
                this.removeConnectionSharingListener(l);
            }
        }
    }

    public void setSharedDatabase(Database database) {
        if (database == null) {
            this.removeSharedDatabase();
        } else if (this.sharedDatabase == null) {
            this.sharedDatabase = database;
            LinkedList c = new LinkedList();
            c.addAll(this.listeners);
            Iterator it = c.iterator();
            while (it.hasNext()) {
                ConnectionSharingListener l = (ConnectionSharingListener)it.next();
                try {
                    l.sharedDatabaseAdded(this, database);
                }
                catch (Throwable throwable) {
                    this.removeConnectionSharingListener(l);
                }
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public Database getSharedDatabase() {
        return this.sharedDatabase;
    }

    public void removeSharedDatabase() {
        if (this.sharedDatabase == null) {
            throw new IllegalStateException();
        }
        Database database = this.sharedDatabase;
        database.eAdapters().clear();
        this.sharedDatabase = null;
        LinkedList c = new LinkedList();
        c.addAll(this.listeners);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ConnectionSharingListener l = (ConnectionSharingListener)it.next();
            try {
                l.sharedDatabaseRemove(this, database);
            }
            catch (Throwable throwable) {
                this.removeConnectionSharingListener(l);
            }
        }
    }

    public boolean addConnectionSharingListener(ConnectionSharingListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            if (listener != it.next()) continue;
            return false;
        }
        this.listeners.add(listener);
        return true;
    }

    public boolean removeConnectionSharingListener(ConnectionSharingListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            if (listener != it.next()) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public void cacheDatabase(Database database) throws IOException {
        if (this.name == null) {
            throw new IllegalStateException();
        }
        IPath path = this.initConnectionDirectory();
        path = path.append("cache.xmi");
        FileOutputStream out = new FileOutputStream(path.toFile());
        CachedConnectionResource r = new CachedConnectionResource();
        r.getContents().add((Object)database);
        ResourceUtil.resolveDanglingReferences((Resource)r);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        r.save(out, options);
        r.getContents().clear();
    }

    public Database getCachedDatabase() {
        if (this.name == null) {
            throw new IllegalStateException();
        }
        IPath path = this.initConnectionDirectory();
        File file = (path = path.append("cache.xmi")).toFile();
        if (file.exists()) {
            XMIResourceImpl r = new XMIResourceImpl();
            try {
                FileInputStream in = new FileInputStream(path.toFile());
                r.load((InputStream)in, null);
                EList l = r.getContents();
                Database database = (Database)l.get(0);
                l.clear();
                return database;
            }
            catch (Throwable o) {
                o.printStackTrace();
            }
        }
        return null;
    }

    public long getCachedDatabaseTimestamp() {
        if (this.name == null) {
            throw new IllegalStateException();
        }
        IPath path = this.initConnectionDirectory();
        File file = (path = path.append("cache.xmi")).toFile();
        if (file.exists()) {
            return file.lastModified();
        }
        return 0L;
    }

    void setDatabaseDefinition(DatabaseDefinition def) {
        this.definition = def;
    }

    private IPath initConnectionDirectory() {
        File dir;
        IPath path = RDBCorePlugin.getDefault().getStateLocation();
        path = path.append("connection/");
        if (this.name != null) {
            path = path.append(String.valueOf(this.name) + "/");
        }
        if (!(dir = path.toFile()).exists()) {
            dir.mkdirs();
        }
        return path;
    }

    public void addFilter(String key, ConnectionFilter filter) {
        if (this.filters == null) {
            this.loadFilterInfo();
        }
        if (this.filters.containsKey(key)) {
            this.filters.remove(key);
        }
        this.filters.put(key, filter);
        try {
            this.saveFilterInfo();
            Iterator it = this.filterListeners.iterator();
            while (it.hasNext()) {
                ConnectionFilterListener l = (ConnectionFilterListener)it.next();
                l.connectionFilterAdded(key);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void removeFilter(String key) {
        if (this.filters == null) {
            this.loadFilterInfo();
        }
        if (this.filters.containsKey(key)) {
            this.filters.remove(key);
            try {
                this.saveFilterInfo();
            }
            catch (Exception exception) {}
            Iterator it = this.filterListeners.iterator();
            while (it.hasNext()) {
                ConnectionFilterListener l = (ConnectionFilterListener)it.next();
                l.connectionFilterRemoved(key);
            }
        }
    }

    public ConnectionFilter getFilter(String key) {
        if (this.filters == null) {
            this.loadFilterInfo();
        }
        if (this.filters.containsKey(key)) {
            return (ConnectionFilter)this.filters.get(key);
        }
        return null;
    }

    public Iterator getFilters() {
        LinkedList filters = new LinkedList();
        Enumeration e = this.filters.elements();
        while (e.hasMoreElements()) {
            filters.add(e.nextElement());
        }
        return filters.iterator();
    }

    public IProject[] getDependentProjects() {
        if (this.projects == null) {
            this.loadDependentProjects();
        }
        IProject[] p = new IProject[this.projects.size()];
        this.projects.toArray(p);
        return p;
    }

    public void addDependentProject(IProject proj) {
        if (this.projects == null) {
            this.loadDependentProjects();
        }
        this.projects.add(proj);
        this.saveDependentProjects();
    }

    public void removeDependentProject(IProject proj) {
        if (this.projects == null) {
            this.loadDependentProjects();
        }
        this.projects.remove(proj);
        this.saveDependentProjects();
    }

    void onSQLException(Connection connection, SQLException exception) {
        LinkedList c = new LinkedList();
        c.addAll(this.listeners);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ConnectionSharingListener l = (ConnectionSharingListener)it.next();
            try {
                l.onSQLException(this, connection, exception);
            }
            catch (Throwable throwable) {
                this.removeConnectionSharingListener(l);
            }
        }
    }

    private void loadDependentProjects() {
        this.projects = new HashSet();
        IPath path = this.initConnectionDirectory();
        File file = (path = path.append("projects")).toFile();
        if (!file.exists()) {
            return;
        }
        try {
            FileInputStream fileInput = new FileInputStream(file);
            ObjectInputStream objectInput = new ObjectInputStream(fileInput);
            LinkedList l = (LinkedList)objectInput.readObject();
            objectInput.close();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                IProject p = root.getProject(name);
                if (p == null) continue;
                this.projects.add(p);
            }
        }
        catch (Exception exception) {}
    }

    private void saveDependentProjects() {
        IPath path = this.initConnectionDirectory();
        path = path.append("projects");
        File file = path.toFile();
        LinkedList<String> l = new LinkedList<String>();
        Iterator i = this.projects.iterator();
        while (i.hasNext()) {
            l.add(((IProject)i.next()).getName());
        }
        try {
            FileOutputStream fileOutput = new FileOutputStream(file);
            ObjectOutputStream objectOutput = new ObjectOutputStream(fileOutput);
            objectOutput.writeObject(l);
            objectOutput.close();
        }
        catch (IOException iOException) {}
    }

    private void saveFilterInfo() throws IOException, FileNotFoundException {
        if (this.name == null || this.name.equals("")) {
            return;
        }
        IPath path = this.initConnectionDirectory();
        String filename = "filter.info";
        path = path.append(filename);
        File file = path.toFile();
        FileOutputStream fileOutput = new FileOutputStream(file);
        ObjectOutputStream objectOutput = new ObjectOutputStream(fileOutput);
        objectOutput.writeObject(this.filters);
        objectOutput.close();
    }

    private void loadFilterInfo() {
        IPath path = RDBCorePlugin.getDefault().getStateLocation();
        path = path.append("connection/" + this.name + "/" + "filter" + "." + "info");
        File file = path.toFile();
        Hashtable filters = null;
        if (file.exists()) {
            try {
                FileInputStream input = new FileInputStream(file);
                ObjectInputStream ois = new ObjectInputStream(input);
                filters = (Hashtable)ois.readObject();
                ois.close();
            }
            catch (Exception exception) {}
        }
        if (filters == null) {
            filters = new Hashtable();
        }
        this.filters = filters;
    }

    public boolean addFilterListener(ConnectionFilterListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Iterator it = this.filterListeners.iterator();
        while (it.hasNext()) {
            if (listener != it.next()) continue;
            return false;
        }
        this.filterListeners.add(listener);
        return true;
    }

    public boolean removeFilterListener(ConnectionFilterListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Iterator it = this.filterListeners.iterator();
        while (it.hasNext()) {
            if (listener != it.next()) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public String getCustomProperty(String key) {
        if (this.customProperties.containsKey(key)) {
            return (String)this.customProperties.get(key);
        }
        return "";
    }

    public void setCustomProperty(String name, String value) {
        if (this.customProperties.containsKey(name)) {
            this.customProperties.remove(name);
            this.customProperties.put(name, value);
        } else {
            this.customProperties.put(name, value);
        }
    }

    public void discoverDatabaseDefinitionWhenConnect() {
        this.detectDefinition = true;
    }

    public boolean isDiscoverDatabaseDefinitionWhenConnectEnabled() {
        return this.detectDefinition;
    }
}

