/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.history;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntryChangePath;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.history.SVNHistoryPage;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ChangePathsTableProvider
extends TableViewer {
    ILogEntry currentLogEntry;
    Font currentPathFont;
    private static final int COL_ACTION = 0;
    private static final int COL_PATH = 1;
    private static final int COL_DESCRIPTION = 2;
    static final LogEntryChangePath[] EMPTY_CHANGE_PATHS = new LogEntryChangePath[0];

    public ChangePathsTableProvider(Composite parent, IContentProvider contentProvider) {
        super(parent, 66306);
        TableLayout layout = new TableLayout();
        GridData data = new GridData(1808);
        Table table = (Table)this.getControl();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)data);
        table.setLayout((Layout)layout);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ChangePathsTableProvider.this.currentPathFont != null) {
                    ChangePathsTableProvider.this.currentPathFont.dispose();
                }
            }
        });
        this.createColumns(table, layout);
        this.setLabelProvider((IBaseLabelProvider)new ChangePathLabelProvider());
        this.setContentProvider(contentProvider);
        ChangePathsSorter sorter = new ChangePathsSorter(1);
        this.setSorter(sorter);
        table.setSortDirection(128);
    }

    public ChangePathsTableProvider(Composite parent, SVNHistoryPage page) {
        this(parent, (IContentProvider)new ChangePathsTableContentProvider(page));
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.currentLogEntry = (ILogEntry)input;
    }

    private void createColumns(Table table, TableLayout layout) {
        SelectionListener headerListener = this.getColumnListener();
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("ChangePathsTableProvider.action"));
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("ChangePathsTableProvider.path"));
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(45, true));
        table.setSortColumn(col);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("ChangePathsTableProvider.description"));
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    private SelectionListener getColumnListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = ChangePathsTableProvider.this.getTable().indexOf((TableColumn)e.widget);
                ChangePathsSorter oldSorter = (ChangePathsSorter)ChangePathsTableProvider.this.getSorter();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    ChangePathsTableProvider.this.refresh();
                } else {
                    ChangePathsTableProvider.this.setSorter(new ChangePathsSorter(column));
                }
                ChangePathsTableProvider.this.getTable().setSortColumn((TableColumn)e.widget);
                if (ChangePathsTableProvider.this.getTable().getSortDirection() == 128) {
                    ChangePathsTableProvider.this.getTable().setSortDirection(1024);
                } else {
                    ChangePathsTableProvider.this.getTable().setSortDirection(128);
                }
            }
        };
    }

    class ChangePathLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        ChangePathLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            LogEntryChangePath changePath = (LogEntryChangePath)element;
            if (changePath == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    return "" + changePath.getAction();
                }
                case 1: {
                    return changePath.getPath();
                }
                case 2: {
                    if (changePath.getCopySrcPath() != null) {
                        return Policy.bind("ChangePathsTableProvider.copiedfrom", changePath.getCopySrcPath(), changePath.getCopySrcRevision().toString());
                    }
                    return "";
                }
            }
            return "";
        }

        public Font getFont(Object element) {
            if (ChangePathsTableProvider.this.currentLogEntry == null || element == null) {
                return null;
            }
            SVNUrl url = ((LogEntryChangePath)element).getUrl();
            ISVNRemoteResource remoteResource = ChangePathsTableProvider.this.currentLogEntry.getRemoteResource();
            if (remoteResource == null) {
                return null;
            }
            SVNUrl currentUrl = remoteResource.getUrl();
            if (currentUrl == null || !currentUrl.equals((Object)url)) {
                return null;
            }
            if (ChangePathsTableProvider.this.currentPathFont == null) {
                Font defaultFont = JFaceResources.getDefaultFont();
                FontData[] data = defaultFont.getFontData();
                int i = 0;
                while (i < data.length) {
                    data[i].setStyle(1);
                    ++i;
                }
                ChangePathsTableProvider.this.currentPathFont = new Font((Device)ChangePathsTableProvider.this.getControl().getDisplay(), data);
            }
            return ChangePathsTableProvider.this.currentPathFont;
        }
    }

    static class ChangePathsTableContentProvider
    implements IStructuredContentProvider {
        private final SVNHistoryPage page;

        ChangePathsTableContentProvider(SVNHistoryPage page) {
            this.page = page;
        }

        public Object[] getElements(Object inputElement) {
            if (!this.page.isShowChangePaths() || !(inputElement instanceof ILogEntry)) {
                return EMPTY_CHANGE_PATHS;
            }
            ILogEntry logEntry = (ILogEntry)inputElement;
            if (SVNProviderPlugin.getPlugin().getSVNClientManager().isFetchChangePathOnDemand()) {
                if (this.page.currentLogEntryChangePath != null) {
                    return this.page.currentLogEntryChangePath;
                }
                this.page.scheduleFetchChangePathJob(logEntry);
                return EMPTY_CHANGE_PATHS;
            }
            return logEntry.getLogEntryChangePaths();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.page.currentLogEntryChangePath = null;
        }
    }

    class ChangePathsSorter
    extends ViewerSorter {
        private boolean reversed = false;
        private int columnNumber;
        private int[][] SORT_ORDERS_BY_COLUMN;

        public ChangePathsSorter(int columnNumber) {
            int[][] nArrayArray = new int[3][];
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[3];
            nArray2[0] = 1;
            nArray2[2] = 2;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[3];
            nArray3[0] = 2;
            nArray3[2] = 1;
            nArrayArray[2] = nArray3;
            this.SORT_ORDERS_BY_COLUMN = nArrayArray;
            this.columnNumber = columnNumber;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            LogEntryChangePath p1 = (LogEntryChangePath)o1;
            LogEntryChangePath p2 = (LogEntryChangePath)o2;
            int result = 0;
            if (p1 == null || p2 == null) {
                result = super.compare(viewer, o1, o2);
            } else {
                int[] columnSortOrder = this.SORT_ORDERS_BY_COLUMN[this.columnNumber];
                int i = 0;
                while (i < columnSortOrder.length) {
                    result = this.compareColumnValue(columnSortOrder[i], p1, p2);
                    if (result != 0) break;
                    ++i;
                }
            }
            if (this.reversed) {
                result = -result;
            }
            return result;
        }

        int compareColumnValue(int columnNumber, LogEntryChangePath p1, LogEntryChangePath p2) {
            switch (columnNumber) {
                case 0: {
                    return this.getCollator().compare("" + p1.getAction(), "" + p2.getAction());
                }
                case 1: {
                    return this.getCollator().compare(p1.getPath(), p2.getPath());
                }
                case 2: {
                    String d1 = p1.getCopySrcPath() != null ? Policy.bind("ChangePathsTableProvider.copiedfrom", p1.getCopySrcPath(), p1.getCopySrcRevision().toString()) : "";
                    String d2 = p2.getCopySrcPath() != null ? Policy.bind("ChangePathsTableProvider.copiedfrom", p2.getCopySrcPath(), p2.getCopySrcRevision().toString()) : "";
                    return this.getCollator().compare(d1, d2);
                }
            }
            return 0;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean newReversed) {
            this.reversed = newReversed;
        }
    }
}

