/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.sync;

import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.Util;

public class SVNRevisionComparator
implements IResourceVariantComparator {
    public boolean compare(IResource local, IResourceVariant remote) {
        ISVNLocalResource a = SVNWorkspaceRoot.getSVNResourceFor(local);
        ISVNRemoteResource b = (ISVNRemoteResource)remote;
        if (local == null && remote == null) {
            return true;
        }
        if (local == null || remote == null) {
            return false;
        }
        try {
            return a.getStatus().getLastChangedRevision().getNumber() == b.getLastChangedRevision().getNumber();
        }
        catch (SVNException e) {
            Util.logError("Cannot compare local resource with remote resource", (Throwable)((Object)e));
            return false;
        }
    }

    public boolean compare(IResourceVariant base, IResourceVariant remote) {
        ISVNRemoteResource a = (ISVNRemoteResource)base;
        ISVNRemoteResource b = (ISVNRemoteResource)remote;
        if (base == remote) {
            return true;
        }
        if (base == null || remote == null) {
            return false;
        }
        return a.getLastChangedRevision().getNumber() == b.getLastChangedRevision().getNumber();
    }

    public boolean isThreeWay() {
        return true;
    }
}

