/*
 * Copyright 2005 - 2015  Zarafa B.V. and its licensors
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation with the following
 * additional terms according to sec. 7:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V.
 * The licensing of the Program under the AGPL does not imply a trademark 
 * license. Therefore any rights, title and interest in our trademarks 
 * remain entirely with us.
 * 
 * Our trademark policy, <http://www.zarafa.com/zarafa-trademark-policy>,
 * allows you to use our trademarks in connection with Propagation and 
 * certain other acts regarding the Program. In any case, if you propagate 
 * an unmodified version of the Program you are allowed to use the term 
 * "Zarafa" to indicate that you distribute the Program. Furthermore you 
 * may use our trademarks where it is necessary to indicate the intended 
 * purpose of a product or service provided you use it in accordance with 
 * honest business practices. For questions please contact Zarafa at 
 * trademark@zarafa.com.
 *
 * The interactive user interface of the software displays an attribution 
 * notice containing the term "Zarafa" and/or the logo of Zarafa. 
 * Interactive user interfaces of unmodified and modified versions must 
 * display Appropriate Legal Notices according to sec. 5 of the GNU Affero 
 * General Public License, version 3, when you propagate unmodified or 
 * modified versions of the Program. In accordance with sec. 7 b) of the GNU 
 * Affero General Public License, version 3, these Appropriate Legal Notices 
 * must retain the logo of Zarafa or display the words "Initial Development 
 * by Zarafa" if the display of the logo is not reasonably feasible for
 * technical reasons.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef EMSABTAG_H
#define EMSABTAG_H

#define AB_SHOW_PHANTOMS      2
#define AB_SHOW_OTHERS        4

#define EMS_AB_ADDRESS_LOOKUP      0x01

#define PR_EMS_AB_SERVER     PROP_TAG( PT_TSTRING, 0xFFFE)
#define PR_EMS_AB_SERVER_A   PROP_TAG( PT_STRING8, 0xFFFE)
#define PR_EMS_AB_SERVER_W   PROP_TAG( PT_UNICODE, 0xFFFE)
#define PR_EMS_AB_CONTAINERID        PROP_TAG( PT_LONG, 0xFFFD)
#define PR_EMS_AB_DOS_ENTRYID        PR_EMS_AB_CONTAINERID
#define PR_EMS_AB_PARENT_ENTRYID     PROP_TAG( PT_BINARY,  0xFFFC)
#define PR_EMS_AB_IS_MASTER  PROP_TAG(PT_BOOLEAN,  0xFFFB)
#define PR_EMS_AB_OBJECT_OID         PROP_TAG(PT_BINARY,   0xFFFA)
#define PR_EMS_AB_HIERARCHY_PATH     PROP_TAG(PT_TSTRING,  0xFFF9)
#define PR_EMS_AB_HIERARCHY_PATH_A   PROP_TAG(PT_STRING8,  0xFFF9)
#define PR_EMS_AB_HIERARCHY_PATH_W   PROP_TAG(PT_UNICODE,  0xFFF9)
#define PR_EMS_AB_CHILD_RDNS  PROP_TAG(PT_MV_STRING8,   0xFFF8)

#define MIN_EMS_AB_CONSTRUCTED_PROP_ID     0xFFF8

#define PR_EMS_AB_OTHER_RECIPS        PROP_TAG(PT_OBJECT,    0xF000)

#define PR_EMS_AB_DISPLAY_NAME_PRINTABLE      PROP_TAG(PT_TSTRING,   0x39FF)
#define PR_EMS_AB_DISPLAY_NAME_PRINTABLE_A    PROP_TAG(PT_STRING8,   0x39FF)
#define PR_EMS_AB_DISPLAY_NAME_PRINTABLE_W    PROP_TAG(PT_UNICODE,   0x39FF)

#define PR_EMS_AB_ACCESS_CATEGORY    PROP_TAG( PT_LONG,  0x8044)
#define PR_EMS_AB_ACTIVATION_SCHEDULE        PROP_TAG( PT_BINARY,     0x8045)
#define PR_EMS_AB_ACTIVATION_STYLE   PROP_TAG( PT_LONG,  0x8046)
#define PR_EMS_AB_ADDRESS_ENTRY_DISPLAY_TABLE PROP_TAG( PT_BINARY,     0x8017)
#define PR_EMS_AB_ADDRESS_ENTRY_DISPLAY_TABLE_MSDOS PROP_TAG( PT_BINARY,     0x8047)
#define PR_EMS_AB_ADDRESS_SYNTAX     PROP_TAG( PT_BINARY,     0x8018)
#define PR_EMS_AB_ADDRESS_TYPE       PROP_TAG( PT_TSTRING,    0x8048)
#define PR_EMS_AB_ADDRESS_TYPE_A     PROP_TAG( PT_STRING8,    0x8048)
#define PR_EMS_AB_ADDRESS_TYPE_W     PROP_TAG( PT_UNICODE,    0x8048)
#define PR_EMS_AB_ADMD       PROP_TAG( PT_TSTRING,    0x8049)
#define PR_EMS_AB_ADMD_A     PROP_TAG( PT_STRING8,    0x8049)
#define PR_EMS_AB_ADMD_W     PROP_TAG( PT_UNICODE,    0x8049)
#define PR_EMS_AB_ADMIN_DESCRIPTION  PROP_TAG( PT_TSTRING,    0x804A)
#define PR_EMS_AB_ADMIN_DESCRIPTION_A        PROP_TAG( PT_STRING8,    0x804A)
#define PR_EMS_AB_ADMIN_DESCRIPTION_W        PROP_TAG( PT_UNICODE,    0x804A)
#define PR_EMS_AB_ADMIN_DISPLAY_NAME PROP_TAG( PT_TSTRING,    0x804B)
#define PR_EMS_AB_ADMIN_DISPLAY_NAME_A       PROP_TAG( PT_STRING8,    0x804B)
#define PR_EMS_AB_ADMIN_DISPLAY_NAME_W       PROP_TAG( PT_UNICODE,    0x804B)
#define PR_EMS_AB_ADMIN_EXTENSION_DLL        PROP_TAG( PT_TSTRING,    0x804C)
#define PR_EMS_AB_ADMIN_EXTENSION_DLL_A      PROP_TAG( PT_STRING8,    0x804C)
#define PR_EMS_AB_ADMIN_EXTENSION_DLL_W      PROP_TAG( PT_UNICODE,    0x804C)
#define PR_EMS_AB_ALIASED_OBJECT_NAME        PROP_TAG( PT_TSTRING,    0x804D)
#define PR_EMS_AB_ALIASED_OBJECT_NAME_A      PROP_TAG( PT_STRING8,    0x804D)
#define PR_EMS_AB_ALIASED_OBJECT_NAME_W      PROP_TAG( PT_UNICODE,    0x804D)
#define PR_EMS_AB_ALIASED_OBJECT_NAME_O      PROP_TAG( PT_OBJECT,     0x804D)
#define PR_EMS_AB_ALIASED_OBJECT_NAME_T      PROP_TAG( PT_TSTRING,    0x804D)
#define PR_EMS_AB_ALT_RECIPIENT      PROP_TAG( PT_TSTRING,    0x804E)
#define PR_EMS_AB_ALT_RECIPIENT_A    PROP_TAG( PT_STRING8,    0x804E)
#define PR_EMS_AB_ALT_RECIPIENT_W    PROP_TAG( PT_UNICODE,    0x804E)
#define PR_EMS_AB_ALT_RECIPIENT_O    PROP_TAG( PT_OBJECT,     0x804E)
#define PR_EMS_AB_ALT_RECIPIENT_T    PROP_TAG( PT_TSTRING,    0x804E)
#define PR_EMS_AB_ALT_RECIPIENT_BL   PROP_TAG( PT_MV_TSTRING, 0x804F)
#define PR_EMS_AB_ALT_RECIPIENT_BL_A PROP_TAG( PT_MV_STRING8, 0x804F)
#define PR_EMS_AB_ALT_RECIPIENT_BL_W PROP_TAG( PT_MV_UNICODE, 0x804F)
#define PR_EMS_AB_ALT_RECIPIENT_BL_O PROP_TAG( PT_OBJECT,     0x804F)
#define PR_EMS_AB_ALT_RECIPIENT_BL_T PROP_TAG( PT_MV_TSTRING, 0x804F)
#define PR_EMS_AB_ANCESTOR_ID        PROP_TAG( PT_BINARY,     0x8050)
#define PR_EMS_AB_ASSOC_NT_ACCOUNT   PROP_TAG( PT_BINARY,     0x8027)
#define PR_EMS_AB_ASSOC_REMOTE_DXA   PROP_TAG( PT_MV_TSTRING, 0x8051)
#define PR_EMS_AB_ASSOC_REMOTE_DXA_A PROP_TAG( PT_MV_STRING8, 0x8051)
#define PR_EMS_AB_ASSOC_REMOTE_DXA_W PROP_TAG( PT_MV_UNICODE, 0x8051)
#define PR_EMS_AB_ASSOC_REMOTE_DXA_O PROP_TAG( PT_OBJECT,     0x8051)
#define PR_EMS_AB_ASSOC_REMOTE_DXA_T PROP_TAG( PT_MV_TSTRING, 0x8051)
#define PR_EMS_AB_ASSOCIATION_LIFETIME       PROP_TAG( PT_LONG,  0x8052)
#define PR_EMS_AB_AUTH_ORIG_BL       PROP_TAG( PT_MV_TSTRING, 0x8053)
#define PR_EMS_AB_AUTH_ORIG_BL_A     PROP_TAG( PT_MV_STRING8, 0x8053)
#define PR_EMS_AB_AUTH_ORIG_BL_W     PROP_TAG( PT_MV_UNICODE, 0x8053)
#define PR_EMS_AB_AUTH_ORIG_BL_O     PROP_TAG( PT_OBJECT,     0x8053)
#define PR_EMS_AB_AUTH_ORIG_BL_T     PROP_TAG( PT_MV_TSTRING, 0x8053)
#define PR_EMS_AB_AUTHORITY_REVOCATION_LIST  PROP_TAG( PT_MV_BINARY,  0x8026)
#define PR_EMS_AB_AUTHORIZED_DOMAIN  PROP_TAG( PT_TSTRING,    0x8054)
#define PR_EMS_AB_AUTHORIZED_DOMAIN_A        PROP_TAG( PT_STRING8,    0x8054)
#define PR_EMS_AB_AUTHORIZED_DOMAIN_W        PROP_TAG( PT_UNICODE,    0x8054)
#define PR_EMS_AB_AUTHORIZED_PASSWORD        PROP_TAG( PT_BINARY,     0x8055)
#define PR_EMS_AB_AUTHORIZED_USER    PROP_TAG( PT_TSTRING,    0x8056)
#define PR_EMS_AB_AUTHORIZED_USER_A  PROP_TAG( PT_STRING8,    0x8056)
#define PR_EMS_AB_AUTHORIZED_USER_W  PROP_TAG( PT_UNICODE,    0x8056)
#define PR_EMS_AB_AUTOREPLY  PROP_TAG( PT_BOOLEAN,    0x800B)
#define PR_EMS_AB_AUTOREPLY_MESSAGE  PROP_TAG( PT_TSTRING,    0x800A)
#define PR_EMS_AB_AUTOREPLY_MESSAGE_A        PROP_TAG( PT_STRING8,    0x800A)
#define PR_EMS_AB_AUTOREPLY_MESSAGE_W        PROP_TAG( PT_UNICODE,    0x800A)
#define PR_EMS_AB_AUTOREPLY_SUBJECT  PROP_TAG( PT_TSTRING,    0x803E)
#define PR_EMS_AB_AUTOREPLY_SUBJECT_A        PROP_TAG( PT_STRING8,    0x803E)
#define PR_EMS_AB_AUTOREPLY_SUBJECT_W        PROP_TAG( PT_UNICODE,    0x803E)
#define PR_EMS_AB_BRIDGEHEAD_SERVERS PROP_TAG( PT_MV_TSTRING, 0x8174)
#define PR_EMS_AB_BRIDGEHEAD_SERVERS_A       PROP_TAG( PT_MV_STRING8, 0x8174)
#define PR_EMS_AB_BRIDGEHEAD_SERVERS_W       PROP_TAG( PT_MV_UNICODE, 0x8174)
#define PR_EMS_AB_BRIDGEHEAD_SERVERS_O       PROP_TAG( PT_OBJECT,     0x8174)
#define PR_EMS_AB_BRIDGEHEAD_SERVERS_T       PROP_TAG( PT_MV_TSTRING, 0x8174)
#define PR_EMS_AB_BUSINESS_CATEGORY  PROP_TAG( PT_MV_TSTRING, 0x8057)
#define PR_EMS_AB_BUSINESS_CATEGORY_A        PROP_TAG( PT_MV_STRING8, 0x8057)
#define PR_EMS_AB_BUSINESS_CATEGORY_W        PROP_TAG( PT_MV_UNICODE, 0x8057)
#define PR_EMS_AB_BUSINESS_ROLES     PROP_TAG( PT_BINARY,     0x8023)
#define PR_EMS_AB_CA_CERTIFICATE     PROP_TAG( PT_MV_BINARY,  0x8003)
#define PR_EMS_AB_CAN_CREATE_PF      PROP_TAG( PT_MV_TSTRING, 0x8058)
#define PR_EMS_AB_CAN_CREATE_PF_A    PROP_TAG( PT_MV_STRING8, 0x8058)
#define PR_EMS_AB_CAN_CREATE_PF_W    PROP_TAG( PT_MV_UNICODE, 0x8058)
#define PR_EMS_AB_CAN_CREATE_PF_O    PROP_TAG( PT_OBJECT,     0x8058)
#define PR_EMS_AB_CAN_CREATE_PF_T    PROP_TAG( PT_MV_TSTRING, 0x8058)
#define PR_EMS_AB_CAN_CREATE_PF_BL   PROP_TAG( PT_MV_TSTRING, 0x8059)
#define PR_EMS_AB_CAN_CREATE_PF_BL_A PROP_TAG( PT_MV_STRING8, 0x8059)
#define PR_EMS_AB_CAN_CREATE_PF_BL_W PROP_TAG( PT_MV_UNICODE, 0x8059)
#define PR_EMS_AB_CAN_CREATE_PF_BL_O PROP_TAG( PT_OBJECT,     0x8059)
#define PR_EMS_AB_CAN_CREATE_PF_BL_T PROP_TAG( PT_MV_TSTRING, 0x8059)
#define PR_EMS_AB_CAN_CREATE_PF_DL   PROP_TAG( PT_MV_TSTRING, 0x805A)
#define PR_EMS_AB_CAN_CREATE_PF_DL_A PROP_TAG( PT_MV_STRING8, 0x805A)
#define PR_EMS_AB_CAN_CREATE_PF_DL_W PROP_TAG( PT_MV_UNICODE, 0x805A)
#define PR_EMS_AB_CAN_CREATE_PF_DL_O PROP_TAG( PT_OBJECT,     0x805A)
#define PR_EMS_AB_CAN_CREATE_PF_DL_T PROP_TAG( PT_MV_TSTRING, 0x805A)
#define PR_EMS_AB_CAN_CREATE_PF_DL_BL        PROP_TAG( PT_MV_TSTRING, 0x805B)
#define PR_EMS_AB_CAN_CREATE_PF_DL_BL_A      PROP_TAG( PT_MV_STRING8, 0x805B)
#define PR_EMS_AB_CAN_CREATE_PF_DL_BL_W      PROP_TAG( PT_MV_UNICODE, 0x805B)
#define PR_EMS_AB_CAN_CREATE_PF_DL_BL_O      PROP_TAG( PT_OBJECT,     0x805B)
#define PR_EMS_AB_CAN_CREATE_PF_DL_BL_T      PROP_TAG( PT_MV_TSTRING, 0x805B)
#define PR_EMS_AB_CAN_NOT_CREATE_PF  PROP_TAG( PT_MV_TSTRING, 0x805C)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_A        PROP_TAG( PT_MV_STRING8, 0x805C)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_W        PROP_TAG( PT_MV_UNICODE, 0x805C)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_O        PROP_TAG( PT_OBJECT,     0x805C)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_T        PROP_TAG( PT_MV_TSTRING, 0x805C)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_BL       PROP_TAG( PT_MV_TSTRING, 0x805D)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_BL_A     PROP_TAG( PT_MV_STRING8, 0x805D)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_BL_W     PROP_TAG( PT_MV_UNICODE, 0x805D)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_BL_O     PROP_TAG( PT_OBJECT,     0x805D)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_BL_T     PROP_TAG( PT_MV_TSTRING, 0x805D)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_DL       PROP_TAG( PT_MV_TSTRING, 0x805E)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_DL_A     PROP_TAG( PT_MV_STRING8, 0x805E)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_DL_W     PROP_TAG( PT_MV_UNICODE, 0x805E)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_DL_O     PROP_TAG( PT_OBJECT,     0x805E)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_DL_T     PROP_TAG( PT_MV_TSTRING, 0x805E)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_DL_BL    PROP_TAG( PT_MV_TSTRING, 0x805F)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_DL_BL_A  PROP_TAG( PT_MV_STRING8, 0x805F)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_DL_BL_W  PROP_TAG( PT_MV_UNICODE, 0x805F)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_DL_BL_O  PROP_TAG( PT_OBJECT,     0x805F)
#define PR_EMS_AB_CAN_NOT_CREATE_PF_DL_BL_T  PROP_TAG( PT_MV_TSTRING, 0x805F)
#define PR_EMS_AB_CAN_PRESERVE_DNS   PROP_TAG( PT_BOOLEAN,    0x8060)
#define PR_EMS_AB_CERTIFICATE_REVOCATION_LIST PROP_TAG( PT_BINARY,     0x8016)
#define PR_EMS_AB_CLOCK_ALERT_OFFSET PROP_TAG( PT_LONG,  0x8061)
#define PR_EMS_AB_CLOCK_ALERT_REPAIR PROP_TAG( PT_BOOLEAN,    0x8062)
#define PR_EMS_AB_CLOCK_WARNING_OFFSET       PROP_TAG( PT_LONG,  0x8063)
#define PR_EMS_AB_CLOCK_WARNING_REPAIR       PROP_TAG( PT_BOOLEAN,    0x8064)
#define PR_EMS_AB_COMPUTER_NAME      PROP_TAG( PT_TSTRING,    0x8065)
#define PR_EMS_AB_COMPUTER_NAME_A    PROP_TAG( PT_STRING8,    0x8065)
#define PR_EMS_AB_COMPUTER_NAME_W    PROP_TAG( PT_UNICODE,    0x8065)
#define PR_EMS_AB_CONNECTED_DOMAINS  PROP_TAG( PT_MV_TSTRING, 0x8066)
#define PR_EMS_AB_CONNECTED_DOMAINS_A        PROP_TAG( PT_MV_STRING8, 0x8066)
#define PR_EMS_AB_CONNECTED_DOMAINS_W        PROP_TAG( PT_MV_UNICODE, 0x8066)
#define PR_EMS_AB_CONTAINER_INFO     PROP_TAG( PT_LONG,  0x8067)
#define PR_EMS_AB_COST       PROP_TAG( PT_LONG,  0x8068)
#define PR_EMS_AB_COUNTRY_NAME       PROP_TAG( PT_TSTRING,    0x8069)
#define PR_EMS_AB_COUNTRY_NAME_A     PROP_TAG( PT_STRING8,    0x8069)
#define PR_EMS_AB_COUNTRY_NAME_W     PROP_TAG( PT_UNICODE,    0x8069)
#define PR_EMS_AB_CROSS_CERTIFICATE_PAIR     PROP_TAG( PT_MV_BINARY,  0x8025)
#define PR_EMS_AB_DELIV_CONT_LENGTH  PROP_TAG( PT_LONG,  0x806A)
#define PR_EMS_AB_DELIV_EITS         PROP_TAG( PT_MV_BINARY,  0x806B)
#define PR_EMS_AB_DELIV_EXT_CONT_TYPES       PROP_TAG( PT_MV_BINARY,  0x806C)
#define PR_EMS_AB_DELIVER_AND_REDIRECT       PROP_TAG( PT_BOOLEAN,    0x806D)
#define PR_EMS_AB_DELIVERY_MECHANISM PROP_TAG( PT_LONG,  0x806E)
#define PR_EMS_AB_DESCRIPTION        PROP_TAG( PT_MV_TSTRING, 0x806F)
#define PR_EMS_AB_DESCRIPTION_A      PROP_TAG( PT_MV_STRING8, 0x806F)
#define PR_EMS_AB_DESCRIPTION_W      PROP_TAG( PT_MV_UNICODE, 0x806F)
#define PR_EMS_AB_DESTINATION_INDICATOR      PROP_TAG( PT_MV_TSTRING, 0x8070)
#define PR_EMS_AB_DESTINATION_INDICATOR_A    PROP_TAG( PT_MV_STRING8, 0x8070)
#define PR_EMS_AB_DESTINATION_INDICATOR_W    PROP_TAG( PT_MV_UNICODE, 0x8070)
#define PR_EMS_AB_DIAGNOSTIC_REG_KEY PROP_TAG( PT_TSTRING,    0x8071)
#define PR_EMS_AB_DIAGNOSTIC_REG_KEY_A       PROP_TAG( PT_STRING8,    0x8071)
#define PR_EMS_AB_DIAGNOSTIC_REG_KEY_W       PROP_TAG( PT_UNICODE,    0x8071)
#define PR_EMS_AB_DISPLAY_NAME_OVERRIDE      PROP_TAG( PT_BOOLEAN,    0x8001)
#define PR_EMS_AB_DL_MEM_REJECT_PERMS_BL     PROP_TAG( PT_MV_TSTRING, 0x8072)
#define PR_EMS_AB_DL_MEM_REJECT_PERMS_BL_A   PROP_TAG( PT_MV_STRING8, 0x8072)
#define PR_EMS_AB_DL_MEM_REJECT_PERMS_BL_W   PROP_TAG( PT_MV_UNICODE, 0x8072)
#define PR_EMS_AB_DL_MEM_REJECT_PERMS_BL_O   PROP_TAG( PT_OBJECT,     0x8072)
#define PR_EMS_AB_DL_MEM_REJECT_PERMS_BL_T   PROP_TAG( PT_MV_TSTRING, 0x8072)
#define PR_EMS_AB_DL_MEM_SUBMIT_PERMS_BL     PROP_TAG( PT_MV_TSTRING, 0x8073)
#define PR_EMS_AB_DL_MEM_SUBMIT_PERMS_BL_A   PROP_TAG( PT_MV_STRING8, 0x8073)
#define PR_EMS_AB_DL_MEM_SUBMIT_PERMS_BL_W   PROP_TAG( PT_MV_UNICODE, 0x8073)
#define PR_EMS_AB_DL_MEM_SUBMIT_PERMS_BL_O   PROP_TAG( PT_OBJECT,     0x8073)
#define PR_EMS_AB_DL_MEM_SUBMIT_PERMS_BL_T   PROP_TAG( PT_MV_TSTRING, 0x8073)
#define PR_EMS_AB_DL_MEMBER_RULE     PROP_TAG( PT_MV_BINARY,  0x8074)
#define PR_EMS_AB_DOMAIN_DEF_ALT_RECIP       PROP_TAG( PT_TSTRING,    0x8075)
#define PR_EMS_AB_DOMAIN_DEF_ALT_RECIP_A     PROP_TAG( PT_STRING8,    0x8075)
#define PR_EMS_AB_DOMAIN_DEF_ALT_RECIP_W     PROP_TAG( PT_UNICODE,    0x8075)
#define PR_EMS_AB_DOMAIN_DEF_ALT_RECIP_O     PROP_TAG( PT_OBJECT,     0x8075)
#define PR_EMS_AB_DOMAIN_DEF_ALT_RECIP_T     PROP_TAG( PT_TSTRING,    0x8075)
#define PR_EMS_AB_DOMAIN_NAME        PROP_TAG( PT_TSTRING,    0x8076)
#define PR_EMS_AB_DOMAIN_NAME_A      PROP_TAG( PT_STRING8,    0x8076)
#define PR_EMS_AB_DOMAIN_NAME_W      PROP_TAG( PT_UNICODE,    0x8076)
#define PR_EMS_AB_DSA_SIGNATURE      PROP_TAG( PT_BINARY,     0x8077)
#define PR_EMS_AB_DXA_ADMIN_COPY     PROP_TAG( PT_BOOLEAN,    0x8078)
#define PR_EMS_AB_DXA_ADMIN_FORWARD  PROP_TAG( PT_BOOLEAN,    0x8079)
#define PR_EMS_AB_DXA_ADMIN_UPDATE   PROP_TAG( PT_LONG,  0x807A)
#define PR_EMS_AB_DXA_APPEND_REQCN   PROP_TAG( PT_BOOLEAN,    0x807B)
#define PR_EMS_AB_DXA_CONF_CONTAINER_LIST    PROP_TAG( PT_MV_TSTRING, 0x807C)
#define PR_EMS_AB_DXA_CONF_CONTAINER_LIST_A  PROP_TAG( PT_MV_STRING8, 0x807C)
#define PR_EMS_AB_DXA_CONF_CONTAINER_LIST_W  PROP_TAG( PT_MV_UNICODE, 0x807C)
#define PR_EMS_AB_DXA_CONF_CONTAINER_LIST_O  PROP_TAG( PT_OBJECT,     0x807C)
#define PR_EMS_AB_DXA_CONF_CONTAINER_LIST_T  PROP_TAG( PT_MV_TSTRING, 0x807C)
#define PR_EMS_AB_DXA_CONF_REQ_TIME  PROP_TAG( PT_SYSTIME,    0x807D)
#define PR_EMS_AB_DXA_CONF_SEQ       PROP_TAG( PT_TSTRING,    0x807E)
#define PR_EMS_AB_DXA_CONF_SEQ_A     PROP_TAG( PT_STRING8,    0x807E)
#define PR_EMS_AB_DXA_CONF_SEQ_W     PROP_TAG( PT_UNICODE,    0x807E)
#define PR_EMS_AB_DXA_CONF_SEQ_USN   PROP_TAG( PT_LONG,  0x807F)
#define PR_EMS_AB_DXA_EXCHANGE_OPTIONS       PROP_TAG( PT_LONG,  0x8080)
#define PR_EMS_AB_DXA_EXPORT_NOW     PROP_TAG( PT_BOOLEAN,    0x8081)
#define PR_EMS_AB_DXA_FLAGS  PROP_TAG( PT_LONG,  0x8082)
#define PR_EMS_AB_DXA_IMP_SEQ        PROP_TAG( PT_TSTRING,    0x8083)
#define PR_EMS_AB_DXA_IMP_SEQ_A      PROP_TAG( PT_STRING8,    0x8083)
#define PR_EMS_AB_DXA_IMP_SEQ_W      PROP_TAG( PT_UNICODE,    0x8083)
#define PR_EMS_AB_DXA_IMP_SEQ_TIME   PROP_TAG( PT_SYSTIME,    0x8084)
#define PR_EMS_AB_DXA_IMP_SEQ_USN    PROP_TAG( PT_LONG,  0x8085)
#define PR_EMS_AB_DXA_IMPORT_NOW     PROP_TAG( PT_BOOLEAN,    0x8086)
#define PR_EMS_AB_DXA_IN_TEMPLATE_MAP        PROP_TAG( PT_MV_TSTRING, 0x8087)
#define PR_EMS_AB_DXA_IN_TEMPLATE_MAP_A      PROP_TAG( PT_MV_STRING8, 0x8087)
#define PR_EMS_AB_DXA_IN_TEMPLATE_MAP_W      PROP_TAG( PT_MV_UNICODE, 0x8087)
#define PR_EMS_AB_DXA_LOCAL_ADMIN    PROP_TAG( PT_TSTRING,    0x8088)
#define PR_EMS_AB_DXA_LOCAL_ADMIN_A  PROP_TAG( PT_STRING8,    0x8088)
#define PR_EMS_AB_DXA_LOCAL_ADMIN_W  PROP_TAG( PT_UNICODE,    0x8088)
#define PR_EMS_AB_DXA_LOCAL_ADMIN_O  PROP_TAG( PT_OBJECT,     0x8088)
#define PR_EMS_AB_DXA_LOCAL_ADMIN_T  PROP_TAG( PT_TSTRING,    0x8088)
#define PR_EMS_AB_DXA_LOGGING_LEVEL  PROP_TAG( PT_LONG,  0x8089)
#define PR_EMS_AB_DXA_NATIVE_ADDRESS_TYPE    PROP_TAG( PT_TSTRING,    0x808A)
#define PR_EMS_AB_DXA_NATIVE_ADDRESS_TYPE_A  PROP_TAG( PT_STRING8,    0x808A)
#define PR_EMS_AB_DXA_NATIVE_ADDRESS_TYPE_W  PROP_TAG( PT_UNICODE,    0x808A)
#define PR_EMS_AB_DXA_OUT_TEMPLATE_MAP       PROP_TAG( PT_MV_TSTRING, 0x808B)
#define PR_EMS_AB_DXA_OUT_TEMPLATE_MAP_A     PROP_TAG( PT_MV_STRING8, 0x808B)
#define PR_EMS_AB_DXA_OUT_TEMPLATE_MAP_W     PROP_TAG( PT_MV_UNICODE, 0x808B)
#define PR_EMS_AB_DXA_PASSWORD       PROP_TAG( PT_TSTRING,    0x808C)
#define PR_EMS_AB_DXA_PASSWORD_A     PROP_TAG( PT_STRING8,    0x808C)
#define PR_EMS_AB_DXA_PASSWORD_W     PROP_TAG( PT_UNICODE,    0x808C)
#define PR_EMS_AB_DXA_PREV_EXCHANGE_OPTIONS  PROP_TAG( PT_LONG,  0x808D)
#define PR_EMS_AB_DXA_PREV_EXPORT_NATIVE_ONLY PROP_TAG( PT_BOOLEAN,    0x808E)
#define PR_EMS_AB_DXA_PREV_IN_EXCHANGE_SENSITIVITY PROP_TAG( PT_LONG,  0x808F)
#define PR_EMS_AB_DXA_PREV_REMOTE_ENTRIES    PROP_TAG( PT_TSTRING,    0x8090)
#define PR_EMS_AB_DXA_PREV_REMOTE_ENTRIES_A  PROP_TAG( PT_STRING8,    0x8090)
#define PR_EMS_AB_DXA_PREV_REMOTE_ENTRIES_W  PROP_TAG( PT_UNICODE,    0x8090)
#define PR_EMS_AB_DXA_PREV_REMOTE_ENTRIES_O  PROP_TAG( PT_OBJECT,     0x8090)
#define PR_EMS_AB_DXA_PREV_REMOTE_ENTRIES_T  PROP_TAG( PT_TSTRING,    0x8090)
#define PR_EMS_AB_DXA_PREV_REPLICATION_SENSITIVITY PROP_TAG( PT_LONG,  0x8091)
#define PR_EMS_AB_DXA_PREV_TEMPLATE_OPTIONS  PROP_TAG( PT_LONG,  0x8092)
#define PR_EMS_AB_DXA_PREV_TYPES     PROP_TAG( PT_LONG,  0x8093)
#define PR_EMS_AB_DXA_RECIPIENT_CP   PROP_TAG( PT_TSTRING,    0x8094)
#define PR_EMS_AB_DXA_RECIPIENT_CP_A PROP_TAG( PT_STRING8,    0x8094)
#define PR_EMS_AB_DXA_RECIPIENT_CP_W PROP_TAG( PT_UNICODE,    0x8094)
#define PR_EMS_AB_DXA_REMOTE_CLIENT  PROP_TAG( PT_TSTRING,    0x8095)
#define PR_EMS_AB_DXA_REMOTE_CLIENT_A        PROP_TAG( PT_STRING8,    0x8095)
#define PR_EMS_AB_DXA_REMOTE_CLIENT_W        PROP_TAG( PT_UNICODE,    0x8095)
#define PR_EMS_AB_DXA_REMOTE_CLIENT_O        PROP_TAG( PT_OBJECT,     0x8095)
#define PR_EMS_AB_DXA_REMOTE_CLIENT_T        PROP_TAG( PT_TSTRING,    0x8095)
#define PR_EMS_AB_DXA_REQ_SEQ        PROP_TAG( PT_TSTRING,    0x8096)
#define PR_EMS_AB_DXA_REQ_SEQ_A      PROP_TAG( PT_STRING8,    0x8096)
#define PR_EMS_AB_DXA_REQ_SEQ_W      PROP_TAG( PT_UNICODE,    0x8096)
#define PR_EMS_AB_DXA_REQ_SEQ_TIME   PROP_TAG( PT_SYSTIME,    0x8097)
#define PR_EMS_AB_DXA_REQ_SEQ_USN    PROP_TAG( PT_LONG,  0x8098)
#define PR_EMS_AB_DXA_REQNAME        PROP_TAG( PT_TSTRING,    0x8099)
#define PR_EMS_AB_DXA_REQNAME_A      PROP_TAG( PT_STRING8,    0x8099)
#define PR_EMS_AB_DXA_REQNAME_W      PROP_TAG( PT_UNICODE,    0x8099)
#define PR_EMS_AB_DXA_SVR_SEQ        PROP_TAG( PT_TSTRING,    0x809A)
#define PR_EMS_AB_DXA_SVR_SEQ_A      PROP_TAG( PT_STRING8,    0x809A)
#define PR_EMS_AB_DXA_SVR_SEQ_W      PROP_TAG( PT_UNICODE,    0x809A)
#define PR_EMS_AB_DXA_SVR_SEQ_TIME   PROP_TAG( PT_SYSTIME,    0x809B)
#define PR_EMS_AB_DXA_SVR_SEQ_USN    PROP_TAG( PT_LONG,  0x809C)
#define PR_EMS_AB_DXA_TASK   PROP_TAG( PT_LONG,  0x809D)
#define PR_EMS_AB_DXA_TEMPLATE_OPTIONS       PROP_TAG( PT_LONG,  0x809E)
#define PR_EMS_AB_DXA_TEMPLATE_TIMESTAMP     PROP_TAG( PT_SYSTIME,    0x809F)
#define PR_EMS_AB_DXA_TYPES  PROP_TAG( PT_LONG,  0x80A0)
#define PR_EMS_AB_DXA_UNCONF_CONTAINER_LIST  PROP_TAG( PT_MV_TSTRING, 0x80A1)
#define PR_EMS_AB_DXA_UNCONF_CONTAINER_LIST_A PROP_TAG( PT_MV_STRING8, 0x80A1)
#define PR_EMS_AB_DXA_UNCONF_CONTAINER_LIST_W PROP_TAG( PT_MV_UNICODE, 0x80A1)
#define PR_EMS_AB_DXA_UNCONF_CONTAINER_LIST_O PROP_TAG( PT_OBJECT,     0x80A1)
#define PR_EMS_AB_DXA_UNCONF_CONTAINER_LIST_T PROP_TAG( PT_MV_TSTRING, 0x80A1)
#define PR_EMS_AB_ENABLED_PROTOCOLS  PROP_TAG( PT_LONG,  0x817F)
#define PR_EMS_AB_ENCAPSULATION_METHOD       PROP_TAG( PT_LONG,  0x80A2)
#define PR_EMS_AB_ENCRYPT    PROP_TAG( PT_BOOLEAN,    0x80A3)
#define PR_EMS_AB_ENCRYPT_ALG_LIST_NA        PROP_TAG( PT_MV_TSTRING, 0x8040)
#define PR_EMS_AB_ENCRYPT_ALG_LIST_NA_A      PROP_TAG( PT_MV_STRING8, 0x8040)
#define PR_EMS_AB_ENCRYPT_ALG_LIST_NA_W      PROP_TAG( PT_MV_UNICODE, 0x8040)
#define PR_EMS_AB_ENCRYPT_ALG_LIST_OTHER     PROP_TAG( PT_MV_TSTRING, 0x8041)
#define PR_EMS_AB_ENCRYPT_ALG_LIST_OTHER_A   PROP_TAG( PT_MV_STRING8, 0x8041)
#define PR_EMS_AB_ENCRYPT_ALG_LIST_OTHER_W   PROP_TAG( PT_MV_UNICODE, 0x8041)
#define PR_EMS_AB_ENCRYPT_ALG_SELECTED_NA    PROP_TAG( PT_TSTRING,    0x8043)
#define PR_EMS_AB_ENCRYPT_ALG_SELECTED_NA_A  PROP_TAG( PT_STRING8,    0x8043)
#define PR_EMS_AB_ENCRYPT_ALG_SELECTED_NA_W  PROP_TAG( PT_UNICODE,    0x8043)
#define PR_EMS_AB_ENCRYPT_ALG_SELECTED_OTHER PROP_TAG( PT_TSTRING,    0x803D)
#define PR_EMS_AB_ENCRYPT_ALG_SELECTED_OTHER_A PROP_TAG( PT_STRING8,    0x803D)
#define PR_EMS_AB_ENCRYPT_ALG_SELECTED_OTHER_W PROP_TAG( PT_UNICODE,    0x803D)
#define PR_EMS_AB_EXPAND_DLS_LOCALLY PROP_TAG( PT_BOOLEAN,    0x80A4)
#define PR_EMS_AB_EXPIRATION_TIME    PROP_TAG( PT_SYSTIME,    0x8028)
#define PR_EMS_AB_EXPORT_CONTAINERS  PROP_TAG( PT_MV_TSTRING, 0x80A5)
#define PR_EMS_AB_EXPORT_CONTAINERS_A        PROP_TAG( PT_MV_STRING8, 0x80A5)
#define PR_EMS_AB_EXPORT_CONTAINERS_W        PROP_TAG( PT_MV_UNICODE, 0x80A5)
#define PR_EMS_AB_EXPORT_CONTAINERS_O        PROP_TAG( PT_OBJECT,     0x80A5)
#define PR_EMS_AB_EXPORT_CONTAINERS_T        PROP_TAG( PT_MV_TSTRING, 0x80A5)
#define PR_EMS_AB_EXPORT_CUSTOM_RECIPIENTS   PROP_TAG( PT_BOOLEAN,    0x80A6)
#define PR_EMS_AB_EXTENDED_CHARS_ALLOWED     PROP_TAG( PT_BOOLEAN,    0x80A7)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_1      PROP_TAG( PT_TSTRING,    0x802D)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_1_A    PROP_TAG( PT_STRING8,    0x802D)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_1_W    PROP_TAG( PT_UNICODE,    0x802D)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_10     PROP_TAG( PT_TSTRING,    0x8036)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_10_A   PROP_TAG( PT_STRING8,    0x8036)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_10_W   PROP_TAG( PT_UNICODE,    0x8036)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_2      PROP_TAG( PT_TSTRING,    0x802E)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_2_A    PROP_TAG( PT_STRING8,    0x802E)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_2_W    PROP_TAG( PT_UNICODE,    0x802E)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_3      PROP_TAG( PT_TSTRING,    0x802F)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_3_A    PROP_TAG( PT_STRING8,    0x802F)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_3_W    PROP_TAG( PT_UNICODE,    0x802F)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_4      PROP_TAG( PT_TSTRING,    0x8030)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_4_A    PROP_TAG( PT_STRING8,    0x8030)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_4_W    PROP_TAG( PT_UNICODE,    0x8030)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_5      PROP_TAG( PT_TSTRING,    0x8031)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_5_A    PROP_TAG( PT_STRING8,    0x8031)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_5_W    PROP_TAG( PT_UNICODE,    0x8031)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_6      PROP_TAG( PT_TSTRING,    0x8032)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_6_A    PROP_TAG( PT_STRING8,    0x8032)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_6_W    PROP_TAG( PT_UNICODE,    0x8032)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_7      PROP_TAG( PT_TSTRING,    0x8033)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_7_A    PROP_TAG( PT_STRING8,    0x8033)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_7_W    PROP_TAG( PT_UNICODE,    0x8033)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_8      PROP_TAG( PT_TSTRING,    0x8034)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_8_A    PROP_TAG( PT_STRING8,    0x8034)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_8_W    PROP_TAG( PT_UNICODE,    0x8034)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_9      PROP_TAG( PT_TSTRING,    0x8035)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_9_A    PROP_TAG( PT_STRING8,    0x8035)
#define PR_EMS_AB_EXTENSION_ATTRIBUTE_9_W    PROP_TAG( PT_UNICODE,    0x8035)
#define PR_EMS_AB_EXTENSION_DATA     PROP_TAG( PT_MV_BINARY,  0x80A8)
#define PR_EMS_AB_EXTENSION_NAME     PROP_TAG( PT_MV_TSTRING, 0x80A9)
#define PR_EMS_AB_EXTENSION_NAME_A   PROP_TAG( PT_MV_STRING8, 0x80A9)
#define PR_EMS_AB_EXTENSION_NAME_W   PROP_TAG( PT_MV_UNICODE, 0x80A9)
#define PR_EMS_AB_EXTENSION_NAME_INHERITED   PROP_TAG( PT_MV_TSTRING, 0x80AA)
#define PR_EMS_AB_EXTENSION_NAME_INHERITED_A PROP_TAG( PT_MV_STRING8, 0x80AA)
#define PR_EMS_AB_EXTENSION_NAME_INHERITED_W PROP_TAG( PT_MV_UNICODE, 0x80AA)
#define PR_EMS_AB_FACSIMILE_TELEPHONE_NUMBER PROP_TAG( PT_MV_BINARY,  0x80AB)
#define PR_EMS_AB_FILE_VERSION       PROP_TAG( PT_BINARY,     0x80AC)
#define PR_EMS_AB_FILTER_LOCAL_ADDRESSES     PROP_TAG( PT_BOOLEAN,    0x80AD)
#define PR_EMS_AB_FOLDER_PATHNAME    PROP_TAG( PT_TSTRING,    0x8004)
#define PR_EMS_AB_FOLDER_PATHNAME_A  PROP_TAG( PT_STRING8,    0x8004)
#define PR_EMS_AB_FOLDER_PATHNAME_W  PROP_TAG( PT_UNICODE,    0x8004)
#define PR_EMS_AB_FOLDERS_CONTAINER  PROP_TAG( PT_TSTRING,    0x80AE)
#define PR_EMS_AB_FOLDERS_CONTAINER_A        PROP_TAG( PT_STRING8,    0x80AE)
#define PR_EMS_AB_FOLDERS_CONTAINER_W        PROP_TAG( PT_UNICODE,    0x80AE)
#define PR_EMS_AB_FOLDERS_CONTAINER_O        PROP_TAG( PT_OBJECT,     0x80AE)
#define PR_EMS_AB_FOLDERS_CONTAINER_T        PROP_TAG( PT_TSTRING,    0x80AE)
#define PR_EMS_AB_GARBAGE_COLL_PERIOD        PROP_TAG( PT_LONG,  0x80AF)
#define PR_EMS_AB_GATEWAY_LOCAL_CRED PROP_TAG( PT_TSTRING,    0x80B0)
#define PR_EMS_AB_GATEWAY_LOCAL_CRED_A       PROP_TAG( PT_STRING8,    0x80B0)
#define PR_EMS_AB_GATEWAY_LOCAL_CRED_W       PROP_TAG( PT_UNICODE,    0x80B0)
#define PR_EMS_AB_GATEWAY_LOCAL_DESIG        PROP_TAG( PT_TSTRING,    0x80B1)
#define PR_EMS_AB_GATEWAY_LOCAL_DESIG_A      PROP_TAG( PT_STRING8,    0x80B1)
#define PR_EMS_AB_GATEWAY_LOCAL_DESIG_W      PROP_TAG( PT_UNICODE,    0x80B1)
#define PR_EMS_AB_GATEWAY_PROXY      PROP_TAG( PT_MV_TSTRING, 0x80B2)
#define PR_EMS_AB_GATEWAY_PROXY_A    PROP_TAG( PT_MV_STRING8, 0x80B2)
#define PR_EMS_AB_GATEWAY_PROXY_W    PROP_TAG( PT_MV_UNICODE, 0x80B2)
#define PR_EMS_AB_GATEWAY_ROUTING_TREE       PROP_TAG( PT_BINARY,     0x80B3)
#define PR_EMS_AB_GWART_LAST_MODIFIED        PROP_TAG( PT_SYSTIME,    0x80B4)
#define PR_EMS_AB_HAS_FULL_REPLICA_NCS       PROP_TAG( PT_MV_TSTRING, 0x80B5)
#define PR_EMS_AB_HAS_FULL_REPLICA_NCS_A     PROP_TAG( PT_MV_STRING8, 0x80B5)
#define PR_EMS_AB_HAS_FULL_REPLICA_NCS_W     PROP_TAG( PT_MV_UNICODE, 0x80B5)
#define PR_EMS_AB_HAS_FULL_REPLICA_NCS_O     PROP_TAG( PT_OBJECT,     0x80B5)
#define PR_EMS_AB_HAS_FULL_REPLICA_NCS_T     PROP_TAG( PT_MV_TSTRING, 0x80B5)
#define PR_EMS_AB_HAS_MASTER_NCS     PROP_TAG( PT_MV_TSTRING, 0x80B6)
#define PR_EMS_AB_HAS_MASTER_NCS_A   PROP_TAG( PT_MV_STRING8, 0x80B6)
#define PR_EMS_AB_HAS_MASTER_NCS_W   PROP_TAG( PT_MV_UNICODE, 0x80B6)
#define PR_EMS_AB_HAS_MASTER_NCS_O   PROP_TAG( PT_OBJECT,     0x80B6)
#define PR_EMS_AB_HAS_MASTER_NCS_T   PROP_TAG( PT_MV_TSTRING, 0x80B6)
#define PR_EMS_AB_HELP_DATA16        PROP_TAG( PT_BINARY,     0x803A)
#define PR_EMS_AB_HELP_DATA32        PROP_TAG( PT_BINARY,     0x8010)
#define PR_EMS_AB_HELP_FILE_NAME     PROP_TAG( PT_TSTRING,    0x803B)
#define PR_EMS_AB_HELP_FILE_NAME_A   PROP_TAG( PT_STRING8,    0x803B)
#define PR_EMS_AB_HELP_FILE_NAME_W   PROP_TAG( PT_UNICODE,    0x803B)
#define PR_EMS_AB_HEURISTICS         PROP_TAG( PT_LONG,  0x80B7)
#define PR_EMS_AB_HIDE_DL_MEMBERSHIP PROP_TAG( PT_BOOLEAN,    0x80B8)
#define PR_EMS_AB_HIDE_FROM_ADDRESS_BOOK     PROP_TAG( PT_BOOLEAN,    0x80B9)
#define PR_EMS_AB_HOME_MDB   PROP_TAG( PT_TSTRING,    0x8006)
#define PR_EMS_AB_HOME_MDB_A         PROP_TAG( PT_STRING8,    0x8006)
#define PR_EMS_AB_HOME_MDB_W         PROP_TAG( PT_UNICODE,    0x8006)
#define PR_EMS_AB_HOME_MDB_O         PROP_TAG( PT_OBJECT,     0x8006)
#define PR_EMS_AB_HOME_MDB_T         PROP_TAG( PT_TSTRING,    0x8006)
#define PR_EMS_AB_HOME_MDB_BL        PROP_TAG( PT_MV_TSTRING, 0x8014)
#define PR_EMS_AB_HOME_MDB_BL_A      PROP_TAG( PT_MV_STRING8, 0x8014)
#define PR_EMS_AB_HOME_MDB_BL_W      PROP_TAG( PT_MV_UNICODE, 0x8014)
#define PR_EMS_AB_HOME_MDB_BL_O      PROP_TAG( PT_OBJECT,     0x8014)
#define PR_EMS_AB_HOME_MDB_BL_T      PROP_TAG( PT_MV_TSTRING, 0x8014)
#define PR_EMS_AB_HOME_MTA   PROP_TAG( PT_TSTRING,    0x8007)
#define PR_EMS_AB_HOME_MTA_A         PROP_TAG( PT_STRING8,    0x8007)
#define PR_EMS_AB_HOME_MTA_W         PROP_TAG( PT_UNICODE,    0x8007)
#define PR_EMS_AB_HOME_MTA_O         PROP_TAG( PT_OBJECT,     0x8007)
#define PR_EMS_AB_HOME_MTA_T         PROP_TAG( PT_TSTRING,    0x8007)
#define PR_EMS_AB_HOME_PUBLIC_SERVER PROP_TAG( PT_TSTRING,    0x803F)
#define PR_EMS_AB_HOME_PUBLIC_SERVER_A       PROP_TAG( PT_STRING8,    0x803F)
#define PR_EMS_AB_HOME_PUBLIC_SERVER_W       PROP_TAG( PT_UNICODE,    0x803F)
#define PR_EMS_AB_HOME_PUBLIC_SERVER_O       PROP_TAG( PT_OBJECT,     0x803F)
#define PR_EMS_AB_HOME_PUBLIC_SERVER_T       PROP_TAG( PT_TSTRING,    0x803F)
#define PR_EMS_AB_IMPORT_CONTAINER   PROP_TAG( PT_TSTRING,    0x80BA)
#define PR_EMS_AB_IMPORT_CONTAINER_A PROP_TAG( PT_STRING8,    0x80BA)
#define PR_EMS_AB_IMPORT_CONTAINER_W PROP_TAG( PT_UNICODE,    0x80BA)
#define PR_EMS_AB_IMPORT_CONTAINER_O PROP_TAG( PT_OBJECT,     0x80BA)
#define PR_EMS_AB_IMPORT_CONTAINER_T PROP_TAG( PT_TSTRING,    0x80BA)
#define PR_EMS_AB_IMPORT_SENSITIVITY PROP_TAG( PT_LONG,  0x80BB)
#define PR_EMS_AB_IMPORTED_FROM      PROP_TAG( PT_TSTRING,    0x8042)
#define PR_EMS_AB_IMPORTED_FROM_A    PROP_TAG( PT_STRING8,    0x8042)
#define PR_EMS_AB_IMPORTED_FROM_W    PROP_TAG( PT_UNICODE,    0x8042)
#define PR_EMS_AB_INBOUND_SITES      PROP_TAG( PT_MV_TSTRING, 0x80BC)
#define PR_EMS_AB_INBOUND_SITES_A    PROP_TAG( PT_MV_STRING8, 0x80BC)
#define PR_EMS_AB_INBOUND_SITES_W    PROP_TAG( PT_MV_UNICODE, 0x80BC)
#define PR_EMS_AB_INBOUND_SITES_O    PROP_TAG( PT_OBJECT,     0x80BC)
#define PR_EMS_AB_INBOUND_SITES_T    PROP_TAG( PT_MV_TSTRING, 0x80BC)
#define PR_EMS_AB_INSTANCE_TYPE      PROP_TAG( PT_LONG,  0x80BD)
#define PR_EMS_AB_INTERNATIONAL_ISDN_NUMBER  PROP_TAG( PT_MV_TSTRING, 0x80BE)
#define PR_EMS_AB_INTERNATIONAL_ISDN_NUMBER_A PROP_TAG( PT_MV_STRING8, 0x80BE)
#define PR_EMS_AB_INTERNATIONAL_ISDN_NUMBER_W PROP_TAG( PT_MV_UNICODE, 0x80BE)
#define PR_EMS_AB_INVOCATION_ID      PROP_TAG( PT_BINARY,     0x80BF)
#define PR_EMS_AB_IS_DELETED         PROP_TAG( PT_BOOLEAN,    0x80C0)
#define PR_EMS_AB_IS_MEMBER_OF_DL    PROP_TAG( PT_OBJECT,  0x8008)
#define PR_EMS_AB_IS_MEMBER_OF_DL_A  PROP_TAG( PT_MV_STRING8, 0x8008)
#define PR_EMS_AB_IS_MEMBER_OF_DL_W  PROP_TAG( PT_MV_UNICODE, 0x8008)
#define PR_EMS_AB_IS_MEMBER_OF_DL_O  PROP_TAG( PT_OBJECT,     0x8008)
#define PR_EMS_AB_IS_MEMBER_OF_DL_T  PROP_TAG( PT_MV_TSTRING, 0x8008)
#define PR_EMS_AB_IS_SINGLE_VALUED   PROP_TAG( PT_BOOLEAN,    0x80C1)
#define PR_EMS_AB_KCC_STATUS         PROP_TAG( PT_MV_BINARY,  0x80C2)
#define PR_EMS_AB_KM_SERVER  PROP_TAG( PT_TSTRING,    0x800D)
#define PR_EMS_AB_KM_SERVER_A        PROP_TAG( PT_STRING8,    0x800D)
#define PR_EMS_AB_KM_SERVER_W        PROP_TAG( PT_UNICODE,    0x800D)
#define PR_EMS_AB_KM_SERVER_O        PROP_TAG( PT_OBJECT,     0x800D)
#define PR_EMS_AB_KM_SERVER_T        PROP_TAG( PT_TSTRING,    0x800D)
#define PR_EMS_AB_KNOWLEDGE_INFORMATION      PROP_TAG( PT_MV_TSTRING, 0x80C3)
#define PR_EMS_AB_KNOWLEDGE_INFORMATION_A    PROP_TAG( PT_MV_STRING8, 0x80C3)
#define PR_EMS_AB_KNOWLEDGE_INFORMATION_W    PROP_TAG( PT_MV_UNICODE, 0x80C3)
#define PR_EMS_AB_LANGUAGE   PROP_TAG( PT_LONG,  0x8178)
#define PR_EMS_AB_LDAP_DISPLAY_NAME  PROP_TAG( PT_MV_TSTRING, 0x8171)
#define PR_EMS_AB_LDAP_DISPLAY_NAME_A        PROP_TAG( PT_MV_STRING8, 0x8171)
#define PR_EMS_AB_LDAP_DISPLAY_NAME_W        PROP_TAG( PT_MV_UNICODE, 0x8171)
#define PR_EMS_AB_LINE_WRAP  PROP_TAG( PT_LONG,  0x80C4)
#define PR_EMS_AB_LINK_ID    PROP_TAG( PT_LONG,  0x80C5)
#define PR_EMS_AB_LOCAL_BRIDGE_HEAD  PROP_TAG( PT_TSTRING,    0x80C6)
#define PR_EMS_AB_LOCAL_BRIDGE_HEAD_A        PROP_TAG( PT_STRING8,    0x80C6)
#define PR_EMS_AB_LOCAL_BRIDGE_HEAD_W        PROP_TAG( PT_UNICODE,    0x80C6)
#define PR_EMS_AB_LOCAL_BRIDGE_HEAD_ADDRESS  PROP_TAG( PT_TSTRING,    0x80C7)
#define PR_EMS_AB_LOCAL_BRIDGE_HEAD_ADDRESS_A PROP_TAG( PT_STRING8,    0x80C7)
#define PR_EMS_AB_LOCAL_BRIDGE_HEAD_ADDRESS_W PROP_TAG( PT_UNICODE,    0x80C7)
#define PR_EMS_AB_LOCAL_INITIAL_TURN PROP_TAG( PT_BOOLEAN,    0x80C8)
#define PR_EMS_AB_LOCAL_SCOPE        PROP_TAG( PT_MV_TSTRING, 0x80C9)
#define PR_EMS_AB_LOCAL_SCOPE_A      PROP_TAG( PT_MV_STRING8, 0x80C9)
#define PR_EMS_AB_LOCAL_SCOPE_W      PROP_TAG( PT_MV_UNICODE, 0x80C9)
#define PR_EMS_AB_LOCAL_SCOPE_O      PROP_TAG( PT_OBJECT,     0x80C9)
#define PR_EMS_AB_LOCAL_SCOPE_T      PROP_TAG( PT_MV_TSTRING, 0x80C9)
#define PR_EMS_AB_LOG_FILENAME       PROP_TAG( PT_TSTRING,    0x80CA)
#define PR_EMS_AB_LOG_FILENAME_A     PROP_TAG( PT_STRING8,    0x80CA)
#define PR_EMS_AB_LOG_FILENAME_W     PROP_TAG( PT_UNICODE,    0x80CA)
#define PR_EMS_AB_LOG_ROLLOVER_INTERVAL      PROP_TAG( PT_LONG,  0x80CB)
#define PR_EMS_AB_MAINTAIN_AUTOREPLY_HISTORY PROP_TAG( PT_BOOLEAN,    0x80CC)
#define PR_EMS_AB_MANAGER    PROP_TAG( PT_OBJECT,     0x8005)
#define PR_EMS_AB_MANAGER_A  PROP_TAG( PT_STRING8,    0x8005)
#define PR_EMS_AB_MANAGER_W  PROP_TAG( PT_UNICODE,    0x8005)
#define PR_EMS_AB_MANAGER_O  PROP_TAG( PT_OBJECT,     0x8005)
#define PR_EMS_AB_MANAGER_T  PROP_TAG( PT_TSTRING,    0x8005)
#define PR_EMS_AB_MAPI_DISPLAY_TYPE  PROP_TAG( PT_LONG,  0x80CD)
#define PR_EMS_AB_MAPI_ID    PROP_TAG( PT_LONG,  0x80CE)
#define PR_EMS_AB_MAXIMUM_OBJECT_ID  PROP_TAG( PT_BINARY,     0x8169)
#define PR_EMS_AB_MDB_BACKOFF_INTERVAL       PROP_TAG( PT_LONG,  0x80CF)
#define PR_EMS_AB_MDB_MSG_TIME_OUT_PERIOD    PROP_TAG( PT_LONG,  0x80D0)
#define PR_EMS_AB_MDB_OVER_QUOTA_LIMIT       PROP_TAG( PT_LONG,  0x80D1)
#define PR_EMS_AB_MDB_STORAGE_QUOTA  PROP_TAG( PT_LONG,  0x80D2)
#define PR_EMS_AB_MDB_UNREAD_LIMIT   PROP_TAG( PT_LONG,  0x80D3)
#define PR_EMS_AB_MDB_USE_DEFAULTS   PROP_TAG( PT_BOOLEAN,    0x80D4)
#define PR_EMS_AB_MEMBER     PROP_TAG( PT_OBJECT,     0x8009)
#define PR_EMS_AB_MEMBER_A   PROP_TAG( PT_MV_STRING8, 0x8009)
#define PR_EMS_AB_MEMBER_W   PROP_TAG( PT_MV_UNICODE, 0x8009)
#define PR_EMS_AB_MEMBER_O   PROP_TAG( PT_OBJECT,     0x8009)
#define PR_EMS_AB_MEMBER_T   PROP_TAG( PT_MV_TSTRING, 0x8009)
#define PR_EMS_AB_MESSAGE_TRACKING_ENABLED   PROP_TAG( PT_BOOLEAN,    0x80D5)
#define PR_EMS_AB_MONITOR_CLOCK      PROP_TAG( PT_BOOLEAN,    0x80D6)
#define PR_EMS_AB_MONITOR_SERVERS    PROP_TAG( PT_BOOLEAN,    0x80D7)
#define PR_EMS_AB_MONITOR_SERVICES   PROP_TAG( PT_BOOLEAN,    0x80D8)
#define PR_EMS_AB_MONITORED_CONFIGURATIONS   PROP_TAG( PT_MV_TSTRING, 0x80D9)
#define PR_EMS_AB_MONITORED_CONFIGURATIONS_A PROP_TAG( PT_MV_STRING8, 0x80D9)
#define PR_EMS_AB_MONITORED_CONFIGURATIONS_W PROP_TAG( PT_MV_UNICODE, 0x80D9)
#define PR_EMS_AB_MONITORED_CONFIGURATIONS_O PROP_TAG( PT_OBJECT,     0x80D9)
#define PR_EMS_AB_MONITORED_CONFIGURATIONS_T PROP_TAG( PT_MV_TSTRING, 0x80D9)
#define PR_EMS_AB_MONITORED_SERVERS  PROP_TAG( PT_MV_TSTRING, 0x80DA)
#define PR_EMS_AB_MONITORED_SERVERS_A        PROP_TAG( PT_MV_STRING8, 0x80DA)
#define PR_EMS_AB_MONITORED_SERVERS_W        PROP_TAG( PT_MV_UNICODE, 0x80DA)
#define PR_EMS_AB_MONITORED_SERVERS_O        PROP_TAG( PT_OBJECT,     0x80DA)
#define PR_EMS_AB_MONITORED_SERVERS_T        PROP_TAG( PT_MV_TSTRING, 0x80DA)
#define PR_EMS_AB_MONITORED_SERVICES PROP_TAG( PT_MV_TSTRING, 0x80DB)
#define PR_EMS_AB_MONITORED_SERVICES_A       PROP_TAG( PT_MV_STRING8, 0x80DB)
#define PR_EMS_AB_MONITORED_SERVICES_W       PROP_TAG( PT_MV_UNICODE, 0x80DB)
#define PR_EMS_AB_MONITORING_ALERT_DELAY     PROP_TAG( PT_LONG,  0x80DC)
#define PR_EMS_AB_MONITORING_ALERT_UNITS     PROP_TAG( PT_LONG,  0x80DD)
#define PR_EMS_AB_MONITORING_AVAILABILITY_STYLE PROP_TAG( PT_LONG,  0x80DE)
#define PR_EMS_AB_MONITORING_AVAILABILITY_WINDOW PROP_TAG( PT_BINARY,     0x80DF)
#define PR_EMS_AB_MONITORING_CACHED_VIA_MAIL PROP_TAG( PT_MV_TSTRING, 0x80E0)
#define PR_EMS_AB_MONITORING_CACHED_VIA_MAIL_A PROP_TAG( PT_MV_STRING8, 0x80E0)
#define PR_EMS_AB_MONITORING_CACHED_VIA_MAIL_W PROP_TAG( PT_MV_UNICODE, 0x80E0)
#define PR_EMS_AB_MONITORING_CACHED_VIA_MAIL_O PROP_TAG( PT_OBJECT,     0x80E0)
#define PR_EMS_AB_MONITORING_CACHED_VIA_MAIL_T PROP_TAG( PT_MV_TSTRING, 0x80E0)
#define PR_EMS_AB_MONITORING_CACHED_VIA_RPC  PROP_TAG( PT_MV_TSTRING, 0x80E1)
#define PR_EMS_AB_MONITORING_CACHED_VIA_RPC_A PROP_TAG( PT_MV_STRING8, 0x80E1)
#define PR_EMS_AB_MONITORING_CACHED_VIA_RPC_W PROP_TAG( PT_MV_UNICODE, 0x80E1)
#define PR_EMS_AB_MONITORING_CACHED_VIA_RPC_O PROP_TAG( PT_OBJECT,     0x80E1)
#define PR_EMS_AB_MONITORING_CACHED_VIA_RPC_T PROP_TAG( PT_MV_TSTRING, 0x80E1)
#define PR_EMS_AB_MONITORING_ESCALATION_PROCEDURE PROP_TAG( PT_MV_BINARY,  0x80E2)
#define PR_EMS_AB_MONITORING_HOTSITE_POLL_INTERVAL PROP_TAG( PT_LONG,  0x80E3)
#define PR_EMS_AB_MONITORING_HOTSITE_POLL_UNITS PROP_TAG( PT_LONG,  0x80E4)
#define PR_EMS_AB_MONITORING_MAIL_UPDATE_INTERVAL PROP_TAG( PT_LONG,  0x80E5)
#define PR_EMS_AB_MONITORING_MAIL_UPDATE_UNITS PROP_TAG( PT_LONG,  0x80E6)
#define PR_EMS_AB_MONITORING_NORMAL_POLL_INTERVAL PROP_TAG( PT_LONG,  0x80E7)
#define PR_EMS_AB_MONITORING_NORMAL_POLL_UNITS PROP_TAG( PT_LONG,  0x80E8)
#define PR_EMS_AB_MONITORING_RECIPIENTS      PROP_TAG( PT_MV_TSTRING, 0x80E9)
#define PR_EMS_AB_MONITORING_RECIPIENTS_A    PROP_TAG( PT_MV_STRING8, 0x80E9)
#define PR_EMS_AB_MONITORING_RECIPIENTS_W    PROP_TAG( PT_MV_UNICODE, 0x80E9)
#define PR_EMS_AB_MONITORING_RECIPIENTS_O    PROP_TAG( PT_OBJECT,     0x80E9)
#define PR_EMS_AB_MONITORING_RECIPIENTS_T    PROP_TAG( PT_MV_TSTRING, 0x80E9)
#define PR_EMS_AB_MONITORING_RECIPIENTS_NDR  PROP_TAG( PT_MV_TSTRING, 0x80EA)
#define PR_EMS_AB_MONITORING_RECIPIENTS_NDR_A PROP_TAG( PT_MV_STRING8, 0x80EA)
#define PR_EMS_AB_MONITORING_RECIPIENTS_NDR_W PROP_TAG( PT_MV_UNICODE, 0x80EA)
#define PR_EMS_AB_MONITORING_RECIPIENTS_NDR_O PROP_TAG( PT_OBJECT,     0x80EA)
#define PR_EMS_AB_MONITORING_RECIPIENTS_NDR_T PROP_TAG( PT_MV_TSTRING, 0x80EA)
#define PR_EMS_AB_MONITORING_RPC_UPDATE_INTERVAL PROP_TAG( PT_LONG,  0x80EB)
#define PR_EMS_AB_MONITORING_RPC_UPDATE_UNITS PROP_TAG( PT_LONG,  0x80EC)
#define PR_EMS_AB_MONITORING_WARNING_DELAY   PROP_TAG( PT_LONG,  0x80ED)
#define PR_EMS_AB_MONITORING_WARNING_UNITS   PROP_TAG( PT_LONG,  0x80EE)
#define PR_EMS_AB_MTA_LOCAL_CRED     PROP_TAG( PT_TSTRING,    0x80EF)
#define PR_EMS_AB_MTA_LOCAL_CRED_A   PROP_TAG( PT_STRING8,    0x80EF)
#define PR_EMS_AB_MTA_LOCAL_CRED_W   PROP_TAG( PT_UNICODE,    0x80EF)
#define PR_EMS_AB_MTA_LOCAL_DESIG    PROP_TAG( PT_TSTRING,    0x80F0)
#define PR_EMS_AB_MTA_LOCAL_DESIG_A  PROP_TAG( PT_STRING8,    0x80F0)
#define PR_EMS_AB_MTA_LOCAL_DESIG_W  PROP_TAG( PT_UNICODE,    0x80F0)
#define PR_EMS_AB_N_ADDRESS  PROP_TAG( PT_BINARY,     0x80F1)
#define PR_EMS_AB_N_ADDRESS_TYPE     PROP_TAG( PT_LONG,  0x80F2)
#define PR_EMS_AB_NETWORK_ADDRESS    PROP_TAG( PT_MV_TSTRING, 0x8170)
#define PR_EMS_AB_NETWORK_ADDRESS_A  PROP_TAG( PT_MV_STRING8, 0x8170)
#define PR_EMS_AB_NETWORK_ADDRESS_W  PROP_TAG( PT_MV_UNICODE, 0x8170)
#define PR_EMS_AB_NNTP_CHARACTER_SET PROP_TAG( PT_TSTRING,    0x817D)
#define PR_EMS_AB_NNTP_CHARACTER_SET_A       PROP_TAG( PT_STRING8,    0x817D)
#define PR_EMS_AB_NNTP_CHARACTER_SET_W       PROP_TAG( PT_UNICODE,    0x817D)
#define PR_EMS_AB_NNTP_CONTENT_FORMAT        PROP_TAG( PT_TSTRING,    0x8176)
#define PR_EMS_AB_NNTP_CONTENT_FORMAT_A      PROP_TAG( PT_STRING8,    0x8176)
#define PR_EMS_AB_NNTP_CONTENT_FORMAT_W      PROP_TAG( PT_UNICODE,    0x8176)
#define PR_EMS_AB_NT_MACHINE_NAME    PROP_TAG( PT_TSTRING,    0x80F3)
#define PR_EMS_AB_NT_MACHINE_NAME_A  PROP_TAG( PT_STRING8,    0x80F3)
#define PR_EMS_AB_NT_MACHINE_NAME_W  PROP_TAG( PT_UNICODE,    0x80F3)
#define PR_EMS_AB_NT_SECURITY_DESCRIPTOR     PROP_TAG( PT_BINARY,     0x8013)
#define PR_EMS_AB_NUM_OF_OPEN_RETRIES        PROP_TAG( PT_LONG,  0x80F4)
#define PR_EMS_AB_NUM_OF_TRANSFER_RETRIES    PROP_TAG( PT_LONG,  0x80F5)
#define PR_EMS_AB_OBJ_DIST_NAME      PROP_TAG( PT_TSTRING,    0x803C)
#define PR_EMS_AB_OBJ_DIST_NAME_A    PROP_TAG( PT_STRING8,    0x803C)
#define PR_EMS_AB_OBJ_DIST_NAME_W    PROP_TAG( PT_UNICODE,    0x803C)
#define PR_EMS_AB_OBJ_DIST_NAME_O    PROP_TAG( PT_OBJECT,     0x803C)
#define PR_EMS_AB_OBJ_DIST_NAME_T    PROP_TAG( PT_TSTRING,    0x803C)
#define PR_EMS_AB_OBJECT_CLASS_CATEGORY      PROP_TAG( PT_LONG,  0x80F6)
#define PR_EMS_AB_OBJECT_VERSION     PROP_TAG( PT_LONG,  0x80F7)
#define PR_EMS_AB_OFF_LINE_AB_CONTAINERS     PROP_TAG( PT_MV_TSTRING, 0x80F8)
#define PR_EMS_AB_OFF_LINE_AB_CONTAINERS_A   PROP_TAG( PT_MV_STRING8, 0x80F8)
#define PR_EMS_AB_OFF_LINE_AB_CONTAINERS_W   PROP_TAG( PT_MV_UNICODE, 0x80F8)
#define PR_EMS_AB_OFF_LINE_AB_CONTAINERS_O   PROP_TAG( PT_OBJECT,     0x80F8)
#define PR_EMS_AB_OFF_LINE_AB_CONTAINERS_T   PROP_TAG( PT_MV_TSTRING, 0x80F8)
#define PR_EMS_AB_OFF_LINE_AB_SCHEDULE       PROP_TAG( PT_BINARY,     0x80F9)
#define PR_EMS_AB_OFF_LINE_AB_SERVER PROP_TAG( PT_TSTRING,    0x80FA)
#define PR_EMS_AB_OFF_LINE_AB_SERVER_A       PROP_TAG( PT_STRING8,    0x80FA)
#define PR_EMS_AB_OFF_LINE_AB_SERVER_W       PROP_TAG( PT_UNICODE,    0x80FA)
#define PR_EMS_AB_OFF_LINE_AB_SERVER_O       PROP_TAG( PT_OBJECT,     0x80FA)
#define PR_EMS_AB_OFF_LINE_AB_SERVER_T       PROP_TAG( PT_TSTRING,    0x80FA)
#define PR_EMS_AB_OFF_LINE_AB_STYLE  PROP_TAG( PT_LONG,  0x80FB)
#define PR_EMS_AB_OID_TYPE   PROP_TAG( PT_LONG,  0x80FC)
#define PR_EMS_AB_OM_OBJECT_CLASS    PROP_TAG( PT_BINARY,     0x80FD)
#define PR_EMS_AB_OM_SYNTAX  PROP_TAG( PT_LONG,  0x80FE)
#define PR_EMS_AB_OOF_REPLY_TO_ORIGINATOR    PROP_TAG( PT_BOOLEAN,    0x80FF)
#define PR_EMS_AB_OPEN_RETRY_INTERVAL        PROP_TAG( PT_LONG,  0x8100)
#define PR_EMS_AB_ORGANIZATION_NAME  PROP_TAG( PT_MV_TSTRING, 0x8101)
#define PR_EMS_AB_ORGANIZATION_NAME_A        PROP_TAG( PT_MV_STRING8, 0x8101)
#define PR_EMS_AB_ORGANIZATION_NAME_W        PROP_TAG( PT_MV_UNICODE, 0x8101)
#define PR_EMS_AB_ORGANIZATIONAL_UNIT_NAME   PROP_TAG( PT_MV_TSTRING, 0x8102)
#define PR_EMS_AB_ORGANIZATIONAL_UNIT_NAME_A PROP_TAG( PT_MV_STRING8, 0x8102)
#define PR_EMS_AB_ORGANIZATIONAL_UNIT_NAME_W PROP_TAG( PT_MV_UNICODE, 0x8102)
#define PR_EMS_AB_ORIGINAL_DISPLAY_TABLE     PROP_TAG( PT_BINARY,     0x8103)
#define PR_EMS_AB_ORIGINAL_DISPLAY_TABLE_MSDOS PROP_TAG( PT_BINARY,     0x8104)
#define PR_EMS_AB_OUTBOUND_SITES     PROP_TAG( PT_MV_TSTRING, 0x8105)
#define PR_EMS_AB_OUTBOUND_SITES_A   PROP_TAG( PT_MV_STRING8, 0x8105)
#define PR_EMS_AB_OUTBOUND_SITES_W   PROP_TAG( PT_MV_UNICODE, 0x8105)
#define PR_EMS_AB_OUTBOUND_SITES_O   PROP_TAG( PT_OBJECT,     0x8105)
#define PR_EMS_AB_OUTBOUND_SITES_T   PROP_TAG( PT_MV_TSTRING, 0x8105)
#define PR_EMS_AB_OWNER      PROP_TAG( PT_TSTRING,    0x800C)
#define PR_EMS_AB_OWNER_A    PROP_TAG( PT_STRING8,    0x800C)
#define PR_EMS_AB_OWNER_W    PROP_TAG( PT_UNICODE,    0x800C)
#define PR_EMS_AB_OWNER_O    PROP_TAG( PT_OBJECT,     0x800C)
#define PR_EMS_AB_OWNER_T    PROP_TAG( PT_TSTRING,    0x800C)
#define PR_EMS_AB_OWNER_BL   PROP_TAG( PT_TSTRING,    0x8024)
#define PR_EMS_AB_OWNER_BL_A         PROP_TAG( PT_STRING8,    0x8024)
#define PR_EMS_AB_OWNER_BL_W         PROP_TAG( PT_UNICODE,    0x8024)
#define PR_EMS_AB_OWNER_BL_O         PROP_TAG( PT_OBJECT,     0x8024)
#define PR_EMS_AB_OWNER_BL_T         PROP_TAG( PT_TSTRING,    0x8024)
#define PR_EMS_AB_P_SELECTOR         PROP_TAG( PT_BINARY,     0x8106)
#define PR_EMS_AB_P_SELECTOR_INBOUND PROP_TAG( PT_BINARY,     0x8107)
#define PR_EMS_AB_PER_MSG_DIALOG_DISPLAY_TABLE PROP_TAG( PT_BINARY,     0x8108)
#define PR_EMS_AB_PER_RECIP_DIALOG_DISPLAY_TABLE PROP_TAG( PT_BINARY,     0x8109)
#define PR_EMS_AB_PERIOD_REP_SYNC_TIMES      PROP_TAG( PT_BINARY,     0x810A)
#define PR_EMS_AB_PERIOD_REPL_STAGGER        PROP_TAG( PT_LONG,  0x810B)
#define PR_EMS_AB_PF_CONTACTS        PROP_TAG( PT_MV_TSTRING, 0x8038)
#define PR_EMS_AB_PF_CONTACTS_A      PROP_TAG( PT_MV_STRING8, 0x8038)
#define PR_EMS_AB_PF_CONTACTS_W      PROP_TAG( PT_MV_UNICODE, 0x8038)
#define PR_EMS_AB_PF_CONTACTS_O      PROP_TAG( PT_OBJECT,     0x8038)
#define PR_EMS_AB_PF_CONTACTS_T      PROP_TAG( PT_MV_TSTRING, 0x8038)
#define PR_EMS_AB_POP_CHARACTER_SET  PROP_TAG( PT_TSTRING,    0x8179)
#define PR_EMS_AB_POP_CHARACTER_SET_A        PROP_TAG( PT_STRING8,    0x8179)
#define PR_EMS_AB_POP_CHARACTER_SET_W        PROP_TAG( PT_UNICODE,    0x8179)
#define PR_EMS_AB_POP_CONTENT_FORMAT PROP_TAG( PT_TSTRING,    0x8177)
#define PR_EMS_AB_POP_CONTENT_FORMAT_A       PROP_TAG( PT_STRING8,    0x8177)
#define PR_EMS_AB_POP_CONTENT_FORMAT_W       PROP_TAG( PT_UNICODE,    0x8177)
#define PR_EMS_AB_POSTAL_ADDRESS     PROP_TAG( PT_MV_BINARY,  0x810C)
#define PR_EMS_AB_PREFERRED_DELIVERY_METHOD  PROP_TAG( PT_MV_LONG,    0x810D)
#define PR_EMS_AB_PRMD       PROP_TAG( PT_TSTRING,    0x810E)
#define PR_EMS_AB_PRMD_A     PROP_TAG( PT_STRING8,    0x810E)
#define PR_EMS_AB_PRMD_W     PROP_TAG( PT_UNICODE,    0x810E)
#define PR_EMS_AB_PROXY_ADDRESSES    PROP_TAG( PT_MV_TSTRING, 0x800F)
#define PR_EMS_AB_PROXY_ADDRESSES_A  PROP_TAG( PT_MV_STRING8, 0x800F)
#define PR_EMS_AB_PROXY_ADDRESSES_W  PROP_TAG( PT_MV_UNICODE, 0x800F)
#define PR_EMS_AB_PROXY_GENERATOR_DLL        PROP_TAG( PT_TSTRING,    0x810F)
#define PR_EMS_AB_PROXY_GENERATOR_DLL_A      PROP_TAG( PT_STRING8,    0x810F)
#define PR_EMS_AB_PROXY_GENERATOR_DLL_W      PROP_TAG( PT_UNICODE,    0x810F)
#define PR_EMS_AB_PUBLIC_DELEGATES   PROP_TAG( PT_OBJECT,     0x8015)
#define PR_EMS_AB_PUBLIC_DELEGATES_A PROP_TAG( PT_MV_STRING8, 0x8015)
#define PR_EMS_AB_PUBLIC_DELEGATES_W PROP_TAG( PT_MV_UNICODE, 0x8015)
#define PR_EMS_AB_PUBLIC_DELEGATES_O PROP_TAG( PT_OBJECT,     0x8015)
#define PR_EMS_AB_PUBLIC_DELEGATES_T PROP_TAG( PT_MV_TSTRING, 0x8015)
#define PR_EMS_AB_PUBLIC_DELEGATES_BL        PROP_TAG( PT_MV_TSTRING, 0x8110)
#define PR_EMS_AB_PUBLIC_DELEGATES_BL_A      PROP_TAG( PT_MV_STRING8, 0x8110)
#define PR_EMS_AB_PUBLIC_DELEGATES_BL_W      PROP_TAG( PT_MV_UNICODE, 0x8110)
#define PR_EMS_AB_PUBLIC_DELEGATES_BL_O      PROP_TAG( PT_OBJECT,     0x8110)
#define PR_EMS_AB_PUBLIC_DELEGATES_BL_T      PROP_TAG( PT_MV_TSTRING, 0x8110)
#define PR_EMS_AB_QUOTA_NOTIFICATION_SCHEDULE PROP_TAG( PT_BINARY,     0x8111)
#define PR_EMS_AB_QUOTA_NOTIFICATION_STYLE   PROP_TAG( PT_LONG,  0x8112)
#define PR_EMS_AB_RANGE_LOWER        PROP_TAG( PT_LONG,  0x8113)
#define PR_EMS_AB_RANGE_UPPER        PROP_TAG( PT_LONG,  0x8114)
#define PR_EMS_AB_RAS_CALLBACK_NUMBER        PROP_TAG( PT_TSTRING,    0x8115)
#define PR_EMS_AB_RAS_CALLBACK_NUMBER_A      PROP_TAG( PT_STRING8,    0x8115)
#define PR_EMS_AB_RAS_CALLBACK_NUMBER_W      PROP_TAG( PT_UNICODE,    0x8115)
#define PR_EMS_AB_RAS_PHONE_NUMBER   PROP_TAG( PT_TSTRING,    0x8116)
#define PR_EMS_AB_RAS_PHONE_NUMBER_A PROP_TAG( PT_STRING8,    0x8116)
#define PR_EMS_AB_RAS_PHONE_NUMBER_W PROP_TAG( PT_UNICODE,    0x8116)
#define PR_EMS_AB_RAS_PHONEBOOK_ENTRY_NAME   PROP_TAG( PT_TSTRING,    0x8117)
#define PR_EMS_AB_RAS_PHONEBOOK_ENTRY_NAME_A PROP_TAG( PT_STRING8,    0x8117)
#define PR_EMS_AB_RAS_PHONEBOOK_ENTRY_NAME_W PROP_TAG( PT_UNICODE,    0x8117)
#define PR_EMS_AB_RAS_REMOTE_SRVR_NAME       PROP_TAG( PT_TSTRING,    0x8118)
#define PR_EMS_AB_RAS_REMOTE_SRVR_NAME_A     PROP_TAG( PT_STRING8,    0x8118)
#define PR_EMS_AB_RAS_REMOTE_SRVR_NAME_W     PROP_TAG( PT_UNICODE,    0x8118)
#define PR_EMS_AB_REGISTERED_ADDRESS PROP_TAG( PT_MV_BINARY,  0x8119)
#define PR_EMS_AB_REMOTE_BRIDGE_HEAD PROP_TAG( PT_TSTRING,    0x811A)
#define PR_EMS_AB_REMOTE_BRIDGE_HEAD_A       PROP_TAG( PT_STRING8,    0x811A)
#define PR_EMS_AB_REMOTE_BRIDGE_HEAD_W       PROP_TAG( PT_UNICODE,    0x811A)
#define PR_EMS_AB_REMOTE_BRIDGE_HEAD_ADDRESS PROP_TAG( PT_TSTRING,    0x811B)
#define PR_EMS_AB_REMOTE_BRIDGE_HEAD_ADDRESS_A PROP_TAG( PT_STRING8,    0x811B)
#define PR_EMS_AB_REMOTE_BRIDGE_HEAD_ADDRESS_W PROP_TAG( PT_UNICODE,    0x811B)
#define PR_EMS_AB_REMOTE_OUT_BH_SERVER       PROP_TAG( PT_TSTRING,    0x811C)
#define PR_EMS_AB_REMOTE_OUT_BH_SERVER_A     PROP_TAG( PT_STRING8,    0x811C)
#define PR_EMS_AB_REMOTE_OUT_BH_SERVER_W     PROP_TAG( PT_UNICODE,    0x811C)
#define PR_EMS_AB_REMOTE_OUT_BH_SERVER_O     PROP_TAG( PT_OBJECT,     0x811C)
#define PR_EMS_AB_REMOTE_OUT_BH_SERVER_T     PROP_TAG( PT_TSTRING,    0x811C)
#define PR_EMS_AB_REMOTE_SITE        PROP_TAG( PT_TSTRING,    0x811D)
#define PR_EMS_AB_REMOTE_SITE_A      PROP_TAG( PT_STRING8,    0x811D)
#define PR_EMS_AB_REMOTE_SITE_W      PROP_TAG( PT_UNICODE,    0x811D)
#define PR_EMS_AB_REMOTE_SITE_O      PROP_TAG( PT_OBJECT,     0x811D)
#define PR_EMS_AB_REMOTE_SITE_T      PROP_TAG( PT_TSTRING,    0x811D)
#define PR_EMS_AB_REPLICATION_MAIL_MSG_SIZE  PROP_TAG( PT_LONG,  0x8168)
#define PR_EMS_AB_REPLICATION_SENSITIVITY    PROP_TAG( PT_LONG,  0x811E)
#define PR_EMS_AB_REPLICATION_STAGGER        PROP_TAG( PT_LONG,  0x811F)
#define PR_EMS_AB_REPORT_TO_ORIGINATOR       PROP_TAG( PT_BOOLEAN,    0x8120)
#define PR_EMS_AB_REPORT_TO_OWNER    PROP_TAG( PT_BOOLEAN,    0x8121)
#define PR_EMS_AB_REPORTS    PROP_TAG( PT_OBJECT,     0x800E)
#define PR_EMS_AB_REPORTS_A  PROP_TAG( PT_MV_STRING8, 0x800E)
#define PR_EMS_AB_REPORTS_W  PROP_TAG( PT_MV_UNICODE, 0x800E)
#define PR_EMS_AB_REPORTS_O  PROP_TAG( PT_OBJECT,     0x800E)
#define PR_EMS_AB_REPORTS_T  PROP_TAG( PT_MV_TSTRING, 0x800E)
#define PR_EMS_AB_REQ_SEQ    PROP_TAG( PT_LONG,  0x8122)
#define PR_EMS_AB_RESPONSIBLE_LOCAL_DXA      PROP_TAG( PT_TSTRING,    0x8123)
#define PR_EMS_AB_RESPONSIBLE_LOCAL_DXA_A    PROP_TAG( PT_STRING8,    0x8123)
#define PR_EMS_AB_RESPONSIBLE_LOCAL_DXA_W    PROP_TAG( PT_UNICODE,    0x8123)
#define PR_EMS_AB_RESPONSIBLE_LOCAL_DXA_O    PROP_TAG( PT_OBJECT,     0x8123)
#define PR_EMS_AB_RESPONSIBLE_LOCAL_DXA_T    PROP_TAG( PT_TSTRING,    0x8123)
#define PR_EMS_AB_RID_SERVER         PROP_TAG( PT_TSTRING,    0x8124)
#define PR_EMS_AB_RID_SERVER_A       PROP_TAG( PT_STRING8,    0x8124)
#define PR_EMS_AB_RID_SERVER_W       PROP_TAG( PT_UNICODE,    0x8124)
#define PR_EMS_AB_RID_SERVER_O       PROP_TAG( PT_OBJECT,     0x8124)
#define PR_EMS_AB_RID_SERVER_T       PROP_TAG( PT_TSTRING,    0x8124)
#define PR_EMS_AB_ROLE_OCCUPANT      PROP_TAG( PT_MV_TSTRING, 0x8125)
#define PR_EMS_AB_ROLE_OCCUPANT_A    PROP_TAG( PT_MV_STRING8, 0x8125)
#define PR_EMS_AB_ROLE_OCCUPANT_W    PROP_TAG( PT_MV_UNICODE, 0x8125)
#define PR_EMS_AB_ROLE_OCCUPANT_O    PROP_TAG( PT_OBJECT,     0x8125)
#define PR_EMS_AB_ROLE_OCCUPANT_T    PROP_TAG( PT_MV_TSTRING, 0x8125)
#define PR_EMS_AB_ROUTING_LIST       PROP_TAG( PT_MV_TSTRING, 0x8126)
#define PR_EMS_AB_ROUTING_LIST_A     PROP_TAG( PT_MV_STRING8, 0x8126)
#define PR_EMS_AB_ROUTING_LIST_W     PROP_TAG( PT_MV_UNICODE, 0x8126)
#define PR_EMS_AB_RTS_CHECKPOINT_SIZE        PROP_TAG( PT_LONG,  0x8127)
#define PR_EMS_AB_RTS_RECOVERY_TIMEOUT       PROP_TAG( PT_LONG,  0x8128)
#define PR_EMS_AB_RTS_WINDOW_SIZE    PROP_TAG( PT_LONG,  0x8129)
#define PR_EMS_AB_RUNS_ON    PROP_TAG( PT_MV_TSTRING, 0x812A)
#define PR_EMS_AB_RUNS_ON_A  PROP_TAG( PT_MV_STRING8, 0x812A)
#define PR_EMS_AB_RUNS_ON_W  PROP_TAG( PT_MV_UNICODE, 0x812A)
#define PR_EMS_AB_RUNS_ON_O  PROP_TAG( PT_OBJECT,     0x812A)
#define PR_EMS_AB_RUNS_ON_T  PROP_TAG( PT_MV_TSTRING, 0x812A)
#define PR_EMS_AB_S_SELECTOR         PROP_TAG( PT_BINARY,     0x812B)
#define PR_EMS_AB_S_SELECTOR_INBOUND PROP_TAG( PT_BINARY,     0x812C)
#define PR_EMS_AB_SCHEMA_FLAGS       PROP_TAG( PT_LONG,  0x8173)
#define PR_EMS_AB_SCHEMA_VERSION     PROP_TAG( PT_MV_LONG,    0x817C)
#define PR_EMS_AB_SEARCH_FLAGS       PROP_TAG( PT_LONG,  0x812D)
#define PR_EMS_AB_SEARCH_GUIDE       PROP_TAG( PT_MV_BINARY,  0x812E)
#define PR_EMS_AB_SECURITY_PROTOCOL  PROP_TAG( PT_MV_BINARY,  0x8037)
#define PR_EMS_AB_SEE_ALSO   PROP_TAG( PT_MV_TSTRING, 0x812F)
#define PR_EMS_AB_SEE_ALSO_A         PROP_TAG( PT_MV_STRING8, 0x812F)
#define PR_EMS_AB_SEE_ALSO_W         PROP_TAG( PT_MV_UNICODE, 0x812F)
#define PR_EMS_AB_SEE_ALSO_O         PROP_TAG( PT_OBJECT,     0x812F)
#define PR_EMS_AB_SEE_ALSO_T         PROP_TAG( PT_MV_TSTRING, 0x812F)
#define PR_EMS_AB_SERIAL_NUMBER      PROP_TAG( PT_MV_TSTRING, 0x8130)
#define PR_EMS_AB_SERIAL_NUMBER_A    PROP_TAG( PT_MV_STRING8, 0x8130)
#define PR_EMS_AB_SERIAL_NUMBER_W    PROP_TAG( PT_MV_UNICODE, 0x8130)
#define PR_EMS_AB_SERVICE_ACTION_FIRST       PROP_TAG( PT_LONG,  0x8131)
#define PR_EMS_AB_SERVICE_ACTION_OTHER       PROP_TAG( PT_LONG,  0x8132)
#define PR_EMS_AB_SERVICE_ACTION_SECOND      PROP_TAG( PT_LONG,  0x8133)
#define PR_EMS_AB_SERVICE_RESTART_DELAY      PROP_TAG( PT_LONG,  0x8134)
#define PR_EMS_AB_SERVICE_RESTART_MESSAGE    PROP_TAG( PT_TSTRING,    0x8135)
#define PR_EMS_AB_SERVICE_RESTART_MESSAGE_A  PROP_TAG( PT_STRING8,    0x8135)
#define PR_EMS_AB_SERVICE_RESTART_MESSAGE_W  PROP_TAG( PT_UNICODE,    0x8135)
#define PR_EMS_AB_SESSION_DISCONNECT_TIMER   PROP_TAG( PT_LONG,  0x8136)
#define PR_EMS_AB_SITE_AFFINITY      PROP_TAG( PT_MV_TSTRING, 0x8137)
#define PR_EMS_AB_SITE_AFFINITY_A    PROP_TAG( PT_MV_STRING8, 0x8137)
#define PR_EMS_AB_SITE_AFFINITY_W    PROP_TAG( PT_MV_UNICODE, 0x8137)
#define PR_EMS_AB_SITE_FOLDER_GUID   PROP_TAG( PT_BINARY,     0x8166)
#define PR_EMS_AB_SITE_FOLDER_SERVER PROP_TAG( PT_TSTRING,    0x8167)
#define PR_EMS_AB_SITE_FOLDER_SERVER_A       PROP_TAG( PT_STRING8,    0x8167)
#define PR_EMS_AB_SITE_FOLDER_SERVER_W       PROP_TAG( PT_UNICODE,    0x8167)
#define PR_EMS_AB_SITE_FOLDER_SERVER_O       PROP_TAG( PT_OBJECT,     0x8167)
#define PR_EMS_AB_SITE_FOLDER_SERVER_T       PROP_TAG( PT_TSTRING,    0x8167)
#define PR_EMS_AB_SITE_PROXY_SPACE   PROP_TAG( PT_MV_TSTRING, 0x8138)
#define PR_EMS_AB_SITE_PROXY_SPACE_A PROP_TAG( PT_MV_STRING8, 0x8138)
#define PR_EMS_AB_SITE_PROXY_SPACE_W PROP_TAG( PT_MV_UNICODE, 0x8138)
#define PR_EMS_AB_SPACE_LAST_COMPUTED        PROP_TAG( PT_SYSTIME,    0x8139)
#define PR_EMS_AB_STREET_ADDRESS     PROP_TAG( PT_TSTRING,    0x813A)
#define PR_EMS_AB_STREET_ADDRESS_A   PROP_TAG( PT_STRING8,    0x813A)
#define PR_EMS_AB_STREET_ADDRESS_W   PROP_TAG( PT_UNICODE,    0x813A)
#define PR_EMS_AB_SUB_REFS   PROP_TAG( PT_MV_TSTRING, 0x813B)
#define PR_EMS_AB_SUB_REFS_A         PROP_TAG( PT_MV_STRING8, 0x813B)
#define PR_EMS_AB_SUB_REFS_W         PROP_TAG( PT_MV_UNICODE, 0x813B)
#define PR_EMS_AB_SUB_REFS_O         PROP_TAG( PT_OBJECT,     0x813B)
#define PR_EMS_AB_SUB_REFS_T         PROP_TAG( PT_MV_TSTRING, 0x813B)
#define PR_EMS_AB_SUB_SITE   PROP_TAG( PT_TSTRING,    0x817B)
#define PR_EMS_AB_SUB_SITE_A         PROP_TAG( PT_STRING8,    0x817B)
#define PR_EMS_AB_SUB_SITE_W         PROP_TAG( PT_UNICODE,    0x817B)
#define PR_EMS_AB_SUBMISSION_CONT_LENGTH     PROP_TAG( PT_LONG,  0x813C)
#define PR_EMS_AB_SUPPORTED_APPLICATION_CONTEXT PROP_TAG( PT_MV_BINARY,  0x813D)
#define PR_EMS_AB_SUPPORTING_STACK   PROP_TAG( PT_MV_TSTRING, 0x813E)
#define PR_EMS_AB_SUPPORTING_STACK_A PROP_TAG( PT_MV_STRING8, 0x813E)
#define PR_EMS_AB_SUPPORTING_STACK_W PROP_TAG( PT_MV_UNICODE, 0x813E)
#define PR_EMS_AB_SUPPORTING_STACK_O PROP_TAG( PT_OBJECT,     0x813E)
#define PR_EMS_AB_SUPPORTING_STACK_T PROP_TAG( PT_MV_TSTRING, 0x813E)
#define PR_EMS_AB_SUPPORTING_STACK_BL        PROP_TAG( PT_MV_TSTRING, 0x813F)
#define PR_EMS_AB_SUPPORTING_STACK_BL_A      PROP_TAG( PT_MV_STRING8, 0x813F)
#define PR_EMS_AB_SUPPORTING_STACK_BL_W      PROP_TAG( PT_MV_UNICODE, 0x813F)
#define PR_EMS_AB_SUPPORTING_STACK_BL_O      PROP_TAG( PT_OBJECT,     0x813F)
#define PR_EMS_AB_SUPPORTING_STACK_BL_T      PROP_TAG( PT_MV_TSTRING, 0x813F)
#define PR_EMS_AB_T_SELECTOR         PROP_TAG( PT_BINARY,     0x8140)
#define PR_EMS_AB_T_SELECTOR_INBOUND PROP_TAG( PT_BINARY,     0x8141)
#define PR_EMS_AB_TARGET_ADDRESS     PROP_TAG( PT_TSTRING,    0x8011)
#define PR_EMS_AB_TARGET_ADDRESS_A   PROP_TAG( PT_STRING8,    0x8011)
#define PR_EMS_AB_TARGET_ADDRESS_W   PROP_TAG( PT_UNICODE,    0x8011)
#define PR_EMS_AB_TARGET_MTAS        PROP_TAG( PT_MV_TSTRING, 0x8142)
#define PR_EMS_AB_TARGET_MTAS_A      PROP_TAG( PT_MV_STRING8, 0x8142)
#define PR_EMS_AB_TARGET_MTAS_W      PROP_TAG( PT_MV_UNICODE, 0x8142)
#define PR_EMS_AB_TELEPHONE_NUMBER   PROP_TAG( PT_MV_TSTRING, 0x8012)
#define PR_EMS_AB_TELEPHONE_NUMBER_A PROP_TAG( PT_MV_STRING8, 0x8012)
#define PR_EMS_AB_TELEPHONE_NUMBER_W PROP_TAG( PT_MV_UNICODE, 0x8012)
#define PR_EMS_AB_TELETEX_TERMINAL_IDENTIFIER PROP_TAG( PT_MV_BINARY,  0x8143)
#define PR_EMS_AB_TEMP_ASSOC_THRESHOLD       PROP_TAG( PT_LONG,  0x8144)
#define PR_EMS_AB_TOMBSTONE_LIFETIME PROP_TAG( PT_LONG,  0x8145)
#define PR_EMS_AB_TRACKING_LOG_PATH_NAME     PROP_TAG( PT_TSTRING,    0x8146)
#define PR_EMS_AB_TRACKING_LOG_PATH_NAME_A   PROP_TAG( PT_STRING8,    0x8146)
#define PR_EMS_AB_TRACKING_LOG_PATH_NAME_W   PROP_TAG( PT_UNICODE,    0x8146)
#define PR_EMS_AB_TRANS_RETRY_MINS   PROP_TAG( PT_LONG,  0x8147)
#define PR_EMS_AB_TRANS_TIMEOUT_MINS PROP_TAG( PT_LONG,  0x8148)
#define PR_EMS_AB_TRANSFER_RETRY_INTERVAL    PROP_TAG( PT_LONG,  0x8149)
#define PR_EMS_AB_TRANSFER_TIMEOUT_NON_URGENT PROP_TAG( PT_LONG,  0x814A)
#define PR_EMS_AB_TRANSFER_TIMEOUT_NORMAL    PROP_TAG( PT_LONG,  0x814B)
#define PR_EMS_AB_TRANSFER_TIMEOUT_URGENT    PROP_TAG( PT_LONG,  0x814C)
#define PR_EMS_AB_TRANSLATION_TABLE_USED     PROP_TAG( PT_LONG,  0x814D)
#define PR_EMS_AB_TRANSPORT_EXPEDITED_DATA   PROP_TAG( PT_BOOLEAN,    0x814E)
#define PR_EMS_AB_TRUST_LEVEL        PROP_TAG( PT_LONG,  0x814F)
#define PR_EMS_AB_TURN_REQUEST_THRESHOLD     PROP_TAG( PT_LONG,  0x8150)
#define PR_EMS_AB_TWO_WAY_ALTERNATE_FACILITY PROP_TAG( PT_BOOLEAN,    0x8151)
#define PR_EMS_AB_UNAUTH_ORIG_BL     PROP_TAG( PT_MV_TSTRING, 0x8152)
#define PR_EMS_AB_UNAUTH_ORIG_BL_A   PROP_TAG( PT_MV_STRING8, 0x8152)
#define PR_EMS_AB_UNAUTH_ORIG_BL_W   PROP_TAG( PT_MV_UNICODE, 0x8152)
#define PR_EMS_AB_UNAUTH_ORIG_BL_O   PROP_TAG( PT_OBJECT,     0x8152)
#define PR_EMS_AB_UNAUTH_ORIG_BL_T   PROP_TAG( PT_MV_TSTRING, 0x8152)
#define PR_EMS_AB_USE_SERVER_VALUES  PROP_TAG( PT_BOOLEAN,    0x817E)
#define PR_EMS_AB_USER_PASSWORD      PROP_TAG( PT_MV_BINARY,  0x8153)
#define PR_EMS_AB_USN_CHANGED        PROP_TAG( PT_LONG,  0x8029)
#define PR_EMS_AB_USN_CREATED        PROP_TAG( PT_LONG,  0x8154)
#define PR_EMS_AB_USN_DSA_LAST_OBJ_REMOVED   PROP_TAG( PT_LONG,  0x8155)
#define PR_EMS_AB_USN_INTERSITE      PROP_TAG( PT_LONG,  0x817A)
#define PR_EMS_AB_USN_LAST_OBJ_REM   PROP_TAG( PT_LONG,  0x8156)
#define PR_EMS_AB_USN_SOURCE         PROP_TAG( PT_LONG,  0x8157)
#define PR_EMS_AB_WWW_HOME_PAGE      PROP_TAG( PT_TSTRING,    0x8175)
#define PR_EMS_AB_WWW_HOME_PAGE_A    PROP_TAG( PT_STRING8,    0x8175)
#define PR_EMS_AB_WWW_HOME_PAGE_W    PROP_TAG( PT_UNICODE,    0x8175)
#define PR_EMS_AB_X121_ADDRESS       PROP_TAG( PT_MV_TSTRING, 0x8158)
#define PR_EMS_AB_X121_ADDRESS_A     PROP_TAG( PT_MV_STRING8, 0x8158)
#define PR_EMS_AB_X121_ADDRESS_W     PROP_TAG( PT_MV_UNICODE, 0x8158)
#define PR_EMS_AB_X25_CALL_USER_DATA_INCOMING PROP_TAG( PT_BINARY,     0x8159)
#define PR_EMS_AB_X25_CALL_USER_DATA_OUTGOING PROP_TAG( PT_BINARY,     0x815A)
#define PR_EMS_AB_X25_FACILITIES_DATA_INCOMING PROP_TAG( PT_BINARY,     0x815B)
#define PR_EMS_AB_X25_FACILITIES_DATA_OUTGOING PROP_TAG( PT_BINARY,     0x815C)
#define PR_EMS_AB_X25_LEASED_LINE_PORT       PROP_TAG( PT_BINARY,     0x815D)
#define PR_EMS_AB_X25_LEASED_OR_SWITCHED     PROP_TAG( PT_BOOLEAN,    0x815E)
#define PR_EMS_AB_X25_REMOTE_MTA_PHONE       PROP_TAG( PT_TSTRING,    0x815F)
#define PR_EMS_AB_X25_REMOTE_MTA_PHONE_A     PROP_TAG( PT_STRING8,    0x815F)
#define PR_EMS_AB_X25_REMOTE_MTA_PHONE_W     PROP_TAG( PT_UNICODE,    0x815F)
#define PR_EMS_AB_X400_ATTACHMENT_TYPE       PROP_TAG( PT_BINARY,     0x8160)
#define PR_EMS_AB_X400_SELECTOR_SYNTAX       PROP_TAG( PT_LONG,  0x8161)
#define PR_EMS_AB_X500_ACCESS_CONTROL_LIST   PROP_TAG( PT_BINARY,     0x8162)
#define PR_EMS_AB_XMIT_TIMEOUT_NON_URGENT    PROP_TAG( PT_LONG,  0x8163)
#define PR_EMS_AB_XMIT_TIMEOUT_NORMAL        PROP_TAG( PT_LONG,  0x8164)
#define PR_EMS_AB_XMIT_TIMEOUT_URGENT        PROP_TAG( PT_LONG,  0x8165)

#endif
