/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.progress.spi;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.progress.module.Controller;
import org.netbeans.progress.module.TrivialProgressUIWorkerProvider;
import org.netbeans.progress.spi.ExtractedProgressUIWorker;
import org.netbeans.progress.spi.ProgressEvent;
import org.netbeans.progress.spi.ProgressUIWorkerProvider;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public final class InternalHandle {
    private static final Logger LOG = Logger.getLogger(InternalHandle.class.getName());
    private String displayName;
    private boolean customPlaced1 = false;
    private boolean customPlaced2 = false;
    private boolean customPlaced3 = false;
    private int state;
    private int totalUnits;
    private int currentUnit;
    private long initialEstimate;
    private long timeStarted;
    private long timeLastProgress;
    private long timeSleepy = 0L;
    private String lastMessage;
    private final Cancellable cancelable;
    private final Action viewAction;
    private final boolean userInitiated;
    private int initialDelay = 500;
    private Controller controller;
    private ExtractedProgressUIWorker component;
    public static final int STATE_INITIALIZED = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_FINISHED = 2;
    public static final int STATE_REQUEST_STOP = 3;
    public static final int NO_INCREASE = -2;

    public InternalHandle(String string, Cancellable cancellable, boolean bl, Action action) {
        this.displayName = string;
        this.userInitiated = bl;
        this.state = 0;
        this.totalUnits = 0;
        this.lastMessage = null;
        this.cancelable = cancellable;
        this.viewAction = action;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public synchronized int getState() {
        return this.state;
    }

    public boolean isAllowCancel() {
        return this.cancelable != null && !this.isCustomPlaced();
    }

    public boolean isAllowView() {
        return this.viewAction != null && !this.isCustomPlaced();
    }

    public boolean isCustomPlaced() {
        return this.component != null;
    }

    public boolean isUserInitialized() {
        return this.userInitiated;
    }

    private int getCurrentUnit() {
        return this.currentUnit;
    }

    public int getTotalUnits() {
        return this.totalUnits;
    }

    public void setInitialDelay(int n) {
        if (this.state != 0) {
            LOG.warning("Setting ProgressHandle.setInitialDelay() after the task is started has no effect");
            return;
        }
        this.initialDelay = n;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public synchronized void toSilent(String string) {
        if (this.state != 1 && this.state != 3) assert (false) : "cannot switch to silent mode when not running";
        this.timeSleepy = this.timeLastProgress = System.currentTimeMillis();
        if (string != null) {
            this.lastMessage = string;
        }
        this.controller.toSilent(this, string);
    }

    public boolean isInSleepMode() {
        return this.timeSleepy == this.timeLastProgress;
    }

    public synchronized void toIndeterminate() {
        if (this.state != 1 && this.state != 3) assert (false) : "cannot switch to indeterminate mode when not running: " + this.state;
        this.totalUnits = 0;
        this.currentUnit = 0;
        this.initialEstimate = -1L;
        this.timeLastProgress = System.currentTimeMillis();
        this.controller.toIndeterminate(this);
    }

    public synchronized void toDeterminate(int n, long l) {
        if (this.state != 1 && this.state != 3) assert (false) : "cannot switch to determinate mode when not running";
        if (n < 0) {
            throw new IllegalArgumentException("number of workunits cannot be negative");
        }
        this.totalUnits = n;
        this.currentUnit = 0;
        this.initialEstimate = l;
        this.timeLastProgress = System.currentTimeMillis();
        this.controller.toDeterminate(this);
    }

    public synchronized void start(String string, int n, long l) {
        if (this.state != 0) {
            throw new IllegalStateException("Cannot call start twice on a handle");
        }
        if (n < 0) {
            throw new IllegalArgumentException("number of workunits cannot be negative");
        }
        this.totalUnits = n;
        this.currentUnit = 0;
        if (string != null) {
            this.lastMessage = string;
        }
        if (this.controller == null) {
            this.controller = Controller.getDefault();
        }
        this.state = 1;
        this.initialEstimate = l;
        this.timeLastProgress = this.timeStarted = System.currentTimeMillis();
        this.controller.start(this);
    }

    public synchronized void finish() {
        if (this.state == 0) {
            throw new IllegalStateException("Cannot finish not a started task");
        }
        if (this.state == 2) {
            return;
        }
        this.state = 2;
        this.currentUnit = this.totalUnits;
        this.controller.finish(this);
    }

    public synchronized void progress(String string, int n) {
        if (this.state != 1 && this.state != 3) {
            return;
        }
        if (n != -2) {
            if (n < this.currentUnit) {
                throw new IllegalArgumentException("Cannot decrease processed workunit count (" + n + ") to lower value than before (" + this.currentUnit + ")");
            }
            if (n > this.totalUnits) {
                LOG.log(Level.INFO, "Cannot process more work than scheduled. Progress handle with name \"" + this.getDisplayName() + "\" has requested progress to workunit no." + n + " but the total number of workunits is " + this.totalUnits + ". That means the progress bar UI will not display real progress and will stay at 100%.", new IllegalArgumentException());
                n = this.totalUnits;
            }
            this.currentUnit = n;
        }
        if (string != null) {
            this.lastMessage = string;
        }
        this.timeLastProgress = System.currentTimeMillis();
        this.controller.progress(this, string, this.currentUnit, this.totalUnits > 0 ? this.getPercentageDone() : -1.0, this.initialEstimate == -1L ? -1L : this.calculateFinishEstimate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCancel() {
        if (!this.isAllowCancel()) {
            return;
        }
        InternalHandle internalHandle = this;
        synchronized (internalHandle) {
            this.state = 3;
        }
        this.cancelable.cancel();
        internalHandle = this;
        synchronized (internalHandle) {
            this.requestStateSnapshot();
        }
    }

    public void requestView() {
        if (!this.isAllowView()) {
            return;
        }
        this.viewAction.actionPerformed(new ActionEvent(this.viewAction, 1001, "performView"));
    }

    public synchronized void requestExplicitSelection() {
        if (!this.isInSleepMode()) {
            this.timeLastProgress = System.currentTimeMillis();
        }
        this.controller.explicitSelection(this);
    }

    public synchronized void requestDisplayNameChange(String string) {
        this.displayName = string;
        if (this.state == 0) {
            return;
        }
        this.timeLastProgress = System.currentTimeMillis();
        this.controller.displayNameChange(this, this.currentUnit, this.totalUnits > 0 ? this.getPercentageDone() : -1.0, this.initialEstimate == -1L ? -1L : this.calculateFinishEstimate(), string);
    }

    public synchronized ProgressEvent requestStateSnapshot() {
        if (!this.isInSleepMode()) {
            this.timeLastProgress = System.currentTimeMillis();
        }
        return this.controller.snapshot(this, this.lastMessage, this.currentUnit, this.totalUnits > 0 ? this.getPercentageDone() : -1.0, this.initialEstimate == -1L ? -1L : this.calculateFinishEstimate());
    }

    private void createExtractedWorker() {
        if (this.component == null) {
            ProgressUIWorkerProvider progressUIWorkerProvider = (ProgressUIWorkerProvider)Lookup.getDefault().lookup(ProgressUIWorkerProvider.class);
            if (progressUIWorkerProvider == null) {
                LOG.log(Level.CONFIG, "Using fallback trivial progress implementation");
                progressUIWorkerProvider = new TrivialProgressUIWorkerProvider();
            }
            this.component = progressUIWorkerProvider.getExtractedComponentWorker();
            this.controller = new Controller(this.component);
        }
    }

    public synchronized JComponent extractComponent() {
        if (this.customPlaced1) {
            throw new IllegalStateException("Cannot retrieve progress component multiple times");
        }
        if (this.state != 0) {
            throw new IllegalStateException("You can request custom placement of progress component only before starting the task");
        }
        this.customPlaced1 = true;
        this.createExtractedWorker();
        return this.component.getProgressComponent();
    }

    public synchronized JLabel extractDetailLabel() {
        if (this.customPlaced2) {
            throw new IllegalStateException("Cannot retrieve progress detail label component multiple times");
        }
        if (this.state != 0) {
            throw new IllegalStateException("You can request custom placement of progress component only before starting the task");
        }
        this.customPlaced2 = true;
        this.createExtractedWorker();
        return this.component.getDetailLabelComponent();
    }

    public synchronized JLabel extractMainLabel() {
        if (this.customPlaced3) {
            throw new IllegalStateException("Cannot retrieve progress main label component multiple times");
        }
        if (this.state != 0) {
            throw new IllegalStateException("You can request custom placement of progress component only before starting the task");
        }
        this.customPlaced3 = true;
        this.createExtractedWorker();
        return this.component.getMainLabelComponent();
    }

    long calculateFinishEstimate() {
        double d = (double)(System.currentTimeMillis() - this.timeStarted) / 1000.0;
        if (this.initialEstimate == -1L) {
            return (long)(d * (double)(this.totalUnits - this.currentUnit) / (double)this.totalUnits);
        }
        long l = this.totalUnits - this.currentUnit;
        double d2 = (double)l / (double)this.totalUnits;
        double d3 = d / (double)this.currentUnit * (double)this.totalUnits;
        long l2 = (long)(((double)(this.initialEstimate * l) * d2 + d3 * (double)l * (1.0 - d2)) / (double)this.totalUnits);
        return l2;
    }

    public double getPercentageDone() {
        return (double)this.currentUnit * 100.0 / (double)this.totalUnits;
    }

    public long getTimeStampStarted() {
        return this.timeStarted;
    }
}

