/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc.access;

import javax.transaction.Transaction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cache.jbc.BasicRegionAdapter;
import org.hibernate.cache.jbc.access.PutFromLoadValidator;
import org.hibernate.cache.jbc.util.CacheHelper;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Option;

public class TransactionalAccessDelegate {
    protected final Cache cache;
    protected final Fqn regionFqn;
    protected final boolean invalidation;
    protected final BasicRegionAdapter region;
    protected final PutFromLoadValidator putValidator;

    public TransactionalAccessDelegate(BasicRegionAdapter adapter, PutFromLoadValidator validator) {
        this.region = adapter;
        this.cache = adapter.getCacheInstance();
        this.regionFqn = adapter.getRegionFqn();
        this.putValidator = validator;
        this.invalidation = CacheHelper.isClusteredInvalidation(this.cache);
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        if (!this.region.checkValid()) {
            return null;
        }
        this.region.ensureRegionRootExists();
        Object val = CacheHelper.get(this.cache, this.regionFqn, key);
        if (val == null) {
            this.putValidator.registerPendingPut(key);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        if (!this.putValidator.acquirePutFromLoadLock(key)) {
            return false;
        }
        try {
            this.region.ensureRegionRootExists();
            boolean bl = CacheHelper.putForExternalRead(this.cache, this.regionFqn, key, value);
            return bl;
        }
        finally {
            this.putValidator.releasePutFromLoadLock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        if (!this.putValidator.acquirePutFromLoadLock(key)) {
            return false;
        }
        try {
            this.region.ensureRegionRootExists();
            boolean bl = CacheHelper.putForExternalRead(this.cache, this.regionFqn, key, value);
            return bl;
        }
        finally {
            this.putValidator.releasePutFromLoadLock(key);
        }
    }

    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) throws CacheException {
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
    }

    public boolean insert(Object key, Object value, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        this.region.ensureRegionRootExists();
        if (this.invalidation) {
            Option opt = new Option();
            opt.setCacheModeLocal(true);
            CacheHelper.put(this.cache, this.regionFqn, key, value, opt);
        } else {
            CacheHelper.put(this.cache, this.regionFqn, key, value);
        }
        return true;
    }

    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.region.ensureRegionRootExists();
        CacheHelper.put(this.cache, this.regionFqn, key, value);
        return true;
    }

    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        return false;
    }

    public void remove(Object key) throws CacheException {
        if (!this.putValidator.invalidateKey(key)) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for key " + key + " from region " + this.region.getName());
        }
        this.region.ensureRegionRootExists();
        CacheHelper.remove(this.cache, this.regionFqn, key);
    }

    public void removeAll() throws CacheException {
        if (!this.putValidator.invalidateRegion()) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for region " + this.region.getName());
        }
        CacheHelper.removeAll(this.cache, this.regionFqn);
    }

    public void evict(Object key) throws CacheException {
        if (!this.putValidator.invalidateKey(key)) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for key " + key + " from region " + this.region.getName());
        }
        this.region.ensureRegionRootExists();
        CacheHelper.remove(this.cache, this.regionFqn, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() throws CacheException {
        if (!this.putValidator.invalidateRegion()) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for region " + this.region.getName());
        }
        Transaction tx = this.region.suspend();
        try {
            this.region.ensureRegionRootExists();
            CacheHelper.sendEvictAllNotification(this.cache, this.regionFqn, this.region.getMemberId(), null);
        }
        finally {
            this.region.resume(tx);
        }
    }
}

