/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;

final class MlibTransposeOpImage
extends GeometricOpImage {
    protected int type;
    protected int src_width;
    protected int src_height;
    protected Rectangle sourceBounds;

    private static ImageLayout layoutHelper(ImageLayout layout, RenderedImage source, int type) {
        ImageLayout newLayout = layout != null ? (ImageLayout)layout.clone() : new ImageLayout();
        int x1 = source.getMinX();
        int y1 = source.getMinY();
        int s_width = source.getWidth();
        int s_height = source.getHeight();
        int x2 = x1 + s_width - 1;
        int y2 = y1 + s_height - 1;
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 0;
        switch (type) {
            case 0: {
                dx1 = x1;
                dy1 = s_height - y2 - 1;
                dx2 = x2;
                dy2 = s_height - y1 - 1;
                break;
            }
            case 1: {
                dx1 = s_width - x2 - 1;
                dy1 = y1;
                dx2 = s_width - x1 - 1;
                dy2 = y2;
                break;
            }
            case 2: {
                dx1 = y1;
                dy1 = x1;
                dx2 = y2;
                dy2 = x2;
                break;
            }
            case 3: {
                dx1 = s_height - y2 - 1;
                dy1 = s_width - x2 - 1;
                dx2 = s_height - y1 - 1;
                dy2 = s_width - x1 - 1;
                break;
            }
            case 4: {
                dx1 = s_height - y2 - 1;
                dy1 = x1;
                dx2 = s_height - y1 - 1;
                dy2 = x2;
                break;
            }
            case 5: {
                dx1 = s_width - x2 - 1;
                dy1 = s_height - y2 - 1;
                dx2 = s_width - x1 - 1;
                dy2 = s_height - y1 - 1;
                break;
            }
            case 6: {
                dx1 = y1;
                dy1 = s_width - x2 - 1;
                dx2 = y2;
                dy2 = s_width - x1 - 1;
            }
        }
        newLayout.setMinX(dx1);
        newLayout.setMinY(dy1);
        newLayout.setWidth(dx2 - dx1 + 1);
        newLayout.setHeight(dy2 - dy1 + 1);
        return newLayout;
    }

    public MlibTransposeOpImage(RenderedImage source, Map config, ImageLayout layout, int type) {
        super(MlibTransposeOpImage.vectorize(source), MlibTransposeOpImage.layoutHelper(layout, source, type), config, true, null, null, null);
        this.type = type;
        this.src_width = source.getWidth();
        this.src_height = source.getHeight();
        this.sourceBounds = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
    }

    protected Rectangle forwardMapRect(Rectangle sourceRect, int sourceIndex) {
        return MlibTransposeOpImage.mapRect(sourceRect, this.sourceBounds, this.type, true);
    }

    protected Rectangle backwardMapRect(Rectangle destRect, int sourceIndex) {
        int x1 = destRect.x;
        int y1 = destRect.y;
        int x2 = x1 + destRect.width - 1;
        int y2 = y1 + destRect.height - 1;
        int sx1 = 0;
        int sy1 = 0;
        int sx2 = 0;
        int sy2 = 0;
        switch (this.type) {
            case 0: {
                sx1 = x1;
                sy1 = this.src_height - y2 - 1;
                sx2 = x2;
                sy2 = this.src_height - y1 - 1;
                break;
            }
            case 1: {
                sx1 = this.src_width - x2 - 1;
                sy1 = y1;
                sx2 = this.src_width - x1 - 1;
                sy2 = y2;
                break;
            }
            case 2: {
                sx1 = y1;
                sy1 = x1;
                sx2 = y2;
                sy2 = x2;
                break;
            }
            case 3: {
                sx1 = this.src_width - y2 - 1;
                sy1 = this.src_height - x2 - 1;
                sx2 = this.src_width - y1 - 1;
                sy2 = this.src_height - x1 - 1;
                break;
            }
            case 4: {
                sx1 = y1;
                sy1 = this.src_height - x2 - 1;
                sx2 = y2;
                sy2 = this.src_height - x1 - 1;
                break;
            }
            case 5: {
                sx1 = this.src_width - x2 - 1;
                sy1 = this.src_height - y2 - 1;
                sx2 = this.src_width - x1 - 1;
                sy2 = this.src_height - y1 - 1;
                break;
            }
            case 6: {
                sx1 = this.src_width - y2 - 1;
                sy1 = x1;
                sx2 = this.src_width - y1 - 1;
                sy2 = x2;
            }
        }
        return new Rectangle(sx1, sy1, sx2 - sx1 + 1, sy2 - sy1 + 1);
    }

    protected static void mapPoint(int[] pt, int minX, int minY, int maxX, int maxY, int type, boolean mapForwards) {
        int sx = pt[0];
        int sy = pt[1];
        int dx = -1;
        int dy = -1;
        switch (type) {
            case 0: {
                dx = sx;
                dy = minY + maxY - sy;
                break;
            }
            case 1: {
                dx = minX + maxX - sx;
                dy = sy;
                break;
            }
            case 2: {
                dx = minX - minY + sy;
                dy = minY - minX + sx;
                break;
            }
            case 3: {
                if (mapForwards) {
                    dx = minX + maxY - sy;
                    dy = minY + maxX - sx;
                    break;
                }
                dx = minY + maxX - sy;
                dy = minX + maxY - sx;
                break;
            }
            case 4: {
                if (mapForwards) {
                    dx = minX + maxY - sy;
                    dy = minY - minX + sx;
                    break;
                }
                dx = minX - minY + sy;
                dy = minX + maxY - sx;
                break;
            }
            case 5: {
                dx = minX + maxX - sx;
                dy = minY + maxY - sy;
                break;
            }
            case 6: {
                if (mapForwards) {
                    dx = minX - minY + sy;
                    dy = maxX + minY - sx;
                    break;
                }
                dx = maxX + minY - sy;
                dy = minY - minX + sx;
            }
        }
        pt[0] = dx;
        pt[1] = dy;
    }

    private static Rectangle mapRect(Rectangle rect, Rectangle sourceBounds, int type, boolean mapForwards) {
        int dMaxY;
        int dMaxX;
        int sMinX = sourceBounds.x;
        int sMinY = sourceBounds.y;
        int sMaxX = sMinX + sourceBounds.width - 1;
        int sMaxY = sMinY + sourceBounds.height - 1;
        int[] pt = new int[]{rect.x, rect.y};
        MlibTransposeOpImage.mapPoint(pt, sMinX, sMinY, sMaxX, sMaxY, type, mapForwards);
        int dMinX = dMaxX = pt[0];
        int dMinY = dMaxY = pt[1];
        pt[0] = rect.x + rect.width - 1;
        pt[1] = rect.y;
        MlibTransposeOpImage.mapPoint(pt, sMinX, sMinY, sMaxX, sMaxY, type, mapForwards);
        dMinX = Math.min(dMinX, pt[0]);
        dMinY = Math.min(dMinY, pt[1]);
        dMaxX = Math.max(dMaxX, pt[0]);
        dMaxY = Math.max(dMaxY, pt[1]);
        pt[0] = rect.x;
        pt[1] = rect.y + rect.height - 1;
        MlibTransposeOpImage.mapPoint(pt, sMinX, sMinY, sMaxX, sMaxY, type, mapForwards);
        dMinX = Math.min(dMinX, pt[0]);
        dMinY = Math.min(dMinY, pt[1]);
        dMaxX = Math.max(dMaxX, pt[0]);
        dMaxY = Math.max(dMaxY, pt[1]);
        pt[0] = rect.x + rect.width - 1;
        pt[1] = rect.y + rect.height - 1;
        MlibTransposeOpImage.mapPoint(pt, sMinX, sMinY, sMaxX, sMaxY, type, mapForwards);
        dMinX = Math.min(dMinX, pt[0]);
        dMinY = Math.min(dMinY, pt[1]);
        dMaxX = Math.max(dMaxX, pt[0]);
        dMaxY = Math.max(dMaxY, pt[1]);
        return new Rectangle(dMinX, dMinY, dMaxX - dMinX + 1, dMaxY - dMinY + 1);
    }

    public Raster computeTile(int tileX, int tileY) {
        Point org = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        WritableRaster dest = this.createWritableRaster(this.sampleModel, org);
        Rectangle rect = new Rectangle(org.x, org.y, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        Rectangle destRect = rect.intersection(this.getBounds());
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        PlanarImage src = this.getSourceImage(0);
        Raster[] sources = new Raster[]{src.getData(srcRect)};
        this.computeRect(sources, dest, destRect);
        if (src.overlapsMultipleTiles(srcRect)) {
            this.recycleTile(sources[0]);
        }
        return dest;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        Raster source = sources[0];
        int x1 = source.getMinX();
        int y1 = source.getMinY();
        int src_width = source.getWidth();
        int src_height = source.getHeight();
        Rectangle srcRect = new Rectangle(x1, y1, src_width, src_height);
        int formatTag = MediaLibAccessor.findCompatibleTag(sources, dest);
        MediaLibAccessor srcAccessor = new MediaLibAccessor(source, srcRect, formatTag);
        MediaLibAccessor dstAccessor = new MediaLibAccessor(dest, destRect, formatTag);
        int numBands = this.getSampleModel().getNumBands();
        switch (dstAccessor.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                mediaLibImage[] srcML = srcAccessor.getMediaLibImages();
                mediaLibImage[] dstML = dstAccessor.getMediaLibImages();
                switch (this.type) {
                    case 0: {
                        Image.FlipX((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                        break;
                    }
                    case 1: {
                        Image.FlipY((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                        break;
                    }
                    case 2: {
                        Image.FlipMainDiag((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                        break;
                    }
                    case 3: {
                        Image.FlipAntiDiag((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                        break;
                    }
                    case 4: {
                        Image.Rotate90((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                        break;
                    }
                    case 5: {
                        Image.Rotate180((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                        break;
                    }
                    case 6: {
                        Image.Rotate270((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                mediaLibImage[] srcML = srcAccessor.getMediaLibImages();
                mediaLibImage[] dstML = dstAccessor.getMediaLibImages();
                switch (this.type) {
                    case 0: {
                        Image.FlipX_Fp((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                        break;
                    }
                    case 1: {
                        Image.FlipY_Fp((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                        break;
                    }
                    case 2: {
                        Image.FlipMainDiag_Fp((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                        break;
                    }
                    case 3: {
                        Image.FlipAntiDiag_Fp((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                        break;
                    }
                    case 4: {
                        Image.Rotate90_Fp((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                        break;
                    }
                    case 5: {
                        Image.Rotate180_Fp((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                        break;
                    }
                    case 6: {
                        Image.Rotate270_Fp((mediaLibImage)dstML[0], (mediaLibImage)srcML[0]);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("Generic2"));
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.copyDataToRaster();
        }
    }
}

