/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.popups;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.print.attribute.standard.PageRanges;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import org.jpedal.examples.simpleviewer.gui.popups.Save;
import org.jpedal.examples.simpleviewer.utils.FileFilterer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class StampImageToPDFPages
extends Save {
    JLabel OutputLabel = new JLabel();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    ButtonGroup buttonGroup2 = new ButtonGroup();
    JToggleButton jToggleButton3 = new JToggleButton();
    JToggleButton jToggleButton2 = new JToggleButton();
    JRadioButton printAll = new JRadioButton();
    JRadioButton printCurrent = new JRadioButton();
    JRadioButton printPages = new JRadioButton();
    JTextField pagesBox = new JTextField();
    JTextField imageBox = new JTextField();
    JSpinner rotationBox = new JSpinner(new SpinnerNumberModel(0, 0, 360, 1));
    JComboBox placementBox = new JComboBox<String>(new String[]{Messages.getMessage("PdfViewerLabel.Overlay"), Messages.getMessage("PdfViewerLabel.Underlay")});
    JSpinner heightScale = new JSpinner(new SpinnerNumberModel(100, 1, 1000, 1));
    JSpinner widthScale = new JSpinner(new SpinnerNumberModel(100, 1, 1000, 1));
    JComboBox horizontalBox = new JComboBox<String>(new String[]{Messages.getMessage("PdfViewerLabel.FromLeft"), Messages.getMessage("PdfViewerLabel.Centered"), Messages.getMessage("PdfViewerLabel.FromRight")});
    JComboBox verticalBox = new JComboBox<String>(new String[]{Messages.getMessage("PdfViewerLabel.FromTop"), Messages.getMessage("PdfViewerLabel.Centered"), Messages.getMessage("PdfViewerLabel.FromBottom")});
    JSpinner horizontalOffset = new JSpinner(new SpinnerNumberModel(0.0, -1000.0, 1000.0, 1.0));
    JSpinner verticalOffset = new JSpinner(new SpinnerNumberModel(0.0, -1000.0, 1000.0, 1.0));

    public StampImageToPDFPages(String string, int n, int n2) {
        super(string, n, n2);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final int[] getPages() {
        int[] nArray;
        block7: {
            block8: {
                block6: {
                    nArray = null;
                    if (!this.printAll.isSelected()) break block6;
                    nArray = new int[this.end_page];
                    for (int i = 0; i < this.end_page; ++i) {
                        nArray[i] = i + 1;
                    }
                    break block7;
                }
                if (!this.printCurrent.isSelected()) break block8;
                nArray = new int[]{this.currentPage};
                break block7;
            }
            if (!this.printPages.isSelected()) break block7;
            try {
                PageRanges pageRanges = new PageRanges(this.pagesBox.getText());
                int n = 0;
                int n2 = -1;
                while ((n2 = pageRanges.next(n2)) != -1) {
                    ++n;
                }
                nArray = new int[n];
                n = 0;
                n2 = -1;
                while ((n2 = pageRanges.next(n2)) != -1) {
                    if (n2 > this.end_page) {
                        JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerText.Page") + ' ' + pageRanges + ' ' + Messages.getMessage("PdfViewerError.OutOfBounds") + ' ' + Messages.getMessage("PdfViewerText.PageCount") + ' ' + this.end_page);
                        return null;
                    }
                    nArray[n] = n2;
                    ++n;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogWriter.writeLog("Exception " + illegalArgumentException + " in exporting pdfs");
                JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerError.InvalidSyntax"));
            }
        }
        return nArray;
    }

    public float getHorizontalOffset() {
        return Float.parseFloat(this.horizontalOffset.getValue().toString());
    }

    public float getVerticalOffset() {
        return Float.parseFloat(this.verticalOffset.getValue().toString());
    }

    public String getHorizontalPosition() {
        return (String)this.horizontalBox.getSelectedItem();
    }

    public String getVerticalPosition() {
        return (String)this.verticalBox.getSelectedItem();
    }

    public int getRotation() {
        return Integer.parseInt(this.rotationBox.getValue().toString());
    }

    public String getPlacement() {
        return (String)this.placementBox.getSelectedItem();
    }

    public int getHeightScale() {
        return Integer.parseInt(this.heightScale.getValue().toString());
    }

    public int getWidthScale() {
        return Integer.parseInt(this.widthScale.getValue().toString());
    }

    public String getImageLocation() {
        return this.imageBox.getText();
    }

    private void jbInit() throws Exception {
        JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerLabel.TextAndFont"));
        jLabel.setFont(new Font("Dialog", 1, 14));
        jLabel.setDisplayedMnemonic('0');
        jLabel.setBounds(new Rectangle(13, 13, 220, 26));
        JLabel jLabel2 = new JLabel(Messages.getMessage("PdfViewerLabel.Image"));
        jLabel2.setBounds(new Rectangle(20, 40, 50, 23));
        this.imageBox.setBounds(new Rectangle(55, 40, 295, 23));
        JButton jButton = new JButton("...");
        jButton.setBounds(new Rectangle(360, 40, 23, 23));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(StampImageToPDFPages.this.root_dir);
                jFileChooser.setFileSelectionMode(0);
                String[] stringArray = new String[]{"png", "tif", "tiff", "jpg", "jpeg"};
                jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "Images (Tiff, Jpeg,Png)"));
                int n = jFileChooser.showOpenDialog(null);
                File file = jFileChooser.getSelectedFile();
                if (file != null && n == 0) {
                    StampImageToPDFPages.this.imageBox.setText(file.getAbsolutePath());
                }
            }
        });
        JLabel jLabel3 = new JLabel(Messages.getMessage("PdfViewerLabel.Rotation"));
        jLabel3.setBounds(new Rectangle(20, 80, 90, 23));
        this.rotationBox.setBounds(new Rectangle(80, 80, 50, 23));
        JLabel jLabel4 = new JLabel(Messages.getMessage("PdfViewerText.Degrees"));
        jLabel4.setBounds(new Rectangle(140, 80, 50, 23));
        JLabel jLabel5 = new JLabel(Messages.getMessage("PdfViewerLabel.Placement"));
        jLabel5.setBounds(new Rectangle(240, 80, 70, 23));
        this.placementBox.setBounds(new Rectangle(300, 80, 83, 23));
        JLabel jLabel6 = new JLabel(Messages.getMessage("PdfViewerLabel.WidthScale"));
        jLabel6.setBounds(new Rectangle(20, 120, 100, 23));
        this.widthScale.setBounds(new Rectangle(120, 120, 60, 23));
        JLabel jLabel7 = new JLabel(Messages.getMessage("PdfViewerLabel.HeightScale"));
        jLabel7.setBounds(new Rectangle(240, 120, 110, 23));
        this.heightScale.setBounds(new Rectangle(330, 120, 60, 23));
        JLabel jLabel8 = new JLabel(Messages.getMessage("PdfViewerLabel.PositionAndOffset"));
        jLabel8.setFont(new Font("Dialog", 1, 14));
        jLabel8.setDisplayedMnemonic('0');
        jLabel8.setBounds(new Rectangle(13, 150, 220, 26));
        JLabel jLabel9 = new JLabel(Messages.getMessage("PdfViewerLabel.Horizontal"));
        jLabel9.setBounds(new Rectangle(20, 185, 90, 23));
        this.horizontalBox.setBounds(new Rectangle(80, 185, 120, 23));
        this.horizontalBox.setSelectedItem(Messages.getMessage("PdfViewerLabel.Centered"));
        JLabel jLabel10 = new JLabel(Messages.getMessage("PdfViewerLabel.Vertical"));
        jLabel10.setBounds(new Rectangle(20, 215, 90, 23));
        this.verticalBox.setBounds(new Rectangle(80, 215, 120, 23));
        this.verticalBox.setSelectedItem(Messages.getMessage("PdfViewerLabel.Centered"));
        JLabel jLabel11 = new JLabel(Messages.getMessage("PdfViewerLabel.Offset"));
        jLabel11.setBounds(new Rectangle(250, 185, 90, 23));
        this.horizontalOffset.setBounds(new Rectangle(320, 185, 70, 23));
        JLabel jLabel12 = new JLabel(Messages.getMessage("PdfViewerLabel.Offset"));
        jLabel12.setBounds(new Rectangle(250, 215, 90, 23));
        this.verticalOffset.setBounds(new Rectangle(320, 215, 70, 23));
        this.pageRangeLabel.setText(Messages.getMessage("PdfViewerPageRange.text"));
        this.pageRangeLabel.setBounds(new Rectangle(13, 250, 400, 26));
        this.printAll.setText(Messages.getMessage("PdfViewerRadioButton.All"));
        this.printAll.setBounds(new Rectangle(23, 280, 75, 22));
        this.printCurrent.setText(Messages.getMessage("PdfViewerRadioButton.CurrentPage"));
        this.printCurrent.setBounds(new Rectangle(23, 300, 100, 22));
        this.printCurrent.setSelected(true);
        this.printPages.setText(Messages.getMessage("PdfViewerRadioButton.Pages"));
        this.printPages.setBounds(new Rectangle(23, 322, 70, 22));
        this.pagesBox.setBounds(new Rectangle(95, 322, 230, 22));
        this.pagesBox.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (StampImageToPDFPages.this.pagesBox.getText().length() == 0) {
                    StampImageToPDFPages.this.printCurrent.setSelected(true);
                } else {
                    StampImageToPDFPages.this.printPages.setSelected(true);
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        JTextArea jTextArea = new JTextArea(Messages.getMessage("PdfViewerMessage.PageNumberOrRange") + '\n' + Messages.getMessage("PdfViewerMessage.PageRangeExample"));
        jTextArea.setBounds(new Rectangle(23, 355, 400, 40));
        jTextArea.setOpaque(false);
        this.add((Component)this.printAll, null);
        this.add((Component)this.printCurrent, null);
        this.add((Component)this.printPages, null);
        this.add((Component)this.pagesBox, null);
        this.add((Component)jTextArea, null);
        this.add((Component)jLabel2, null);
        this.add((Component)jButton, null);
        this.add((Component)this.imageBox, null);
        this.add((Component)jLabel3, null);
        this.add((Component)this.rotationBox, null);
        this.add((Component)jLabel4, null);
        this.add((Component)jLabel5, null);
        this.add((Component)this.placementBox, null);
        this.add((Component)jLabel8, null);
        this.add((Component)jLabel9, null);
        this.add((Component)this.horizontalBox, null);
        this.add((Component)jLabel10, null);
        this.add((Component)this.verticalBox, null);
        this.add((Component)jLabel11, null);
        this.add((Component)this.horizontalOffset, null);
        this.add((Component)jLabel12, null);
        this.add((Component)this.verticalOffset, null);
        this.add((Component)jLabel6, null);
        this.add((Component)this.widthScale, null);
        this.add((Component)jLabel7, null);
        this.add((Component)this.heightScale, null);
        this.add((Component)jLabel, null);
        this.add((Component)this.changeButton, null);
        this.add((Component)this.pageRangeLabel, null);
        this.add((Component)this.jToggleButton2, null);
        this.add((Component)this.jToggleButton3, null);
        this.buttonGroup1.add(this.printAll);
        this.buttonGroup1.add(this.printCurrent);
        this.buttonGroup1.add(this.printPages);
    }

    public final Dimension getPreferredSize() {
        return new Dimension(440, 400);
    }
}

