/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import java.awt.PaintContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;

public class TensorContext
implements PaintContext {
    private byte[] stream;
    private byte[] currentTile = new byte[32];
    private byte[] lastTile;
    private byte[] currentColor = new byte[4];
    private byte[] lastColor;
    private byte flag = 0;
    private int pointer = 0;

    public TensorContext(byte[] byArray) {
        this.stream = byArray;
    }

    public void beginMeshing() {
        this.flag = 0;
        this.pointer = 0;
        block6: while (this.pointer + 26 < this.stream.length) {
            this.flag = this.stream[this.pointer];
            ++this.pointer;
            switch (this.flag) {
                case 0: {
                    this.pointer = this.f0(this.stream, this.pointer);
                    continue block6;
                }
                case 1: {
                    this.pointer = this.f1(this.stream, this.pointer);
                    continue block6;
                }
                case 2: {
                    this.pointer = this.f2(this.stream, this.pointer);
                    continue block6;
                }
                case 3: {
                    this.pointer = this.f3(this.stream, this.pointer);
                    continue block6;
                }
            }
        }
    }

    public int f0(byte[] byArray, int n) {
        int n2;
        this.lastTile = this.currentTile;
        this.lastColor = this.currentColor;
        this.currentTile = new byte[32];
        for (n2 = 0; n2 != 32; ++n2) {
            this.currentTile[n2] = byArray[n + n2];
        }
        n += 32;
        for (n2 = 0; n2 != 4; ++n2) {
            this.currentColor[n2] = byArray[n + n2];
        }
        return n += 4;
    }

    public int f1(byte[] byArray, int n) {
        int n2;
        this.lastTile = this.currentTile;
        this.lastColor = this.currentColor;
        this.currentTile = new byte[32];
        for (n2 = 0; n2 != 8; ++n2) {
            this.currentTile[n2] = this.lastTile[6 + n2];
        }
        for (n2 = 0; n2 != 24; ++n2) {
            this.currentTile[8 + n2] = byArray[n + n2];
        }
        n += 24;
        for (n2 = 0; n2 != 2; ++n2) {
            this.currentColor[n2] = this.lastColor[1 + n2];
        }
        for (n2 = 0; n2 != 2; ++n2) {
            this.currentColor[2 + n2] = byArray[n + n2];
        }
        return n += 2;
    }

    public int f2(byte[] byArray, int n) {
        int n2;
        this.lastTile = this.currentTile;
        this.lastColor = this.currentColor;
        this.currentTile = new byte[32];
        for (n2 = 0; n2 != 8; ++n2) {
            this.currentTile[n2] = this.lastTile[12 + n2];
        }
        for (n2 = 0; n2 != 24; ++n2) {
            this.currentTile[8 + n2] = byArray[n + n2];
        }
        n += 24;
        for (n2 = 0; n2 != 2; ++n2) {
            this.currentColor[n2] = this.lastColor[2 + n2];
        }
        for (n2 = 0; n2 != 2; ++n2) {
            this.currentColor[2 + n2] = byArray[n + n2];
        }
        return n += 2;
    }

    public int f3(byte[] byArray, int n) {
        int n2;
        this.lastTile = this.currentTile;
        this.lastColor = this.currentColor;
        this.currentTile = new byte[32];
        for (n2 = 0; n2 != 6; ++n2) {
            this.currentTile[n2] = this.lastTile[18 + n2];
        }
        for (n2 = 0; n2 != 2; ++n2) {
            this.currentTile[n2] = this.lastTile[n2];
        }
        for (n2 = 0; n2 != 24; ++n2) {
            this.currentTile[8 + n2] = byArray[n + n2];
        }
        n += 24;
        this.currentColor[0] = this.lastColor[3];
        this.currentColor[1] = this.lastColor[0];
        for (n2 = 0; n2 != 2; ++n2) {
            this.currentColor[2 + n2] = byArray[n + n2];
        }
        return n += 2;
    }

    public float BersteinPolynomials(int n, int n2) {
        switch (n) {
            case 0: {
                return 1 - n2 ^ 3;
            }
            case 1: {
                return 3 * n2 * (1 - n2 ^ 2);
            }
            case 2: {
                return (3 * n2 ^ 2) * (1 - n2);
            }
            case 3: {
                return n2 ^ 3;
            }
        }
        return n2;
    }

    public float getValue(byte[][] byArray, int n, int n2) {
        float f = 0.0f;
        for (int i = 0; i != 3; ++i) {
            for (int j = 0; j != 3; ++j) {
                f += (float)byArray[i][j] * this.BersteinPolynomials(i, n) * this.BersteinPolynomials(j, n2);
            }
        }
        return f;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return null;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        return null;
    }
}

