/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstrainingFacet;
import oracle.xml.parser.schema.XSDDataValue;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDParticleNode;
import oracle.xml.parser.schema.XSDTypeConstants;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.util.QxName;
import oracle.xml.util.XMLUtil;

public class XSDSimpleType
extends XSDNode
implements XSDParticleNode,
XSDTypeConstants {
    XSDSimpleType baseType;
    XSDSimpleType itemType;
    Vector memberTypes;
    String variety;
    String derivedBy;
    String refNamespace;
    String refName;
    int basicType;
    boolean parsed = true;
    boolean resolved = true;
    XSDConstrainingFacet[] facets;
    Vector facetVals;
    boolean[] isNewFacet;
    XSDConstrainingFacet enumFacet;
    int fundamentals;
    BitSet properties;
    HashMap enumAnnotations;
    static final Hashtable builtInTypes;
    static final HashMap typeIdTable;
    static final XSDSimpleType[] builtInArray;
    static final int[] bltToPrim;
    static final int TYPE_FLAGS = 0x3F0000;
    public static final XSDSimpleType urType;
    public static final XSDSimpleType yearMonthDuration;
    public static final XSDSimpleType dayTimeDuration;
    public static final XSDSimpleType untypedAtomic;
    static final byte[][] tfTable;
    static final byte[] uTable;

    public XSDSimpleType() {
        this.nodeType = 2;
        this.variety = "#undef";
        this.baseType = null;
        this.properties = new BitSet(8);
        this.basicType = 0;
        this.parsed = true;
    }

    public boolean hasFlag(int n) {
        return (this.fundamentals & n) != 0;
    }

    void setFlag(int n) {
        this.fundamentals |= n;
    }

    public String getTargetNS() {
        if (this.parent != null) {
            return this.parent.getTargetNS();
        }
        return "http://www.w3.org/2001/XMLSchema";
    }

    public boolean isEmptiable() {
        return false;
    }

    public XSDNode getNamedBaseType() {
        if (this.name != null) {
            return this;
        }
        if (this.baseType != null) {
            return this.baseType.getNamedBaseType();
        }
        return null;
    }

    public boolean isPrimitive() {
        return this == builtInArray[this.basicType];
    }

    public boolean isBuiltInDataType() {
        return this.targetNS == "http://www.w3.org/2001/XMLSchema" || this.targetNS == "http://www.w3.org/2005/04/xpath-datatypes";
    }

    public XSDSimpleType(int n, String string) {
        this();
        this.name = string;
        this.basicType = n;
        this.variety = "atomic";
        this.isNewFacet = new boolean[13];
        this.facets = new XSDConstrainingFacet[13];
        this.baseType = urType;
    }

    void setDerivation(String string) {
        this.derivedBy = string;
        if (this.derivedBy == "restriction") {
            this.isNewFacet = new boolean[13];
            this.facets = new XSDConstrainingFacet[13];
        } else if (this.derivedBy == "union") {
            this.memberTypes = new Vector(4);
            this.variety = "union";
            this.baseType = urType;
        } else if (this.derivedBy == "list") {
            this.variety = "list";
            this.baseType = urType;
        }
    }

    public String getDerivedMethod() {
        return this.derivedBy;
    }

    void setReference(String string, String string2) {
        this.refNamespace = string;
        this.refName = string2;
        this.resolved = false;
        this.parsed = false;
    }

    boolean isValidRestriction(XSDSimpleType xSDSimpleType) {
        return true;
    }

    boolean isParsed() {
        return this.parsed;
    }

    boolean isResolved() {
        return this.resolved;
    }

    void parseDerivation() throws XSDException {
        block8: {
            block7: {
                if (this.parsed) {
                    return;
                }
                this.parsed = true;
                if (this.derivedBy != "restriction") break block7;
                if (this.baseType != null && !this.baseType.parsed) {
                    this.baseType.parseDerivation();
                }
                if (this.baseType != null) {
                    this.setBaseType(this.baseType);
                }
                if (this.facetVals == null) break block8;
                int n = this.facetVals.size();
                for (int i = 0; i < n; ++i) {
                    if (this.facetVals.elementAt(i) == null) continue;
                    if (i < 13) {
                        this.setFacet(XSDTypeConstants.sFacets[i], (String)this.facetVals.elementAt(i));
                        continue;
                    }
                    this.setEnumeration((XMLElement)this.facetVals.elementAt(i), null);
                }
                break block8;
            }
            if (this.derivedBy == "union") {
                for (int i = 0; i < this.memberTypes.size(); ++i) {
                    ((XSDSimpleType)this.memberTypes.elementAt(i)).parseDerivation();
                }
            }
        }
    }

    XSDSimpleType resolveReference(XMLSchema xMLSchema) throws XSDException {
        XSDSimpleType xSDSimpleType = null;
        if (this.derivedBy == "restriction") {
            xSDSimpleType = (XSDSimpleType)xMLSchema.getComponent(this.refNamespace, this.refName, 2);
            if (xSDSimpleType == null) {
                return null;
            }
            this.resolved = true;
            this.setBaseType(xSDSimpleType);
        } else if (this.derivedBy == "list") {
            xSDSimpleType = (XSDSimpleType)xMLSchema.getComponent(this.refNamespace, this.refName, 2);
            if (xSDSimpleType == null) {
                return null;
            }
            this.resolved = true;
            this.parsed = true;
            this.setItemType(xSDSimpleType);
        } else if (this.derivedBy == "union") {
            this.resolved = true;
            this.parsed = true;
            int n = this.memberTypes.size();
            for (int i = 0; i < n; ++i) {
                XSDNode xSDNode = (XSDNode)this.memberTypes.elementAt(i);
                if (xSDNode.getNodeType() == 2) continue;
                xSDSimpleType = (XSDSimpleType)xMLSchema.getComponent(xSDNode.targetNS, xSDNode.getName(), 2);
                if (xSDSimpleType != null) {
                    if (!xSDSimpleType.parsed) {
                        this.parsed = false;
                    }
                    this.memberTypes.setElementAt(xSDSimpleType, i);
                    continue;
                }
                this.resolved = false;
            }
        }
        return xSDSimpleType;
    }

    public static XSDSimpleType getPrimitiveType(int n) {
        if (n >= 0 && n < 20) {
            return builtInArray[n];
        }
        return null;
    }

    public static XSDSimpleType getBuiltInType(int n) {
        if (n < 0 || n >= 47) {
            return null;
        }
        return builtInArray[n];
    }

    public static XSDSimpleType derivedFrom(XSDSimpleType xSDSimpleType, String string, String string2) throws XSDException {
        XSDSimpleType xSDSimpleType2 = new XSDSimpleType();
        xSDSimpleType2.setName(string);
        if (string2 == "list") {
            xSDSimpleType2.setDerivation("list");
            xSDSimpleType2.setItemType(xSDSimpleType);
        } else if (string2 == "union") {
            xSDSimpleType2.setDerivation("union");
            xSDSimpleType2.addMemberType(xSDSimpleType);
        } else {
            xSDSimpleType2.setDerivation("restriction");
            xSDSimpleType2.setBaseType(xSDSimpleType);
        }
        return xSDSimpleType2;
    }

    void setBaseType(XSDSimpleType xSDSimpleType) {
        this.baseType = xSDSimpleType;
        if (!xSDSimpleType.parsed) {
            this.parsed = false;
            return;
        }
        this.basicType = xSDSimpleType.basicType;
        this.fundamentals = xSDSimpleType.fundamentals;
        if (xSDSimpleType.facets != null) {
            for (int i = 0; i < 13; ++i) {
                this.facets[i] = xSDSimpleType.facets[i];
            }
        }
        this.variety = xSDSimpleType.variety;
        this.memberTypes = xSDSimpleType.memberTypes;
        this.itemType = xSDSimpleType.itemType;
        this.properties.or(xSDSimpleType.properties);
    }

    public Vector getMemberTypes() {
        return this.memberTypes;
    }

    public XSDSimpleType getItemType() {
        return this.itemType;
    }

    public Vector getEnumeration() {
        XSDConstrainingFacet xSDConstrainingFacet;
        if (this.facets != null && (xSDConstrainingFacet = this.facets[10]) != null) {
            return xSDConstrainingFacet.getLexicalEnumeration();
        }
        return null;
    }

    void addMemberType(XSDNode xSDNode) throws XSDException {
        if (xSDNode.getNodeType() != 2) {
            this.resolved = false;
            this.memberTypes.addElement(xSDNode);
            return;
        }
        XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDNode;
        if (xSDSimpleType.properties.get(6)) {
            throw new XSDException();
        }
        if (xSDSimpleType.variety == "union") {
            Vector vector = xSDSimpleType.memberTypes;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                this.addMemberType((XSDNode)vector.elementAt(i));
            }
        } else {
            this.memberTypes.addElement(xSDSimpleType);
        }
    }

    void setItemType(XSDSimpleType xSDSimpleType) throws XSDException {
        if (this.variety != "list") {
            throw new XSDException();
        }
        if (xSDSimpleType.variety == "list") {
            throw new XSDException();
        }
        if (xSDSimpleType.properties.get(5)) {
            throw new XSDException();
        }
        this.itemType = xSDSimpleType;
    }

    public int getBasicType() {
        return this.basicType;
    }

    public static int getBasicType(int n) {
        return bltToPrim[n];
    }

    public int getBuiltInId() {
        return (this.fundamentals & 0x3F0000) >> 16;
    }

    public boolean isAbstract() {
        return this.properties.get(7);
    }

    public XSDSimpleType getBase() {
        return this.baseType;
    }

    public String getWSFacetValue() {
        if (this.variety.equals("list")) {
            return "collapse";
        }
        switch (this.basicType) {
            case 0: {
                return "";
            }
            case 1: {
                if (this.facets == null || this.facets[12] == null) {
                    return "preserve";
                }
                return this.facets[12].getLexicalValue();
            }
        }
        return "collapse";
    }

    public XSDConstrainingFacet[] getFacets() {
        if (this.facets == null) {
            this.facets = new XSDConstrainingFacet[13];
        }
        return this.facets;
    }

    public String getVariety() {
        return this.variety;
    }

    public static Hashtable getBuiltInDatatypes() throws XSDException {
        return builtInTypes;
    }

    public static int getBuiltInTypeId(QName qName) {
        Integer n = (Integer)typeIdTable.get(qName);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public static int getTypeId(QName qName) {
        int n = XSDSimpleType.getBuiltInTypeId(qName);
        if (n <= 22) {
            return n;
        }
        return -1;
    }

    public static XSDSimpleType getBuiltInDatatype(QName qName) {
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        if (string.equals("http://www.w3.org/2001/XMLSchema")) {
            return (XSDSimpleType)builtInTypes.get(string2);
        }
        if (string.equals("http://www.w3.org/2005/04/xpath-datatypes")) {
            if (string2.equals("yearMonthDuration")) {
                return yearMonthDuration;
            }
            if (string2.equals("dayTimeDuration")) {
                return dayTimeDuration;
            }
            if (string2.equals("untypedAtomic")) {
                return untypedAtomic;
            }
        }
        return null;
    }

    BitSet getProperties() {
        return this.properties;
    }

    boolean isDerivedFrom(XSDNode xSDNode, BitSet bitSet) {
        if (xSDNode instanceof XSDComplexType) {
            return xSDNode == XSDComplexType.urType;
        }
        XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDNode;
        boolean bl = false;
        if (this.variety == "atomic" && xSDSimpleType.variety == "union") {
            int n = this.memberTypes.size();
            for (int i = 0; i < n; ++i) {
                xSDSimpleType = (XSDSimpleType)this.memberTypes.elementAt(i);
                if (!this.isDerivedFrom(xSDSimpleType, bitSet)) continue;
                return true;
            }
            return false;
        }
        XSDSimpleType xSDSimpleType2 = this;
        while (xSDSimpleType2 != null) {
            XSDSimpleType xSDSimpleType3 = xSDSimpleType2.getBase();
            if (xSDSimpleType2 == xSDSimpleType) {
                return !bl || !bitSet.get(2);
            }
            if (this.derivedBy == "restriction") {
                bl = true;
            }
            if (xSDSimpleType3 == null || xSDSimpleType2 == xSDSimpleType3) break;
            xSDSimpleType2 = xSDSimpleType3;
        }
        return false;
    }

    boolean isSubstitutableFor(XSDNode xSDNode, boolean bl, boolean bl2) {
        if (this == xSDNode || xSDNode == XSDComplexType.urType) {
            return true;
        }
        if (bl) {
            return false;
        }
        if (this.variety == "atomic" && this.baseType != null) {
            return this.baseType.isSubstitutableFor(xSDNode, false, false);
        }
        if (xSDNode == urType || xSDNode == XSDComplexType.urType) {
            return true;
        }
        if (this.variety == "union") {
            int n = this.memberTypes.size();
            for (int i = 0; i < n; ++i) {
                if (!((XSDSimpleType)this.memberTypes.elementAt(i)).isSubstitutableFor(xSDNode, false, false)) continue;
                return true;
            }
        }
        return false;
    }

    public int getMinOccurs() {
        return 1;
    }

    public int getMaxOccurs() {
        return 1;
    }

    public void setMinOccurs(int n) {
    }

    public void setMaxOccurs(int n) {
    }

    public void setSource(XSDNode xSDNode) throws XSDException {
        XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDNode;
        for (int i = 0; i < 13; ++i) {
            this.facets[i] = xSDSimpleType.facets[i];
        }
    }

    public void validateValue(String string) throws Exception {
        this.validateValue(string, null);
    }

    XSDSimpleType validateValue(String string, XSDValidator xSDValidator) throws Exception {
        XSDDataValue xSDDataValue = null;
        if (this.variety == "union") {
            if (this.facets != null && this.facets[11] != null) {
                this.facets[11].validateLexical(string);
            }
            if (this.facets != null && this.facets[10] != null) {
                this.facets[10].validateLexical(string);
            }
            int n = this.memberTypes.size();
            for (int i = 0; i < n; ++i) {
                XSDSimpleType xSDSimpleType = (XSDSimpleType)this.memberTypes.elementAt(i);
                try {
                    return xSDSimpleType.validateValue(string, xSDValidator);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            throw new XSDException(24507, string, this.name);
        }
        if (this.variety == "list") {
            if (this.itemType == null) {
                throw new XSDException(24507, string, this.name);
            }
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.itemType.validateValue(string2, xSDValidator);
                ++n;
            }
            String string3 = this.processWS(string);
            if (this.facets != null) {
                for (int i = 1; i < 13; ++i) {
                    if (this.facets[i] == null) continue;
                    if (i == 11 || i == 10) {
                        this.facets[i].validateLexical(string3);
                        continue;
                    }
                    this.facets[i].validateLength(n);
                }
            }
        } else {
            String string4 = string;
            if (xSDValidator != null) {
                string4 = this.processWS(string);
            }
            if (xSDValidator != null) {
                xSDDataValue = xSDValidator.getDataValue();
            }
            if (xSDDataValue != null) {
                xSDDataValue.setValue(this.basicType, string4);
            } else {
                xSDDataValue = new XSDDataValue(this.basicType, string4);
            }
            if ((this.basicType == 18 || this.basicType == 19) && xSDValidator != null) {
                xSDValidator.checkQName(string4, xSDDataValue);
            }
            for (int i = 1; i < 13; ++i) {
                if (this.facets[i] == null) continue;
                this.facets[i].validateFacet(xSDDataValue);
            }
            if (this.hasFlag(8) && xSDValidator != null) {
                xSDValidator.checkID(string4);
            } else if (this.hasFlag(16) && xSDValidator != null) {
                xSDValidator.addIDRef(string4);
            }
        }
        return this;
    }

    public int compareValues(String string, String string2) {
        try {
            XSDDataValue xSDDataValue = new XSDDataValue(this.basicType, string);
            XSDDataValue xSDDataValue2 = new XSDDataValue(this.basicType, string2);
            return xSDDataValue.compareTo(xSDDataValue2);
        }
        catch (Exception exception) {
            return 2;
        }
    }

    String getCanonicalForm(String string) {
        string = this.processWS(string);
        try {
            XSDSimpleType xSDSimpleType = this.validateValue(string, null);
            return new XSDDataValue(xSDSimpleType.basicType, string).getCanonicalValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String processWS(String string) {
        String string2 = "collapse";
        if (this.basicType == 1) {
            if (this.facets[12] == null) {
                return string;
            }
            string2 = this.facets[12].getLexicalValue();
            if (string2.equals("preserve")) {
                return string;
            }
        }
        String string3 = string.replace('\t', ' ');
        string3 = string3.replace('\n', ' ');
        string3 = string3.replace('\r', ' ');
        if (string2 == "replace") {
            return string3;
        }
        string3 = string3.trim();
        char[] cArray = string3.toCharArray();
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < string3.length(); ++i) {
            if (cArray[i] == ' ' && bl) continue;
            cArray[n++] = cArray[i];
            bl = cArray[i] == ' ';
        }
        return new String(cArray, 0, n);
    }

    void saveFacet(String string, Object object) throws XSDException {
        int n;
        if (this.facetVals == null) {
            this.facetVals = new Vector(23);
            this.facetVals.setSize(13);
        }
        if ((n = XSDSimpleType.getFacetId(string)) >= 13 || this.facetVals.elementAt(n) != null) {
            throw new XSDException();
        }
        if (n == 10) {
            this.facetVals.addElement(object);
        } else {
            this.facetVals.setElementAt(object, n);
        }
    }

    public void setFacet(String string, String string2) throws XSDException {
        boolean bl;
        if (!this.parsed || !this.resolved) {
            this.saveFacet(string, string2);
            return;
        }
        int n = XSDSimpleType.getFacetId(string);
        if (this.variety == "atomic") {
            bl = tfTable[this.basicType][n] == 1;
        } else if (this.variety == "union") {
            bl = n == 10 || n == 11;
        } else {
            boolean bl2 = bl = uTable[n] == 1;
        }
        if (!bl) {
            throw new XSDException(24504, string2, this.name, string);
        }
        try {
            this.setFacet(n, string2);
        }
        catch (XSDException xSDException) {
            throw xSDException;
        }
        catch (Exception exception) {
            throw new XSDException(24504, string2, this.name, string);
        }
    }

    public XSDAnnotation getEnumAnnotation(String string) {
        if (this.enumAnnotations != null) {
            return (XSDAnnotation)this.enumAnnotations.get(string);
        }
        return null;
    }

    void setEnumeration(XMLElement xMLElement, XSDAnnotation xSDAnnotation) throws XSDException {
        Object object;
        String string = xMLElement.getAttribute("value");
        if (xSDAnnotation != null) {
            if (this.enumAnnotations == null) {
                this.enumAnnotations = new HashMap(20);
            }
            this.enumAnnotations.put(string, xSDAnnotation);
        }
        if (!this.parsed || !this.resolved) {
            this.saveFacet("enumeration", xMLElement);
            return;
        }
        if (!this.isNewFacet[10]) {
            if (this.facets[10] != null) {
                this.facets[10] = null;
            }
            this.isNewFacet[10] = true;
        }
        XSDDataValue xSDDataValue = new XSDDataValue(this.basicType, string);
        if (this.basicType == 18 || this.basicType == 19) {
            XMLSchema xMLSchema;
            object = XMLUtil.getPrefix(string);
            String string2 = xMLElement.resolveNamespacePrefix((String)(object == "" ? "#default" : object));
            String string3 = XMLUtil.getLocalName(string);
            xSDDataValue.setQNameValue(string, string2, string3);
            if (this.basicType == 19 && (xMLSchema = this.getOwnerSchema()) != null) {
                xMLSchema.addNotationValue(new QxName(string2, string3, (String)object, string));
            }
        }
        try {
            object = this.baseType.validateValue(string, null);
            if (this.variety == "union") {
                xSDDataValue = new XSDDataValue(((XSDSimpleType)object).basicType, string);
            }
        }
        catch (Exception exception) {
            throw new XSDException(24505, XSDTypeConstants.sFacets[10], string);
        }
        if (this.facets[10] == null) {
            this.facets[10] = new XSDConstrainingFacet(10);
            this.facets[10].lexical = string;
        }
        this.facets[10].addEnumeration(xSDDataValue);
    }

    private void setFacet(int n, String string) throws Exception {
        if (this.isNewFacet[n] && n != 10) {
            throw new XSDException(24504, XSDTypeConstants.sFacets[n], XSDTypeConstants.sFacets[n]);
        }
        if (this.facets[n] != null && this.facets[n].isFixed) {
            throw new XSDException(24504, XSDTypeConstants.sFacets[n], XSDTypeConstants.sFacets[n]);
        }
        XSDConstrainingFacet xSDConstrainingFacet = new XSDConstrainingFacet(n);
        xSDConstrainingFacet.setValue(string, this.basicType);
        switch (n) {
            case 1: {
                if (this.facets[n] != null && this.facets[n].compareTo(xSDConstrainingFacet) >= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 2: {
                if (this.facets[n] != null && this.facets[n].compareTo(xSDConstrainingFacet) >= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 3: {
                if (this.facets[n] != null && this.facets[n].compareTo(xSDConstrainingFacet) <= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 4: {
                if (this.facets[n] != null && this.facets[n].compareTo(xSDConstrainingFacet) <= 0) {
                    throw new XSDException(24504, XSDTypeConstants.sFacets[n], XSDTypeConstants.sFacets[n]);
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 7: {
                if (this.facets[n] != null && this.facets[n].compareTo(xSDConstrainingFacet) != 0) {
                    throw new XSDException(24504, XSDTypeConstants.sFacets[n], XSDTypeConstants.sFacets[n]);
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 8: {
                if (this.facets[n] != null && this.facets[n].compareTo(xSDConstrainingFacet) <= 0) {
                    throw new XSDException(24504, XSDTypeConstants.sFacets[n], XSDTypeConstants.sFacets[n]);
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 9: {
                if (this.facets[n] != null && this.facets[n].compareTo(xSDConstrainingFacet) >= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 10: {
                if (!this.isNewFacet[n]) {
                    if (this.facets[n] != null) {
                        this.enumFacet = this.facets[n];
                        this.facets[n] = null;
                    }
                    this.isNewFacet[n] = true;
                }
                XSDDataValue xSDDataValue = new XSDDataValue(this.basicType, string);
                if (this.enumFacet != null && !this.enumFacet.includeEnum(xSDDataValue)) {
                    return;
                }
                if (this.facets[n] == null) {
                    this.facets[n] = xSDConstrainingFacet;
                    break;
                }
                this.facets[n].addEnumeration(xSDDataValue);
                break;
            }
            case 11: {
                if (!this.isNewFacet[n] && this.facets[n] != null) {
                    xSDConstrainingFacet.mergePattern(this.facets[n]);
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 5: {
                if (this.facets[n] != null && xSDConstrainingFacet.compareTo(this.facets[n]) >= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 6: {
                if (this.facets[n] != null && xSDConstrainingFacet.compareTo(this.facets[n]) >= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 12: {
                if (this.basicType != 1 && this.baseType != urType && !string.equals("collapse")) {
                    throw new XSDException();
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
            }
        }
    }

    static int getFacetId(String string) throws XSDException {
        if (string == XSDTypeConstants.MININCLUSIVE) {
            return 1;
        }
        if (string == XSDTypeConstants.MINEXCLUSIVE) {
            return 2;
        }
        if (string == XSDTypeConstants.MAXINCLUSIVE) {
            return 3;
        }
        if (string == XSDTypeConstants.MAXEXCLUSIVE) {
            return 4;
        }
        if (string == "precision") {
            return 5;
        }
        if (string == "scale") {
            return 6;
        }
        if (string == XSDTypeConstants.TOTAL_DIGITS) {
            return 5;
        }
        if (string == XSDTypeConstants.FRACTION_DIGITS) {
            return 6;
        }
        if (string == XSDTypeConstants.LENGTH) {
            return 7;
        }
        if (string == XSDTypeConstants.MAXLENGTH) {
            return 8;
        }
        if (string == XSDTypeConstants.MINLENGTH) {
            return 9;
        }
        if (string == XSDTypeConstants.ENUMERATION) {
            return 10;
        }
        if (string == XSDTypeConstants.PATTERN) {
            return 11;
        }
        if (string == XSDTypeConstants.WHITESPACE) {
            return 12;
        }
        throw new XSDException(24000, "05");
    }

    void print(int n) {
        this.printSTag(n);
        if (this.isAbstract()) {
            System.out.println(XSDSimpleType.indent(n) + "abstract = true");
        } else {
            System.out.println(XSDSimpleType.indent(n) + "abstract = false");
        }
        if (this.variety != "#undef") {
            System.out.println(XSDSimpleType.indent(n) + "variety = " + this.variety);
        }
        this.printSTagEnd(n);
        if (this.facets != null) {
            for (int i = 0; i < 13; ++i) {
                if (this.facets[i] == null) continue;
                System.out.print(XSDSimpleType.indent(n + 3));
                System.out.print("<" + XSDTypeConstants.sFacets[i] + " ");
                System.out.println("value = " + this.facets[i].print() + "/>");
            }
        }
        this.printETag(n);
    }

    static boolean isNCName(String string) {
        if (string.equals("")) {
            return false;
        }
        char c = string.charAt(0);
        if (!XMLUtil.isFirstNameChar(c) || c == ':') {
            return false;
        }
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (c != ':' && XMLUtil.isNameChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isURI(String string) {
        int n = string.length();
        boolean bl = false;
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c >= '\u007f') {
                return false;
            }
            switch (c) {
                case ' ': 
                case '<': 
                case '>': {
                    return false;
                }
                case '#': {
                    if (!bl) {
                        bl = true;
                        continue block5;
                    }
                }
                case '\"': 
                case '\'': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    return false;
                }
            }
        }
        return true;
    }

    static {
        XSDSimpleType xSDSimpleType;
        builtInTypes = new Hashtable();
        builtInArray = new XSDSimpleType[47];
        uTable = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0};
        tfTable = new byte[20][];
        bltToPrim = new int[47];
        XSDSimpleType.tfTable[0] = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1};
        XSDSimpleType.tfTable[1] = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1};
        XSDSimpleType.tfTable[2] = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1};
        XSDSimpleType.tfTable[3] = new byte[]{0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1};
        XSDSimpleType.tfTable[4] = new byte[]{0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1};
        XSDSimpleType.tfTable[5] = new byte[]{0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1};
        XSDSimpleType.tfTable[6] = new byte[]{0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1};
        XSDSimpleType.tfTable[7] = new byte[]{0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1};
        XSDSimpleType.tfTable[8] = new byte[]{0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1};
        XSDSimpleType.tfTable[9] = new byte[]{0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1};
        XSDSimpleType.tfTable[10] = new byte[]{0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1};
        XSDSimpleType.tfTable[11] = new byte[]{0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1};
        XSDSimpleType.tfTable[12] = new byte[]{0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1};
        XSDSimpleType.tfTable[13] = new byte[]{0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1};
        XSDSimpleType.tfTable[14] = new byte[]{0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1};
        XSDSimpleType.tfTable[15] = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1};
        XSDSimpleType.tfTable[16] = new byte[]{0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1};
        XSDSimpleType.tfTable[17] = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1};
        XSDSimpleType.tfTable[18] = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1};
        XSDSimpleType.tfTable[19] = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1};
        urType = xSDSimpleType = new XSDSimpleType(0, XSDTypeConstants.ANY_SIMPLE);
        XSDSimpleType.builtInArray[0] = xSDSimpleType;
        builtInTypes.put(XSDTypeConstants.ANY_SIMPLE, xSDSimpleType);
        xSDSimpleType = new XSDSimpleType(1, XSDTypeConstants.STRING);
        xSDSimpleType.setFlag(2);
        builtInTypes.put(XSDTypeConstants.STRING, xSDSimpleType);
        XSDSimpleType.builtInArray[1] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(2, XSDTypeConstants.BOOLEAN);
        builtInTypes.put(XSDTypeConstants.BOOLEAN, xSDSimpleType);
        XSDSimpleType.builtInArray[2] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(3, XSDTypeConstants.FLOAT);
        xSDSimpleType.setFlag(2);
        xSDSimpleType.setFlag(1);
        builtInTypes.put(XSDTypeConstants.FLOAT, xSDSimpleType);
        XSDSimpleType.builtInArray[3] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(4, XSDTypeConstants.DOUBLE);
        xSDSimpleType.setFlag(2);
        xSDSimpleType.setFlag(1);
        builtInTypes.put(XSDTypeConstants.DOUBLE, xSDSimpleType);
        XSDSimpleType.builtInArray[4] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(5, XSDTypeConstants.DECIMAL);
        xSDSimpleType.setFlag(2);
        xSDSimpleType.setFlag(1);
        builtInTypes.put(XSDTypeConstants.DECIMAL, xSDSimpleType);
        XSDSimpleType.builtInArray[5] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(6, XSDTypeConstants.DURATION);
        builtInTypes.put(XSDTypeConstants.DURATION, xSDSimpleType);
        XSDSimpleType.builtInArray[6] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(7, XSDTypeConstants.DATE_TIME);
        xSDSimpleType.setFlag(2);
        builtInTypes.put(XSDTypeConstants.DATE_TIME, xSDSimpleType);
        XSDSimpleType.builtInArray[7] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(8, XSDTypeConstants.TIME);
        xSDSimpleType.setFlag(2);
        builtInTypes.put(XSDTypeConstants.TIME, xSDSimpleType);
        XSDSimpleType.builtInArray[8] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(9, XSDTypeConstants.DATE);
        xSDSimpleType.setFlag(2);
        builtInTypes.put(XSDTypeConstants.DATE, xSDSimpleType);
        XSDSimpleType.builtInArray[9] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(10, XSDTypeConstants.GYEAR_MONTH);
        xSDSimpleType.setFlag(2);
        builtInTypes.put(XSDTypeConstants.GYEAR_MONTH, xSDSimpleType);
        XSDSimpleType.builtInArray[10] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(11, XSDTypeConstants.GYEAR);
        xSDSimpleType.setFlag(2);
        builtInTypes.put(XSDTypeConstants.GYEAR, xSDSimpleType);
        XSDSimpleType.builtInArray[11] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(13, XSDTypeConstants.GMONTH_DAY);
        xSDSimpleType.setFlag(2);
        builtInTypes.put(XSDTypeConstants.GMONTH_DAY, xSDSimpleType);
        XSDSimpleType.builtInArray[13] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(14, XSDTypeConstants.GDAY);
        xSDSimpleType.setFlag(2);
        builtInTypes.put(XSDTypeConstants.GDAY, xSDSimpleType);
        XSDSimpleType.builtInArray[14] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(12, XSDTypeConstants.GMONTH);
        xSDSimpleType.setFlag(2);
        builtInTypes.put(XSDTypeConstants.GMONTH, xSDSimpleType);
        XSDSimpleType.builtInArray[12] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(15, XSDTypeConstants.HEX_BINARY);
        builtInTypes.put(XSDTypeConstants.HEX_BINARY, xSDSimpleType);
        XSDSimpleType.builtInArray[15] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(16, XSDTypeConstants.BASE64_BINARY);
        builtInTypes.put(XSDTypeConstants.BASE64_BINARY, xSDSimpleType);
        XSDSimpleType.builtInArray[16] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(17, XSDTypeConstants.ANY_URI);
        builtInTypes.put(XSDTypeConstants.ANY_URI, xSDSimpleType);
        XSDSimpleType.builtInArray[17] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(18, XSDTypeConstants.QNAME);
        builtInTypes.put(XSDTypeConstants.QNAME, xSDSimpleType);
        XSDSimpleType.builtInArray[18] = xSDSimpleType;
        xSDSimpleType = new XSDSimpleType(19, XSDTypeConstants.SNOTATION);
        builtInTypes.put(XSDTypeConstants.SNOTATION, xSDSimpleType);
        XSDSimpleType.builtInArray[19] = xSDSimpleType;
        untypedAtomic = new XSDSimpleType(0, "untypedAtomic");
        try {
            XSDSimpleType xSDSimpleType2 = (XSDSimpleType)builtInTypes.get(XSDTypeConstants.STRING);
            XSDSimpleType xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "normalizedString", "restriction");
            xSDSimpleType3.setFacet(12, "replace");
            xSDSimpleType3.setFacet(11, "[^\\n\\t\\r]*");
            builtInTypes.put("normalizedString", xSDSimpleType3);
            XSDSimpleType.builtInArray[35] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("normalizedString");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "token", "restriction");
            xSDSimpleType3.setFacet(12, "collapse");
            xSDSimpleType3.setFacet(11, "([^ ]+( [^ ]+)*)?");
            builtInTypes.put("token", xSDSimpleType3);
            XSDSimpleType.builtInArray[36] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("token");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "language", "restriction");
            xSDSimpleType3.setFacet(11, "([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]+)(-[a-zA-Z]+)*");
            builtInTypes.put("language", xSDSimpleType3);
            XSDSimpleType.builtInArray[37] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("token");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "NMTOKEN", "restriction");
            xSDSimpleType3.setFacet(11, "\\c+");
            builtInTypes.put("NMTOKEN", xSDSimpleType3);
            XSDSimpleType.builtInArray[40] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("token");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "Name", "restriction");
            xSDSimpleType3.setFacet(11, "\\i\\c*");
            builtInTypes.put("Name", xSDSimpleType3);
            XSDSimpleType.builtInArray[42] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get(XSDTypeConstants.DECIMAL);
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "integer", "restriction");
            xSDSimpleType3.setFlag(32);
            xSDSimpleType3.setFacet(6, "0");
            builtInTypes.put("integer", xSDSimpleType3);
            XSDSimpleType.builtInArray[22] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("Name");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "NCName", "restriction");
            xSDSimpleType3.setFacet(11, "[\\i-[:]][\\c-[:]]*");
            builtInTypes.put("NCName", xSDSimpleType3);
            XSDSimpleType.builtInArray[43] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("NCName");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "ID", "restriction");
            xSDSimpleType3.setFlag(8);
            builtInTypes.put("ID", xSDSimpleType3);
            XSDSimpleType.builtInArray[38] = xSDSimpleType3;
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "IDREF", "restriction");
            builtInTypes.put("IDREF", xSDSimpleType3);
            xSDSimpleType3.setFlag(16);
            XSDSimpleType.builtInArray[39] = xSDSimpleType3;
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "ENTITY", "restriction");
            builtInTypes.put("ENTITY", xSDSimpleType3);
            XSDSimpleType.builtInArray[41] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("integer");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "nonPositiveInteger", "restriction");
            xSDSimpleType3.setFacet(3, "0");
            builtInTypes.put("nonPositiveInteger", xSDSimpleType3);
            XSDSimpleType.builtInArray[23] = xSDSimpleType3;
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "long", "restriction");
            xSDSimpleType3.setFacet(1, "-9223372036854775808");
            xSDSimpleType3.setFacet(3, "9223372036854775807");
            builtInTypes.put("long", xSDSimpleType3);
            XSDSimpleType.builtInArray[24] = xSDSimpleType3;
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "nonNegativeInteger", "restriction");
            xSDSimpleType3.setFacet(1, "0");
            builtInTypes.put("nonNegativeInteger", xSDSimpleType3);
            XSDSimpleType.builtInArray[25] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("nonPositiveInteger");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "negativeInteger", "restriction");
            xSDSimpleType3.setFacet(3, "-1");
            builtInTypes.put("negativeInteger", xSDSimpleType3);
            XSDSimpleType.builtInArray[26] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("long");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "int", "restriction");
            xSDSimpleType3.setFacet(1, "-2147483648");
            xSDSimpleType3.setFacet(3, "2147483647");
            builtInTypes.put("int", xSDSimpleType3);
            XSDSimpleType.builtInArray[27] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("int");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "short", "restriction");
            xSDSimpleType3.setFacet(1, "-32768");
            xSDSimpleType3.setFacet(3, "32767");
            builtInTypes.put("short", xSDSimpleType3);
            XSDSimpleType.builtInArray[28] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("short");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "byte", "restriction");
            xSDSimpleType3.setFacet(1, "-128");
            xSDSimpleType3.setFacet(3, "127");
            builtInTypes.put("byte", xSDSimpleType3);
            XSDSimpleType.builtInArray[29] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("nonNegativeInteger");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "unsignedLong", "restriction");
            xSDSimpleType3.setFacet(3, "18446744073709551615");
            builtInTypes.put("unsignedLong", xSDSimpleType3);
            XSDSimpleType.builtInArray[30] = xSDSimpleType3;
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "positiveInteger", "restriction");
            xSDSimpleType3.setFacet(1, "1");
            builtInTypes.put("positiveInteger", xSDSimpleType3);
            XSDSimpleType.builtInArray[31] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("unsignedLong");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "unsignedInt", "restriction");
            xSDSimpleType3.setFacet(3, "4294967295");
            builtInTypes.put("unsignedInt", xSDSimpleType3);
            XSDSimpleType.builtInArray[32] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("unsignedInt");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "unsignedShort", "restriction");
            xSDSimpleType3.setFacet(3, "65535");
            builtInTypes.put("unsignedShort", xSDSimpleType3);
            XSDSimpleType.builtInArray[33] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("unsignedShort");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "unsignedByte", "restriction");
            xSDSimpleType3.setFacet(3, "255");
            builtInTypes.put("unsignedByte", xSDSimpleType3);
            XSDSimpleType.builtInArray[34] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("NMTOKEN");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "NMTOKENS", "list");
            builtInTypes.put("NMTOKENS", xSDSimpleType3);
            XSDSimpleType.builtInArray[46] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("IDREF");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "IDREFS", "list");
            builtInTypes.put("IDREFS", xSDSimpleType3);
            XSDSimpleType.builtInArray[44] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get("ENTITY");
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "ENTITIES", "list");
            builtInTypes.put("ENTITIES", xSDSimpleType3);
            XSDSimpleType.builtInArray[45] = xSDSimpleType3;
            xSDSimpleType2 = (XSDSimpleType)builtInTypes.get(XSDTypeConstants.DURATION);
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "yearMonthDuration", "restriction");
            xSDSimpleType3.setFacet(11, "[^DTHS]+");
            xSDSimpleType3.setFlag(64);
            XSDSimpleType.builtInArray[20] = xSDSimpleType3;
            xSDSimpleType3 = XSDSimpleType.derivedFrom(xSDSimpleType2, "dayTimeDuration", "restriction");
            xSDSimpleType3.setFacet(11, "\\-?P([0-9]+D)?(T.+)?");
            xSDSimpleType3.setFlag(128);
            XSDSimpleType.builtInArray[21] = xSDSimpleType3;
        }
        catch (Exception exception) {
            // empty catch block
        }
        typeIdTable = new HashMap(50);
        yearMonthDuration = builtInArray[20];
        dayTimeDuration = builtInArray[21];
        for (int i = 0; i < 47; ++i) {
            xSDSimpleType = builtInArray[i];
            xSDSimpleType.targetNS = i == 20 || i == 21 ? "http://www.w3.org/2005/04/xpath-datatypes" : "http://www.w3.org/2001/XMLSchema";
            xSDSimpleType.setFlag(i << 16);
            typeIdTable.put(xSDSimpleType.getQName(), new Integer(i));
            XSDSimpleType.bltToPrim[i] = i <= 22 ? i : (i <= 34 ? 22 : (i <= 43 ? 1 : 0));
        }
    }
}

