/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.management.runtime.messaging.endpoints.StreamingAMFEndpointControl;
import flex.messaging.MessageBroker;
import flex.messaging.endpoints.BaseStreamingHTTPEndpoint;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.endpoints.amf.BatchProcessFilter;
import flex.messaging.endpoints.amf.LegacyFilter;
import flex.messaging.endpoints.amf.MessageBrokerFilter;
import flex.messaging.endpoints.amf.SerializationFilter;
import flex.messaging.endpoints.amf.SessionFilter;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.Amf3Output;
import flex.messaging.log.Log;
import flex.messaging.messages.Message;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class StreamingAMFEndpoint
extends BaseStreamingHTTPEndpoint {
    public static final String LOG_CATEGORY = "Endpoint.StreamingAMF";

    public StreamingAMFEndpoint() {
        this(false);
    }

    public StreamingAMFEndpoint(boolean enableManagement) {
        super(enableManagement);
    }

    protected AMFFilter createFilterChain() {
        SerializationFilter serializationFilter = new SerializationFilter(this.getLogCategory());
        BatchProcessFilter batchFilter = new BatchProcessFilter();
        SessionFilter sessionFilter = new SessionFilter();
        LegacyFilter envelopeFilter = new LegacyFilter(this);
        MessageBrokerFilter messageBrokerFilter = new MessageBrokerFilter(this);
        serializationFilter.setNext(batchFilter);
        batchFilter.setNext(sessionFilter);
        sessionFilter.setNext(envelopeFilter);
        envelopeFilter.setNext(messageBrokerFilter);
        return serializationFilter;
    }

    protected String getResponseContentType() {
        return "application/x-amf";
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected long getMessageSizeForPerformanceInfo(Message message) {
        DataOutputStream dataOutStream;
        block2: {
            Amf3Output amfOut = new Amf3Output(this.serializationContext);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            dataOutStream = new DataOutputStream(outStream);
            amfOut.setOutputStream(dataOutStream);
            try {
                amfOut.writeObject(message);
            }
            catch (IOException e) {
                if (!Log.isDebug()) break block2;
                this.log.debug("MPI exception while retrieving the size of the serialized message: " + e.toString());
            }
        }
        return dataOutStream.size();
    }

    protected String getDeserializerClassName() {
        return "flex.messaging.io.amf.AmfMessageDeserializer";
    }

    protected String getSerializerClassName() {
        return "flex.messaging.io.amf.AmfMessageSerializer";
    }

    protected String getSerializerJava15ClassName() {
        return "flex.messaging.io.amf.Java15AmfMessageSerializer";
    }

    protected void setupEndpointControl(MessageBroker broker) {
        this.controller = new StreamingAMFEndpointControl(this, broker.getControl());
        this.controller.register();
        this.setControl(this.controller);
    }

    protected void streamMessages(List messages, ServletOutputStream os, HttpServletResponse response) throws IOException {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        TypeMarshallingContext.setTypeMarshaller(this.getTypeMarshaller());
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            Amf3Output amfOut = this.getAmfOutput();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DataOutputStream dataOutStream = new DataOutputStream(outStream);
            amfOut.setOutputStream(dataOutStream);
            Message message = (Message)iter.next();
            if (this.isRecordMessageSizes() || this.isRecordMessageTimes()) {
                this.addPerformanceInfo(message);
            }
            if (Log.isDebug()) {
                this.log.debug("Endpoint with id '" + this.getId() + "' is streaming message: " + message);
            }
            amfOut.writeObject(message);
            dataOutStream.flush();
            byte[] messageBytes = outStream.toByteArray();
            this.streamChunk(messageBytes, os, response);
            if (!this.isManaged()) continue;
            ((StreamingAMFEndpointControl)this.controller).incrementPushCount();
        }
        TypeMarshallingContext.setTypeMarshaller(null);
    }

    protected Amf3Output getAmfOutput() {
        block3: {
            String scn = this.serializationContext.getSerializerClass().getName();
            if (this.getSerializerJava15ClassName().equals(scn)) {
                String amfOutClassName = "flex.messaging.io.amf.Java15Amf3Output";
                try {
                    Class amfOutClass = this.createClass("flex.messaging.io.amf.Java15Amf3Output");
                    Constructor c = amfOutClass.getConstructor(this.serializationContext.getClass());
                    return (Amf3Output)c.newInstance(this.serializationContext);
                }
                catch (Exception e) {
                    if (!Log.isDebug()) break block3;
                    this.log.debug("Endpoint with id '" + this.getId() + "' cannot use Java5 specific AMF output class: " + e.getMessage());
                }
            }
        }
        return new Amf3Output(this.serializationContext);
    }
}

