/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.cluster;

import flex.messaging.cluster.Cluster;
import flex.messaging.cluster.JGroupsCluster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.MembershipListener;
import org.jgroups.View;

class ClusterMembershipListener
implements MembershipListener {
    private JGroupsCluster cluster;
    private List memberList;
    private List zombieList;

    public ClusterMembershipListener(Cluster cluster) {
        this.cluster = (JGroupsCluster)cluster;
        this.memberList = new ArrayList();
        this.zombieList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewAccepted(View membershipView) {
        ClusterMembershipListener clusterMembershipListener = this;
        synchronized (clusterMembershipListener) {
            Address member;
            Vector currentMemberList = membershipView.getMembers();
            Iterator iter = currentMemberList.iterator();
            while (iter.hasNext()) {
                member = (Address)iter.next();
                if (this.cluster.getLocalAddress().equals(member) || this.memberList.contains(member)) continue;
                this.cluster.addClusterNode(member);
            }
            iter = this.memberList.iterator();
            while (iter.hasNext()) {
                member = (Address)iter.next();
                if (membershipView.containsMember(member)) continue;
                this.cluster.removeClusterNode(member);
                this.zombieList.remove(member);
            }
            this.memberList = currentMemberList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspect(Address zombieAddress) {
        ClusterMembershipListener clusterMembershipListener = this;
        synchronized (clusterMembershipListener) {
            this.zombieList.add(zombieAddress);
        }
    }

    public void block() {
    }

    public boolean isZombie(Address address) {
        return this.zombieList.contains(address);
    }
}

