/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.audio.vorbis.mapping;

import javax.media.Buffer;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.OggReader;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.VorbisDecoder;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.mapping.Mapping;

public class Mapping0
extends Mapping {
    private int channels;
    private int submaps;
    private int coupling_steps;
    private int[] coupling_mag = new int[257];
    private int[] coupling_ang = new int[257];
    private int[] chmuxlist = new int[6];
    private int[] floorsubmap = new int[17];
    private int[] residuesubmap = new int[17];
    private float[][] pcm;
    private int pcmend;
    private float[][] window = new float[2][];
    private static boolean lastWindow;
    private static boolean thisWindow;
    private static int centerW;
    private static int pcm_returned;
    private static int pcm_current;
    private static float[][] pcmb;

    private static final int ilog(long l) {
        int n = 0;
        if (l > 0L) {
            --l;
        }
        while (l > 0L) {
            ++n;
            l >>= 1;
        }
        return n;
    }

    public void unpack(OggReader oggReader, int n) {
        int n2;
        this.channels = n;
        this.submaps = oggReader.getBits(1) == 1L ? (int)oggReader.getBits(4) + 1 : 1;
        if (oggReader.getBits(1) == 1L) {
            this.coupling_steps = (int)oggReader.getBits(8) + 1;
            for (n2 = 0; n2 < this.coupling_steps; ++n2) {
                this.coupling_mag[n2] = (int)oggReader.getBits(Mapping0.ilog(n));
                this.coupling_ang[n2] = (int)oggReader.getBits(Mapping0.ilog(n));
            }
        }
        if (oggReader.getBits(2) > 0L) {
            throw new Error("Reserved");
        }
        if (this.submaps > 1) {
            for (n2 = 0; n2 < n; ++n2) {
                this.chmuxlist[n2] = (int)oggReader.getBits(4);
            }
        }
        for (n2 = 0; n2 < this.submaps; ++n2) {
            oggReader.getBits(8);
            this.floorsubmap[n2] = (int)oggReader.getBits(8);
            this.residuesubmap[n2] = (int)oggReader.getBits(8);
        }
        this.pcm = new float[n][4096];
        pcmb = new float[n][4096];
    }

    public void inverse(OggReader oggReader, VorbisDecoder vorbisDecoder) {
        int n;
        int n2;
        int n3;
        this.pcmend = vorbisDecoder.getBlockSize(vorbisDecoder.getW() ? 1 : 0);
        long l = this.pcmend;
        float[][] fArray = new float[this.channels][(int)l];
        int[] nArray = new int[this.channels];
        int[] nArray2 = new int[this.channels];
        Object[] objectArray = new Object[this.channels];
        for (n3 = 0; n3 < this.channels; ++n3) {
            n2 = this.chmuxlist[n3];
            objectArray[n3] = vorbisDecoder.getFloor(this.floorsubmap[n2]).inverse1(oggReader, vorbisDecoder);
            nArray2[n3] = objectArray[n3] != null ? 1 : 0;
            n = 0;
            while ((long)n < l) {
                this.pcm[n3][n] = 0.0f;
                ++n;
            }
        }
        for (n3 = 0; n3 < this.coupling_steps; ++n3) {
            if (nArray2[this.coupling_mag[n3]] == 0 && nArray2[this.coupling_ang[n3]] == 0) continue;
            nArray2[this.coupling_mag[n3]] = 1;
            nArray2[this.coupling_ang[n3]] = 1;
        }
        for (n3 = 0; n3 < this.submaps; ++n3) {
            n2 = 0;
            for (n = 0; n < this.channels; ++n) {
                if (this.chmuxlist[n] != n3) continue;
                nArray[n2] = nArray2[n] != 0 ? 1 : 0;
                fArray[n2++] = this.pcm[n];
            }
            vorbisDecoder.getResidue(this.residuesubmap[n3]).inverse(oggReader, fArray, nArray, n2);
        }
        for (n3 = this.coupling_steps - 1; n3 >= 0; --n3) {
            float[] fArray2 = this.pcm[this.coupling_mag[n3]];
            float[] fArray3 = this.pcm[this.coupling_ang[n3]];
            int n4 = 0;
            while ((long)n4 < l / 2L) {
                float f = fArray2[n4];
                float f2 = fArray3[n4];
                if (f > 0.0f) {
                    if (f2 > 0.0f) {
                        fArray2[n4] = f;
                        fArray3[n4] = f - f2;
                    } else {
                        fArray3[n4] = f;
                        fArray2[n4] = f + f2;
                    }
                } else if (f2 > 0.0f) {
                    fArray2[n4] = f;
                    fArray3[n4] = f + f2;
                } else {
                    fArray3[n4] = f;
                    fArray2[n4] = f - f2;
                }
                ++n4;
            }
        }
        for (n3 = 0; n3 < this.channels; ++n3) {
            float[] fArray4 = this.pcm[n3];
            int n5 = this.chmuxlist[n3];
            vorbisDecoder.getFloor(this.floorsubmap[n5]).inverse2(objectArray[n3], fArray4, vorbisDecoder);
        }
        for (n3 = 0; n3 < this.channels; ++n3) {
            float[] fArray5 = this.pcm[n3];
            vorbisDecoder.getMdct().mdct_backward(fArray5, fArray5);
        }
        for (n3 = 0; n3 < this.channels; ++n3) {
            float[] fArray6 = this.pcm[n3];
            if (nArray2[n3] != 0) {
                this._vorbis_apply_window(fArray6, vorbisDecoder);
                continue;
            }
            int n6 = 0;
            while ((long)n6 < l) {
                fArray6[n6] = 0.0f;
                ++n6;
            }
        }
    }

    public Mapping0(VorbisDecoder vorbisDecoder) {
        for (int i = 0; i < 2; ++i) {
            int n = vorbisDecoder.getBlockSize(i) / 2;
            this.window[i] = new float[n];
            for (int j = 0; j < n; ++j) {
                double d = ((double)j + 0.5) / (double)n * Math.PI / 2.0;
                d = Math.sin(d);
                d *= d;
                d *= 1.5707963267948966;
                d = Math.sin(d);
                this.window[i][j] = (float)d;
            }
        }
    }

    private void _vorbis_apply_window(float[] fArray, VorbisDecoder vorbisDecoder) {
        int n;
        int n2 = vorbisDecoder.getW() ? vorbisDecoder.getlW() : 0;
        int n3 = vorbisDecoder.getW() ? vorbisDecoder.getnW() : 0;
        int n4 = vorbisDecoder.getBlockSize(vorbisDecoder.getW() ? 1 : 0);
        int n5 = vorbisDecoder.getBlockSize(n2);
        int n6 = vorbisDecoder.getBlockSize(n3);
        int n7 = n4 / 4 - n5 / 4;
        int n8 = n7 + n5 / 2;
        int n9 = n4 / 2 + n4 / 4 - n6 / 4;
        int n10 = n9 + n6 / 2;
        for (n = 0; n < n7; ++n) {
            fArray[n] = 0.0f;
        }
        int n11 = 0;
        while (n < n8) {
            int n12 = n++;
            fArray[n12] = fArray[n12] * this.window[n2][n11];
            ++n11;
        }
        n = n9;
        n11 = n6 / 2 - 1;
        while (n < n10) {
            int n13 = n++;
            fArray[n13] = fArray[n13] * this.window[n3][n11];
            --n11;
        }
        while (n < n4) {
            fArray[n] = 0.0f;
            ++n;
        }
    }

    public void vorbis_synthesis_blockin(VorbisDecoder vorbisDecoder) {
        int n;
        int n2;
        lastWindow = thisWindow;
        thisWindow = vorbisDecoder.getW();
        int n3 = vorbisDecoder.getBlockSize(thisWindow ? 1 : 0) / 2;
        int n4 = vorbisDecoder.getBlockSize(0) / 2;
        int n5 = vorbisDecoder.getBlockSize(1) / 2;
        if (centerW != 0) {
            n2 = n5;
            n = 0;
        } else {
            n2 = 0;
            n = n5;
        }
        for (int i = 0; i < this.channels; ++i) {
            int n6;
            int n7;
            int n8;
            if (lastWindow) {
                if (thisWindow) {
                    n8 = n;
                    n7 = 0;
                    for (n6 = 0; n6 < n5; ++n6) {
                        float[] fArray = pcmb[i];
                        int n9 = n6 + n8;
                        fArray[n9] = fArray[n9] + this.pcm[i][n6 + n7];
                    }
                } else {
                    n8 = n + n5 / 2 - n4 / 2;
                    n7 = 0;
                    for (n6 = 0; n6 < n4; ++n6) {
                        float[] fArray = pcmb[i];
                        int n10 = n6 + n8;
                        fArray[n10] = fArray[n10] + this.pcm[i][n6 + n7];
                    }
                }
            } else if (thisWindow) {
                n8 = n;
                n7 = n5 / 2 - n4 / 2;
                for (n6 = 0; n6 < n4; ++n6) {
                    float[] fArray = pcmb[i];
                    int n11 = n6 + n8;
                    fArray[n11] = fArray[n11] + this.pcm[i][n6 + n7];
                }
                while (n6 < n5 / 2 + n4 / 2) {
                    Mapping0.pcmb[i][n6 + n8] = this.pcm[i][n6 + n7];
                    ++n6;
                }
            } else {
                n8 = n;
                n7 = 0;
                for (n6 = 0; n6 < n4; ++n6) {
                    float[] fArray = pcmb[i];
                    int n12 = n6 + n8;
                    fArray[n12] = fArray[n12] + this.pcm[i][n6 + n7];
                }
            }
            n8 = n2;
            n7 = n3;
            for (n6 = 0; n6 < n3; ++n6) {
                Mapping0.pcmb[i][n6 + n8] = this.pcm[i][n6 + n7];
            }
        }
        centerW = centerW != 0 ? 0 : n5;
        if (pcm_returned == -1) {
            pcm_returned = n2;
            pcm_current = n2;
        } else {
            pcm_returned = n;
            pcm_current = n + vorbisDecoder.getBlockSize(lastWindow ? 1 : 0) / 4 + vorbisDecoder.getBlockSize(thisWindow ? 1 : 0) / 4;
        }
    }

    public void soundOutput(Buffer buffer) {
        int n = pcm_current - pcm_returned;
        byte[] byArray = (byte[])buffer.getData();
        if (byArray == null || byArray.length < buffer.getLength() + n * 4) {
            byte[] byArray2 = new byte[buffer.getLength() + n * 4];
            if (byArray != null) {
                System.arraycopy(byArray2, 0, byArray, 0, buffer.getLength());
            }
            buffer.setData((Object)byArray2);
            byArray = byArray2;
        }
        int n2 = buffer.getLength();
        for (int i = 0; i < n; ++i) {
            int n3 = Mapping0.scale(pcmb[0][i + pcm_returned]);
            byArray[n2 + i * 4 + 1] = (byte)((n3 & 0xFF00) >> 8);
            byArray[n2 + i * 4 + 0] = (byte)(n3 & 0xFF);
            n3 = Mapping0.scale(pcmb[1][i + pcm_returned]);
            byArray[n2 + i * 4 + 3] = (byte)((n3 & 0xFF00) >> 8);
            byArray[n2 + i * 4 + 2] = (byte)(n3 & 0xFF);
        }
        buffer.setLength(n2 + n * 4);
    }

    private static final int scale(double d) {
        int n = (int)(d * 32767.0);
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        }
        if (n < Short.MIN_VALUE) {
            n = Short.MIN_VALUE;
        }
        return n;
    }

    static {
        thisWindow = false;
        centerW = -1;
        pcm_returned = -1;
        pcm_current = -1;
    }
}

