
#include <Python.h>
#include <stddef.h>

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
   typedef unsigned char _Bool;
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX)
#  include <alloca.h>
# endif
#endif

#if PY_MAJOR_VERSION < 3
# undef PyCapsule_CheckExact
# undef PyCapsule_GetPointer
# define PyCapsule_CheckExact(capsule) (PyCObject_Check(capsule))
# define PyCapsule_GetPointer(capsule, name) \
    (PyCObject_AsVoidPtr(capsule))
#endif

#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int_const(x)                                        \
    (((x) > 0) ?                                                         \
        ((unsigned long long)(x) <= (unsigned long long)LONG_MAX) ?      \
            PyInt_FromLong((long)(x)) :                                  \
            PyLong_FromUnsignedLongLong((unsigned long long)(x)) :       \
        ((long long)(x) >= (long long)LONG_MIN) ?                        \
            PyInt_FromLong((long)(x)) :                                  \
            PyLong_FromLongLong((long long)(x)))

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ?   /* unsigned */                                   \
        (sizeof(type) < sizeof(long) ? PyInt_FromLong(x) :               \
         sizeof(type) == sizeof(long) ? PyLong_FromUnsignedLong(x) :     \
                                        PyLong_FromUnsignedLongLong(x))  \
      : (sizeof(type) <= sizeof(long) ? PyInt_FromLong(x) :              \
                                        PyLong_FromLongLong(x)))

#define _cffi_to_c_int(o, type)                                          \
    (sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), 0))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, CTypeDescrObject *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, CTypeDescrObject *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    ((PyObject *(*)(Py_ssize_t[]))_cffi_exports[12])
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, CTypeDescrObject *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, CTypeDescrObject *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, CTypeDescrObject *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(CTypeDescrObject *, PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, CTypeDescrObject *, PyObject *))_cffi_exports[24])
#define _CFFI_NUM_EXPORTS 25

typedef struct _ctypedescr CTypeDescrObject;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];
static PyObject *_cffi_types, *_cffi_VerificationError;

static int _cffi_setup_custom(PyObject *lib);   /* forward */

static PyObject *_cffi_setup(PyObject *self, PyObject *args)
{
    PyObject *library;
    int was_alive = (_cffi_types != NULL);
    if (!PyArg_ParseTuple(args, "OOO", &_cffi_types, &_cffi_VerificationError,
                                       &library))
        return NULL;
    Py_INCREF(_cffi_types);
    Py_INCREF(_cffi_VerificationError);
    if (_cffi_setup_custom(library) < 0)
        return NULL;
    return PyBool_FromLong(was_alive);
}

static int _cffi_init(void)
{
    PyObject *module, *c_api_object = NULL;

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    c_api_object = PyObject_GetAttrString(module, "_C_API");
    if (c_api_object == NULL)
        goto failure;
    if (!PyCapsule_CheckExact(c_api_object)) {
        PyErr_SetNone(PyExc_ImportError);
        goto failure;
    }
    memcpy(_cffi_exports, PyCapsule_GetPointer(c_api_object, "cffi"),
           _CFFI_NUM_EXPORTS * sizeof(void *));

    Py_DECREF(module);
    Py_DECREF(c_api_object);
    return 0;

  failure:
    Py_XDECREF(module);
    Py_XDECREF(c_api_object);
    return -1;
}

#define _cffi_type(num) ((CTypeDescrObject *)PyList_GET_ITEM(_cffi_types, num))

/**********/



#ifdef __APPLE__
#include <AvailabilityMacros.h>
#define __ORIG_DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER     DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER
#undef DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER
#define DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER
#endif


#include <openssl/aes.h>


#include <openssl/asn1.h>


#include <openssl/bn.h>


#include <openssl/bio.h>


#if OPENSSL_VERSION_NUMBER >= 0x10001000L
#include <openssl/cmac.h>
#endif


#if !defined(OPENSSL_NO_CMS) && OPENSSL_VERSION_NUMBER >= 0x0090808fL
/* The next define should really be in the OpenSSL header, but it is missing.
   Failing to include this on Windows causes compilation failures. */
#if defined(OPENSSL_SYS_WINDOWS)
#include <windows.h>
#endif
#include <openssl/cms.h>
#endif


#include <openssl/conf.h>


#include <openssl/crypto.h>


#include <openssl/dh.h>


#include <openssl/dsa.h>


#ifndef OPENSSL_NO_EC
#include <openssl/ec.h>
#endif

#include <openssl/obj_mac.h>


#ifndef OPENSSL_NO_ECDH
#include <openssl/ecdh.h>
#endif


#ifndef OPENSSL_NO_ECDSA
#include <openssl/ecdsa.h>
#endif


#include <openssl/engine.h>


#include <openssl/err.h>


#include <openssl/evp.h>


#include <openssl/hmac.h>


#include <openssl/obj_mac.h>


#include <openssl/objects.h>


#include <openssl/opensslv.h>

#ifdef _WIN32
#include <Wincrypt.h>
#else
#include <fcntl.h>
#include <unistd.h>
#endif


#include <openssl/pem.h>


#include <openssl/pkcs7.h>


#include <openssl/pkcs12.h>


#include <openssl/rand.h>


#include <openssl/rsa.h>


#include <openssl/ssl.h>

typedef STACK_OF(SSL_CIPHER) Cryptography_STACK_OF_SSL_CIPHER;


#include <openssl/ssl.h>

/*
 * This is part of a work-around for the difficulty cffi has in dealing with
 * `STACK_OF(foo)` as the name of a type.  We invent a new, simpler name that
 * will be an alias for this type and use the alias throughout.  This works
 * together with another opaque typedef for the same name in the TYPES section.
 * Note that the result is an opaque type.
 */
typedef STACK_OF(X509) Cryptography_STACK_OF_X509;
typedef STACK_OF(X509_CRL) Cryptography_STACK_OF_X509_CRL;
typedef STACK_OF(X509_REVOKED) Cryptography_STACK_OF_X509_REVOKED;


#include <openssl/x509.h>

/*
 * See the comment above Cryptography_STACK_OF_X509 in x509.py
 */
typedef STACK_OF(X509_NAME) Cryptography_STACK_OF_X509_NAME;
typedef STACK_OF(X509_NAME_ENTRY) Cryptography_STACK_OF_X509_NAME_ENTRY;


#include <openssl/x509v3.h>

/*
 * This is part of a work-around for the difficulty cffi has in dealing with
 * `LHASH_OF(foo)` as the name of a type.  We invent a new, simpler name that
 * will be an alias for this type and use the alias throughout.  This works
 * together with another opaque typedef for the same name in the TYPES section.
 * Note that the result is an opaque type.
 */
#if OPENSSL_VERSION_NUMBER >= 0x10000000
typedef LHASH_OF(CONF_VALUE) Cryptography_LHASH_OF_CONF_VALUE;
#else
typedef LHASH Cryptography_LHASH_OF_CONF_VALUE;
#endif
typedef STACK_OF(ACCESS_DESCRIPTION) Cryptography_STACK_OF_ACCESS_DESCRIPTION;
typedef STACK_OF(DIST_POINT) Cryptography_STACK_OF_DIST_POINT;
typedef STACK_OF(POLICYQUALINFO) Cryptography_STACK_OF_POLICYQUALINFO;
typedef STACK_OF(POLICYINFO) Cryptography_STACK_OF_POLICYINFO;
typedef STACK_OF(ASN1_INTEGER) Cryptography_STACK_OF_ASN1_INTEGER;


#include <openssl/x509_vfy.h>

/*
 * This is part of a work-around for the difficulty cffi has in dealing with
 * `STACK_OF(foo)` as the name of a type.  We invent a new, simpler name that
 * will be an alias for this type and use the alias throughout.  This works
 * together with another opaque typedef for the same name in the TYPES section.
 * Note that the result is an opaque type.
 */
typedef STACK_OF(ASN1_OBJECT) Cryptography_STACK_OF_ASN1_OBJECT;


#ifdef __APPLE__
#undef DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER
#define DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER     __ORIG_DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER
#endif


int AES_set_encrypt_key(const unsigned char *, const int, AES_KEY *);
int AES_set_decrypt_key(const unsigned char *, const int, AES_KEY *);


ASN1_OBJECT *ASN1_OBJECT_new(void);
void ASN1_OBJECT_free(ASN1_OBJECT *);

/*  ASN1 OBJECT IDENTIFIER */
ASN1_OBJECT *d2i_ASN1_OBJECT(ASN1_OBJECT **, const unsigned char **, long);
int i2d_ASN1_OBJECT(ASN1_OBJECT *, unsigned char **);

/*  ASN1 STRING */
ASN1_STRING *ASN1_STRING_new(void);
ASN1_STRING *ASN1_STRING_type_new(int);
void ASN1_STRING_free(ASN1_STRING *);
unsigned char *ASN1_STRING_data(ASN1_STRING *);
int ASN1_STRING_set(ASN1_STRING *, const void *, int);
int ASN1_STRING_type(ASN1_STRING *);
int ASN1_STRING_to_UTF8(unsigned char **, ASN1_STRING *);

/*  ASN1 OCTET STRING */
ASN1_OCTET_STRING *ASN1_OCTET_STRING_new(void);
void ASN1_OCTET_STRING_free(ASN1_OCTET_STRING *);
int ASN1_OCTET_STRING_set(ASN1_OCTET_STRING *, const unsigned char *, int);

/*  ASN1 INTEGER */
ASN1_INTEGER *ASN1_INTEGER_new(void);
void ASN1_INTEGER_free(ASN1_INTEGER *);
int ASN1_INTEGER_set(ASN1_INTEGER *, long);
int i2a_ASN1_INTEGER(BIO *, ASN1_INTEGER *);

/*  ASN1 TIME */
ASN1_TIME *ASN1_TIME_new(void);
void ASN1_TIME_free(ASN1_TIME *);
ASN1_GENERALIZEDTIME *ASN1_TIME_to_generalizedtime(ASN1_TIME *,
                                                   ASN1_GENERALIZEDTIME **);

/*  ASN1 UTCTIME */
ASN1_UTCTIME *ASN1_UTCTIME_new(void);
void ASN1_UTCTIME_free(ASN1_UTCTIME *);
int ASN1_UTCTIME_cmp_time_t(const ASN1_UTCTIME *, time_t);
ASN1_UTCTIME *ASN1_UTCTIME_set(ASN1_UTCTIME *, time_t);

/*  ASN1 GENERALIZEDTIME */
int ASN1_GENERALIZEDTIME_set_string(ASN1_GENERALIZEDTIME *, const char *);
void ASN1_GENERALIZEDTIME_free(ASN1_GENERALIZEDTIME *);

/*  ASN1 ENUMERATED */
ASN1_ENUMERATED *ASN1_ENUMERATED_new(void);
void ASN1_ENUMERATED_free(ASN1_ENUMERATED *);
int ASN1_ENUMERATED_set(ASN1_ENUMERATED *, long);

ASN1_VALUE *ASN1_item_d2i(ASN1_VALUE **, const unsigned char **, long,
                          const ASN1_ITEM *);
int ASN1_BIT_STRING_set_bit(ASN1_BIT_STRING *, int, int);


BIGNUM *BN_new(void);
void BN_free(BIGNUM *);

BN_CTX *BN_CTX_new(void);
void BN_CTX_free(BN_CTX *);

void BN_CTX_start(BN_CTX *);
BIGNUM *BN_CTX_get(BN_CTX *);
void BN_CTX_end(BN_CTX *);

BIGNUM *BN_copy(BIGNUM *, const BIGNUM *);
BIGNUM *BN_dup(const BIGNUM *);

int BN_set_word(BIGNUM *, BN_ULONG);
BN_ULONG BN_get_word(const BIGNUM *);

const BIGNUM *BN_value_one(void);

char *BN_bn2hex(const BIGNUM *);
int BN_hex2bn(BIGNUM **, const char *);
int BN_dec2bn(BIGNUM **, const char *);

int BN_bn2bin(const BIGNUM *, unsigned char *);
BIGNUM *BN_bin2bn(const unsigned char *, int, BIGNUM *);

int BN_num_bits(const BIGNUM *);

int BN_cmp(const BIGNUM *, const BIGNUM *);
int BN_add(BIGNUM *, const BIGNUM *, const BIGNUM *);
int BN_sub(BIGNUM *, const BIGNUM *, const BIGNUM *);
int BN_mul(BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *);
int BN_sqr(BIGNUM *, const BIGNUM *, BN_CTX *);
int BN_div(BIGNUM *, BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *);
int BN_nnmod(BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *);
int BN_mod_add(BIGNUM *, const BIGNUM *, const BIGNUM *, const BIGNUM *,
               BN_CTX *);
int BN_mod_sub(BIGNUM *, const BIGNUM *, const BIGNUM *, const BIGNUM *,
               BN_CTX *);
int BN_mod_mul(BIGNUM *, const BIGNUM *, const BIGNUM *, const BIGNUM *,
               BN_CTX *);
int BN_mod_sqr(BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *);
int BN_exp(BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *);
int BN_mod_exp(BIGNUM *, const BIGNUM *, const BIGNUM *, const BIGNUM *,
               BN_CTX *);
int BN_gcd(BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *);
BIGNUM *BN_mod_inverse(BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *);

int BN_set_bit(BIGNUM *, int);
int BN_clear_bit(BIGNUM *, int);

int BN_is_bit_set(const BIGNUM *, int);

int BN_mask_bits(BIGNUM *, int);


BIO *BIO_new(BIO_METHOD *);
int BIO_set(BIO *, BIO_METHOD *);
int BIO_free(BIO *);
void BIO_vfree(BIO *);
void BIO_free_all(BIO *);
BIO *BIO_push(BIO *, BIO *);
BIO *BIO_pop(BIO *);
BIO *BIO_next(BIO *);
BIO *BIO_find_type(BIO *, int);
BIO_METHOD *BIO_s_mem(void);
BIO *BIO_new_mem_buf(void *, int);
BIO_METHOD *BIO_s_file(void);
BIO *BIO_new_file(const char *, const char *);
BIO *BIO_new_fp(FILE *, int);
BIO_METHOD *BIO_s_fd(void);
BIO *BIO_new_fd(int, int);
BIO_METHOD *BIO_s_socket(void);
BIO *BIO_new_socket(int, int);
BIO_METHOD *BIO_s_null(void);
long BIO_ctrl(BIO *, int, long, void *);
long BIO_callback_ctrl(
    BIO *,
    int,
    void (*)(struct bio_st *, int, const char *, int, long, long)
);
char *BIO_ptr_ctrl(BIO *, int, long);
long BIO_int_ctrl(BIO *, int, long, int);
size_t BIO_ctrl_pending(BIO *);
size_t BIO_ctrl_wpending(BIO *);
int BIO_read(BIO *, void *, int);
int BIO_gets(BIO *, char *, int);
int BIO_write(BIO *, const void *, int);
int BIO_puts(BIO *, const char *);
BIO_METHOD *BIO_f_null(void);
BIO_METHOD *BIO_f_buffer(void);






void OPENSSL_config(const char *);
void OPENSSL_no_config(void);


unsigned long SSLeay(void);
const char *SSLeay_version(int);

void CRYPTO_free(void *);
int CRYPTO_mem_ctrl(int);
int CRYPTO_is_mem_check_on(void);
void CRYPTO_mem_leaks(struct bio_st *);
void CRYPTO_cleanup_all_ex_data(void);
int CRYPTO_num_locks(void);
void CRYPTO_set_locking_callback(void(*)(int, int, const char *, int));
void CRYPTO_set_id_callback(unsigned long (*)(void));
unsigned long (*CRYPTO_get_id_callback(void))(void);
void (*CRYPTO_get_locking_callback(void))(int, int, const char *, int);
void CRYPTO_lock(int, int, const char *, int);

void OPENSSL_free(void *);


DH *DH_new(void);
void DH_free(DH *);
int DH_size(const DH *);
DH *DH_generate_parameters(int, int, void (*)(int, int, void *), void *);
int DH_check(const DH *, int *);
int DH_check_pub_key(const DH *, const BIGNUM *, int *);
int DH_generate_key(DH *);
int DH_compute_key(unsigned char *, const BIGNUM *, DH *);
int DH_set_ex_data(DH *, int, void *);
void *DH_get_ex_data(DH *, int);
DH *d2i_DHparams(DH **, const unsigned char **, long);
int i2d_DHparams(const DH *, unsigned char **);
int DHparams_print_fp(FILE *, const DH *);
int DHparams_print(BIO *, const DH *);


DSA *DSA_generate_parameters(int, unsigned char *, int, int *, unsigned long *,
                             void (*)(int, int, void *), void *);
int DSA_generate_key(DSA *);
DSA *DSA_new(void);
void DSA_free(DSA *);
DSA_SIG *DSA_SIG_new(void);
void DSA_SIG_free(DSA_SIG *);
int i2d_DSA_SIG(const DSA_SIG *, unsigned char **);
DSA_SIG *d2i_DSA_SIG(DSA_SIG **, const unsigned char **, long);
int DSA_size(const DSA *);
int DSA_sign(int, const unsigned char *, int, unsigned char *, unsigned int *,
             DSA *);
int DSA_verify(int, const unsigned char *, int, const unsigned char *, int,
               DSA *);








ENGINE *ENGINE_get_first(void);
ENGINE *ENGINE_get_last(void);
ENGINE *ENGINE_get_next(ENGINE *);
ENGINE *ENGINE_get_prev(ENGINE *);
int ENGINE_add(ENGINE *);
int ENGINE_remove(ENGINE *);
ENGINE *ENGINE_by_id(const char *);
int ENGINE_init(ENGINE *);
int ENGINE_finish(ENGINE *);
void ENGINE_load_openssl(void);
void ENGINE_load_dynamic(void);
void ENGINE_load_builtin_engines(void);
void ENGINE_cleanup(void);
ENGINE *ENGINE_get_default_RSA(void);
ENGINE *ENGINE_get_default_DSA(void);
ENGINE *ENGINE_get_default_ECDH(void);
ENGINE *ENGINE_get_default_ECDSA(void);
ENGINE *ENGINE_get_default_DH(void);
ENGINE *ENGINE_get_default_RAND(void);
ENGINE *ENGINE_get_cipher_engine(int);
ENGINE *ENGINE_get_digest_engine(int);
int ENGINE_set_default_RSA(ENGINE *);
int ENGINE_set_default_DSA(ENGINE *);
int ENGINE_set_default_ECDH(ENGINE *);
int ENGINE_set_default_ECDSA(ENGINE *);
int ENGINE_set_default_DH(ENGINE *);
int ENGINE_set_default_RAND(ENGINE *);
int ENGINE_set_default_ciphers(ENGINE *);
int ENGINE_set_default_digests(ENGINE *);
int ENGINE_set_default_string(ENGINE *, const char *);
int ENGINE_set_default(ENGINE *, unsigned int);
unsigned int ENGINE_get_table_flags(void);
void ENGINE_set_table_flags(unsigned int);
int ENGINE_register_RSA(ENGINE *);
void ENGINE_unregister_RSA(ENGINE *);
void ENGINE_register_all_RSA(void);
int ENGINE_register_DSA(ENGINE *);
void ENGINE_unregister_DSA(ENGINE *);
void ENGINE_register_all_DSA(void);
int ENGINE_register_ECDH(ENGINE *);
void ENGINE_unregister_ECDH(ENGINE *);
void ENGINE_register_all_ECDH(void);
int ENGINE_register_ECDSA(ENGINE *);
void ENGINE_unregister_ECDSA(ENGINE *);
void ENGINE_register_all_ECDSA(void);
int ENGINE_register_DH(ENGINE *);
void ENGINE_unregister_DH(ENGINE *);
void ENGINE_register_all_DH(void);
int ENGINE_register_RAND(ENGINE *);
void ENGINE_unregister_RAND(ENGINE *);
void ENGINE_register_all_RAND(void);
int ENGINE_register_STORE(ENGINE *);
void ENGINE_unregister_STORE(ENGINE *);
void ENGINE_register_all_STORE(void);
int ENGINE_register_ciphers(ENGINE *);
void ENGINE_unregister_ciphers(ENGINE *);
void ENGINE_register_all_ciphers(void);
int ENGINE_register_digests(ENGINE *);
void ENGINE_unregister_digests(ENGINE *);
void ENGINE_register_all_digests(void);
int ENGINE_register_complete(ENGINE *);
int ENGINE_register_all_complete(void);
int ENGINE_ctrl(ENGINE *, int, long, void *, void (*)(void));
int ENGINE_cmd_is_executable(ENGINE *, int);
int ENGINE_ctrl_cmd(ENGINE *, const char *, long, void *, void (*)(void), int);
int ENGINE_ctrl_cmd_string(ENGINE *, const char *, const char *, int);

ENGINE *ENGINE_new(void);
int ENGINE_free(ENGINE *);
int ENGINE_up_ref(ENGINE *);
int ENGINE_set_id(ENGINE *, const char *);
int ENGINE_set_name(ENGINE *, const char *);
int ENGINE_set_RSA(ENGINE *, const RSA_METHOD *);
int ENGINE_set_DSA(ENGINE *, const DSA_METHOD *);
int ENGINE_set_ECDH(ENGINE *, const ECDH_METHOD *);
int ENGINE_set_ECDSA(ENGINE *, const ECDSA_METHOD *);
int ENGINE_set_DH(ENGINE *, const DH_METHOD *);
int ENGINE_set_RAND(ENGINE *, const RAND_METHOD *);
int ENGINE_set_STORE(ENGINE *, const STORE_METHOD *);
int ENGINE_set_destroy_function(ENGINE *, ENGINE_GEN_INT_FUNC_PTR);
int ENGINE_set_init_function(ENGINE *, ENGINE_GEN_INT_FUNC_PTR);
int ENGINE_set_finish_function(ENGINE *, ENGINE_GEN_INT_FUNC_PTR);
int ENGINE_set_ctrl_function(ENGINE *, ENGINE_CTRL_FUNC_PTR);
int ENGINE_set_load_privkey_function(ENGINE *, ENGINE_LOAD_KEY_PTR);
int ENGINE_set_load_pubkey_function(ENGINE *, ENGINE_LOAD_KEY_PTR);
int ENGINE_set_ciphers(ENGINE *, ENGINE_CIPHERS_PTR);
int ENGINE_set_digests(ENGINE *, ENGINE_DIGESTS_PTR);
int ENGINE_set_flags(ENGINE *, int);
int ENGINE_set_cmd_defns(ENGINE *, const ENGINE_CMD_DEFN *);
const char *ENGINE_get_id(const ENGINE *);
const char *ENGINE_get_name(const ENGINE *);
const RSA_METHOD *ENGINE_get_RSA(const ENGINE *);
const DSA_METHOD *ENGINE_get_DSA(const ENGINE *);
const ECDH_METHOD *ENGINE_get_ECDH(const ENGINE *);
const ECDSA_METHOD *ENGINE_get_ECDSA(const ENGINE *);
const DH_METHOD *ENGINE_get_DH(const ENGINE *);
const RAND_METHOD *ENGINE_get_RAND(const ENGINE *);
const STORE_METHOD *ENGINE_get_STORE(const ENGINE *);

const EVP_CIPHER *ENGINE_get_cipher(ENGINE *, int);
const EVP_MD *ENGINE_get_digest(ENGINE *, int);
int ENGINE_get_flags(const ENGINE *);
const ENGINE_CMD_DEFN *ENGINE_get_cmd_defns(const ENGINE *);
EVP_PKEY *ENGINE_load_private_key(ENGINE *, const char *, UI_METHOD *, void *);
EVP_PKEY *ENGINE_load_public_key(ENGINE *, const char *, UI_METHOD *, void *);
void ENGINE_add_conf_module(void);


void ERR_load_crypto_strings(void);
void ERR_load_SSL_strings(void);
void ERR_free_strings(void);
char *ERR_error_string(unsigned long, char *);
void ERR_error_string_n(unsigned long, char *, size_t);
const char *ERR_lib_error_string(unsigned long);
const char *ERR_func_error_string(unsigned long);
const char *ERR_reason_error_string(unsigned long);
void ERR_print_errors(BIO *);
void ERR_print_errors_fp(FILE *);
unsigned long ERR_get_error(void);
unsigned long ERR_peek_error(void);
unsigned long ERR_peek_last_error(void);
unsigned long ERR_get_error_line(const char **, int *);
unsigned long ERR_peek_error_line(const char **, int *);
unsigned long ERR_peek_last_error_line(const char **, int *);
unsigned long ERR_get_error_line_data(const char **, int *,
                                      const char **, int *);
unsigned long ERR_peek_error_line_data(const char **,
                                       int *, const char **, int *);
unsigned long ERR_peek_last_error_line_data(const char **,
                                            int *, const char **, int *);
void ERR_put_error(int, int, int, const char *, int);
void ERR_add_error_data(int, ...);
int ERR_get_next_error_library(void);


const EVP_CIPHER *EVP_get_cipherbyname(const char *);
int EVP_EncryptInit_ex(EVP_CIPHER_CTX *, const EVP_CIPHER *, ENGINE *,
                       const unsigned char *, const unsigned char *);
int EVP_CIPHER_CTX_set_padding(EVP_CIPHER_CTX *, int);
int EVP_EncryptUpdate(EVP_CIPHER_CTX *, unsigned char *, int *,
                      const unsigned char *, int);
int EVP_EncryptFinal_ex(EVP_CIPHER_CTX *, unsigned char *, int *);
int EVP_DecryptInit_ex(EVP_CIPHER_CTX *, const EVP_CIPHER *, ENGINE *,
                       const unsigned char *, const unsigned char *);
int EVP_DecryptUpdate(EVP_CIPHER_CTX *, unsigned char *, int *,
                      const unsigned char *, int);
int EVP_DecryptFinal_ex(EVP_CIPHER_CTX *, unsigned char *, int *);
int EVP_CipherInit_ex(EVP_CIPHER_CTX *, const EVP_CIPHER *, ENGINE *,
                      const unsigned char *, const unsigned char *, int);
int EVP_CipherUpdate(EVP_CIPHER_CTX *, unsigned char *, int *,
                     const unsigned char *, int);
int EVP_CipherFinal_ex(EVP_CIPHER_CTX *, unsigned char *, int *);
int EVP_CIPHER_CTX_cleanup(EVP_CIPHER_CTX *);
void EVP_CIPHER_CTX_init(EVP_CIPHER_CTX *);
EVP_CIPHER_CTX *EVP_CIPHER_CTX_new(void);
void EVP_CIPHER_CTX_free(EVP_CIPHER_CTX *);
int EVP_CIPHER_CTX_set_key_length(EVP_CIPHER_CTX *, int);

EVP_MD_CTX *EVP_MD_CTX_create(void);
int EVP_MD_CTX_copy_ex(EVP_MD_CTX *, const EVP_MD_CTX *);
int EVP_DigestInit_ex(EVP_MD_CTX *, const EVP_MD *, ENGINE *);
int EVP_DigestUpdate(EVP_MD_CTX *, const void *, size_t);
int EVP_DigestFinal_ex(EVP_MD_CTX *, unsigned char *, unsigned int *);
int EVP_MD_CTX_cleanup(EVP_MD_CTX *);
void EVP_MD_CTX_destroy(EVP_MD_CTX *);
const EVP_MD *EVP_get_digestbyname(const char *);

EVP_PKEY *EVP_PKEY_new(void);
void EVP_PKEY_free(EVP_PKEY *);
int EVP_PKEY_type(int);
int EVP_PKEY_bits(EVP_PKEY *);
int EVP_PKEY_size(EVP_PKEY *);
RSA *EVP_PKEY_get1_RSA(EVP_PKEY *);
DSA *EVP_PKEY_get1_DSA(EVP_PKEY *);
DH *EVP_PKEY_get1_DH(EVP_PKEY *);

int EVP_SignInit(EVP_MD_CTX *, const EVP_MD *);
int EVP_SignUpdate(EVP_MD_CTX *, const void *, size_t);
int EVP_SignFinal(EVP_MD_CTX *, unsigned char *, unsigned int *, EVP_PKEY *);

int EVP_VerifyInit(EVP_MD_CTX *, const EVP_MD *);
int EVP_VerifyUpdate(EVP_MD_CTX *, const void *, size_t);
int EVP_VerifyFinal(EVP_MD_CTX *, const unsigned char *, unsigned int,
                    EVP_PKEY *);

const EVP_MD *EVP_md5(void);
const EVP_MD *EVP_sha1(void);
const EVP_MD *EVP_ripemd160(void);
const EVP_MD *EVP_sha224(void);
const EVP_MD *EVP_sha256(void);
const EVP_MD *EVP_sha384(void);
const EVP_MD *EVP_sha512(void);

int PKCS5_PBKDF2_HMAC_SHA1(const char *, int, const unsigned char *, int, int,
                           int, unsigned char *);

int EVP_PKEY_set1_RSA(EVP_PKEY *, struct rsa_st *);
int EVP_PKEY_set1_DSA(EVP_PKEY *, struct dsa_st *);
int EVP_PKEY_set1_DH(EVP_PKEY *, DH *);

int EVP_PKEY_get_attr_count(const EVP_PKEY *);
int EVP_PKEY_get_attr_by_NID(const EVP_PKEY *, int, int);
int EVP_PKEY_get_attr_by_OBJ(const EVP_PKEY *, ASN1_OBJECT *, int);
X509_ATTRIBUTE *EVP_PKEY_get_attr(const EVP_PKEY *, int);
X509_ATTRIBUTE *EVP_PKEY_delete_attr(EVP_PKEY *, int);
int EVP_PKEY_add1_attr(EVP_PKEY *, X509_ATTRIBUTE *);
int EVP_PKEY_add1_attr_by_OBJ(EVP_PKEY *, const ASN1_OBJECT *, int,
                              const unsigned char *, int);
int EVP_PKEY_add1_attr_by_NID(EVP_PKEY *, int, int,
                              const unsigned char *, int);
int EVP_PKEY_add1_attr_by_txt(EVP_PKEY *, const char *, int,
                              const unsigned char *, int);

int EVP_PKEY_cmp(const EVP_PKEY *, const EVP_PKEY *);

EVP_PKEY *EVP_PKCS82PKEY(PKCS8_PRIV_KEY_INFO *);


void HMAC_CTX_init(HMAC_CTX *);
void HMAC_CTX_cleanup(HMAC_CTX *);

int Cryptography_HMAC_Init_ex(HMAC_CTX *, const void *, int, const EVP_MD *,
                              ENGINE *);
int Cryptography_HMAC_Update(HMAC_CTX *, const unsigned char *, size_t);
int Cryptography_HMAC_Final(HMAC_CTX *, unsigned char *, unsigned int *);
int Cryptography_HMAC_CTX_copy(HMAC_CTX *, HMAC_CTX *);




ASN1_OBJECT *OBJ_nid2obj(int);
const char *OBJ_nid2ln(int);
const char *OBJ_nid2sn(int);
int OBJ_obj2nid(const ASN1_OBJECT *);
int OBJ_ln2nid(const char *);
int OBJ_sn2nid(const char *);
int OBJ_txt2nid(const char *);
ASN1_OBJECT *OBJ_txt2obj(const char *, int);
int OBJ_obj2txt(char *, int, const ASN1_OBJECT *, int);
int OBJ_cmp(const ASN1_OBJECT *, const ASN1_OBJECT *);
ASN1_OBJECT *OBJ_dup(const ASN1_OBJECT *);
int OBJ_create(const char *, const char *, const char *);
void OBJ_cleanup(void);




int Cryptography_add_osrandom_engine(void);


X509 *PEM_read_bio_X509(BIO *, X509 **, pem_password_cb *, void *);
int PEM_write_bio_X509(BIO *, X509 *);

int PEM_write_bio_PrivateKey(BIO *, EVP_PKEY *, const EVP_CIPHER *,
                             unsigned char *, int, pem_password_cb *, void *);

EVP_PKEY *PEM_read_bio_PrivateKey(BIO *, EVP_PKEY **, pem_password_cb *,
                                 void *);

int PEM_write_bio_PKCS8PrivateKey(BIO *, EVP_PKEY *, const EVP_CIPHER *,
                                  char *, int, pem_password_cb *, void *);
int PEM_write_bio_PKCS8PrivateKey_nid(BIO *, EVP_PKEY *, int, char *, int,
                                      pem_password_cb *, void *);

int i2d_PKCS8PrivateKey_bio(BIO *, EVP_PKEY *, const EVP_CIPHER *,
                            char *, int, pem_password_cb *, void *);
int i2d_PKCS8PrivateKey_nid_bio(BIO *, EVP_PKEY *, int,
                                char *, int, pem_password_cb *, void *);

int i2d_PKCS7_bio(BIO *, PKCS7 *);
PKCS7 *d2i_PKCS7_bio(BIO *, PKCS7 **);

EVP_PKEY *d2i_PKCS8PrivateKey_bio(BIO *, EVP_PKEY **, pem_password_cb *,
                                  void *);

int PEM_write_bio_X509_REQ(BIO *, X509_REQ *);

X509_REQ *PEM_read_bio_X509_REQ(BIO *, X509_REQ **, pem_password_cb *, void *);

X509_CRL *PEM_read_bio_X509_CRL(BIO *, X509_CRL **, pem_password_cb *, void *);

int PEM_write_bio_X509_CRL(BIO *, X509_CRL *);

PKCS7 *PEM_read_bio_PKCS7(BIO *, PKCS7 **, pem_password_cb *, void *);
int PEM_write_bio_PKCS7(BIO *, PKCS7 *);

DH *PEM_read_bio_DHparams(BIO *, DH **, pem_password_cb *, void *);

DSA *PEM_read_bio_DSAPrivateKey(BIO *, DSA **, pem_password_cb *, void *);

RSA *PEM_read_bio_RSAPrivateKey(BIO *, RSA **, pem_password_cb *, void *);

int PEM_write_bio_DSAPrivateKey(BIO *, DSA *, const EVP_CIPHER *,
                                unsigned char *, int,
                                pem_password_cb *, void *);

int PEM_write_bio_RSAPrivateKey(BIO *, RSA *, const EVP_CIPHER *,
                                unsigned char *, int,
                                pem_password_cb *, void *);

DSA *PEM_read_bio_DSA_PUBKEY(BIO *, DSA **, pem_password_cb *, void *);

RSA *PEM_read_bio_RSAPublicKey(BIO *, RSA **, pem_password_cb *, void *);

int PEM_write_bio_DSA_PUBKEY(BIO *, DSA *);

int PEM_write_bio_RSAPublicKey(BIO *, const RSA *);

EVP_PKEY *PEM_read_bio_PUBKEY(BIO *, EVP_PKEY **, pem_password_cb *, void *);
int PEM_write_bio_PUBKEY(BIO *, EVP_PKEY *);


PKCS7 *SMIME_read_PKCS7(BIO *, BIO **);
int SMIME_write_PKCS7(BIO *, PKCS7 *, BIO *, int);

void PKCS7_free(PKCS7 *);

PKCS7 *PKCS7_sign(X509 *, EVP_PKEY *, Cryptography_STACK_OF_X509 *,
                  BIO *, int);
int PKCS7_verify(PKCS7 *, Cryptography_STACK_OF_X509 *, X509_STORE *, BIO *,
                 BIO *, int);
Cryptography_STACK_OF_X509 *PKCS7_get0_signers(PKCS7 *,
                                               Cryptography_STACK_OF_X509 *,
                                               int);

PKCS7 *PKCS7_encrypt(Cryptography_STACK_OF_X509 *, BIO *,
                     const EVP_CIPHER *, int);
int PKCS7_decrypt(PKCS7 *, EVP_PKEY *, X509 *, BIO *, int);


void PKCS12_free(PKCS12 *);

PKCS12 *d2i_PKCS12_bio(BIO *, PKCS12 **);
int i2d_PKCS12_bio(BIO *, PKCS12 *);


void ERR_load_RAND_strings(void);
void RAND_seed(const void *, int);
void RAND_add(const void *, int, double);
int RAND_status(void);
const char *RAND_file_name(char *, size_t);
int RAND_load_file(const char *, long);
int RAND_write_file(const char *);
void RAND_cleanup(void);
int RAND_bytes(unsigned char *, int);
int RAND_pseudo_bytes(unsigned char *, int);


RSA *RSA_new(void);
void RSA_free(RSA *);
int RSA_size(const RSA *);
int RSA_generate_key_ex(RSA *, int, BIGNUM *, BN_GENCB *);
int RSA_check_key(const RSA *);
RSA *RSAPublicKey_dup(RSA *);
int RSA_blinding_on(RSA *, BN_CTX *);
void RSA_blinding_off(RSA *);
int RSA_public_encrypt(int, const unsigned char *, unsigned char *,
                       RSA *, int);
int RSA_private_encrypt(int, const unsigned char *, unsigned char *,
                        RSA *, int);
int RSA_public_decrypt(int, const unsigned char *, unsigned char *,
                       RSA *, int);
int RSA_private_decrypt(int, const unsigned char *, unsigned char *,
                        RSA *, int);
int RSA_print(BIO *, const RSA *, int);
int RSA_verify_PKCS1_PSS(RSA *, const unsigned char *, const EVP_MD *,
                         const unsigned char *, int);
int RSA_padding_add_PKCS1_PSS(RSA *, unsigned char *, const unsigned char *,
                              const EVP_MD *, int);
int RSA_padding_add_PKCS1_OAEP(unsigned char *, int, const unsigned char *,
                               int, const unsigned char *, int);
int RSA_padding_check_PKCS1_OAEP(unsigned char *, int, const unsigned char *,
                                 int, int, const unsigned char *, int);


void SSL_load_error_strings(void);
int SSL_library_init(void);

/*  SSL */
const char *SSL_state_string_long(const SSL *);
SSL_SESSION *SSL_get1_session(SSL *);
int SSL_set_session(SSL *, SSL_SESSION *);
int SSL_get_verify_mode(const SSL *);
void SSL_set_verify(SSL *, int, int (*)(int, X509_STORE_CTX *));
void SSL_set_verify_depth(SSL *, int);
int SSL_get_verify_depth(const SSL *);
int (*SSL_get_verify_callback(const SSL *))(int, X509_STORE_CTX *);
void SSL_set_info_callback(SSL *ssl, void (*)(const SSL *, int, int));
void (*SSL_get_info_callback(const SSL *))(const SSL *, int, int);
SSL *SSL_new(SSL_CTX *);
void SSL_free(SSL *);
int SSL_set_fd(SSL *, int);
void SSL_set_bio(SSL *, BIO *, BIO *);
void SSL_set_connect_state(SSL *);
void SSL_set_accept_state(SSL *);
void SSL_set_shutdown(SSL *, int);
int SSL_get_shutdown(const SSL *);
int SSL_pending(const SSL *);
int SSL_write(SSL *, const void *, int);
int SSL_read(SSL *, void *, int);
X509 *SSL_get_peer_certificate(const SSL *);
int SSL_get_ex_data_X509_STORE_CTX_idx(void);

Cryptography_STACK_OF_X509 *SSL_get_peer_cert_chain(const SSL *);
Cryptography_STACK_OF_X509_NAME *SSL_get_client_CA_list(const SSL *);

int SSL_get_error(const SSL *, int);
int SSL_do_handshake(SSL *);
int SSL_shutdown(SSL *);
const char *SSL_get_cipher_list(const SSL *, int);
Cryptography_STACK_OF_SSL_CIPHER *SSL_get_ciphers(const SSL *);

/*  context */
void SSL_CTX_free(SSL_CTX *);
long SSL_CTX_set_timeout(SSL_CTX *, long);
int SSL_CTX_set_default_verify_paths(SSL_CTX *);
void SSL_CTX_set_verify(SSL_CTX *, int, int (*)(int, X509_STORE_CTX *));
void SSL_CTX_set_verify_depth(SSL_CTX *, int);
int (*SSL_CTX_get_verify_callback(const SSL_CTX *))(int, X509_STORE_CTX *);
int SSL_CTX_get_verify_mode(const SSL_CTX *);
int SSL_CTX_get_verify_depth(const SSL_CTX *);
int SSL_CTX_set_cipher_list(SSL_CTX *, const char *);
int SSL_CTX_load_verify_locations(SSL_CTX *, const char *, const char *);
void SSL_CTX_set_default_passwd_cb(SSL_CTX *, pem_password_cb *);
void SSL_CTX_set_default_passwd_cb_userdata(SSL_CTX *, void *);
int SSL_CTX_use_certificate(SSL_CTX *, X509 *);
int SSL_CTX_use_certificate_file(SSL_CTX *, const char *, int);
int SSL_CTX_use_certificate_chain_file(SSL_CTX *, const char *);
int SSL_CTX_use_PrivateKey(SSL_CTX *, EVP_PKEY *);
int SSL_CTX_use_PrivateKey_file(SSL_CTX *, const char *, int);
int SSL_CTX_check_private_key(const SSL_CTX *);
void SSL_CTX_set_cert_verify_callback(SSL_CTX *,
                                      int (*)(X509_STORE_CTX *,void *),
                                      void *);

void SSL_CTX_set_cert_store(SSL_CTX *, X509_STORE *);
X509_STORE *SSL_CTX_get_cert_store(const SSL_CTX *);
int SSL_CTX_add_client_CA(SSL_CTX *, X509 *);

void SSL_CTX_set_client_CA_list(SSL_CTX *, Cryptography_STACK_OF_X509_NAME *);

/*  SSL_SESSION */
void SSL_SESSION_free(SSL_SESSION *);

/* Information about actually used cipher */
const char *SSL_CIPHER_get_name(const SSL_CIPHER *);
int SSL_CIPHER_get_bits(const SSL_CIPHER *, int *);
char *SSL_CIPHER_get_version(const SSL_CIPHER *);

size_t SSL_get_finished(const SSL *, void *, size_t);
size_t SSL_get_peer_finished(const SSL *, void *, size_t);


X509 *X509_new(void);
void X509_free(X509 *);
X509 *X509_dup(X509 *);
int X509_cmp(const X509 *, const X509 *);

int X509_print_ex(BIO *, X509 *, unsigned long, unsigned long);

int X509_set_version(X509 *, long);

EVP_PKEY *X509_get_pubkey(X509 *);
int X509_set_pubkey(X509 *, EVP_PKEY *);

unsigned char *X509_alias_get0(X509 *, int *);
int X509_sign(X509 *, EVP_PKEY *, const EVP_MD *);

int X509_digest(const X509 *, const EVP_MD *, unsigned char *, unsigned int *);

ASN1_TIME *X509_gmtime_adj(ASN1_TIME *, long);

unsigned long X509_subject_name_hash(X509 *);

X509_NAME *X509_get_subject_name(X509 *);
int X509_set_subject_name(X509 *, X509_NAME *);

X509_NAME *X509_get_issuer_name(X509 *);
int X509_set_issuer_name(X509 *, X509_NAME *);

int X509_get_ext_count(X509 *);
int X509_add_ext(X509 *, X509_EXTENSION *, int);
X509_EXTENSION *X509_delete_ext(X509 *, int);
X509_EXTENSION *X509_EXTENSION_dup(X509_EXTENSION *);
X509_EXTENSION *X509_get_ext(X509 *, int);
int X509_get_ext_by_NID(X509 *, int, int);
int X509_EXTENSION_get_critical(X509_EXTENSION *);
ASN1_OBJECT *X509_EXTENSION_get_object(X509_EXTENSION *);
void X509_EXTENSION_free(X509_EXTENSION *);

int i2d_X509(X509 *, unsigned char **);

int X509_REQ_set_version(X509_REQ *, long);
X509_REQ *X509_REQ_new(void);
void X509_REQ_free(X509_REQ *);
int X509_REQ_set_pubkey(X509_REQ *, EVP_PKEY *);
int X509_REQ_sign(X509_REQ *, EVP_PKEY *, const EVP_MD *);
int X509_REQ_verify(X509_REQ *, EVP_PKEY *);
int X509_REQ_digest(const X509_REQ *, const EVP_MD *,
                    unsigned char *, unsigned int *);
EVP_PKEY *X509_REQ_get_pubkey(X509_REQ *);
int X509_REQ_print_ex(BIO *, X509_REQ *, unsigned long, unsigned long);

int X509V3_EXT_print(BIO *, X509_EXTENSION *, unsigned long, int);
ASN1_OCTET_STRING *X509_EXTENSION_get_data(X509_EXTENSION *);

X509_REVOKED *X509_REVOKED_new(void);
void X509_REVOKED_free(X509_REVOKED *);

int X509_REVOKED_set_serialNumber(X509_REVOKED *, ASN1_INTEGER *);

int X509_REVOKED_get_ext_count(X509_REVOKED *);
X509_EXTENSION *X509_REVOKED_get_ext(X509_REVOKED *, int);
int X509_REVOKED_add_ext(X509_REVOKED *, X509_EXTENSION*, int);
int X509_REVOKED_add1_ext_i2d(X509_REVOKED *, int, void *, int, unsigned long);

X509_CRL *d2i_X509_CRL_bio(BIO *, X509_CRL **);
X509_CRL *X509_CRL_new(void);
void X509_CRL_free(X509_CRL *);
int X509_CRL_add0_revoked(X509_CRL *, X509_REVOKED *);
int i2d_X509_CRL_bio(BIO *, X509_CRL *);
int X509_CRL_print(BIO *, X509_CRL *);
int X509_CRL_set_issuer_name(X509_CRL *, X509_NAME *);
int X509_CRL_sign(X509_CRL *, EVP_PKEY *, const EVP_MD *);
int X509_CRL_verify(X509_CRL *, EVP_PKEY *);
int X509_CRL_get_ext_count(X509_CRL *);
X509_EXTENSION *X509_CRL_get_ext(X509_CRL *, int);
int X509_CRL_add_ext(X509_CRL *, X509_EXTENSION *, int);

int NETSCAPE_SPKI_verify(NETSCAPE_SPKI *, EVP_PKEY *);
int NETSCAPE_SPKI_sign(NETSCAPE_SPKI *, EVP_PKEY *, const EVP_MD *);
char *NETSCAPE_SPKI_b64_encode(NETSCAPE_SPKI *);
NETSCAPE_SPKI *NETSCAPE_SPKI_b64_decode(const char *, int);
EVP_PKEY *NETSCAPE_SPKI_get_pubkey(NETSCAPE_SPKI *);
int NETSCAPE_SPKI_set_pubkey(NETSCAPE_SPKI *, EVP_PKEY *);
NETSCAPE_SPKI *NETSCAPE_SPKI_new(void);
void NETSCAPE_SPKI_free(NETSCAPE_SPKI *);

/*  ASN1 serialization */
int i2d_X509_bio(BIO *, X509 *);
X509 *d2i_X509_bio(BIO *, X509 **);

int i2d_X509_REQ_bio(BIO *, X509_REQ *);
X509_REQ *d2i_X509_REQ_bio(BIO *, X509_REQ **);

int i2d_PrivateKey_bio(BIO *, EVP_PKEY *);
EVP_PKEY *d2i_PrivateKey_bio(BIO *, EVP_PKEY **);
int i2d_PUBKEY_bio(BIO *, EVP_PKEY *);
EVP_PKEY *d2i_PUBKEY_bio(BIO *, EVP_PKEY **);

ASN1_INTEGER *X509_get_serialNumber(X509 *);
int X509_set_serialNumber(X509 *, ASN1_INTEGER *);

const char *X509_verify_cert_error_string(long);

const char *X509_get_default_cert_area(void);
const char *X509_get_default_cert_dir(void);
const char *X509_get_default_cert_file(void);
const char *X509_get_default_cert_dir_env(void);
const char *X509_get_default_cert_file_env(void);
const char *X509_get_default_private_dir(void);

int i2d_RSA_PUBKEY(RSA *, unsigned char **);
RSA *d2i_RSA_PUBKEY(RSA **, const unsigned char **, long);
RSA *d2i_RSAPublicKey(RSA **, const unsigned char **, long);
RSA *d2i_RSAPrivateKey(RSA **, const unsigned char **, long);
int i2d_DSA_PUBKEY(DSA *, unsigned char **);
DSA *d2i_DSA_PUBKEY(DSA **, const unsigned char **, long);
DSA *d2i_DSAPublicKey(DSA **, const unsigned char **, long);
DSA *d2i_DSAPrivateKey(DSA **, const unsigned char **, long);

RSA *d2i_RSAPrivateKey_bio(BIO *, RSA **);
int i2d_RSAPrivateKey_bio(BIO *, RSA *);
RSA *d2i_RSAPublicKey_bio(BIO *, RSA **);
int i2d_RSAPublicKey_bio(BIO *, RSA *);
RSA *d2i_RSA_PUBKEY_bio(BIO *, RSA **);
int i2d_RSA_PUBKEY_bio(BIO *, RSA *);
DSA *d2i_DSA_PUBKEY_bio(BIO *, DSA **);
int i2d_DSA_PUBKEY_bio(BIO *, DSA *);
DSA *d2i_DSAPrivateKey_bio(BIO *, DSA **);
int i2d_DSAPrivateKey_bio(BIO *, DSA *);

PKCS8_PRIV_KEY_INFO *d2i_PKCS8_PRIV_KEY_INFO_bio(BIO *,
                                                 PKCS8_PRIV_KEY_INFO **);
void PKCS8_PRIV_KEY_INFO_free(PKCS8_PRIV_KEY_INFO *);


X509_NAME *X509_NAME_new(void);
void X509_NAME_free(X509_NAME *);

int X509_NAME_entry_count(X509_NAME *);
X509_NAME_ENTRY *X509_NAME_get_entry(X509_NAME *, int);
ASN1_OBJECT *X509_NAME_ENTRY_get_object(X509_NAME_ENTRY *);
ASN1_STRING *X509_NAME_ENTRY_get_data(X509_NAME_ENTRY *);
unsigned long X509_NAME_hash(X509_NAME *);

int i2d_X509_NAME(X509_NAME *, unsigned char **);
int X509_NAME_add_entry_by_txt(X509_NAME *, const char *, int,
                               const unsigned char *, int, int, int);
int X509_NAME_add_entry_by_NID(X509_NAME *, int, int, unsigned char *,
                               int, int, int);
X509_NAME_ENTRY *X509_NAME_delete_entry(X509_NAME *, int);
void X509_NAME_ENTRY_free(X509_NAME_ENTRY *);
int X509_NAME_get_index_by_NID(X509_NAME *, int, int);
int X509_NAME_cmp(const X509_NAME *, const X509_NAME *);
char *X509_NAME_oneline(X509_NAME *, char *, int);
X509_NAME *X509_NAME_dup(X509_NAME *);


int X509V3_EXT_add_alias(int, int);
void X509V3_set_ctx(X509V3_CTX *, X509 *, X509 *, X509_REQ *, X509_CRL *, int);
X509_EXTENSION *X509V3_EXT_nconf(CONF *, X509V3_CTX *, char *, char *);
int GENERAL_NAME_print(BIO *, GENERAL_NAME *);
void GENERAL_NAMES_free(GENERAL_NAMES *);
void *X509V3_EXT_d2i(X509_EXTENSION *);


int X509_verify_cert(X509_STORE_CTX *);

/* X509_STORE */
X509_STORE *X509_STORE_new(void);
void X509_STORE_free(X509_STORE *);
int X509_STORE_add_cert(X509_STORE *, X509 *);
int X509_STORE_load_locations(X509_STORE *, const char *, const char *);
int X509_STORE_set_default_paths(X509_STORE *);

/* X509_STORE_CTX */
X509_STORE_CTX *X509_STORE_CTX_new(void);
void X509_STORE_CTX_cleanup(X509_STORE_CTX *);
void X509_STORE_CTX_free(X509_STORE_CTX *);
int X509_STORE_CTX_init(X509_STORE_CTX *, X509_STORE *, X509 *,
                        Cryptography_STACK_OF_X509 *);
void X509_STORE_CTX_trusted_stack(X509_STORE_CTX *,
                                  Cryptography_STACK_OF_X509 *);
void X509_STORE_CTX_set_cert(X509_STORE_CTX *, X509 *);
void X509_STORE_CTX_set_chain(X509_STORE_CTX *,Cryptography_STACK_OF_X509 *);
X509_VERIFY_PARAM *X509_STORE_CTX_get0_param(X509_STORE_CTX *);
void X509_STORE_CTX_set0_param(X509_STORE_CTX *, X509_VERIFY_PARAM *);
int X509_STORE_CTX_set_default(X509_STORE_CTX *, const char *);
void X509_STORE_CTX_set_verify_cb(X509_STORE_CTX *,
                                  int (*)(int, X509_STORE_CTX *));
Cryptography_STACK_OF_X509 *X509_STORE_CTX_get_chain(X509_STORE_CTX *);
Cryptography_STACK_OF_X509 *X509_STORE_CTX_get1_chain(X509_STORE_CTX *);
int X509_STORE_CTX_get_error(X509_STORE_CTX *);
void X509_STORE_CTX_set_error(X509_STORE_CTX *, int);
int X509_STORE_CTX_get_error_depth(X509_STORE_CTX *);
X509 *X509_STORE_CTX_get_current_cert(X509_STORE_CTX *);
int X509_STORE_CTX_set_ex_data(X509_STORE_CTX *, int, void *);
void *X509_STORE_CTX_get_ex_data(X509_STORE_CTX *, int);

/* X509_VERIFY_PARAM */
X509_VERIFY_PARAM *X509_VERIFY_PARAM_new(void);
int X509_VERIFY_PARAM_set_flags(X509_VERIFY_PARAM *, unsigned long);
int X509_VERIFY_PARAM_clear_flags(X509_VERIFY_PARAM *, unsigned long);
unsigned long X509_VERIFY_PARAM_get_flags(X509_VERIFY_PARAM *);
int X509_VERIFY_PARAM_set_purpose(X509_VERIFY_PARAM *, int);
int X509_VERIFY_PARAM_set_trust(X509_VERIFY_PARAM *, int);
void X509_VERIFY_PARAM_set_time(X509_VERIFY_PARAM *, time_t);
int X509_VERIFY_PARAM_add0_policy(X509_VERIFY_PARAM *, ASN1_OBJECT *);
int X509_VERIFY_PARAM_set1_policies(X509_VERIFY_PARAM *,
                                    Cryptography_STACK_OF_ASN1_OBJECT *);
void X509_VERIFY_PARAM_set_depth(X509_VERIFY_PARAM *, int);
int X509_VERIFY_PARAM_get_depth(const X509_VERIFY_PARAM *);


/* OpenSSL 0.9.8h+ */
#if OPENSSL_VERSION_NUMBER >= 0x0090808fL
static const long Cryptography_HAS_AES_WRAP = 1;
#else
static const long Cryptography_HAS_AES_WRAP = 0;
int (*AES_wrap_key)(AES_KEY *, const unsigned char *, unsigned char *,
                    const unsigned char *, unsigned int) = NULL;
int (*AES_unwrap_key)(AES_KEY *, const unsigned char *, unsigned char *,
                      const unsigned char *, unsigned int) = NULL;
#endif









#if OPENSSL_VERSION_NUMBER < 0x10001000L

static const long Cryptography_HAS_CMAC = 0;
typedef void CMAC_CTX;
CMAC_CTX *(*CMAC_CTX_new)(void) = NULL;
int (*CMAC_Init)(CMAC_CTX *, const void *, size_t, const EVP_CIPHER *,
    ENGINE *) = NULL;
int (*CMAC_Update)(CMAC_CTX *, const void *, size_t) = NULL;
int (*CMAC_Final)(CMAC_CTX *, unsigned char *, size_t *) = NULL;
int (*CMAC_CTX_copy)(CMAC_CTX *, const CMAC_CTX *) = NULL;
void (*CMAC_CTX_free)(CMAC_CTX *) = NULL;
#else
static const long Cryptography_HAS_CMAC = 1;
#endif


#if !defined(OPENSSL_NO_CMS) && OPENSSL_VERSION_NUMBER >= 0x0090808fL
static const long Cryptography_HAS_CMS = 1;
#else
static const long Cryptography_HAS_CMS = 0;
typedef void CMS_ContentInfo;
typedef void CMS_SignerInfo;
typedef void CMS_CertificateChoices;
typedef void CMS_RevocationInfoChoice;
typedef void CMS_RecipientInfo;
typedef void CMS_ReceiptRequest;
typedef void CMS_Receipt;
const long CMS_TEXT = 0;
const long CMS_NOCERTS = 0;
const long CMS_NO_CONTENT_VERIFY = 0;
const long CMS_NO_ATTR_VERIFY = 0;
const long CMS_NOSIGS = 0;
const long CMS_NOINTERN = 0;
const long CMS_NO_SIGNER_CERT_VERIFY = 0;
const long CMS_NOVERIFY = 0;
const long CMS_DETACHED = 0;
const long CMS_BINARY = 0;
const long CMS_NOATTR = 0;
const long CMS_NOSMIMECAP = 0;
const long CMS_NOOLDMIMETYPE = 0;
const long CMS_CRLFEOL = 0;
const long CMS_STREAM = 0;
const long CMS_NOCRL = 0;
const long CMS_PARTIAL = 0;
const long CMS_REUSE_DIGEST = 0;
const long CMS_USE_KEYID = 0;
const long CMS_DEBUG_DECRYPT = 0;
BIO *(*BIO_new_CMS)(BIO *, CMS_ContentInfo *) = NULL;
int (*i2d_CMS_bio_stream)(BIO *, CMS_ContentInfo *, BIO *, int) = NULL;
int (*PEM_write_bio_CMS_stream)(BIO *, CMS_ContentInfo *, BIO *, int) = NULL;
int (*CMS_final)(CMS_ContentInfo *, BIO *, BIO *, unsigned int) = NULL;
CMS_ContentInfo *(*CMS_sign)(X509 *, EVP_PKEY *, Cryptography_STACK_OF_X509 *,
                             BIO *, unsigned int) = NULL;
int (*CMS_verify)(CMS_ContentInfo *, Cryptography_STACK_OF_X509 *,
                  X509_STORE *, BIO *, BIO *, unsigned int) = NULL;
CMS_ContentInfo *(*CMS_encrypt)(Cryptography_STACK_OF_X509 *, BIO *,
                                const EVP_CIPHER *, unsigned int) = NULL;
int (*CMS_decrypt)(CMS_ContentInfo *, EVP_PKEY *, X509 *, BIO *, BIO *,
                   unsigned int) = NULL;
CMS_SignerInfo *(*CMS_add1_signer)(CMS_ContentInfo *, X509 *, EVP_PKEY *,
                                   const EVP_MD *, unsigned int) = NULL;
#endif










#ifdef OPENSSL_NO_EC
static const long Cryptography_HAS_EC = 0;

typedef void EC_KEY;
typedef void EC_GROUP;
typedef void EC_POINT;
typedef void EC_METHOD;
typedef struct {
    int nid;
    const char *comment;
} EC_builtin_curve;
typedef long point_conversion_form_t;

static const int OPENSSL_EC_NAMED_CURVE = 0;

void (*EC_KEY_free)(EC_KEY *) = NULL;
size_t (*EC_get_builtin_curves)(EC_builtin_curve *, size_t) = NULL;
EC_KEY *(*EC_KEY_new_by_curve_name)(int) = NULL;
EC_KEY *(*EC_KEY_copy)(EC_KEY *, const EC_KEY *) = NULL;
EC_KEY *(*EC_KEY_dup)(const EC_KEY *) = NULL;
int (*EC_KEY_up_ref)(EC_KEY *) = NULL;
const EC_GROUP *(*EC_KEY_get0_group)(const EC_KEY *) = NULL;
int (*EC_GROUP_get_order)(const EC_GROUP *, BIGNUM *, BN_CTX *) = NULL;
int (*EC_KEY_set_group)(EC_KEY *, const EC_GROUP *) = NULL;
const BIGNUM *(*EC_KEY_get0_private_key)(const EC_KEY *) = NULL;
int (*EC_KEY_set_private_key)(EC_KEY *, const BIGNUM *) = NULL;
const EC_POINT *(*EC_KEY_get0_public_key)(const EC_KEY *) = NULL;
int (*EC_KEY_set_public_key)(EC_KEY *, const EC_POINT *) = NULL;
unsigned int (*EC_KEY_get_enc_flags)(const EC_KEY *) = NULL;
void (*EC_KEY_set_enc_flags)(EC_KEY *eckey, unsigned int) = NULL;
point_conversion_form_t (*EC_KEY_get_conv_form)(const EC_KEY *) = NULL;
void (*EC_KEY_set_conv_form)(EC_KEY *, point_conversion_form_t) = NULL;
void *(*EC_KEY_get_key_method_data)(
    EC_KEY *, void *(*)(void *), void (*)(void *), void (*)(void *)) = NULL;
void (*EC_KEY_insert_key_method_data)(
    EC_KEY *, void *,
    void *(*)(void *), void (*)(void *), void (*)(void *)) = NULL;
void (*EC_KEY_set_asn1_flag)(EC_KEY *, int) = NULL;
int (*EC_KEY_precompute_mult)(EC_KEY *, BN_CTX *) = NULL;
int (*EC_KEY_generate_key)(EC_KEY *) = NULL;
int (*EC_KEY_check_key)(const EC_KEY *) = NULL;

EC_GROUP *(*EC_GROUP_new)(const EC_METHOD *);
void (*EC_GROUP_free)(EC_GROUP *);
void (*EC_GROUP_clear_free)(EC_GROUP *);

EC_GROUP *(*EC_GROUP_new_curve_GFp)(
    const BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *);

EC_GROUP *(*EC_GROUP_new_by_curve_name)(int);

int (*EC_GROUP_set_curve_GFp)(
    EC_GROUP *, const BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *);

int (*EC_GROUP_get_curve_GFp)(
    const EC_GROUP *, BIGNUM *, BIGNUM *, BIGNUM *, BN_CTX *);

int (*EC_GROUP_get_degree)(const EC_GROUP *) = NULL;

const EC_METHOD *(*EC_GROUP_method_of)(const EC_GROUP *) = NULL;
const EC_POINT *(*EC_GROUP_get0_generator)(const EC_GROUP *) = NULL;
int (*EC_GROUP_get_curve_name)(const EC_GROUP *) = NULL;

EC_POINT *(*EC_POINT_new)(const EC_GROUP *) = NULL;
void (*EC_POINT_free)(EC_POINT *) = NULL;
void (*EC_POINT_clear_free)(EC_POINT *) = NULL;
int (*EC_POINT_copy)(EC_POINT *, const EC_POINT *) = NULL;
EC_POINT *(*EC_POINT_dup)(const EC_POINT *, const EC_GROUP *) = NULL;
const EC_METHOD *(*EC_POINT_method_of)(const EC_POINT *) = NULL;
int (*EC_POINT_set_to_infinity)(const EC_GROUP *, EC_POINT *) = NULL;
int (*EC_POINT_set_Jprojective_coordinates_GFp)(const EC_GROUP *, EC_POINT *,
    const BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *) = NULL;

int (*EC_POINT_get_Jprojective_coordinates_GFp)(const EC_GROUP *,
    const EC_POINT *, BIGNUM *, BIGNUM *, BIGNUM *, BN_CTX *) = NULL;

int (*EC_POINT_set_affine_coordinates_GFp)(const EC_GROUP *, EC_POINT *,
    const BIGNUM *, const BIGNUM *, BN_CTX *) = NULL;

int (*EC_POINT_get_affine_coordinates_GFp)(const EC_GROUP *,
    const EC_POINT *, BIGNUM *, BIGNUM *, BN_CTX *) = NULL;

int (*EC_POINT_set_compressed_coordinates_GFp)(const EC_GROUP *, EC_POINT *,
    const BIGNUM *, int, BN_CTX *) = NULL;

size_t (*EC_POINT_point2oct)(const EC_GROUP *, const EC_POINT *,
    point_conversion_form_t,
    unsigned char *, size_t, BN_CTX *) = NULL;

int (*EC_POINT_oct2point)(const EC_GROUP *, EC_POINT *,
    const unsigned char *, size_t, BN_CTX *) = NULL;

BIGNUM *(*EC_POINT_point2bn)(const EC_GROUP *, const EC_POINT *,
    point_conversion_form_t form, BIGNUM *, BN_CTX *) = NULL;

EC_POINT *(*EC_POINT_bn2point)(const EC_GROUP *, const BIGNUM *,
    EC_POINT *, BN_CTX *) = NULL;

char *(*EC_POINT_point2hex)(const EC_GROUP *, const EC_POINT *,
    point_conversion_form_t form, BN_CTX *) = NULL;

EC_POINT *(*EC_POINT_hex2point)(const EC_GROUP *, const char *,
    EC_POINT *, BN_CTX *) = NULL;

int (*EC_POINT_add)(const EC_GROUP *, EC_POINT *, const EC_POINT *,
    const EC_POINT *, BN_CTX *) = NULL;

int (*EC_POINT_dbl)(const EC_GROUP *, EC_POINT *, const EC_POINT *,
    BN_CTX *) = NULL;

int (*EC_POINT_invert)(const EC_GROUP *, EC_POINT *, BN_CTX *) = NULL;
int (*EC_POINT_is_at_infinity)(const EC_GROUP *, const EC_POINT *) = NULL;

int (*EC_POINT_is_on_curve)(const EC_GROUP *, const EC_POINT *,
    BN_CTX *) = NULL;

int (*EC_POINT_cmp)(
    const EC_GROUP *, const EC_POINT *, const EC_POINT *, BN_CTX *) = NULL;

int (*EC_POINT_make_affine)(const EC_GROUP *, EC_POINT *, BN_CTX *) = NULL;

int (*EC_POINTs_make_affine)(const EC_GROUP *, size_t, EC_POINT *[],
    BN_CTX *) = NULL;

int (*EC_POINTs_mul)(
    const EC_GROUP *, EC_POINT *, const BIGNUM *,
    size_t, const EC_POINT *[], const BIGNUM *[], BN_CTX *) = NULL;

int (*EC_POINT_mul)(const EC_GROUP *, EC_POINT *, const BIGNUM *,
    const EC_POINT *, const BIGNUM *, BN_CTX *) = NULL;

int (*EC_GROUP_precompute_mult)(EC_GROUP *, BN_CTX *) = NULL;
int (*EC_GROUP_have_precompute_mult)(const EC_GROUP *) = NULL;

const EC_METHOD *(*EC_GFp_simple_method)() = NULL;
const EC_METHOD *(*EC_GFp_mont_method)() = NULL;
const EC_METHOD *(*EC_GFp_nist_method)() = NULL;

int (*EC_METHOD_get_field_type)(const EC_METHOD *) = NULL;

#else
static const long Cryptography_HAS_EC = 1;
#endif

#if defined(OPENSSL_NO_EC) || OPENSSL_VERSION_NUMBER < 0x1000100f
static const long Cryptography_HAS_EC_1_0_1 = 0;

int (*EC_KEY_get_flags)(const EC_KEY *) = NULL;
void (*EC_KEY_set_flags)(EC_KEY *, int) = NULL;
void (*EC_KEY_clear_flags)(EC_KEY *, int) = NULL;

int (*EC_KEY_set_public_key_affine_coordinates)(
    EC_KEY *, BIGNUM *, BIGNUM *) = NULL;
#else
static const long Cryptography_HAS_EC_1_0_1 = 1;
#endif


#if defined(OPENSSL_NO_EC) || OPENSSL_VERSION_NUMBER < 0x1000100f ||     defined(OPENSSL_NO_EC_NISTP_64_GCC_128)
static const long Cryptography_HAS_EC_NISTP_64_GCC_128 = 0;

const EC_METHOD *(*EC_GFp_nistp224_method)(void) = NULL;
const EC_METHOD *(*EC_GFp_nistp256_method)(void) = NULL;
const EC_METHOD *(*EC_GFp_nistp521_method)(void) = NULL;
#else
static const long Cryptography_HAS_EC_NISTP_64_GCC_128 = 1;
#endif

#if defined(OPENSSL_NO_EC) || defined(OPENSSL_NO_EC2M)
static const long Cryptography_HAS_EC2M = 0;

const EC_METHOD *(*EC_GF2m_simple_method)() = NULL;

int (*EC_POINT_set_affine_coordinates_GF2m)(const EC_GROUP *, EC_POINT *,
    const BIGNUM *, const BIGNUM *, BN_CTX *) = NULL;

int (*EC_POINT_get_affine_coordinates_GF2m)(const EC_GROUP *,
    const EC_POINT *, BIGNUM *, BIGNUM *, BN_CTX *) = NULL;

int (*EC_POINT_set_compressed_coordinates_GF2m)(const EC_GROUP *, EC_POINT *,
    const BIGNUM *, int, BN_CTX *) = NULL;

int (*EC_GROUP_set_curve_GF2m)(
    EC_GROUP *, const BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *);

int (*EC_GROUP_get_curve_GF2m)(
    const EC_GROUP *, BIGNUM *, BIGNUM *, BIGNUM *, BN_CTX *);

EC_GROUP *(*EC_GROUP_new_curve_GF2m)(
    const BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *);
#else
static const long Cryptography_HAS_EC2M = 1;
#endif

#if defined(OPENSSL_NO_EC) || OPENSSL_VERSION_NUMBER < 0x1000200f
static const long Cryptography_HAS_EC_1_0_2 = 0;
const char *(*EC_curve_nid2nist)(int) = NULL;
#else
static const long Cryptography_HAS_EC_1_0_2 = 1;
#endif


#ifdef OPENSSL_NO_ECDH
static const long Cryptography_HAS_ECDH = 0;

int (*ECDH_compute_key)(void *, size_t, const EC_POINT *, EC_KEY *,
                        void *(*)(const void *, size_t, void *,
                        size_t *)) = NULL;

int (*ECDH_get_ex_new_index)(long, void *, CRYPTO_EX_new *, CRYPTO_EX_dup *,
                             CRYPTO_EX_free *) = NULL;

int (*ECDH_set_ex_data)(EC_KEY *, int, void *) = NULL;

void *(*ECDH_get_ex_data)(EC_KEY *, int) = NULL;

#else
static const long Cryptography_HAS_ECDH = 1;
#endif


#ifdef OPENSSL_NO_ECDSA
static const long Cryptography_HAS_ECDSA = 0;

typedef struct {
    BIGNUM *r;
    BIGNUM *s;
} ECDSA_SIG;

ECDSA_SIG* (*ECDSA_SIG_new)() = NULL;
void (*ECDSA_SIG_free)(ECDSA_SIG *) = NULL;
int (*i2d_ECDSA_SIG)(const ECDSA_SIG *, unsigned char **) = NULL;
ECDSA_SIG* (*d2i_ECDSA_SIG)(ECDSA_SIG **s, const unsigned char **,
                            long) = NULL;
ECDSA_SIG* (*ECDSA_do_sign)(const unsigned char *, int, EC_KEY *eckey) = NULL;
ECDSA_SIG* (*ECDSA_do_sign_ex)(const unsigned char *, int, const BIGNUM *,
                               const BIGNUM *, EC_KEY *) = NULL;
int (*ECDSA_do_verify)(const unsigned char *, int, const ECDSA_SIG *,
                       EC_KEY *) = NULL;
int (*ECDSA_sign_setup)(EC_KEY *, BN_CTX *, BIGNUM **, BIGNUM **) = NULL;
int (*ECDSA_sign)(int, const unsigned char *, int, unsigned char *,
                  unsigned int *, EC_KEY *) = NULL;
int (*ECDSA_sign_ex)(int, const unsigned char *, int dgstlen, unsigned char *,
                     unsigned int *, const BIGNUM *, const BIGNUM *,
                     EC_KEY *) = NULL;
int (*ECDSA_verify)(int, const unsigned char *, int, const unsigned char *,
                    int, EC_KEY *) = NULL;
int (*ECDSA_size)(const EC_KEY *) = NULL;

const ECDSA_METHOD* (*ECDSA_OpenSSL)() = NULL;
void (*ECDSA_set_default_method)(const ECDSA_METHOD *) = NULL;
const ECDSA_METHOD* (*ECDSA_get_default_method)() = NULL;
int (*ECDSA_set_method)(EC_KEY *, const ECDSA_METHOD *) = NULL;
int (*ECDSA_get_ex_new_index)(long, void *, CRYPTO_EX_new *,
                              CRYPTO_EX_dup *, CRYPTO_EX_free *) = NULL;
int (*ECDSA_set_ex_data)(EC_KEY *, int, void *) = NULL;
void* (*ECDSA_get_ex_data)(EC_KEY *, int) = NULL;
#else
static const long Cryptography_HAS_ECDSA = 1;
#endif


#if defined(LIBRESSL_VERSION_NUMBER)
static const long Cryptography_HAS_ENGINE_CRYPTODEV = 0;
void (*ENGINE_load_cryptodev)(void) = NULL;
#else
static const long Cryptography_HAS_ENGINE_CRYPTODEV = 1;
#endif


#if OPENSSL_VERSION_NUMBER >= 0x10000000L
static const long Cryptography_HAS_REMOVE_THREAD_STATE = 1;
#else
static const long Cryptography_HAS_REMOVE_THREAD_STATE = 0;
typedef uint32_t CRYPTO_THREADID;
void (*ERR_remove_thread_state)(const CRYPTO_THREADID *) = NULL;
#endif

/* OpenSSL 0.9.8h+ */
#if OPENSSL_VERSION_NUMBER >= 0x0090808fL
static const long Cryptography_HAS_098H_ERROR_CODES = 1;
#else
static const long Cryptography_HAS_098H_ERROR_CODES = 0;
static const int ASN1_F_B64_READ_ASN1 = 0;
static const int ASN1_F_B64_WRITE_ASN1 = 0;
static const int ASN1_F_SMIME_READ_ASN1 = 0;
static const int ASN1_F_SMIME_TEXT = 0;
static const int ASN1_R_NO_CONTENT_TYPE = 0;
static const int ASN1_R_NO_MULTIPART_BODY_FAILURE = 0;
static const int ASN1_R_NO_MULTIPART_BOUNDARY = 0;
#endif

/* OpenSSL 0.9.8c+ */
#ifdef EVP_F_CAMELLIA_INIT_KEY
static const long Cryptography_HAS_098C_CAMELLIA_CODES = 1;
#else
static const long Cryptography_HAS_098C_CAMELLIA_CODES = 0;
static const int EVP_F_CAMELLIA_INIT_KEY = 0;
static const int EVP_R_CAMELLIA_KEY_SETUP_FAILED = 0;
#endif

// OpenSSL without EC. e.g. RHEL
#ifndef OPENSSL_NO_EC
static const long Cryptography_HAS_EC_CODES = 1;
#else
static const long Cryptography_HAS_EC_CODES = 0;
static const int EC_R_UNKNOWN_GROUP = 0;
static const int EC_F_EC_GROUP_NEW_BY_CURVE_NAME = 0;
#endif

#ifdef RSA_R_PKCS_DECODING_ERROR
static const long Cryptography_HAS_RSA_R_PKCS_DECODING_ERROR = 1;
#else
static const long Cryptography_HAS_RSA_R_PKCS_DECODING_ERROR = 0;
static const long RSA_R_PKCS_DECODING_ERROR = 0;
#endif


#ifdef EVP_CTRL_GCM_SET_TAG
const long Cryptography_HAS_GCM = 1;
#else
const long Cryptography_HAS_GCM = 0;
const long EVP_CTRL_GCM_GET_TAG = -1;
const long EVP_CTRL_GCM_SET_TAG = -1;
const long EVP_CTRL_GCM_SET_IVLEN = -1;
#endif
#if OPENSSL_VERSION_NUMBER >= 0x10000000L
const long Cryptography_HAS_PBKDF2_HMAC = 1;
const long Cryptography_HAS_PKEY_CTX = 1;

/* OpenSSL 0.9.8 defines EVP_PKEY_encrypt and EVP_PKEY_decrypt functions,
   but they are a completely different signature from the ones in 1.0.0+.
   These wrapper functions allows us to safely declare them on any version and
   conditionally remove them on 0.9.8. */
int Cryptography_EVP_PKEY_encrypt(EVP_PKEY_CTX *ctx, unsigned char *out,
                                  size_t *outlen, const unsigned char *in,
                                  size_t inlen) {
    return EVP_PKEY_encrypt(ctx, out, outlen, in, inlen);
}
int Cryptography_EVP_PKEY_decrypt(EVP_PKEY_CTX *ctx, unsigned char *out,
                                  size_t *outlen, const unsigned char *in,
                                  size_t inlen) {
    return EVP_PKEY_decrypt(ctx, out, outlen, in, inlen);
}
#else
const long Cryptography_HAS_PBKDF2_HMAC = 0;
int (*PKCS5_PBKDF2_HMAC)(const char *, int, const unsigned char *, int, int,
                         const EVP_MD *, int, unsigned char *) = NULL;
const long Cryptography_HAS_PKEY_CTX = 0;
typedef void EVP_PKEY_CTX;
int (*EVP_PKEY_CTX_set_signature_md)(EVP_PKEY_CTX *, const EVP_MD *) = NULL;
int (*EVP_PKEY_sign_init)(EVP_PKEY_CTX *) = NULL;
int (*EVP_PKEY_sign)(EVP_PKEY_CTX *, unsigned char *, size_t *,
                     const unsigned char *, size_t) = NULL;
int (*EVP_PKEY_verify_init)(EVP_PKEY_CTX *) = NULL;
int (*EVP_PKEY_verify)(EVP_PKEY_CTX *, const unsigned char *, size_t,
                       const unsigned char *, size_t) = NULL;
EVP_PKEY_CTX *(*EVP_PKEY_CTX_new)(EVP_PKEY *, ENGINE *) = NULL;
EVP_PKEY_CTX *(*EVP_PKEY_CTX_new_id)(int, ENGINE *) = NULL;
EVP_PKEY_CTX *(*EVP_PKEY_CTX_dup)(EVP_PKEY_CTX *) = NULL;
void (*EVP_PKEY_CTX_free)(EVP_PKEY_CTX *) = NULL;
int (*EVP_PKEY_encrypt_init)(EVP_PKEY_CTX *) = NULL;
int (*EVP_PKEY_decrypt_init)(EVP_PKEY_CTX *) = NULL;
int (*Cryptography_EVP_PKEY_encrypt)(EVP_PKEY_CTX *, unsigned char *, size_t *,
                                     const unsigned char *, size_t) = NULL;
int (*Cryptography_EVP_PKEY_decrypt)(EVP_PKEY_CTX *, unsigned char *, size_t *,
                                     const unsigned char *, size_t) = NULL;
int (*EVP_PKEY_id)(const EVP_PKEY *) = NULL;
#endif
#ifdef OPENSSL_NO_EC
int (*EVP_PKEY_assign_EC_KEY)(EVP_PKEY *, EC_KEY *) = NULL;
EC_KEY *(*EVP_PKEY_get1_EC_KEY)(EVP_PKEY *) = NULL;
int (*EVP_PKEY_set1_EC_KEY)(EVP_PKEY *, EC_KEY *) = NULL;
#endif


int Cryptography_HMAC_Init_ex(HMAC_CTX *ctx, const void *key, int key_len,
                              const EVP_MD *md, ENGINE *impl) {
#if OPENSSL_VERSION_NUMBER >= 0x010000000
    return HMAC_Init_ex(ctx, key, key_len, md, impl);
#else
    HMAC_Init_ex(ctx, key, key_len, md, impl);
    return 1;
#endif
}

int Cryptography_HMAC_Update(HMAC_CTX *ctx, const unsigned char *data,
                             size_t data_len) {
#if OPENSSL_VERSION_NUMBER >= 0x010000000
    return HMAC_Update(ctx, data, data_len);
#else
    HMAC_Update(ctx, data, data_len);
    return 1;
#endif
}

int Cryptography_HMAC_Final(HMAC_CTX *ctx, unsigned char *digest,
    unsigned int *outlen) {
#if OPENSSL_VERSION_NUMBER >= 0x010000000
    return HMAC_Final(ctx, digest, outlen);
#else
    HMAC_Final(ctx, digest, outlen);
    return 1;
#endif
}

int Cryptography_HMAC_CTX_copy(HMAC_CTX *dst_ctx, HMAC_CTX *src_ctx) {
#if OPENSSL_VERSION_NUMBER >= 0x010000000
    return HMAC_CTX_copy(dst_ctx, src_ctx);
#else
    HMAC_CTX_init(dst_ctx);
    if (!EVP_MD_CTX_copy_ex(&dst_ctx->i_ctx, &src_ctx->i_ctx)) {
        goto err;
    }
    if (!EVP_MD_CTX_copy_ex(&dst_ctx->o_ctx, &src_ctx->o_ctx)) {
        goto err;
    }
    if (!EVP_MD_CTX_copy_ex(&dst_ctx->md_ctx, &src_ctx->md_ctx)) {
        goto err;
    }
    memcpy(dst_ctx->key, src_ctx->key, HMAC_MAX_MD_CBLOCK);
    dst_ctx->key_length = src_ctx->key_length;
    dst_ctx->md = src_ctx->md;
    return 1;

    err:
        return 0;
#endif
}


/* OpenSSL 0.9.8g+ */
#if OPENSSL_VERSION_NUMBER >= 0x0090807fL
static const long Cryptography_HAS_ECDSA_SHA2_NIDS = 1;
#else
static const long Cryptography_HAS_ECDSA_SHA2_NIDS = 0;
static const int NID_ecdsa_with_SHA224 = 0;
static const int NID_ecdsa_with_SHA256 = 0;
static const int NID_ecdsa_with_SHA384 = 0;
static const int NID_ecdsa_with_SHA512 = 0;
#endif





static const char *Cryptography_osrandom_engine_id = "osrandom";
static const char *Cryptography_osrandom_engine_name = "osrandom_engine";

#if defined(_WIN32)
static HCRYPTPROV hCryptProv = 0;

static int osrandom_init(ENGINE *e) {
    if (hCryptProv > 0) {
        return 1;
    }
    if (CryptAcquireContext(&hCryptProv, NULL, NULL,
                            PROV_RSA_FULL, CRYPT_VERIFYCONTEXT)) {
        return 1;
    } else {
        return 0;
    }
}

static int osrandom_rand_bytes(unsigned char *buffer, int size) {
    if (hCryptProv == 0) {
        return 0;
    }

    if (!CryptGenRandom(hCryptProv, (DWORD)size, buffer)) {
        ERR_put_error(
            ERR_LIB_RAND, 0, ERR_R_RAND_LIB, "osrandom_engine.py", 0
        );
        return 0;
    }
    return 1;
}

static int osrandom_finish(ENGINE *e) {
    if (CryptReleaseContext(hCryptProv, 0)) {
        hCryptProv = 0;
        return 1;
    } else {
        return 0;
    }
}

static int osrandom_rand_status(void) {
    if (hCryptProv == 0) {
        return 0;
    } else {
        return 1;
    }
}
#else
static int urandom_fd = -1;

static int osrandom_finish(ENGINE *e);

static int osrandom_init(ENGINE *e) {
    if (urandom_fd > -1) {
        return 1;
    }
    urandom_fd = open("/dev/urandom", O_RDONLY);
    if (urandom_fd > -1) {
        int flags = fcntl(urandom_fd, F_GETFD);
        if (flags == -1) {
            osrandom_finish(e);
            return 0;
        } else if (fcntl(urandom_fd, F_SETFD, flags | FD_CLOEXEC) == -1) {
            osrandom_finish(e);
            return 0;
        }
        return 1;
    } else {
        return 0;
    }
}

static int osrandom_rand_bytes(unsigned char *buffer, int size) {
    ssize_t n;
    while (size > 0) {
        do {
            n = read(urandom_fd, buffer, (size_t)size);
        } while (n < 0 && errno == EINTR);
        if (n <= 0) {
            ERR_put_error(
                ERR_LIB_RAND, 0, ERR_R_RAND_LIB, "osrandom_engine.py", 0
            );
            return 0;
        }
        buffer += n;
        size -= n;
    }
    return 1;
}

static int osrandom_finish(ENGINE *e) {
    int n;
    do {
        n = close(urandom_fd);
    } while (n < 0 && errno == EINTR);
    urandom_fd = -1;
    if (n < 0) {
        return 0;
    } else {
        return 1;
    }
}

static int osrandom_rand_status(void) {
    if (urandom_fd == -1) {
        return 0;
    } else {
        return 1;
    }
}
#endif

/* This replicates the behavior of the OpenSSL FIPS RNG, which returns a
   -1 in the event that there is an error when calling RAND_pseudo_bytes. */
static int osrandom_pseudo_rand_bytes(unsigned char *buffer, int size) {
    int res = osrandom_rand_bytes(buffer, size);
    if (res == 0) {
        return -1;
    } else {
        return res;
    }
}

static RAND_METHOD osrandom_rand = {
    NULL,
    osrandom_rand_bytes,
    NULL,
    NULL,
    osrandom_pseudo_rand_bytes,
    osrandom_rand_status,
};

/* Returns 1 if successfully added, 2 if engine has previously been added,
   and 0 for error. */
int Cryptography_add_osrandom_engine(void) {
    ENGINE *e;
    e = ENGINE_by_id(Cryptography_osrandom_engine_id);
    if (e != NULL) {
        ENGINE_free(e);
        return 2;
    } else {
        ERR_clear_error();
    }

    e = ENGINE_new();
    if (e == NULL) {
        return 0;
    }
    if(!ENGINE_set_id(e, Cryptography_osrandom_engine_id) ||
            !ENGINE_set_name(e, Cryptography_osrandom_engine_name) ||
            !ENGINE_set_RAND(e, &osrandom_rand) ||
            !ENGINE_set_init_function(e, osrandom_init) ||
            !ENGINE_set_finish_function(e, osrandom_finish)) {
        ENGINE_free(e);
        return 0;
    }
    if (!ENGINE_add(e)) {
        ENGINE_free(e);
        return 0;
    }
    if (!ENGINE_free(e)) {
        return 0;
    }

    return 1;
}


// Cryptography_HAS_EC is provided by ec.py so we don't need to define it here
#ifdef OPENSSL_NO_EC
int (*PEM_write_bio_ECPrivateKey)(BIO *, EC_KEY *, const EVP_CIPHER *,
                                  unsigned char *, int, pem_password_cb *,
                                  void *) = NULL;
#endif






#if defined(LIBRESSL_VERSION_NUMBER)
static const long Cryptography_HAS_EGD = 0;
int (*RAND_egd)(const char *) = NULL;
int (*RAND_egd_bytes)(const char *, int) = NULL;
int (*RAND_query_egd_bytes)(const char *, unsigned char *, int) = NULL;
#else
static const long Cryptography_HAS_EGD = 1;
#endif


#if OPENSSL_VERSION_NUMBER >= 0x10000000
static const long Cryptography_HAS_PSS_PADDING = 1;
#else
/* see evp.py for the definition of Cryptography_HAS_PKEY_CTX */
static const long Cryptography_HAS_PSS_PADDING = 0;
int (*EVP_PKEY_CTX_set_rsa_padding)(EVP_PKEY_CTX *, int) = NULL;
int (*EVP_PKEY_CTX_set_rsa_pss_saltlen)(EVP_PKEY_CTX *, int) = NULL;
static const long RSA_PKCS1_PSS_PADDING = 0;
#endif
#if OPENSSL_VERSION_NUMBER >= 0x1000100f
static const long Cryptography_HAS_MGF1_MD = 1;
#else
static const long Cryptography_HAS_MGF1_MD = 0;
int (*EVP_PKEY_CTX_set_rsa_mgf1_md)(EVP_PKEY_CTX *, EVP_MD *) = NULL;
#endif


/** Secure renegotiation is supported in OpenSSL >= 0.9.8m
 *  But some Linux distributions have back ported some features.
 */
#ifndef SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION
static const long Cryptography_HAS_SECURE_RENEGOTIATION = 0;
long (*SSL_get_secure_renegotiation_support)(SSL *) = NULL;
const long SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION = 0;
const long SSL_OP_LEGACY_SERVER_CONNECT = 0;
#else
static const long Cryptography_HAS_SECURE_RENEGOTIATION = 1;
#endif
#ifdef OPENSSL_NO_SSL2
static const long Cryptography_HAS_SSL2 = 0;
SSL_METHOD* (*SSLv2_method)(void) = NULL;
SSL_METHOD* (*SSLv2_client_method)(void) = NULL;
SSL_METHOD* (*SSLv2_server_method)(void) = NULL;
#else
static const long Cryptography_HAS_SSL2 = 1;
#endif

#ifdef OPENSSL_NO_SSL3_METHOD
static const long Cryptography_HAS_SSL3_METHOD = 0;
SSL_METHOD* (*SSLv3_method)(void) = NULL;
SSL_METHOD* (*SSLv3_client_method)(void) = NULL;
SSL_METHOD* (*SSLv3_server_method)(void) = NULL;
#else
static const long Cryptography_HAS_SSL3_METHOD = 1;
#endif

#ifdef SSL_CTRL_SET_TLSEXT_HOSTNAME
static const long Cryptography_HAS_TLSEXT_HOSTNAME = 1;
#else
static const long Cryptography_HAS_TLSEXT_HOSTNAME = 0;
void (*SSL_set_tlsext_host_name)(SSL *, char *) = NULL;
const char* (*SSL_get_servername)(const SSL *, const int) = NULL;
void (*SSL_CTX_set_tlsext_servername_callback)(
    SSL_CTX *,
    int (*)(const SSL *, int *, void *)) = NULL;
#endif

#ifdef SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB
static const long Cryptography_HAS_TLSEXT_STATUS_REQ_CB = 1;
#else
static const long Cryptography_HAS_TLSEXT_STATUS_REQ_CB = 0;
long (*SSL_CTX_set_tlsext_status_cb)(SSL_CTX *, int(*)(SSL *, void *)) = NULL;
long (*SSL_CTX_set_tlsext_status_arg)(SSL_CTX *, void *) = NULL;
#endif

#ifdef SSL_CTRL_SET_TLSEXT_STATUS_REQ_OCSP_RESP
static const long Cryptography_HAS_STATUS_REQ_OCSP_RESP = 1;
#else
static const long Cryptography_HAS_STATUS_REQ_OCSP_RESP = 0;
long (*SSL_set_tlsext_status_ocsp_resp)(SSL *, unsigned char *, int) = NULL;
long (*SSL_get_tlsext_status_ocsp_resp)(SSL *, const unsigned char **) = NULL;
#endif

#ifdef SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE
static const long Cryptography_HAS_TLSEXT_STATUS_REQ_TYPE = 1;
#else
static const long Cryptography_HAS_TLSEXT_STATUS_REQ_TYPE = 0;
long (*SSL_set_tlsext_status_type)(SSL *, long) = NULL;
#endif

#ifdef SSL_MODE_RELEASE_BUFFERS
static const long Cryptography_HAS_RELEASE_BUFFERS = 1;
#else
static const long Cryptography_HAS_RELEASE_BUFFERS = 0;
const long SSL_MODE_RELEASE_BUFFERS = 0;
#endif

#ifdef SSL_OP_NO_COMPRESSION
static const long Cryptography_HAS_OP_NO_COMPRESSION = 1;
#else
static const long Cryptography_HAS_OP_NO_COMPRESSION = 0;
const long SSL_OP_NO_COMPRESSION = 0;
#endif

#ifdef SSL_OP_NO_TLSv1_1
static const long Cryptography_HAS_TLSv1_1 = 1;
#else
static const long Cryptography_HAS_TLSv1_1 = 0;
static const long SSL_OP_NO_TLSv1_1 = 0;
SSL_METHOD* (*TLSv1_1_method)(void) = NULL;
SSL_METHOD* (*TLSv1_1_client_method)(void) = NULL;
SSL_METHOD* (*TLSv1_1_server_method)(void) = NULL;
#endif

#ifdef SSL_OP_NO_TLSv1_2
static const long Cryptography_HAS_TLSv1_2 = 1;
#else
static const long Cryptography_HAS_TLSv1_2 = 0;
static const long SSL_OP_NO_TLSv1_2 = 0;
SSL_METHOD* (*TLSv1_2_method)(void) = NULL;
SSL_METHOD* (*TLSv1_2_client_method)(void) = NULL;
SSL_METHOD* (*TLSv1_2_server_method)(void) = NULL;
#endif

#ifdef SSL_OP_MSIE_SSLV2_RSA_PADDING
static const long Cryptography_HAS_SSL_OP_MSIE_SSLV2_RSA_PADDING = 1;
#else
static const long Cryptography_HAS_SSL_OP_MSIE_SSLV2_RSA_PADDING = 0;
const long SSL_OP_MSIE_SSLV2_RSA_PADDING = 0;
#endif

#ifdef OPENSSL_NO_EC
long (*SSL_CTX_set_tmp_ecdh)(SSL_CTX *, EC_KEY *) = NULL;
#endif

#ifdef SSL_OP_NO_TICKET
static const long Cryptography_HAS_SSL_OP_NO_TICKET = 1;
#else
static const long Cryptography_HAS_SSL_OP_NO_TICKET = 0;
const long SSL_OP_NO_TICKET = 0;
#endif

/* OpenSSL 0.9.8f+ */
#if OPENSSL_VERSION_NUMBER >= 0x00908070L
static const long Cryptography_HAS_SSL_SET_SSL_CTX = 1;
#else
static const long Cryptography_HAS_SSL_SET_SSL_CTX = 0;
static const long TLSEXT_NAMETYPE_host_name = 0;
SSL_CTX *(*SSL_set_SSL_CTX)(SSL *, SSL_CTX *) = NULL;
#endif

/* NetBSD shipped without including d1_meth.c. This workaround checks to see
   if the version of NetBSD we're currently running on is old enough to
   have the bug and provides an empty implementation so we can link and
   then remove the function from the ffi object. */
#ifdef __NetBSD__
#  include <sys/param.h>
#  if (__NetBSD_Version__ < 699003800)
static const long Cryptography_HAS_NETBSD_D1_METH = 0;
const SSL_METHOD *DTLSv1_method(void) {
    return NULL;
}
#  else
static const long Cryptography_HAS_NETBSD_D1_METH = 1;
#  endif
#else
static const long Cryptography_HAS_NETBSD_D1_METH = 1;
#endif

/* Workaround for #794 caused by cffi const** bug. */
const SSL_METHOD *Cryptography_SSL_CTX_get_method(const SSL_CTX *ctx) {
    return ctx->method;
}

/* Because OPENSSL defines macros that claim lack of support for things, rather
 * than macros that claim support for things, we need to do a version check in
 * addition to a definition check. NPN was added in 1.0.1: for any version
 * before that, there is no compatibility.
 */
#if defined(OPENSSL_NO_NEXTPROTONEG) || OPENSSL_VERSION_NUMBER < 0x1000100fL
static const long Cryptography_HAS_NEXTPROTONEG = 0;
void (*SSL_CTX_set_next_protos_advertised_cb)(SSL_CTX *,
                                              int (*)(SSL *,
                                                      const unsigned char **,
                                                      unsigned int *,
                                                      void *),
                                              void *) = NULL;
void (*SSL_CTX_set_next_proto_select_cb)(SSL_CTX *,
                                         int (*)(SSL *,
                                                 unsigned char **,
                                                 unsigned char *,
                                                 const unsigned char *,
                                                 unsigned int,
                                                 void *),
                                         void *) = NULL;
int (*SSL_select_next_proto)(unsigned char **, unsigned char *,
                             const unsigned char *, unsigned int,
                             const unsigned char *, unsigned int) = NULL;
void (*SSL_get0_next_proto_negotiated)(const SSL *,
                                       const unsigned char **,
                                       unsigned *) = NULL;
#else
static const long Cryptography_HAS_NEXTPROTONEG = 1;
#endif

/* ALPN was added in OpenSSL 1.0.2. */
#if OPENSSL_VERSION_NUMBER < 0x10002001L && !defined(LIBRESSL_VERSION_NUMBER)
int (*SSL_CTX_set_alpn_protos)(SSL_CTX *,
                               const unsigned char *,
                               unsigned) = NULL;
int (*SSL_set_alpn_protos)(SSL *, const unsigned char *, unsigned) = NULL;
void (*SSL_CTX_set_alpn_select_cb)(SSL_CTX *,
                                   int (*) (SSL *,
                                            const unsigned char **,
                                            unsigned char *,
                                            const unsigned char *,
                                            unsigned int,
                                            void *),
                                   void *) = NULL;
void (*SSL_get0_alpn_selected)(const SSL *,
                               const unsigned char **,
                               unsigned *) = NULL;
static const long Cryptography_HAS_ALPN = 0;
#else
static const long Cryptography_HAS_ALPN = 1;
#endif

#if defined(OPENSSL_NO_COMP) || defined(LIBRESSL_VERSION_NUMBER)
static const long Cryptography_HAS_COMPRESSION = 0;
typedef void COMP_METHOD;
#else
static const long Cryptography_HAS_COMPRESSION = 1;
#endif

#if defined(SSL_CTRL_GET_SERVER_TMP_KEY)
static const long Cryptography_HAS_GET_SERVER_TMP_KEY = 1;
#else
static const long Cryptography_HAS_GET_SERVER_TMP_KEY = 0;
long (*SSL_get_server_tmp_key)(SSL *, EVP_PKEY **) = NULL;
#endif



/* OpenSSL 0.9.8e does not have this definition. */
#if OPENSSL_VERSION_NUMBER <= 0x0090805fL
typedef STACK_OF(X509_EXTENSION) X509_EXTENSIONS;
#endif
#ifdef OPENSSL_NO_EC
int (*i2d_EC_PUBKEY)(EC_KEY *, unsigned char **) = NULL;
EC_KEY *(*d2i_EC_PUBKEY)(EC_KEY **, const unsigned char **, long) = NULL;
EC_KEY *(*d2i_EC_PUBKEY_bio)(BIO *, EC_KEY **) = NULL;
int (*i2d_EC_PUBKEY_bio)(BIO *, EC_KEY *) = NULL;
EC_KEY *(*d2i_ECPrivateKey_bio)(BIO *, EC_KEY **) = NULL;
int (*i2d_ECPrivateKey_bio)(BIO *, EC_KEY *) = NULL;
#endif






/* OpenSSL 1.0.2+ verification error codes */
#if OPENSSL_VERSION_NUMBER >= 0x10002000L && !defined(LIBRESSL_VERSION_NUMBER)
static const long Cryptography_HAS_102_VERIFICATION_ERROR_CODES = 1;
#else
static const long Cryptography_HAS_102_VERIFICATION_ERROR_CODES = 0;
static const long X509_V_ERR_SUITE_B_INVALID_VERSION = 0;
static const long X509_V_ERR_SUITE_B_INVALID_ALGORITHM = 0;
static const long X509_V_ERR_SUITE_B_INVALID_CURVE = 0;
static const long X509_V_ERR_SUITE_B_INVALID_SIGNATURE_ALGORITHM = 0;
static const long X509_V_ERR_SUITE_B_LOS_NOT_ALLOWED = 0;
static const long X509_V_ERR_SUITE_B_CANNOT_SIGN_P_384_WITH_P_256 = 0;
static const long X509_V_ERR_HOSTNAME_MISMATCH = 0;
static const long X509_V_ERR_EMAIL_MISMATCH = 0;
static const long X509_V_ERR_IP_ADDRESS_MISMATCH = 0;
#endif

/* OpenSSL 1.0.2+ verification parameters */
#if OPENSSL_VERSION_NUMBER >= 0x10002000L && !defined(LIBRESSL_VERSION_NUMBER)
static const long Cryptography_HAS_102_VERIFICATION_PARAMS = 1;
#else
static const long Cryptography_HAS_102_VERIFICATION_PARAMS = 0;
/* X509_V_FLAG_TRUSTED_FIRST is also new in 1.0.2+, but it is added separately
   below because it shows up in some earlier 3rd party OpenSSL packages. */
static const long X509_V_FLAG_SUITEB_128_LOS_ONLY = 0;
static const long X509_V_FLAG_SUITEB_192_LOS = 0;
static const long X509_V_FLAG_SUITEB_128_LOS = 0;

int (*X509_VERIFY_PARAM_set1_host)(X509_VERIFY_PARAM *, const char *,
                                   size_t) = NULL;
int (*X509_VERIFY_PARAM_set1_email)(X509_VERIFY_PARAM *, const char *,
                                    size_t) = NULL;
int (*X509_VERIFY_PARAM_set1_ip)(X509_VERIFY_PARAM *, const unsigned char *,
                                 size_t) = NULL;
int (*X509_VERIFY_PARAM_set1_ip_asc)(X509_VERIFY_PARAM *, const char *) = NULL;
void (*X509_VERIFY_PARAM_set_hostflags)(X509_VERIFY_PARAM *,
                                        unsigned int) = NULL;
#endif

/* OpenSSL 1.0.2+ or Solaris's backport */
#ifdef X509_V_FLAG_PARTIAL_CHAIN
static const long Cryptography_HAS_X509_V_FLAG_PARTIAL_CHAIN = 1;
#else
static const long Cryptography_HAS_X509_V_FLAG_PARTIAL_CHAIN = 0;
static const long X509_V_FLAG_PARTIAL_CHAIN = 0;
#endif

/* OpenSSL 1.0.2+, *or* Fedora 20's flavor of OpenSSL 1.0.1e... */
#ifdef X509_V_FLAG_TRUSTED_FIRST
static const long Cryptography_HAS_X509_V_FLAG_TRUSTED_FIRST = 1;
#else
static const long Cryptography_HAS_X509_V_FLAG_TRUSTED_FIRST = 0;
static const long X509_V_FLAG_TRUSTED_FIRST = 0;
#endif

/* OpenSSL 1.0.0+ verification error codes */
#if OPENSSL_VERSION_NUMBER >= 0x10000000L
static const long Cryptography_HAS_100_VERIFICATION_ERROR_CODES = 1;
#else
static const long Cryptography_HAS_100_VERIFICATION_ERROR_CODES = 0;
static const long X509_V_ERR_DIFFERENT_CRL_SCOPE = 0;
static const long X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE = 0;
static const long X509_V_ERR_PERMITTED_VIOLATION = 0;
static const long X509_V_ERR_EXCLUDED_VIOLATION = 0;
static const long X509_V_ERR_SUBTREE_MINMAX = 0;
static const long X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE = 0;
static const long X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX = 0;
static const long X509_V_ERR_UNSUPPORTED_NAME_SYNTAX = 0;
static const long X509_V_ERR_CRL_PATH_VALIDATION_ERROR = 0;
#endif

/* OpenSSL 1.0.0+ verification parameters */
#if OPENSSL_VERSION_NUMBER >= 0x10000000L
static const long Cryptography_HAS_100_VERIFICATION_PARAMS = 1;
#else
static const long Cryptography_HAS_100_VERIFICATION_PARAMS = 0;
static const long X509_V_FLAG_EXTENDED_CRL_SUPPORT = 0;
static const long X509_V_FLAG_USE_DELTAS = 0;
#endif

/* OpenSSL 0.9.8recent+ */
#ifdef X509_V_FLAG_CHECK_SS_SIGNATURE
static const long Cryptography_HAS_X509_V_FLAG_CHECK_SS_SIGNATURE = 1;
#else
static const long Cryptography_HAS_X509_V_FLAG_CHECK_SS_SIGNATURE = 0;
static const long X509_V_FLAG_CHECK_SS_SIGNATURE = 0;
#endif


static void _cffi_check__ACCESS_DESCRIPTION(ACCESS_DESCRIPTION *p)
{
  /* only to generate compile-time warnings or errors */
  { ASN1_OBJECT * *tmp = &p->method; (void)tmp; }
  { GENERAL_NAME * *tmp = &p->location; (void)tmp; }
}
static PyObject *
_cffi_layout__ACCESS_DESCRIPTION(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; ACCESS_DESCRIPTION y; };
  static Py_ssize_t nums[] = {
    sizeof(ACCESS_DESCRIPTION),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(ACCESS_DESCRIPTION, method),
    sizeof(((ACCESS_DESCRIPTION *)0)->method),
    offsetof(ACCESS_DESCRIPTION, location),
    sizeof(((ACCESS_DESCRIPTION *)0)->location),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__ACCESS_DESCRIPTION(0);
}

static void _cffi_check__ASN1_TIME(ASN1_TIME *p)
{
  /* only to generate compile-time warnings or errors */
}
static PyObject *
_cffi_layout__ASN1_TIME(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; ASN1_TIME y; };
  static Py_ssize_t nums[] = {
    sizeof(ASN1_TIME),
    offsetof(struct _cffi_aligncheck, y),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__ASN1_TIME(0);
}

static void _cffi_check__AUTHORITY_KEYID(AUTHORITY_KEYID *p)
{
  /* only to generate compile-time warnings or errors */
  { ASN1_OCTET_STRING * *tmp = &p->keyid; (void)tmp; }
  { GENERAL_NAMES * *tmp = &p->issuer; (void)tmp; }
  { ASN1_INTEGER * *tmp = &p->serial; (void)tmp; }
}
static PyObject *
_cffi_layout__AUTHORITY_KEYID(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; AUTHORITY_KEYID y; };
  static Py_ssize_t nums[] = {
    sizeof(AUTHORITY_KEYID),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(AUTHORITY_KEYID, keyid),
    sizeof(((AUTHORITY_KEYID *)0)->keyid),
    offsetof(AUTHORITY_KEYID, issuer),
    sizeof(((AUTHORITY_KEYID *)0)->issuer),
    offsetof(AUTHORITY_KEYID, serial),
    sizeof(((AUTHORITY_KEYID *)0)->serial),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__AUTHORITY_KEYID(0);
}

static void _cffi_check__BASIC_CONSTRAINTS(BASIC_CONSTRAINTS *p)
{
  /* only to generate compile-time warnings or errors */
  (void)((p->ca) << 1);
  { ASN1_INTEGER * *tmp = &p->pathlen; (void)tmp; }
}
static PyObject *
_cffi_layout__BASIC_CONSTRAINTS(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; BASIC_CONSTRAINTS y; };
  static Py_ssize_t nums[] = {
    sizeof(BASIC_CONSTRAINTS),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(BASIC_CONSTRAINTS, ca),
    sizeof(((BASIC_CONSTRAINTS *)0)->ca),
    offsetof(BASIC_CONSTRAINTS, pathlen),
    sizeof(((BASIC_CONSTRAINTS *)0)->pathlen),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__BASIC_CONSTRAINTS(0);
}

static void _cffi_check__DIST_POINT(DIST_POINT *p)
{
  /* only to generate compile-time warnings or errors */
  { DIST_POINT_NAME * *tmp = &p->distpoint; (void)tmp; }
  { ASN1_BIT_STRING * *tmp = &p->reasons; (void)tmp; }
  { GENERAL_NAMES * *tmp = &p->CRLissuer; (void)tmp; }
}
static PyObject *
_cffi_layout__DIST_POINT(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; DIST_POINT y; };
  static Py_ssize_t nums[] = {
    sizeof(DIST_POINT),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(DIST_POINT, distpoint),
    sizeof(((DIST_POINT *)0)->distpoint),
    offsetof(DIST_POINT, reasons),
    sizeof(((DIST_POINT *)0)->reasons),
    offsetof(DIST_POINT, CRLissuer),
    sizeof(((DIST_POINT *)0)->CRLissuer),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__DIST_POINT(0);
}

static void _cffi_check__DIST_POINT_NAME(DIST_POINT_NAME *p)
{
  /* only to generate compile-time warnings or errors */
  (void)((p->type) << 1);
  /* cannot generate 'union $2' in field 'name': unknown type name */
}
static PyObject *
_cffi_layout__DIST_POINT_NAME(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; DIST_POINT_NAME y; };
  static Py_ssize_t nums[] = {
    sizeof(DIST_POINT_NAME),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(DIST_POINT_NAME, type),
    sizeof(((DIST_POINT_NAME *)0)->type),
    offsetof(DIST_POINT_NAME, name),
    sizeof(((DIST_POINT_NAME *)0)->name),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__DIST_POINT_NAME(0);
}

static void _cffi_check__DSA_SIG(DSA_SIG *p)
{
  /* only to generate compile-time warnings or errors */
  { BIGNUM * *tmp = &p->r; (void)tmp; }
  { BIGNUM * *tmp = &p->s; (void)tmp; }
}
static PyObject *
_cffi_layout__DSA_SIG(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; DSA_SIG y; };
  static Py_ssize_t nums[] = {
    sizeof(DSA_SIG),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(DSA_SIG, r),
    sizeof(((DSA_SIG *)0)->r),
    offsetof(DSA_SIG, s),
    sizeof(((DSA_SIG *)0)->s),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__DSA_SIG(0);
}

static void _cffi_check__ECDSA_SIG(ECDSA_SIG *p)
{
  /* only to generate compile-time warnings or errors */
  { BIGNUM * *tmp = &p->r; (void)tmp; }
  { BIGNUM * *tmp = &p->s; (void)tmp; }
}
static PyObject *
_cffi_layout__ECDSA_SIG(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; ECDSA_SIG y; };
  static Py_ssize_t nums[] = {
    sizeof(ECDSA_SIG),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(ECDSA_SIG, r),
    sizeof(((ECDSA_SIG *)0)->r),
    offsetof(ECDSA_SIG, s),
    sizeof(((ECDSA_SIG *)0)->s),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__ECDSA_SIG(0);
}

static void _cffi_check__EC_builtin_curve(EC_builtin_curve *p)
{
  /* only to generate compile-time warnings or errors */
  (void)((p->nid) << 1);
  { char const * *tmp = &p->comment; (void)tmp; }
}
static PyObject *
_cffi_layout__EC_builtin_curve(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; EC_builtin_curve y; };
  static Py_ssize_t nums[] = {
    sizeof(EC_builtin_curve),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(EC_builtin_curve, nid),
    sizeof(((EC_builtin_curve *)0)->nid),
    offsetof(EC_builtin_curve, comment),
    sizeof(((EC_builtin_curve *)0)->comment),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__EC_builtin_curve(0);
}

static void _cffi_check__EDIPARTYNAME(EDIPARTYNAME *p)
{
  /* only to generate compile-time warnings or errors */
}
static PyObject *
_cffi_layout__EDIPARTYNAME(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; EDIPARTYNAME y; };
  static Py_ssize_t nums[] = {
    sizeof(EDIPARTYNAME),
    offsetof(struct _cffi_aligncheck, y),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__EDIPARTYNAME(0);
}

static void _cffi_check__EVP_CIPHER_CTX(EVP_CIPHER_CTX *p)
{
  /* only to generate compile-time warnings or errors */
  { EVP_CIPHER const * *tmp = &p->cipher; (void)tmp; }
  { ENGINE * *tmp = &p->engine; (void)tmp; }
  (void)((p->encrypt) << 1);
}
static PyObject *
_cffi_layout__EVP_CIPHER_CTX(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; EVP_CIPHER_CTX y; };
  static Py_ssize_t nums[] = {
    sizeof(EVP_CIPHER_CTX),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(EVP_CIPHER_CTX, cipher),
    sizeof(((EVP_CIPHER_CTX *)0)->cipher),
    offsetof(EVP_CIPHER_CTX, engine),
    sizeof(((EVP_CIPHER_CTX *)0)->engine),
    offsetof(EVP_CIPHER_CTX, encrypt),
    sizeof(((EVP_CIPHER_CTX *)0)->encrypt),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__EVP_CIPHER_CTX(0);
}

static void _cffi_check__GENERAL_NAME(GENERAL_NAME *p)
{
  /* only to generate compile-time warnings or errors */
  (void)((p->type) << 1);
  /* cannot generate 'union $1' in field 'd': unknown type name */
}
static PyObject *
_cffi_layout__GENERAL_NAME(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; GENERAL_NAME y; };
  static Py_ssize_t nums[] = {
    sizeof(GENERAL_NAME),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(GENERAL_NAME, type),
    sizeof(((GENERAL_NAME *)0)->type),
    offsetof(GENERAL_NAME, d),
    sizeof(((GENERAL_NAME *)0)->d),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__GENERAL_NAME(0);
}

static void _cffi_check__HMAC_CTX(HMAC_CTX *p)
{
  /* only to generate compile-time warnings or errors */
}
static PyObject *
_cffi_layout__HMAC_CTX(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; HMAC_CTX y; };
  static Py_ssize_t nums[] = {
    sizeof(HMAC_CTX),
    offsetof(struct _cffi_aligncheck, y),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__HMAC_CTX(0);
}

static void _cffi_check__NOTICEREF(NOTICEREF *p)
{
  /* only to generate compile-time warnings or errors */
  { ASN1_STRING * *tmp = &p->organization; (void)tmp; }
  { Cryptography_STACK_OF_ASN1_INTEGER * *tmp = &p->noticenos; (void)tmp; }
}
static PyObject *
_cffi_layout__NOTICEREF(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; NOTICEREF y; };
  static Py_ssize_t nums[] = {
    sizeof(NOTICEREF),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(NOTICEREF, organization),
    sizeof(((NOTICEREF *)0)->organization),
    offsetof(NOTICEREF, noticenos),
    sizeof(((NOTICEREF *)0)->noticenos),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__NOTICEREF(0);
}

static void _cffi_check__OTHERNAME(OTHERNAME *p)
{
  /* only to generate compile-time warnings or errors */
}
static PyObject *
_cffi_layout__OTHERNAME(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; OTHERNAME y; };
  static Py_ssize_t nums[] = {
    sizeof(OTHERNAME),
    offsetof(struct _cffi_aligncheck, y),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__OTHERNAME(0);
}

static void _cffi_check__PKCS7(PKCS7 *p)
{
  /* only to generate compile-time warnings or errors */
  { ASN1_OBJECT * *tmp = &p->type; (void)tmp; }
}
static PyObject *
_cffi_layout__PKCS7(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; PKCS7 y; };
  static Py_ssize_t nums[] = {
    sizeof(PKCS7),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(PKCS7, type),
    sizeof(((PKCS7 *)0)->type),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__PKCS7(0);
}

static void _cffi_check__POLICYINFO(POLICYINFO *p)
{
  /* only to generate compile-time warnings or errors */
  { ASN1_OBJECT * *tmp = &p->policyid; (void)tmp; }
  { Cryptography_STACK_OF_POLICYQUALINFO * *tmp = &p->qualifiers; (void)tmp; }
}
static PyObject *
_cffi_layout__POLICYINFO(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; POLICYINFO y; };
  static Py_ssize_t nums[] = {
    sizeof(POLICYINFO),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(POLICYINFO, policyid),
    sizeof(((POLICYINFO *)0)->policyid),
    offsetof(POLICYINFO, qualifiers),
    sizeof(((POLICYINFO *)0)->qualifiers),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__POLICYINFO(0);
}

static void _cffi_check__POLICYQUALINFO(POLICYQUALINFO *p)
{
  /* only to generate compile-time warnings or errors */
  { ASN1_OBJECT * *tmp = &p->pqualid; (void)tmp; }
  /* cannot generate 'union $3' in field 'd': unknown type name */
}
static PyObject *
_cffi_layout__POLICYQUALINFO(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; POLICYQUALINFO y; };
  static Py_ssize_t nums[] = {
    sizeof(POLICYQUALINFO),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(POLICYQUALINFO, pqualid),
    sizeof(((POLICYQUALINFO *)0)->pqualid),
    offsetof(POLICYQUALINFO, d),
    sizeof(((POLICYQUALINFO *)0)->d),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__POLICYQUALINFO(0);
}

static void _cffi_check__SSL(SSL *p)
{
  /* only to generate compile-time warnings or errors */
  { SSL3_STATE * *tmp = &p->s3; (void)tmp; }
  { SSL_SESSION * *tmp = &p->session; (void)tmp; }
  (void)((p->type) << 1);
}
static PyObject *
_cffi_layout__SSL(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; SSL y; };
  static Py_ssize_t nums[] = {
    sizeof(SSL),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(SSL, s3),
    sizeof(((SSL *)0)->s3),
    offsetof(SSL, session),
    sizeof(((SSL *)0)->session),
    offsetof(SSL, type),
    sizeof(((SSL *)0)->type),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__SSL(0);
}

static void _cffi_check__SSL3_STATE(SSL3_STATE *p)
{
  /* only to generate compile-time warnings or errors */
  { unsigned char(*tmp)[/*...*/] = &p->server_random; (void)tmp; }
  { unsigned char(*tmp)[/*...*/] = &p->client_random; (void)tmp; }
}
static PyObject *
_cffi_layout__SSL3_STATE(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; SSL3_STATE y; };
  static Py_ssize_t nums[] = {
    sizeof(SSL3_STATE),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(SSL3_STATE, server_random),
    sizeof(((SSL3_STATE *)0)->server_random),
    offsetof(SSL3_STATE, client_random),
    sizeof(((SSL3_STATE *)0)->client_random),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__SSL3_STATE(0);
}

static void _cffi_check__SSL_SESSION(SSL_SESSION *p)
{
  /* only to generate compile-time warnings or errors */
  (void)((p->master_key_length) << 1);
  { unsigned char(*tmp)[/*...*/] = &p->master_key; (void)tmp; }
}
static PyObject *
_cffi_layout__SSL_SESSION(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; SSL_SESSION y; };
  static Py_ssize_t nums[] = {
    sizeof(SSL_SESSION),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(SSL_SESSION, master_key_length),
    sizeof(((SSL_SESSION *)0)->master_key_length),
    offsetof(SSL_SESSION, master_key),
    sizeof(((SSL_SESSION *)0)->master_key),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__SSL_SESSION(0);
}

static void _cffi_check__USERNOTICE(USERNOTICE *p)
{
  /* only to generate compile-time warnings or errors */
  { NOTICEREF * *tmp = &p->noticeref; (void)tmp; }
  { ASN1_STRING * *tmp = &p->exptext; (void)tmp; }
}
static PyObject *
_cffi_layout__USERNOTICE(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; USERNOTICE y; };
  static Py_ssize_t nums[] = {
    sizeof(USERNOTICE),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(USERNOTICE, noticeref),
    sizeof(((USERNOTICE *)0)->noticeref),
    offsetof(USERNOTICE, exptext),
    sizeof(((USERNOTICE *)0)->exptext),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__USERNOTICE(0);
}

static void _cffi_check__X509(X509 *p)
{
  /* only to generate compile-time warnings or errors */
  { X509_ALGOR * *tmp = &p->sig_alg; (void)tmp; }
  { X509_CINF * *tmp = &p->cert_info; (void)tmp; }
}
static PyObject *
_cffi_layout__X509(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; X509 y; };
  static Py_ssize_t nums[] = {
    sizeof(X509),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(X509, sig_alg),
    sizeof(((X509 *)0)->sig_alg),
    offsetof(X509, cert_info),
    sizeof(((X509 *)0)->cert_info),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__X509(0);
}

static void _cffi_check__X509V3_CTX(X509V3_CTX *p)
{
  /* only to generate compile-time warnings or errors */
  { X509 * *tmp = &p->issuer_cert; (void)tmp; }
  { X509 * *tmp = &p->subject_cert; (void)tmp; }
}
static PyObject *
_cffi_layout__X509V3_CTX(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; X509V3_CTX y; };
  static Py_ssize_t nums[] = {
    sizeof(X509V3_CTX),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(X509V3_CTX, issuer_cert),
    sizeof(((X509V3_CTX *)0)->issuer_cert),
    offsetof(X509V3_CTX, subject_cert),
    sizeof(((X509V3_CTX *)0)->subject_cert),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__X509V3_CTX(0);
}

static void _cffi_check__X509V3_EXT_METHOD(X509V3_EXT_METHOD *p)
{
  /* only to generate compile-time warnings or errors */
  { ASN1_ITEM_EXP * *tmp = &p->it; (void)tmp; }
  { void *(* *tmp)(void *, unsigned char const * *, long) = &p->d2i; (void)tmp; }
}
static PyObject *
_cffi_layout__X509V3_EXT_METHOD(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; X509V3_EXT_METHOD y; };
  static Py_ssize_t nums[] = {
    sizeof(X509V3_EXT_METHOD),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(X509V3_EXT_METHOD, it),
    sizeof(((X509V3_EXT_METHOD *)0)->it),
    offsetof(X509V3_EXT_METHOD, d2i),
    sizeof(((X509V3_EXT_METHOD *)0)->d2i),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__X509V3_EXT_METHOD(0);
}

static void _cffi_check__X509_ALGOR(X509_ALGOR *p)
{
  /* only to generate compile-time warnings or errors */
  { ASN1_OBJECT * *tmp = &p->algorithm; (void)tmp; }
}
static PyObject *
_cffi_layout__X509_ALGOR(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; X509_ALGOR y; };
  static Py_ssize_t nums[] = {
    sizeof(X509_ALGOR),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(X509_ALGOR, algorithm),
    sizeof(((X509_ALGOR *)0)->algorithm),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__X509_ALGOR(0);
}

static void _cffi_check__X509_CINF(X509_CINF *p)
{
  /* only to generate compile-time warnings or errors */
  { X509_ALGOR * *tmp = &p->signature; (void)tmp; }
}
static PyObject *
_cffi_layout__X509_CINF(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; X509_CINF y; };
  static Py_ssize_t nums[] = {
    sizeof(X509_CINF),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(X509_CINF, signature),
    sizeof(((X509_CINF *)0)->signature),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__X509_CINF(0);
}

static void _cffi_check__X509_CRL(X509_CRL *p)
{
  /* only to generate compile-time warnings or errors */
  { X509_CRL_INFO * *tmp = &p->crl; (void)tmp; }
  { X509_ALGOR * *tmp = &p->sig_alg; (void)tmp; }
}
static PyObject *
_cffi_layout__X509_CRL(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; X509_CRL y; };
  static Py_ssize_t nums[] = {
    sizeof(X509_CRL),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(X509_CRL, crl),
    sizeof(((X509_CRL *)0)->crl),
    offsetof(X509_CRL, sig_alg),
    sizeof(((X509_CRL *)0)->sig_alg),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__X509_CRL(0);
}

static void _cffi_check__X509_CRL_INFO(X509_CRL_INFO *p)
{
  /* only to generate compile-time warnings or errors */
  { Cryptography_STACK_OF_X509_REVOKED * *tmp = &p->revoked; (void)tmp; }
}
static PyObject *
_cffi_layout__X509_CRL_INFO(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; X509_CRL_INFO y; };
  static Py_ssize_t nums[] = {
    sizeof(X509_CRL_INFO),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(X509_CRL_INFO, revoked),
    sizeof(((X509_CRL_INFO *)0)->revoked),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__X509_CRL_INFO(0);
}

static void _cffi_check__X509_EXTENSION(X509_EXTENSION *p)
{
  /* only to generate compile-time warnings or errors */
  { ASN1_OBJECT * *tmp = &p->object; (void)tmp; }
  (void)((p->critical) << 1);
  { ASN1_OCTET_STRING * *tmp = &p->value; (void)tmp; }
}
static PyObject *
_cffi_layout__X509_EXTENSION(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; X509_EXTENSION y; };
  static Py_ssize_t nums[] = {
    sizeof(X509_EXTENSION),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(X509_EXTENSION, object),
    sizeof(((X509_EXTENSION *)0)->object),
    offsetof(X509_EXTENSION, critical),
    sizeof(((X509_EXTENSION *)0)->critical),
    offsetof(X509_EXTENSION, value),
    sizeof(((X509_EXTENSION *)0)->value),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__X509_EXTENSION(0);
}

static void _cffi_check__X509_REQ(X509_REQ *p)
{
  /* only to generate compile-time warnings or errors */
  { X509_ALGOR * *tmp = &p->sig_alg; (void)tmp; }
}
static PyObject *
_cffi_layout__X509_REQ(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; X509_REQ y; };
  static Py_ssize_t nums[] = {
    sizeof(X509_REQ),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(X509_REQ, sig_alg),
    sizeof(((X509_REQ *)0)->sig_alg),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__X509_REQ(0);
}

static void _cffi_check__X509_REVOKED(X509_REVOKED *p)
{
  /* only to generate compile-time warnings or errors */
  { ASN1_INTEGER * *tmp = &p->serialNumber; (void)tmp; }
  { ASN1_TIME * *tmp = &p->revocationDate; (void)tmp; }
  { X509_EXTENSIONS * *tmp = &p->extensions; (void)tmp; }
  (void)((p->sequence) << 1);
}
static PyObject *
_cffi_layout__X509_REVOKED(PyObject *self, PyObject *noarg)
{
  struct _cffi_aligncheck { char x; X509_REVOKED y; };
  static Py_ssize_t nums[] = {
    sizeof(X509_REVOKED),
    offsetof(struct _cffi_aligncheck, y),
    offsetof(X509_REVOKED, serialNumber),
    sizeof(((X509_REVOKED *)0)->serialNumber),
    offsetof(X509_REVOKED, revocationDate),
    sizeof(((X509_REVOKED *)0)->revocationDate),
    offsetof(X509_REVOKED, extensions),
    sizeof(((X509_REVOKED *)0)->extensions),
    offsetof(X509_REVOKED, sequence),
    sizeof(((X509_REVOKED *)0)->sequence),
    -1
  };
  return _cffi_get_struct_layout(nums);
  /* the next line is not executed, but compiled */
  _cffi_check__X509_REVOKED(0);
}

static int _cffi_const_ASN1_F_ASN1_ENUMERATED_TO_BN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_ENUMERATED_TO_BN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_ENUMERATED_TO_BN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return 0;
}

static int _cffi_const_ASN1_F_ASN1_EX_C2I(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_EX_C2I);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_EX_C2I", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_ENUMERATED_TO_BN(lib);
}

static int _cffi_const_ASN1_F_ASN1_FIND_END(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_FIND_END);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_FIND_END", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_EX_C2I(lib);
}

static int _cffi_const_ASN1_F_ASN1_GENERALIZEDTIME_SET(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_GENERALIZEDTIME_SET);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_GENERALIZEDTIME_SET", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_FIND_END(lib);
}

static int _cffi_const_ASN1_F_ASN1_GENERATE_V3(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_GENERATE_V3);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_GENERATE_V3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_GENERALIZEDTIME_SET(lib);
}

static int _cffi_const_ASN1_F_ASN1_GET_OBJECT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_GET_OBJECT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_GET_OBJECT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_GENERATE_V3(lib);
}

static int _cffi_const_ASN1_F_ASN1_ITEM_I2D_FP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_ITEM_I2D_FP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_ITEM_I2D_FP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_GET_OBJECT(lib);
}

static int _cffi_const_ASN1_F_ASN1_ITEM_PACK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_ITEM_PACK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_ITEM_PACK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_ITEM_I2D_FP(lib);
}

static int _cffi_const_ASN1_F_ASN1_ITEM_SIGN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_ITEM_SIGN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_ITEM_SIGN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_ITEM_PACK(lib);
}

static int _cffi_const_ASN1_F_ASN1_ITEM_UNPACK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_ITEM_UNPACK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_ITEM_UNPACK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_ITEM_SIGN(lib);
}

static int _cffi_const_ASN1_F_ASN1_ITEM_VERIFY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_ITEM_VERIFY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_ITEM_VERIFY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_ITEM_UNPACK(lib);
}

static int _cffi_const_ASN1_F_ASN1_MBSTRING_NCOPY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_MBSTRING_NCOPY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_MBSTRING_NCOPY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_ITEM_VERIFY(lib);
}

static int _cffi_const_ASN1_F_ASN1_TEMPLATE_EX_D2I(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_TEMPLATE_EX_D2I);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_TEMPLATE_EX_D2I", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_MBSTRING_NCOPY(lib);
}

static int _cffi_const_ASN1_F_ASN1_TEMPLATE_NEW(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_TEMPLATE_NEW);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_TEMPLATE_NEW", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_TEMPLATE_EX_D2I(lib);
}

static int _cffi_const_ASN1_F_ASN1_TEMPLATE_NOEXP_D2I(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_TEMPLATE_NOEXP_D2I);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_TEMPLATE_NOEXP_D2I", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_TEMPLATE_NEW(lib);
}

static int _cffi_const_ASN1_F_ASN1_TIME_SET(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_TIME_SET);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_TIME_SET", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_TEMPLATE_NOEXP_D2I(lib);
}

static int _cffi_const_ASN1_F_ASN1_TYPE_GET_INT_OCTETSTRING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_TYPE_GET_INT_OCTETSTRING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_TYPE_GET_INT_OCTETSTRING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_TIME_SET(lib);
}

static int _cffi_const_ASN1_F_ASN1_TYPE_GET_OCTETSTRING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_TYPE_GET_OCTETSTRING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_TYPE_GET_OCTETSTRING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_TYPE_GET_INT_OCTETSTRING(lib);
}

static int _cffi_const_ASN1_F_ASN1_UNPACK_STRING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_UNPACK_STRING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_UNPACK_STRING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_TYPE_GET_OCTETSTRING(lib);
}

static int _cffi_const_ASN1_F_ASN1_UTCTIME_SET(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_UTCTIME_SET);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_UTCTIME_SET", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_UNPACK_STRING(lib);
}

static int _cffi_const_ASN1_F_ASN1_VERIFY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_ASN1_VERIFY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_ASN1_VERIFY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_UTCTIME_SET(lib);
}

static int _cffi_const_ASN1_F_B64_READ_ASN1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_B64_READ_ASN1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_B64_READ_ASN1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_ASN1_VERIFY(lib);
}

static int _cffi_const_ASN1_F_B64_WRITE_ASN1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_B64_WRITE_ASN1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_B64_WRITE_ASN1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_B64_READ_ASN1(lib);
}

static int _cffi_const_ASN1_F_BITSTR_CB(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_BITSTR_CB);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_BITSTR_CB", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_B64_WRITE_ASN1(lib);
}

static int _cffi_const_ASN1_F_BN_TO_ASN1_ENUMERATED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_BN_TO_ASN1_ENUMERATED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_BN_TO_ASN1_ENUMERATED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_BITSTR_CB(lib);
}

static int _cffi_const_ASN1_F_BN_TO_ASN1_INTEGER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_BN_TO_ASN1_INTEGER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_BN_TO_ASN1_INTEGER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_BN_TO_ASN1_ENUMERATED(lib);
}

static int _cffi_const_ASN1_F_D2I_ASN1_TYPE_BYTES(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_D2I_ASN1_TYPE_BYTES);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_D2I_ASN1_TYPE_BYTES", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_BN_TO_ASN1_INTEGER(lib);
}

static int _cffi_const_ASN1_F_D2I_ASN1_UINTEGER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_D2I_ASN1_UINTEGER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_D2I_ASN1_UINTEGER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_D2I_ASN1_TYPE_BYTES(lib);
}

static int _cffi_const_ASN1_F_D2I_ASN1_UTCTIME(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_D2I_ASN1_UTCTIME);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_D2I_ASN1_UTCTIME", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_D2I_ASN1_UINTEGER(lib);
}

static int _cffi_const_ASN1_F_D2I_NETSCAPE_RSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_D2I_NETSCAPE_RSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_D2I_NETSCAPE_RSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_D2I_ASN1_UTCTIME(lib);
}

static int _cffi_const_ASN1_F_D2I_NETSCAPE_RSA_2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_D2I_NETSCAPE_RSA_2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_D2I_NETSCAPE_RSA_2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_D2I_NETSCAPE_RSA(lib);
}

static int _cffi_const_ASN1_F_D2I_PRIVATEKEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_D2I_PRIVATEKEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_D2I_PRIVATEKEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_D2I_NETSCAPE_RSA_2(lib);
}

static int _cffi_const_ASN1_F_D2I_X509(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_D2I_X509);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_D2I_X509", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_D2I_PRIVATEKEY(lib);
}

static int _cffi_const_ASN1_F_D2I_X509_CINF(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_D2I_X509_CINF);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_D2I_X509_CINF", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_D2I_X509(lib);
}

static int _cffi_const_ASN1_F_D2I_X509_PKEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_D2I_X509_PKEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_D2I_X509_PKEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_D2I_X509_CINF(lib);
}

static int _cffi_const_ASN1_F_I2D_ASN1_SET(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_I2D_ASN1_SET);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_I2D_ASN1_SET", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_D2I_X509_PKEY(lib);
}

static int _cffi_const_ASN1_F_I2D_ASN1_TIME(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_I2D_ASN1_TIME);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_I2D_ASN1_TIME", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_I2D_ASN1_SET(lib);
}

static int _cffi_const_ASN1_F_I2D_DSA_PUBKEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_I2D_DSA_PUBKEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_I2D_DSA_PUBKEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_I2D_ASN1_TIME(lib);
}

static int _cffi_const_ASN1_F_LONG_C2I(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_LONG_C2I);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_LONG_C2I", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_I2D_DSA_PUBKEY(lib);
}

static int _cffi_const_ASN1_F_OID_MODULE_INIT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_OID_MODULE_INIT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_OID_MODULE_INIT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_LONG_C2I(lib);
}

static int _cffi_const_ASN1_F_PARSE_TAGGING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_PARSE_TAGGING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_PARSE_TAGGING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_OID_MODULE_INIT(lib);
}

static int _cffi_const_ASN1_F_PKCS5_PBE_SET(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_PKCS5_PBE_SET);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_PKCS5_PBE_SET", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_PARSE_TAGGING(lib);
}

static int _cffi_const_ASN1_F_SMIME_READ_ASN1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_SMIME_READ_ASN1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_SMIME_READ_ASN1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_PKCS5_PBE_SET(lib);
}

static int _cffi_const_ASN1_F_SMIME_TEXT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_SMIME_TEXT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_SMIME_TEXT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_SMIME_READ_ASN1(lib);
}

static int _cffi_const_ASN1_F_X509_CINF_NEW(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_F_X509_CINF_NEW);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_F_X509_CINF_NEW", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_SMIME_TEXT(lib);
}

static int _cffi_const_ASN1_R_BOOLEAN_IS_WRONG_LENGTH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_BOOLEAN_IS_WRONG_LENGTH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_BOOLEAN_IS_WRONG_LENGTH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_F_X509_CINF_NEW(lib);
}

static int _cffi_const_ASN1_R_BUFFER_TOO_SMALL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_BUFFER_TOO_SMALL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_BUFFER_TOO_SMALL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_BOOLEAN_IS_WRONG_LENGTH(lib);
}

static int _cffi_const_ASN1_R_CIPHER_HAS_NO_OBJECT_IDENTIFIER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_CIPHER_HAS_NO_OBJECT_IDENTIFIER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_CIPHER_HAS_NO_OBJECT_IDENTIFIER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_BUFFER_TOO_SMALL(lib);
}

static int _cffi_const_ASN1_R_DATA_IS_WRONG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_DATA_IS_WRONG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_DATA_IS_WRONG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_CIPHER_HAS_NO_OBJECT_IDENTIFIER(lib);
}

static int _cffi_const_ASN1_R_DECODE_ERROR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_DECODE_ERROR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_DECODE_ERROR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_DATA_IS_WRONG(lib);
}

static int _cffi_const_ASN1_R_DECODING_ERROR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_DECODING_ERROR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_DECODING_ERROR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_DECODE_ERROR(lib);
}

static int _cffi_const_ASN1_R_DEPTH_EXCEEDED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_DEPTH_EXCEEDED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_DEPTH_EXCEEDED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_DECODING_ERROR(lib);
}

static int _cffi_const_ASN1_R_ENCODE_ERROR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_ENCODE_ERROR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_ENCODE_ERROR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_DEPTH_EXCEEDED(lib);
}

static int _cffi_const_ASN1_R_ERROR_GETTING_TIME(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_ERROR_GETTING_TIME);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_ERROR_GETTING_TIME", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_ENCODE_ERROR(lib);
}

static int _cffi_const_ASN1_R_ERROR_LOADING_SECTION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_ERROR_LOADING_SECTION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_ERROR_LOADING_SECTION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_ERROR_GETTING_TIME(lib);
}

static int _cffi_const_ASN1_R_MSTRING_WRONG_TAG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_MSTRING_WRONG_TAG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_MSTRING_WRONG_TAG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_ERROR_LOADING_SECTION(lib);
}

static int _cffi_const_ASN1_R_NESTED_ASN1_STRING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_NESTED_ASN1_STRING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_NESTED_ASN1_STRING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_MSTRING_WRONG_TAG(lib);
}

static int _cffi_const_ASN1_R_NO_CONTENT_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_NO_CONTENT_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_NO_CONTENT_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_NESTED_ASN1_STRING(lib);
}

static int _cffi_const_ASN1_R_NO_MATCHING_CHOICE_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_NO_MATCHING_CHOICE_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_NO_MATCHING_CHOICE_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_NO_CONTENT_TYPE(lib);
}

static int _cffi_const_ASN1_R_NO_MULTIPART_BODY_FAILURE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_NO_MULTIPART_BODY_FAILURE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_NO_MULTIPART_BODY_FAILURE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_NO_MATCHING_CHOICE_TYPE(lib);
}

static int _cffi_const_ASN1_R_NO_MULTIPART_BOUNDARY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_NO_MULTIPART_BOUNDARY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_NO_MULTIPART_BOUNDARY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_NO_MULTIPART_BODY_FAILURE(lib);
}

static int _cffi_const_ASN1_R_UNKNOWN_MESSAGE_DIGEST_ALGORITHM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_UNKNOWN_MESSAGE_DIGEST_ALGORITHM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_UNKNOWN_MESSAGE_DIGEST_ALGORITHM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_NO_MULTIPART_BOUNDARY(lib);
}

static int _cffi_const_ASN1_R_UNKNOWN_OBJECT_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_UNKNOWN_OBJECT_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_UNKNOWN_OBJECT_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_UNKNOWN_MESSAGE_DIGEST_ALGORITHM(lib);
}

static int _cffi_const_ASN1_R_UNKNOWN_PUBLIC_KEY_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_UNKNOWN_PUBLIC_KEY_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_UNKNOWN_PUBLIC_KEY_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_UNKNOWN_OBJECT_TYPE(lib);
}

static int _cffi_const_ASN1_R_UNKNOWN_TAG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_UNKNOWN_TAG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_UNKNOWN_TAG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_UNKNOWN_PUBLIC_KEY_TYPE(lib);
}

static int _cffi_const_ASN1_R_UNKOWN_FORMAT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_UNKOWN_FORMAT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_UNKOWN_FORMAT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_UNKNOWN_TAG(lib);
}

static int _cffi_const_ASN1_R_UNSUPPORTED_ANY_DEFINED_BY_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_UNSUPPORTED_ANY_DEFINED_BY_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_UNSUPPORTED_ANY_DEFINED_BY_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_UNKOWN_FORMAT(lib);
}

static int _cffi_const_ASN1_R_UNSUPPORTED_ENCRYPTION_ALGORITHM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_UNSUPPORTED_ENCRYPTION_ALGORITHM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_UNSUPPORTED_ENCRYPTION_ALGORITHM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_UNSUPPORTED_ANY_DEFINED_BY_TYPE(lib);
}

static int _cffi_const_ASN1_R_UNSUPPORTED_PUBLIC_KEY_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_UNSUPPORTED_PUBLIC_KEY_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_UNSUPPORTED_PUBLIC_KEY_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_UNSUPPORTED_ENCRYPTION_ALGORITHM(lib);
}

static int _cffi_const_ASN1_R_UNSUPPORTED_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_UNSUPPORTED_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_UNSUPPORTED_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_UNSUPPORTED_PUBLIC_KEY_TYPE(lib);
}

static int _cffi_const_ASN1_R_WRONG_TAG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_WRONG_TAG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_WRONG_TAG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_UNSUPPORTED_TYPE(lib);
}

static int _cffi_const_ASN1_R_WRONG_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ASN1_R_WRONG_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ASN1_R_WRONG_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_WRONG_TAG(lib);
}

static int _cffi_const_BIO_CLOSE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_CLOSE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_CLOSE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ASN1_R_WRONG_TYPE(lib);
}

static int _cffi_const_BIO_CTRL_DUP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_CTRL_DUP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_CTRL_DUP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_CLOSE(lib);
}

static int _cffi_const_BIO_CTRL_EOF(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_CTRL_EOF);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_CTRL_EOF", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_CTRL_DUP(lib);
}

static int _cffi_const_BIO_CTRL_FLUSH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_CTRL_FLUSH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_CTRL_FLUSH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_CTRL_EOF(lib);
}

static int _cffi_const_BIO_CTRL_GET(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_CTRL_GET);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_CTRL_GET", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_CTRL_FLUSH(lib);
}

static int _cffi_const_BIO_CTRL_GET_CLOSE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_CTRL_GET_CLOSE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_CTRL_GET_CLOSE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_CTRL_GET(lib);
}

static int _cffi_const_BIO_CTRL_INFO(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_CTRL_INFO);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_CTRL_INFO", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_CTRL_GET_CLOSE(lib);
}

static int _cffi_const_BIO_CTRL_PENDING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_CTRL_PENDING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_CTRL_PENDING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_CTRL_INFO(lib);
}

static int _cffi_const_BIO_CTRL_RESET(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_CTRL_RESET);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_CTRL_RESET", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_CTRL_PENDING(lib);
}

static int _cffi_const_BIO_CTRL_SET(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_CTRL_SET);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_CTRL_SET", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_CTRL_RESET(lib);
}

static int _cffi_const_BIO_CTRL_SET_CLOSE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_CTRL_SET_CLOSE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_CTRL_SET_CLOSE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_CTRL_SET(lib);
}

static int _cffi_const_BIO_CTRL_WPENDING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_CTRL_WPENDING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_CTRL_WPENDING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_CTRL_SET_CLOSE(lib);
}

static int _cffi_const_BIO_C_FILE_SEEK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_C_FILE_SEEK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_C_FILE_SEEK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_CTRL_WPENDING(lib);
}

static int _cffi_const_BIO_C_FILE_TELL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_C_FILE_TELL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_C_FILE_TELL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_C_FILE_SEEK(lib);
}

static int _cffi_const_BIO_FLAGS_IO_SPECIAL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_FLAGS_IO_SPECIAL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_FLAGS_IO_SPECIAL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_C_FILE_TELL(lib);
}

static int _cffi_const_BIO_FLAGS_READ(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_FLAGS_READ);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_FLAGS_READ", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_FLAGS_IO_SPECIAL(lib);
}

static int _cffi_const_BIO_FLAGS_RWS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_FLAGS_RWS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_FLAGS_RWS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_FLAGS_READ(lib);
}

static int _cffi_const_BIO_FLAGS_SHOULD_RETRY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_FLAGS_SHOULD_RETRY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_FLAGS_SHOULD_RETRY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_FLAGS_RWS(lib);
}

static int _cffi_const_BIO_FLAGS_WRITE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_FLAGS_WRITE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_FLAGS_WRITE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_FLAGS_SHOULD_RETRY(lib);
}

static int _cffi_const_BIO_NOCLOSE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_NOCLOSE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_NOCLOSE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_FLAGS_WRITE(lib);
}

static int _cffi_const_BIO_TYPE_ACCEPT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_ACCEPT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_ACCEPT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_NOCLOSE(lib);
}

static int _cffi_const_BIO_TYPE_BASE64(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_BASE64);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_BASE64", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_ACCEPT(lib);
}

static int _cffi_const_BIO_TYPE_BER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_BER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_BER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_BASE64(lib);
}

static int _cffi_const_BIO_TYPE_BIO(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_BIO);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_BIO", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_BER(lib);
}

static int _cffi_const_BIO_TYPE_BUFFER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_BUFFER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_BUFFER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_BIO(lib);
}

static int _cffi_const_BIO_TYPE_CIPHER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_CIPHER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_CIPHER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_BUFFER(lib);
}

static int _cffi_const_BIO_TYPE_CONNECT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_CONNECT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_CONNECT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_CIPHER(lib);
}

static int _cffi_const_BIO_TYPE_DESCRIPTOR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_DESCRIPTOR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_DESCRIPTOR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_CONNECT(lib);
}

static int _cffi_const_BIO_TYPE_FD(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_FD);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_FD", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_DESCRIPTOR(lib);
}

static int _cffi_const_BIO_TYPE_FILE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_FILE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_FILE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_FD(lib);
}

static int _cffi_const_BIO_TYPE_FILTER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_FILTER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_FILTER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_FILE(lib);
}

static int _cffi_const_BIO_TYPE_MD(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_MD);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_MD", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_FILTER(lib);
}

static int _cffi_const_BIO_TYPE_MEM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_MEM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_MEM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_MD(lib);
}

static int _cffi_const_BIO_TYPE_NBIO_TEST(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_NBIO_TEST);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_NBIO_TEST", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_MEM(lib);
}

static int _cffi_const_BIO_TYPE_NONE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_NONE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_NONE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_NBIO_TEST(lib);
}

static int _cffi_const_BIO_TYPE_NULL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_NULL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_NULL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_NONE(lib);
}

static int _cffi_const_BIO_TYPE_NULL_FILTER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_NULL_FILTER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_NULL_FILTER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_NULL(lib);
}

static int _cffi_const_BIO_TYPE_PROXY_CLIENT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_PROXY_CLIENT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_PROXY_CLIENT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_NULL_FILTER(lib);
}

static int _cffi_const_BIO_TYPE_PROXY_SERVER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_PROXY_SERVER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_PROXY_SERVER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_PROXY_CLIENT(lib);
}

static int _cffi_const_BIO_TYPE_SOCKET(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_SOCKET);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_SOCKET", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_PROXY_SERVER(lib);
}

static int _cffi_const_BIO_TYPE_SOURCE_SINK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_SOURCE_SINK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_SOURCE_SINK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_SOCKET(lib);
}

static int _cffi_const_BIO_TYPE_SSL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(BIO_TYPE_SSL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "BIO_TYPE_SSL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_SOURCE_SINK(lib);
}

static int _cffi_const_CMS_BINARY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_BINARY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_BINARY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_BIO_TYPE_SSL(lib);
}

static int _cffi_const_CMS_CRLFEOL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_CRLFEOL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_CRLFEOL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_BINARY(lib);
}

static int _cffi_const_CMS_DEBUG_DECRYPT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_DEBUG_DECRYPT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_DEBUG_DECRYPT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_CRLFEOL(lib);
}

static int _cffi_const_CMS_DETACHED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_DETACHED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_DETACHED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_DEBUG_DECRYPT(lib);
}

static int _cffi_const_CMS_NOATTR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_NOATTR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_NOATTR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_DETACHED(lib);
}

static int _cffi_const_CMS_NOCERTS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_NOCERTS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_NOCERTS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_NOATTR(lib);
}

static int _cffi_const_CMS_NOCRL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_NOCRL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_NOCRL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_NOCERTS(lib);
}

static int _cffi_const_CMS_NOINTERN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_NOINTERN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_NOINTERN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_NOCRL(lib);
}

static int _cffi_const_CMS_NOOLDMIMETYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_NOOLDMIMETYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_NOOLDMIMETYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_NOINTERN(lib);
}

static int _cffi_const_CMS_NOSIGS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_NOSIGS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_NOSIGS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_NOOLDMIMETYPE(lib);
}

static int _cffi_const_CMS_NOSMIMECAP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_NOSMIMECAP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_NOSMIMECAP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_NOSIGS(lib);
}

static int _cffi_const_CMS_NOVERIFY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_NOVERIFY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_NOVERIFY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_NOSMIMECAP(lib);
}

static int _cffi_const_CMS_NO_ATTR_VERIFY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_NO_ATTR_VERIFY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_NO_ATTR_VERIFY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_NOVERIFY(lib);
}

static int _cffi_const_CMS_NO_CONTENT_VERIFY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_NO_CONTENT_VERIFY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_NO_CONTENT_VERIFY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_NO_ATTR_VERIFY(lib);
}

static int _cffi_const_CMS_NO_SIGNER_CERT_VERIFY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_NO_SIGNER_CERT_VERIFY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_NO_SIGNER_CERT_VERIFY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_NO_CONTENT_VERIFY(lib);
}

static int _cffi_const_CMS_PARTIAL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_PARTIAL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_PARTIAL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_NO_SIGNER_CERT_VERIFY(lib);
}

static int _cffi_const_CMS_REUSE_DIGEST(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_REUSE_DIGEST);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_REUSE_DIGEST", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_PARTIAL(lib);
}

static int _cffi_const_CMS_STREAM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_STREAM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_STREAM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_REUSE_DIGEST(lib);
}

static int _cffi_const_CMS_TEXT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_TEXT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_TEXT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_STREAM(lib);
}

static int _cffi_const_CMS_USE_KEYID(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CMS_USE_KEYID);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CMS_USE_KEYID", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_TEXT(lib);
}

static int _cffi_const_CRYPTO_LOCK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CRYPTO_LOCK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CRYPTO_LOCK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CMS_USE_KEYID(lib);
}

static int _cffi_const_CRYPTO_LOCK_SSL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CRYPTO_LOCK_SSL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CRYPTO_LOCK_SSL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CRYPTO_LOCK(lib);
}

static int _cffi_const_CRYPTO_MEM_CHECK_DISABLE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CRYPTO_MEM_CHECK_DISABLE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CRYPTO_MEM_CHECK_DISABLE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CRYPTO_LOCK_SSL(lib);
}

static int _cffi_const_CRYPTO_MEM_CHECK_ENABLE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CRYPTO_MEM_CHECK_ENABLE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CRYPTO_MEM_CHECK_ENABLE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CRYPTO_MEM_CHECK_DISABLE(lib);
}

static int _cffi_const_CRYPTO_MEM_CHECK_OFF(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CRYPTO_MEM_CHECK_OFF);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CRYPTO_MEM_CHECK_OFF", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CRYPTO_MEM_CHECK_ENABLE(lib);
}

static int _cffi_const_CRYPTO_MEM_CHECK_ON(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CRYPTO_MEM_CHECK_ON);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CRYPTO_MEM_CHECK_ON", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CRYPTO_MEM_CHECK_OFF(lib);
}

static int _cffi_const_CRYPTO_READ(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CRYPTO_READ);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CRYPTO_READ", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CRYPTO_MEM_CHECK_ON(lib);
}

static int _cffi_const_CRYPTO_UNLOCK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CRYPTO_UNLOCK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CRYPTO_UNLOCK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CRYPTO_READ(lib);
}

static int _cffi_const_CRYPTO_WRITE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(CRYPTO_WRITE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "CRYPTO_WRITE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CRYPTO_UNLOCK(lib);
}

static int _cffi_const_Cryptography_HAS_098C_CAMELLIA_CODES(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_098C_CAMELLIA_CODES);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_098C_CAMELLIA_CODES", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_CRYPTO_WRITE(lib);
}

static int _cffi_const_Cryptography_HAS_098H_ERROR_CODES(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_098H_ERROR_CODES);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_098H_ERROR_CODES", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_098C_CAMELLIA_CODES(lib);
}

static int _cffi_const_Cryptography_HAS_100_VERIFICATION_ERROR_CODES(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_100_VERIFICATION_ERROR_CODES);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_100_VERIFICATION_ERROR_CODES", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_098H_ERROR_CODES(lib);
}

static int _cffi_const_Cryptography_HAS_100_VERIFICATION_PARAMS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_100_VERIFICATION_PARAMS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_100_VERIFICATION_PARAMS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_100_VERIFICATION_ERROR_CODES(lib);
}

static int _cffi_const_Cryptography_HAS_102_VERIFICATION_ERROR_CODES(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_102_VERIFICATION_ERROR_CODES);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_102_VERIFICATION_ERROR_CODES", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_100_VERIFICATION_PARAMS(lib);
}

static int _cffi_const_Cryptography_HAS_102_VERIFICATION_PARAMS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_102_VERIFICATION_PARAMS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_102_VERIFICATION_PARAMS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_102_VERIFICATION_ERROR_CODES(lib);
}

static int _cffi_const_Cryptography_HAS_AES_WRAP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_AES_WRAP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_AES_WRAP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_102_VERIFICATION_PARAMS(lib);
}

static int _cffi_const_Cryptography_HAS_ALPN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_ALPN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_ALPN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_AES_WRAP(lib);
}

static int _cffi_const_Cryptography_HAS_CMAC(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_CMAC);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_CMAC", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_ALPN(lib);
}

static int _cffi_const_Cryptography_HAS_CMS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_CMS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_CMS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_CMAC(lib);
}

static int _cffi_const_Cryptography_HAS_COMPRESSION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_COMPRESSION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_COMPRESSION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_CMS(lib);
}

static int _cffi_const_Cryptography_HAS_EC(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_EC);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_EC", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_COMPRESSION(lib);
}

static int _cffi_const_Cryptography_HAS_EC2M(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_EC2M);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_EC2M", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_EC(lib);
}

static int _cffi_const_Cryptography_HAS_ECDH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_ECDH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_ECDH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_EC2M(lib);
}

static int _cffi_const_Cryptography_HAS_ECDSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_ECDSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_ECDSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_ECDH(lib);
}

static int _cffi_const_Cryptography_HAS_ECDSA_SHA2_NIDS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_ECDSA_SHA2_NIDS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_ECDSA_SHA2_NIDS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_ECDSA(lib);
}

static int _cffi_const_Cryptography_HAS_EC_1_0_1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_EC_1_0_1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_EC_1_0_1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_ECDSA_SHA2_NIDS(lib);
}

static int _cffi_const_Cryptography_HAS_EC_1_0_2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_EC_1_0_2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_EC_1_0_2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_EC_1_0_1(lib);
}

static int _cffi_const_Cryptography_HAS_EC_CODES(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_EC_CODES);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_EC_CODES", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_EC_1_0_2(lib);
}

static int _cffi_const_Cryptography_HAS_EC_NISTP_64_GCC_128(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_EC_NISTP_64_GCC_128);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_EC_NISTP_64_GCC_128", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_EC_CODES(lib);
}

static int _cffi_const_Cryptography_HAS_EGD(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_EGD);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_EGD", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_EC_NISTP_64_GCC_128(lib);
}

static int _cffi_const_Cryptography_HAS_ENGINE_CRYPTODEV(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_ENGINE_CRYPTODEV);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_ENGINE_CRYPTODEV", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_EGD(lib);
}

static int _cffi_const_Cryptography_HAS_GCM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_GCM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_GCM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_ENGINE_CRYPTODEV(lib);
}

static int _cffi_const_Cryptography_HAS_GET_SERVER_TMP_KEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_GET_SERVER_TMP_KEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_GET_SERVER_TMP_KEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_GCM(lib);
}

static int _cffi_const_Cryptography_HAS_MGF1_MD(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_MGF1_MD);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_MGF1_MD", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_GET_SERVER_TMP_KEY(lib);
}

static int _cffi_const_Cryptography_HAS_NETBSD_D1_METH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_NETBSD_D1_METH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_NETBSD_D1_METH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_MGF1_MD(lib);
}

static int _cffi_const_Cryptography_HAS_NEXTPROTONEG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_NEXTPROTONEG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_NEXTPROTONEG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_NETBSD_D1_METH(lib);
}

static int _cffi_const_Cryptography_HAS_OP_NO_COMPRESSION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_OP_NO_COMPRESSION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_OP_NO_COMPRESSION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_NEXTPROTONEG(lib);
}

static int _cffi_const_Cryptography_HAS_PBKDF2_HMAC(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_PBKDF2_HMAC);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_PBKDF2_HMAC", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_OP_NO_COMPRESSION(lib);
}

static int _cffi_const_Cryptography_HAS_PKEY_CTX(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_PKEY_CTX);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_PKEY_CTX", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_PBKDF2_HMAC(lib);
}

static int _cffi_const_Cryptography_HAS_PSS_PADDING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_PSS_PADDING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_PSS_PADDING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_PKEY_CTX(lib);
}

static int _cffi_const_Cryptography_HAS_RELEASE_BUFFERS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_RELEASE_BUFFERS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_RELEASE_BUFFERS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_PSS_PADDING(lib);
}

static int _cffi_const_Cryptography_HAS_REMOVE_THREAD_STATE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_REMOVE_THREAD_STATE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_REMOVE_THREAD_STATE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_RELEASE_BUFFERS(lib);
}

static int _cffi_const_Cryptography_HAS_RSA_R_PKCS_DECODING_ERROR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_RSA_R_PKCS_DECODING_ERROR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_RSA_R_PKCS_DECODING_ERROR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_REMOVE_THREAD_STATE(lib);
}

static int _cffi_const_Cryptography_HAS_SECURE_RENEGOTIATION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_SECURE_RENEGOTIATION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_SECURE_RENEGOTIATION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_RSA_R_PKCS_DECODING_ERROR(lib);
}

static int _cffi_const_Cryptography_HAS_SSL2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_SSL2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_SSL2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_SECURE_RENEGOTIATION(lib);
}

static int _cffi_const_Cryptography_HAS_SSL3_METHOD(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_SSL3_METHOD);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_SSL3_METHOD", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_SSL2(lib);
}

static int _cffi_const_Cryptography_HAS_SSL_OP_MSIE_SSLV2_RSA_PADDING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_SSL_OP_MSIE_SSLV2_RSA_PADDING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_SSL_OP_MSIE_SSLV2_RSA_PADDING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_SSL3_METHOD(lib);
}

static int _cffi_const_Cryptography_HAS_SSL_OP_NO_TICKET(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_SSL_OP_NO_TICKET);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_SSL_OP_NO_TICKET", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_SSL_OP_MSIE_SSLV2_RSA_PADDING(lib);
}

static int _cffi_const_Cryptography_HAS_SSL_SET_SSL_CTX(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_SSL_SET_SSL_CTX);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_SSL_SET_SSL_CTX", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_SSL_OP_NO_TICKET(lib);
}

static int _cffi_const_Cryptography_HAS_STATUS_REQ_OCSP_RESP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_STATUS_REQ_OCSP_RESP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_STATUS_REQ_OCSP_RESP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_SSL_SET_SSL_CTX(lib);
}

static int _cffi_const_Cryptography_HAS_TLSEXT_HOSTNAME(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_TLSEXT_HOSTNAME);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_TLSEXT_HOSTNAME", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_STATUS_REQ_OCSP_RESP(lib);
}

static int _cffi_const_Cryptography_HAS_TLSEXT_STATUS_REQ_CB(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_TLSEXT_STATUS_REQ_CB);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_TLSEXT_STATUS_REQ_CB", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_TLSEXT_HOSTNAME(lib);
}

static int _cffi_const_Cryptography_HAS_TLSEXT_STATUS_REQ_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_TLSEXT_STATUS_REQ_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_TLSEXT_STATUS_REQ_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_TLSEXT_STATUS_REQ_CB(lib);
}

static int _cffi_const_Cryptography_HAS_TLSv1_1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_TLSv1_1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_TLSv1_1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_TLSEXT_STATUS_REQ_TYPE(lib);
}

static int _cffi_const_Cryptography_HAS_TLSv1_2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_TLSv1_2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_TLSv1_2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_TLSv1_1(lib);
}

static int _cffi_const_Cryptography_HAS_X509_V_FLAG_CHECK_SS_SIGNATURE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_X509_V_FLAG_CHECK_SS_SIGNATURE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_X509_V_FLAG_CHECK_SS_SIGNATURE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_TLSv1_2(lib);
}

static int _cffi_const_Cryptography_HAS_X509_V_FLAG_PARTIAL_CHAIN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_X509_V_FLAG_PARTIAL_CHAIN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_X509_V_FLAG_PARTIAL_CHAIN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_X509_V_FLAG_CHECK_SS_SIGNATURE(lib);
}

static int _cffi_const_Cryptography_HAS_X509_V_FLAG_TRUSTED_FIRST(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(Cryptography_HAS_X509_V_FLAG_TRUSTED_FIRST);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_HAS_X509_V_FLAG_TRUSTED_FIRST", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_X509_V_FLAG_PARTIAL_CHAIN(lib);
}

static int _cffi_const_Cryptography_osrandom_engine_id(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (Cryptography_osrandom_engine_id);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_osrandom_engine_id", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_HAS_X509_V_FLAG_TRUSTED_FIRST(lib);
}

static int _cffi_const_Cryptography_osrandom_engine_name(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (Cryptography_osrandom_engine_name);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "Cryptography_osrandom_engine_name", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_osrandom_engine_id(lib);
}

static int _cffi_const_DH_F_COMPUTE_KEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(DH_F_COMPUTE_KEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "DH_F_COMPUTE_KEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_Cryptography_osrandom_engine_name(lib);
}

static int _cffi_const_DH_R_INVALID_PUBKEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(DH_R_INVALID_PUBKEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "DH_R_INVALID_PUBKEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_DH_F_COMPUTE_KEY(lib);
}

static int _cffi_const_EC_F_EC_GROUP_NEW_BY_CURVE_NAME(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EC_F_EC_GROUP_NEW_BY_CURVE_NAME);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EC_F_EC_GROUP_NEW_BY_CURVE_NAME", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_DH_R_INVALID_PUBKEY(lib);
}

static int _cffi_const_EC_R_UNKNOWN_GROUP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EC_R_UNKNOWN_GROUP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EC_R_UNKNOWN_GROUP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EC_F_EC_GROUP_NEW_BY_CURVE_NAME(lib);
}

static int _cffi_const_ENGINE_METHOD_ALL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ENGINE_METHOD_ALL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ENGINE_METHOD_ALL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EC_R_UNKNOWN_GROUP(lib);
}

static int _cffi_const_ENGINE_METHOD_CIPHERS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ENGINE_METHOD_CIPHERS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ENGINE_METHOD_CIPHERS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ENGINE_METHOD_ALL(lib);
}

static int _cffi_const_ENGINE_METHOD_DIGESTS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ENGINE_METHOD_DIGESTS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ENGINE_METHOD_DIGESTS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ENGINE_METHOD_CIPHERS(lib);
}

static int _cffi_const_ENGINE_METHOD_DSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ENGINE_METHOD_DSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ENGINE_METHOD_DSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ENGINE_METHOD_DIGESTS(lib);
}

static int _cffi_const_ENGINE_METHOD_ECDH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ENGINE_METHOD_ECDH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ENGINE_METHOD_ECDH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ENGINE_METHOD_DSA(lib);
}

static int _cffi_const_ENGINE_METHOD_ECDSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ENGINE_METHOD_ECDSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ENGINE_METHOD_ECDSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ENGINE_METHOD_ECDH(lib);
}

static int _cffi_const_ENGINE_METHOD_NONE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ENGINE_METHOD_NONE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ENGINE_METHOD_NONE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ENGINE_METHOD_ECDSA(lib);
}

static int _cffi_const_ENGINE_METHOD_RAND(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ENGINE_METHOD_RAND);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ENGINE_METHOD_RAND", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ENGINE_METHOD_NONE(lib);
}

static int _cffi_const_ENGINE_METHOD_RSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ENGINE_METHOD_RSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ENGINE_METHOD_RSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ENGINE_METHOD_RAND(lib);
}

static int _cffi_const_ENGINE_METHOD_STORE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ENGINE_METHOD_STORE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ENGINE_METHOD_STORE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ENGINE_METHOD_RSA(lib);
}

static int _cffi_const_ERR_LIB_ASN1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ERR_LIB_ASN1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ERR_LIB_ASN1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ENGINE_METHOD_STORE(lib);
}

static int _cffi_const_ERR_LIB_DH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ERR_LIB_DH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ERR_LIB_DH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ERR_LIB_ASN1(lib);
}

static int _cffi_const_ERR_LIB_EC(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ERR_LIB_EC);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ERR_LIB_EC", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ERR_LIB_DH(lib);
}

static int _cffi_const_ERR_LIB_EVP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ERR_LIB_EVP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ERR_LIB_EVP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ERR_LIB_EC(lib);
}

static int _cffi_const_ERR_LIB_PEM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ERR_LIB_PEM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ERR_LIB_PEM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ERR_LIB_EVP(lib);
}

static int _cffi_const_ERR_LIB_PKCS12(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ERR_LIB_PKCS12);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ERR_LIB_PKCS12", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ERR_LIB_PEM(lib);
}

static int _cffi_const_ERR_LIB_RSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(ERR_LIB_RSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ERR_LIB_RSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ERR_LIB_PKCS12(lib);
}

static int _cffi_const_EVP_CTRL_GCM_GET_TAG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_CTRL_GCM_GET_TAG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_CTRL_GCM_GET_TAG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_ERR_LIB_RSA(lib);
}

static int _cffi_const_EVP_CTRL_GCM_SET_IVLEN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_CTRL_GCM_SET_IVLEN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_CTRL_GCM_SET_IVLEN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_CTRL_GCM_GET_TAG(lib);
}

static int _cffi_const_EVP_CTRL_GCM_SET_TAG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_CTRL_GCM_SET_TAG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_CTRL_GCM_SET_TAG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_CTRL_GCM_SET_IVLEN(lib);
}

static int _cffi_const_EVP_F_AES_INIT_KEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_AES_INIT_KEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_AES_INIT_KEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_CTRL_GCM_SET_TAG(lib);
}

static int _cffi_const_EVP_F_CAMELLIA_INIT_KEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_CAMELLIA_INIT_KEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_CAMELLIA_INIT_KEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_AES_INIT_KEY(lib);
}

static int _cffi_const_EVP_F_D2I_PKEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_D2I_PKEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_D2I_PKEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_CAMELLIA_INIT_KEY(lib);
}

static int _cffi_const_EVP_F_DSAPKEY2PKCS8(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_DSAPKEY2PKCS8);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_DSAPKEY2PKCS8", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_D2I_PKEY(lib);
}

static int _cffi_const_EVP_F_DSA_PKEY2PKCS8(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_DSA_PKEY2PKCS8);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_DSA_PKEY2PKCS8", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_DSAPKEY2PKCS8(lib);
}

static int _cffi_const_EVP_F_ECDSA_PKEY2PKCS8(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_ECDSA_PKEY2PKCS8);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_ECDSA_PKEY2PKCS8", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_DSA_PKEY2PKCS8(lib);
}

static int _cffi_const_EVP_F_ECKEY_PKEY2PKCS8(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_ECKEY_PKEY2PKCS8);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_ECKEY_PKEY2PKCS8", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_ECDSA_PKEY2PKCS8(lib);
}

static int _cffi_const_EVP_F_EVP_CIPHERINIT_EX(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_CIPHERINIT_EX);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_CIPHERINIT_EX", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_ECKEY_PKEY2PKCS8(lib);
}

static int _cffi_const_EVP_F_EVP_CIPHER_CTX_CTRL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_CIPHER_CTX_CTRL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_CIPHER_CTX_CTRL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_CIPHERINIT_EX(lib);
}

static int _cffi_const_EVP_F_EVP_CIPHER_CTX_SET_KEY_LENGTH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_CIPHER_CTX_SET_KEY_LENGTH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_CIPHER_CTX_SET_KEY_LENGTH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_CIPHER_CTX_CTRL(lib);
}

static int _cffi_const_EVP_F_EVP_DECRYPTFINAL_EX(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_DECRYPTFINAL_EX);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_DECRYPTFINAL_EX", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_CIPHER_CTX_SET_KEY_LENGTH(lib);
}

static int _cffi_const_EVP_F_EVP_DIGESTINIT_EX(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_DIGESTINIT_EX);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_DIGESTINIT_EX", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_DECRYPTFINAL_EX(lib);
}

static int _cffi_const_EVP_F_EVP_ENCRYPTFINAL_EX(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_ENCRYPTFINAL_EX);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_ENCRYPTFINAL_EX", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_DIGESTINIT_EX(lib);
}

static int _cffi_const_EVP_F_EVP_MD_CTX_COPY_EX(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_MD_CTX_COPY_EX);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_MD_CTX_COPY_EX", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_ENCRYPTFINAL_EX(lib);
}

static int _cffi_const_EVP_F_EVP_OPENINIT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_OPENINIT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_OPENINIT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_MD_CTX_COPY_EX(lib);
}

static int _cffi_const_EVP_F_EVP_PBE_ALG_ADD(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_PBE_ALG_ADD);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_PBE_ALG_ADD", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_OPENINIT(lib);
}

static int _cffi_const_EVP_F_EVP_PBE_CIPHERINIT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_PBE_CIPHERINIT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_PBE_CIPHERINIT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_PBE_ALG_ADD(lib);
}

static int _cffi_const_EVP_F_EVP_PKCS82PKEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_PKCS82PKEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_PKCS82PKEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_PBE_CIPHERINIT(lib);
}

static int _cffi_const_EVP_F_EVP_PKEY2PKCS8_BROKEN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_PKEY2PKCS8_BROKEN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_PKEY2PKCS8_BROKEN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_PKCS82PKEY(lib);
}

static int _cffi_const_EVP_F_EVP_PKEY_COPY_PARAMETERS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_PKEY_COPY_PARAMETERS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_PKEY_COPY_PARAMETERS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_PKEY2PKCS8_BROKEN(lib);
}

static int _cffi_const_EVP_F_EVP_PKEY_DECRYPT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_PKEY_DECRYPT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_PKEY_DECRYPT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_PKEY_COPY_PARAMETERS(lib);
}

static int _cffi_const_EVP_F_EVP_PKEY_ENCRYPT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_PKEY_ENCRYPT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_PKEY_ENCRYPT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_PKEY_DECRYPT(lib);
}

static int _cffi_const_EVP_F_EVP_PKEY_GET1_DH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_PKEY_GET1_DH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_PKEY_GET1_DH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_PKEY_ENCRYPT(lib);
}

static int _cffi_const_EVP_F_EVP_PKEY_GET1_DSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_PKEY_GET1_DSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_PKEY_GET1_DSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_PKEY_GET1_DH(lib);
}

static int _cffi_const_EVP_F_EVP_PKEY_GET1_ECDSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_PKEY_GET1_ECDSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_PKEY_GET1_ECDSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_PKEY_GET1_DSA(lib);
}

static int _cffi_const_EVP_F_EVP_PKEY_GET1_EC_KEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_PKEY_GET1_EC_KEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_PKEY_GET1_EC_KEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_PKEY_GET1_ECDSA(lib);
}

static int _cffi_const_EVP_F_EVP_PKEY_GET1_RSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_PKEY_GET1_RSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_PKEY_GET1_RSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_PKEY_GET1_EC_KEY(lib);
}

static int _cffi_const_EVP_F_EVP_PKEY_NEW(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_PKEY_NEW);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_PKEY_NEW", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_PKEY_GET1_RSA(lib);
}

static int _cffi_const_EVP_F_EVP_RIJNDAEL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_RIJNDAEL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_RIJNDAEL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_PKEY_NEW(lib);
}

static int _cffi_const_EVP_F_EVP_SIGNFINAL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_SIGNFINAL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_SIGNFINAL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_RIJNDAEL(lib);
}

static int _cffi_const_EVP_F_EVP_VERIFYFINAL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_EVP_VERIFYFINAL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_EVP_VERIFYFINAL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_SIGNFINAL(lib);
}

static int _cffi_const_EVP_F_PKCS5_PBE_KEYIVGEN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_PKCS5_PBE_KEYIVGEN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_PKCS5_PBE_KEYIVGEN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_EVP_VERIFYFINAL(lib);
}

static int _cffi_const_EVP_F_PKCS5_V2_PBE_KEYIVGEN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_PKCS5_V2_PBE_KEYIVGEN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_PKCS5_V2_PBE_KEYIVGEN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_PKCS5_PBE_KEYIVGEN(lib);
}

static int _cffi_const_EVP_F_PKCS8_SET_BROKEN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_PKCS8_SET_BROKEN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_PKCS8_SET_BROKEN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_PKCS5_V2_PBE_KEYIVGEN(lib);
}

static int _cffi_const_EVP_F_RC2_MAGIC_TO_METH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_RC2_MAGIC_TO_METH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_RC2_MAGIC_TO_METH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_PKCS8_SET_BROKEN(lib);
}

static int _cffi_const_EVP_F_RC5_CTRL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_F_RC5_CTRL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_F_RC5_CTRL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_RC2_MAGIC_TO_METH(lib);
}

static int _cffi_const_EVP_MAX_MD_SIZE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_MAX_MD_SIZE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_MAX_MD_SIZE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_F_RC5_CTRL(lib);
}

static int _cffi_const_EVP_PKEY_DH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_PKEY_DH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_PKEY_DH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_MAX_MD_SIZE(lib);
}

static int _cffi_const_EVP_PKEY_DSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_PKEY_DSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_PKEY_DSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_PKEY_DH(lib);
}

static int _cffi_const_EVP_PKEY_EC(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_PKEY_EC);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_PKEY_EC", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_PKEY_DSA(lib);
}

static int _cffi_const_EVP_PKEY_RSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_PKEY_RSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_PKEY_RSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_PKEY_EC(lib);
}

static int _cffi_const_EVP_R_AES_KEY_SETUP_FAILED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_AES_KEY_SETUP_FAILED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_AES_KEY_SETUP_FAILED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_PKEY_RSA(lib);
}

static int _cffi_const_EVP_R_ASN1_LIB(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_ASN1_LIB);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_ASN1_LIB", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_AES_KEY_SETUP_FAILED(lib);
}

static int _cffi_const_EVP_R_BAD_BLOCK_LENGTH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_BAD_BLOCK_LENGTH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_BAD_BLOCK_LENGTH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_ASN1_LIB(lib);
}

static int _cffi_const_EVP_R_BAD_DECRYPT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_BAD_DECRYPT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_BAD_DECRYPT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_BAD_BLOCK_LENGTH(lib);
}

static int _cffi_const_EVP_R_BAD_KEY_LENGTH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_BAD_KEY_LENGTH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_BAD_KEY_LENGTH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_BAD_DECRYPT(lib);
}

static int _cffi_const_EVP_R_BN_DECODE_ERROR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_BN_DECODE_ERROR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_BN_DECODE_ERROR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_BAD_KEY_LENGTH(lib);
}

static int _cffi_const_EVP_R_BN_PUBKEY_ERROR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_BN_PUBKEY_ERROR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_BN_PUBKEY_ERROR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_BN_DECODE_ERROR(lib);
}

static int _cffi_const_EVP_R_CAMELLIA_KEY_SETUP_FAILED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_CAMELLIA_KEY_SETUP_FAILED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_CAMELLIA_KEY_SETUP_FAILED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_BN_PUBKEY_ERROR(lib);
}

static int _cffi_const_EVP_R_CIPHER_PARAMETER_ERROR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_CIPHER_PARAMETER_ERROR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_CIPHER_PARAMETER_ERROR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_CAMELLIA_KEY_SETUP_FAILED(lib);
}

static int _cffi_const_EVP_R_CTRL_NOT_IMPLEMENTED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_CTRL_NOT_IMPLEMENTED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_CTRL_NOT_IMPLEMENTED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_CIPHER_PARAMETER_ERROR(lib);
}

static int _cffi_const_EVP_R_CTRL_OPERATION_NOT_IMPLEMENTED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_CTRL_OPERATION_NOT_IMPLEMENTED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_CTRL_OPERATION_NOT_IMPLEMENTED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_CTRL_NOT_IMPLEMENTED(lib);
}

static int _cffi_const_EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_CTRL_OPERATION_NOT_IMPLEMENTED(lib);
}

static int _cffi_const_EVP_R_DECODE_ERROR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_DECODE_ERROR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_DECODE_ERROR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH(lib);
}

static int _cffi_const_EVP_R_DIFFERENT_KEY_TYPES(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_DIFFERENT_KEY_TYPES);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_DIFFERENT_KEY_TYPES", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_DECODE_ERROR(lib);
}

static int _cffi_const_EVP_R_ENCODE_ERROR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_ENCODE_ERROR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_ENCODE_ERROR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_DIFFERENT_KEY_TYPES(lib);
}

static int _cffi_const_EVP_R_INITIALIZATION_ERROR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_INITIALIZATION_ERROR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_INITIALIZATION_ERROR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_ENCODE_ERROR(lib);
}

static int _cffi_const_EVP_R_INPUT_NOT_INITIALIZED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_INPUT_NOT_INITIALIZED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_INPUT_NOT_INITIALIZED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_INITIALIZATION_ERROR(lib);
}

static int _cffi_const_EVP_R_INVALID_KEY_LENGTH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_INVALID_KEY_LENGTH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_INVALID_KEY_LENGTH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_INPUT_NOT_INITIALIZED(lib);
}

static int _cffi_const_EVP_R_IV_TOO_LARGE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_IV_TOO_LARGE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_IV_TOO_LARGE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_INVALID_KEY_LENGTH(lib);
}

static int _cffi_const_EVP_R_KEYGEN_FAILURE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_KEYGEN_FAILURE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_KEYGEN_FAILURE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_IV_TOO_LARGE(lib);
}

static int _cffi_const_EVP_R_MISSING_PARAMETERS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_MISSING_PARAMETERS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_MISSING_PARAMETERS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_KEYGEN_FAILURE(lib);
}

static int _cffi_const_EVP_R_NO_CIPHER_SET(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_NO_CIPHER_SET);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_NO_CIPHER_SET", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_MISSING_PARAMETERS(lib);
}

static int _cffi_const_EVP_R_NO_DIGEST_SET(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_NO_DIGEST_SET);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_NO_DIGEST_SET", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_NO_CIPHER_SET(lib);
}

static int _cffi_const_EVP_R_NO_DSA_PARAMETERS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_NO_DSA_PARAMETERS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_NO_DSA_PARAMETERS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_NO_DIGEST_SET(lib);
}

static int _cffi_const_EVP_R_NO_SIGN_FUNCTION_CONFIGURED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_NO_SIGN_FUNCTION_CONFIGURED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_NO_SIGN_FUNCTION_CONFIGURED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_NO_DSA_PARAMETERS(lib);
}

static int _cffi_const_EVP_R_NO_VERIFY_FUNCTION_CONFIGURED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_NO_VERIFY_FUNCTION_CONFIGURED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_NO_VERIFY_FUNCTION_CONFIGURED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_NO_SIGN_FUNCTION_CONFIGURED(lib);
}

static int _cffi_const_EVP_R_PKCS8_UNKNOWN_BROKEN_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_PKCS8_UNKNOWN_BROKEN_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_PKCS8_UNKNOWN_BROKEN_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_NO_VERIFY_FUNCTION_CONFIGURED(lib);
}

static int _cffi_const_EVP_R_PUBLIC_KEY_NOT_RSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_PUBLIC_KEY_NOT_RSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_PUBLIC_KEY_NOT_RSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_PKCS8_UNKNOWN_BROKEN_TYPE(lib);
}

static int _cffi_const_EVP_R_UNKNOWN_PBE_ALGORITHM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_UNKNOWN_PBE_ALGORITHM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_UNKNOWN_PBE_ALGORITHM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_PUBLIC_KEY_NOT_RSA(lib);
}

static int _cffi_const_EVP_R_UNSUPORTED_NUMBER_OF_ROUNDS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_UNSUPORTED_NUMBER_OF_ROUNDS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_UNSUPORTED_NUMBER_OF_ROUNDS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_UNKNOWN_PBE_ALGORITHM(lib);
}

static int _cffi_const_EVP_R_UNSUPPORTED_CIPHER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_UNSUPPORTED_CIPHER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_UNSUPPORTED_CIPHER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_UNSUPORTED_NUMBER_OF_ROUNDS(lib);
}

static int _cffi_const_EVP_R_UNSUPPORTED_KEYLENGTH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_UNSUPPORTED_KEYLENGTH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_UNSUPPORTED_KEYLENGTH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_UNSUPPORTED_CIPHER(lib);
}

static int _cffi_const_EVP_R_UNSUPPORTED_KEY_DERIVATION_FUNCTION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_UNSUPPORTED_KEY_DERIVATION_FUNCTION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_UNSUPPORTED_KEY_DERIVATION_FUNCTION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_UNSUPPORTED_KEYLENGTH(lib);
}

static int _cffi_const_EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_UNSUPPORTED_KEY_DERIVATION_FUNCTION(lib);
}

static int _cffi_const_EVP_R_UNSUPPORTED_SALT_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_UNSUPPORTED_SALT_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_UNSUPPORTED_SALT_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM(lib);
}

static int _cffi_const_EVP_R_WRONG_FINAL_BLOCK_LENGTH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_WRONG_FINAL_BLOCK_LENGTH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_WRONG_FINAL_BLOCK_LENGTH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_UNSUPPORTED_SALT_TYPE(lib);
}

static int _cffi_const_EVP_R_WRONG_PUBLIC_KEY_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(EVP_R_WRONG_PUBLIC_KEY_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "EVP_R_WRONG_PUBLIC_KEY_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_WRONG_FINAL_BLOCK_LENGTH(lib);
}

static int _cffi_const_GEN_DIRNAME(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(GEN_DIRNAME);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "GEN_DIRNAME", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_EVP_R_WRONG_PUBLIC_KEY_TYPE(lib);
}

static int _cffi_const_GEN_DNS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(GEN_DNS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "GEN_DNS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_GEN_DIRNAME(lib);
}

static int _cffi_const_GEN_EDIPARTY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(GEN_EDIPARTY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "GEN_EDIPARTY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_GEN_DNS(lib);
}

static int _cffi_const_GEN_EMAIL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(GEN_EMAIL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "GEN_EMAIL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_GEN_EDIPARTY(lib);
}

static int _cffi_const_GEN_IPADD(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(GEN_IPADD);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "GEN_IPADD", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_GEN_EMAIL(lib);
}

static int _cffi_const_GEN_OTHERNAME(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(GEN_OTHERNAME);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "GEN_OTHERNAME", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_GEN_IPADD(lib);
}

static int _cffi_const_GEN_RID(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(GEN_RID);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "GEN_RID", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_GEN_OTHERNAME(lib);
}

static int _cffi_const_GEN_URI(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(GEN_URI);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "GEN_URI", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_GEN_RID(lib);
}

static int _cffi_const_GEN_X400(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(GEN_X400);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "GEN_X400", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_GEN_URI(lib);
}

static int _cffi_const_MBSTRING_ASC(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(MBSTRING_ASC);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "MBSTRING_ASC", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_GEN_X400(lib);
}

static int _cffi_const_MBSTRING_BMP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(MBSTRING_BMP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "MBSTRING_BMP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_MBSTRING_ASC(lib);
}

static int _cffi_const_MBSTRING_FLAG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(MBSTRING_FLAG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "MBSTRING_FLAG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_MBSTRING_BMP(lib);
}

static int _cffi_const_MBSTRING_UNIV(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(MBSTRING_UNIV);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "MBSTRING_UNIV", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_MBSTRING_FLAG(lib);
}

static int _cffi_const_MBSTRING_UTF8(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(MBSTRING_UTF8);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "MBSTRING_UTF8", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_MBSTRING_UNIV(lib);
}

static int _cffi_const_NID_X9_62_c2onb191v4(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2onb191v4);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2onb191v4", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_MBSTRING_UTF8(lib);
}

static int _cffi_const_NID_X9_62_c2onb191v5(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2onb191v5);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2onb191v5", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2onb191v4(lib);
}

static int _cffi_const_NID_X9_62_c2onb239v4(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2onb239v4);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2onb239v4", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2onb191v5(lib);
}

static int _cffi_const_NID_X9_62_c2onb239v5(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2onb239v5);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2onb239v5", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2onb239v4(lib);
}

static int _cffi_const_NID_X9_62_c2pnb163v1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2pnb163v1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2pnb163v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2onb239v5(lib);
}

static int _cffi_const_NID_X9_62_c2pnb163v2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2pnb163v2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2pnb163v2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2pnb163v1(lib);
}

static int _cffi_const_NID_X9_62_c2pnb163v3(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2pnb163v3);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2pnb163v3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2pnb163v2(lib);
}

static int _cffi_const_NID_X9_62_c2pnb176v1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2pnb176v1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2pnb176v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2pnb163v3(lib);
}

static int _cffi_const_NID_X9_62_c2pnb208w1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2pnb208w1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2pnb208w1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2pnb176v1(lib);
}

static int _cffi_const_NID_X9_62_c2pnb272w1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2pnb272w1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2pnb272w1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2pnb208w1(lib);
}

static int _cffi_const_NID_X9_62_c2pnb304w1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2pnb304w1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2pnb304w1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2pnb272w1(lib);
}

static int _cffi_const_NID_X9_62_c2pnb368w1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2pnb368w1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2pnb368w1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2pnb304w1(lib);
}

static int _cffi_const_NID_X9_62_c2tnb191v1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2tnb191v1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2tnb191v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2pnb368w1(lib);
}

static int _cffi_const_NID_X9_62_c2tnb191v2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2tnb191v2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2tnb191v2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2tnb191v1(lib);
}

static int _cffi_const_NID_X9_62_c2tnb191v3(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2tnb191v3);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2tnb191v3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2tnb191v2(lib);
}

static int _cffi_const_NID_X9_62_c2tnb239v1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2tnb239v1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2tnb239v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2tnb191v3(lib);
}

static int _cffi_const_NID_X9_62_c2tnb239v2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2tnb239v2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2tnb239v2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2tnb239v1(lib);
}

static int _cffi_const_NID_X9_62_c2tnb239v3(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2tnb239v3);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2tnb239v3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2tnb239v2(lib);
}

static int _cffi_const_NID_X9_62_c2tnb359v1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2tnb359v1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2tnb359v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2tnb239v3(lib);
}

static int _cffi_const_NID_X9_62_c2tnb431r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_c2tnb431r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_c2tnb431r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2tnb359v1(lib);
}

static int _cffi_const_NID_X9_62_prime192v1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_prime192v1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_prime192v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_c2tnb431r1(lib);
}

static int _cffi_const_NID_X9_62_prime192v2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_prime192v2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_prime192v2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_prime192v1(lib);
}

static int _cffi_const_NID_X9_62_prime192v3(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_prime192v3);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_prime192v3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_prime192v2(lib);
}

static int _cffi_const_NID_X9_62_prime239v1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_prime239v1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_prime239v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_prime192v3(lib);
}

static int _cffi_const_NID_X9_62_prime239v2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_prime239v2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_prime239v2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_prime239v1(lib);
}

static int _cffi_const_NID_X9_62_prime239v3(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_prime239v3);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_prime239v3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_prime239v2(lib);
}

static int _cffi_const_NID_X9_62_prime256v1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_X9_62_prime256v1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_X9_62_prime256v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_prime239v3(lib);
}

static int _cffi_const_NID_any_policy(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_any_policy);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_any_policy", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_X9_62_prime256v1(lib);
}

static int _cffi_const_NID_authority_key_identifier(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_authority_key_identifier);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_authority_key_identifier", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_any_policy(lib);
}

static int _cffi_const_NID_basic_constraints(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_basic_constraints);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_basic_constraints", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_authority_key_identifier(lib);
}

static int _cffi_const_NID_certificate_issuer(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_certificate_issuer);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_certificate_issuer", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_basic_constraints(lib);
}

static int _cffi_const_NID_certificate_policies(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_certificate_policies);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_certificate_policies", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_certificate_issuer(lib);
}

static int _cffi_const_NID_commonName(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_commonName);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_commonName", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_certificate_policies(lib);
}

static int _cffi_const_NID_countryName(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_countryName);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_countryName", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_commonName(lib);
}

static int _cffi_const_NID_crl_distribution_points(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_crl_distribution_points);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_crl_distribution_points", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_countryName(lib);
}

static int _cffi_const_NID_crl_number(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_crl_number);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_crl_number", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_crl_distribution_points(lib);
}

static int _cffi_const_NID_crl_reason(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_crl_reason);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_crl_reason", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_crl_number(lib);
}

static int _cffi_const_NID_delta_crl(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_delta_crl);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_delta_crl", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_crl_reason(lib);
}

static int _cffi_const_NID_dnQualifier(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_dnQualifier);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_dnQualifier", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_delta_crl(lib);
}

static int _cffi_const_NID_domainComponent(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_domainComponent);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_domainComponent", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_dnQualifier(lib);
}

static int _cffi_const_NID_dsa(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_dsa);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_dsa", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_domainComponent(lib);
}

static int _cffi_const_NID_dsaWithSHA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_dsaWithSHA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_dsaWithSHA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_dsa(lib);
}

static int _cffi_const_NID_dsaWithSHA1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_dsaWithSHA1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_dsaWithSHA1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_dsaWithSHA(lib);
}

static int _cffi_const_NID_ecdsa_with_SHA1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_ecdsa_with_SHA1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_ecdsa_with_SHA1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_dsaWithSHA1(lib);
}

static int _cffi_const_NID_ecdsa_with_SHA224(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_ecdsa_with_SHA224);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_ecdsa_with_SHA224", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_ecdsa_with_SHA1(lib);
}

static int _cffi_const_NID_ecdsa_with_SHA256(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_ecdsa_with_SHA256);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_ecdsa_with_SHA256", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_ecdsa_with_SHA224(lib);
}

static int _cffi_const_NID_ecdsa_with_SHA384(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_ecdsa_with_SHA384);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_ecdsa_with_SHA384", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_ecdsa_with_SHA256(lib);
}

static int _cffi_const_NID_ecdsa_with_SHA512(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_ecdsa_with_SHA512);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_ecdsa_with_SHA512", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_ecdsa_with_SHA384(lib);
}

static int _cffi_const_NID_ext_key_usage(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_ext_key_usage);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_ext_key_usage", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_ecdsa_with_SHA512(lib);
}

static int _cffi_const_NID_generationQualifier(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_generationQualifier);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_generationQualifier", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_ext_key_usage(lib);
}

static int _cffi_const_NID_givenName(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_givenName);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_givenName", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_generationQualifier(lib);
}

static int _cffi_const_NID_info_access(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_info_access);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_info_access", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_givenName(lib);
}

static int _cffi_const_NID_inhibit_any_policy(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_inhibit_any_policy);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_inhibit_any_policy", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_info_access(lib);
}

static int _cffi_const_NID_invalidity_date(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_invalidity_date);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_invalidity_date", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_inhibit_any_policy(lib);
}

static int _cffi_const_NID_ipsec3(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_ipsec3);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_ipsec3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_invalidity_date(lib);
}

static int _cffi_const_NID_ipsec4(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_ipsec4);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_ipsec4", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_ipsec3(lib);
}

static int _cffi_const_NID_issuer_alt_name(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_issuer_alt_name);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_issuer_alt_name", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_ipsec4(lib);
}

static int _cffi_const_NID_issuing_distribution_point(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_issuing_distribution_point);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_issuing_distribution_point", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_issuer_alt_name(lib);
}

static int _cffi_const_NID_key_usage(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_key_usage);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_key_usage", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_issuing_distribution_point(lib);
}

static int _cffi_const_NID_localityName(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_localityName);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_localityName", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_key_usage(lib);
}

static int _cffi_const_NID_md2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_md2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_md2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_localityName(lib);
}

static int _cffi_const_NID_md4(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_md4);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_md4", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_md2(lib);
}

static int _cffi_const_NID_md5(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_md5);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_md5", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_md4(lib);
}

static int _cffi_const_NID_mdc2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_mdc2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_mdc2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_md5(lib);
}

static int _cffi_const_NID_name_constraints(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_name_constraints);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_name_constraints", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_mdc2(lib);
}

static int _cffi_const_NID_no_rev_avail(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_no_rev_avail);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_no_rev_avail", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_name_constraints(lib);
}

static int _cffi_const_NID_organizationName(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_organizationName);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_organizationName", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_no_rev_avail(lib);
}

static int _cffi_const_NID_organizationalUnitName(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_organizationalUnitName);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_organizationalUnitName", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_organizationName(lib);
}

static int _cffi_const_NID_pbe_WithSHA1And3_Key_TripleDES_CBC(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_pbe_WithSHA1And3_Key_TripleDES_CBC);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_pbe_WithSHA1And3_Key_TripleDES_CBC", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_organizationalUnitName(lib);
}

static int _cffi_const_NID_pkcs9_emailAddress(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_pkcs9_emailAddress);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_pkcs9_emailAddress", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_pbe_WithSHA1And3_Key_TripleDES_CBC(lib);
}

static int _cffi_const_NID_policy_constraints(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_policy_constraints);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_policy_constraints", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_pkcs9_emailAddress(lib);
}

static int _cffi_const_NID_policy_mappings(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_policy_mappings);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_policy_mappings", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_policy_constraints(lib);
}

static int _cffi_const_NID_private_key_usage_period(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_private_key_usage_period);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_private_key_usage_period", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_policy_mappings(lib);
}

static int _cffi_const_NID_pseudonym(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_pseudonym);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_pseudonym", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_private_key_usage_period(lib);
}

static int _cffi_const_NID_ripemd160(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_ripemd160);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_ripemd160", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_pseudonym(lib);
}

static int _cffi_const_NID_secp112r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_secp112r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_secp112r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_ripemd160(lib);
}

static int _cffi_const_NID_secp112r2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_secp112r2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_secp112r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_secp112r1(lib);
}

static int _cffi_const_NID_secp128r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_secp128r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_secp128r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_secp112r2(lib);
}

static int _cffi_const_NID_secp128r2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_secp128r2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_secp128r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_secp128r1(lib);
}

static int _cffi_const_NID_secp160k1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_secp160k1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_secp160k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_secp128r2(lib);
}

static int _cffi_const_NID_secp160r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_secp160r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_secp160r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_secp160k1(lib);
}

static int _cffi_const_NID_secp160r2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_secp160r2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_secp160r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_secp160r1(lib);
}

static int _cffi_const_NID_secp192k1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_secp192k1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_secp192k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_secp160r2(lib);
}

static int _cffi_const_NID_secp224k1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_secp224k1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_secp224k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_secp192k1(lib);
}

static int _cffi_const_NID_secp224r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_secp224r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_secp224r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_secp224k1(lib);
}

static int _cffi_const_NID_secp256k1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_secp256k1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_secp256k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_secp224r1(lib);
}

static int _cffi_const_NID_secp384r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_secp384r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_secp384r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_secp256k1(lib);
}

static int _cffi_const_NID_secp521r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_secp521r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_secp521r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_secp384r1(lib);
}

static int _cffi_const_NID_sect113r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect113r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect113r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_secp521r1(lib);
}

static int _cffi_const_NID_sect113r2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect113r2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect113r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect113r1(lib);
}

static int _cffi_const_NID_sect131r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect131r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect131r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect113r2(lib);
}

static int _cffi_const_NID_sect131r2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect131r2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect131r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect131r1(lib);
}

static int _cffi_const_NID_sect163k1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect163k1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect163k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect131r2(lib);
}

static int _cffi_const_NID_sect163r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect163r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect163r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect163k1(lib);
}

static int _cffi_const_NID_sect163r2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect163r2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect163r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect163r1(lib);
}

static int _cffi_const_NID_sect193r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect193r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect193r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect163r2(lib);
}

static int _cffi_const_NID_sect193r2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect193r2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect193r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect193r1(lib);
}

static int _cffi_const_NID_sect233k1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect233k1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect233k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect193r2(lib);
}

static int _cffi_const_NID_sect233r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect233r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect233r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect233k1(lib);
}

static int _cffi_const_NID_sect239k1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect239k1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect239k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect233r1(lib);
}

static int _cffi_const_NID_sect283k1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect283k1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect283k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect239k1(lib);
}

static int _cffi_const_NID_sect283r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect283r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect283r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect283k1(lib);
}

static int _cffi_const_NID_sect409k1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect409k1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect409k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect283r1(lib);
}

static int _cffi_const_NID_sect409r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect409r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect409r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect409k1(lib);
}

static int _cffi_const_NID_sect571k1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect571k1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect571k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect409r1(lib);
}

static int _cffi_const_NID_sect571r1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sect571r1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sect571r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect571k1(lib);
}

static int _cffi_const_NID_serialNumber(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_serialNumber);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_serialNumber", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sect571r1(lib);
}

static int _cffi_const_NID_sha(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sha);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sha", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_serialNumber(lib);
}

static int _cffi_const_NID_sha1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sha1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sha1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sha(lib);
}

static int _cffi_const_NID_sha224(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sha224);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sha224", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sha1(lib);
}

static int _cffi_const_NID_sha256(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sha256);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sha256", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sha224(lib);
}

static int _cffi_const_NID_sha384(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sha384);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sha384", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sha256(lib);
}

static int _cffi_const_NID_sha512(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_sha512);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_sha512", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sha384(lib);
}

static int _cffi_const_NID_stateOrProvinceName(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_stateOrProvinceName);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_stateOrProvinceName", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_sha512(lib);
}

static int _cffi_const_NID_subject_alt_name(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_subject_alt_name);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_subject_alt_name", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_stateOrProvinceName(lib);
}

static int _cffi_const_NID_subject_key_identifier(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_subject_key_identifier);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_subject_key_identifier", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_subject_alt_name(lib);
}

static int _cffi_const_NID_surname(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_surname);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_surname", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_subject_key_identifier(lib);
}

static int _cffi_const_NID_target_information(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_target_information);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_target_information", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_surname(lib);
}

static int _cffi_const_NID_title(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_title);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_title", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_target_information(lib);
}

static int _cffi_const_NID_undef(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_undef);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_undef", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_title(lib);
}

static int _cffi_const_NID_wap_wsg_idm_ecid_wtls1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_wap_wsg_idm_ecid_wtls1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_wap_wsg_idm_ecid_wtls1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_undef(lib);
}

static int _cffi_const_NID_wap_wsg_idm_ecid_wtls10(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_wap_wsg_idm_ecid_wtls10);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_wap_wsg_idm_ecid_wtls10", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_wap_wsg_idm_ecid_wtls1(lib);
}

static int _cffi_const_NID_wap_wsg_idm_ecid_wtls11(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_wap_wsg_idm_ecid_wtls11);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_wap_wsg_idm_ecid_wtls11", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_wap_wsg_idm_ecid_wtls10(lib);
}

static int _cffi_const_NID_wap_wsg_idm_ecid_wtls12(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_wap_wsg_idm_ecid_wtls12);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_wap_wsg_idm_ecid_wtls12", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_wap_wsg_idm_ecid_wtls11(lib);
}

static int _cffi_const_NID_wap_wsg_idm_ecid_wtls3(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_wap_wsg_idm_ecid_wtls3);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_wap_wsg_idm_ecid_wtls3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_wap_wsg_idm_ecid_wtls12(lib);
}

static int _cffi_const_NID_wap_wsg_idm_ecid_wtls4(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_wap_wsg_idm_ecid_wtls4);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_wap_wsg_idm_ecid_wtls4", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_wap_wsg_idm_ecid_wtls3(lib);
}

static int _cffi_const_NID_wap_wsg_idm_ecid_wtls5(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_wap_wsg_idm_ecid_wtls5);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_wap_wsg_idm_ecid_wtls5", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_wap_wsg_idm_ecid_wtls4(lib);
}

static int _cffi_const_NID_wap_wsg_idm_ecid_wtls6(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_wap_wsg_idm_ecid_wtls6);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_wap_wsg_idm_ecid_wtls6", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_wap_wsg_idm_ecid_wtls5(lib);
}

static int _cffi_const_NID_wap_wsg_idm_ecid_wtls7(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_wap_wsg_idm_ecid_wtls7);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_wap_wsg_idm_ecid_wtls7", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_wap_wsg_idm_ecid_wtls6(lib);
}

static int _cffi_const_NID_wap_wsg_idm_ecid_wtls8(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_wap_wsg_idm_ecid_wtls8);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_wap_wsg_idm_ecid_wtls8", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_wap_wsg_idm_ecid_wtls7(lib);
}

static int _cffi_const_NID_wap_wsg_idm_ecid_wtls9(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(NID_wap_wsg_idm_ecid_wtls9);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "NID_wap_wsg_idm_ecid_wtls9", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_wap_wsg_idm_ecid_wtls8(lib);
}

static int _cffi_const_OPENSSL_EC_NAMED_CURVE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(OPENSSL_EC_NAMED_CURVE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "OPENSSL_EC_NAMED_CURVE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_NID_wap_wsg_idm_ecid_wtls9(lib);
}

static int _cffi_const_OPENSSL_VERSION_NUMBER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(OPENSSL_VERSION_NUMBER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "OPENSSL_VERSION_NUMBER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_OPENSSL_EC_NAMED_CURVE(lib);
}

static int _cffi_const_OPENSSL_VERSION_TEXT(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (OPENSSL_VERSION_TEXT);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "OPENSSL_VERSION_TEXT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_OPENSSL_VERSION_NUMBER(lib);
}

static int _cffi_const_PEM_F_D2I_PKCS8PRIVATEKEY_BIO(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_D2I_PKCS8PRIVATEKEY_BIO);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_D2I_PKCS8PRIVATEKEY_BIO", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_OPENSSL_VERSION_TEXT(lib);
}

static int _cffi_const_PEM_F_D2I_PKCS8PRIVATEKEY_FP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_D2I_PKCS8PRIVATEKEY_FP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_D2I_PKCS8PRIVATEKEY_FP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_D2I_PKCS8PRIVATEKEY_BIO(lib);
}

static int _cffi_const_PEM_F_DO_PK8PKEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_DO_PK8PKEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_DO_PK8PKEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_D2I_PKCS8PRIVATEKEY_FP(lib);
}

static int _cffi_const_PEM_F_DO_PK8PKEY_FP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_DO_PK8PKEY_FP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_DO_PK8PKEY_FP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_DO_PK8PKEY(lib);
}

static int _cffi_const_PEM_F_LOAD_IV(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_LOAD_IV);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_LOAD_IV", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_DO_PK8PKEY_FP(lib);
}

static int _cffi_const_PEM_F_PEM_ASN1_READ(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_ASN1_READ);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_ASN1_READ", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_LOAD_IV(lib);
}

static int _cffi_const_PEM_F_PEM_ASN1_READ_BIO(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_ASN1_READ_BIO);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_ASN1_READ_BIO", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_ASN1_READ(lib);
}

static int _cffi_const_PEM_F_PEM_ASN1_WRITE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_ASN1_WRITE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_ASN1_WRITE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_ASN1_READ_BIO(lib);
}

static int _cffi_const_PEM_F_PEM_ASN1_WRITE_BIO(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_ASN1_WRITE_BIO);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_ASN1_WRITE_BIO", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_ASN1_WRITE(lib);
}

static int _cffi_const_PEM_F_PEM_DEF_CALLBACK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_DEF_CALLBACK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_DEF_CALLBACK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_ASN1_WRITE_BIO(lib);
}

static int _cffi_const_PEM_F_PEM_DO_HEADER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_DO_HEADER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_DO_HEADER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_DEF_CALLBACK(lib);
}

static int _cffi_const_PEM_F_PEM_F_PEM_WRITE_PKCS8PRIVATEKEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_F_PEM_WRITE_PKCS8PRIVATEKEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_F_PEM_WRITE_PKCS8PRIVATEKEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_DO_HEADER(lib);
}

static int _cffi_const_PEM_F_PEM_GET_EVP_CIPHER_INFO(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_GET_EVP_CIPHER_INFO);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_GET_EVP_CIPHER_INFO", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_F_PEM_WRITE_PKCS8PRIVATEKEY(lib);
}

static int _cffi_const_PEM_F_PEM_PK8PKEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_PK8PKEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_PK8PKEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_GET_EVP_CIPHER_INFO(lib);
}

static int _cffi_const_PEM_F_PEM_READ(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_READ);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_READ", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_PK8PKEY(lib);
}

static int _cffi_const_PEM_F_PEM_READ_BIO(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_READ_BIO);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_READ_BIO", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_READ(lib);
}

static int _cffi_const_PEM_F_PEM_READ_BIO_PRIVATEKEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_READ_BIO_PRIVATEKEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_READ_BIO_PRIVATEKEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_READ_BIO(lib);
}

static int _cffi_const_PEM_F_PEM_READ_PRIVATEKEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_READ_PRIVATEKEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_READ_PRIVATEKEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_READ_BIO_PRIVATEKEY(lib);
}

static int _cffi_const_PEM_F_PEM_SEALFINAL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_SEALFINAL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_SEALFINAL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_READ_PRIVATEKEY(lib);
}

static int _cffi_const_PEM_F_PEM_SEALINIT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_SEALINIT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_SEALINIT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_SEALFINAL(lib);
}

static int _cffi_const_PEM_F_PEM_SIGNFINAL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_SIGNFINAL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_SIGNFINAL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_SEALINIT(lib);
}

static int _cffi_const_PEM_F_PEM_WRITE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_WRITE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_WRITE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_SIGNFINAL(lib);
}

static int _cffi_const_PEM_F_PEM_WRITE_BIO(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_WRITE_BIO);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_WRITE_BIO", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_WRITE(lib);
}

static int _cffi_const_PEM_F_PEM_X509_INFO_READ(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_X509_INFO_READ);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_X509_INFO_READ", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_WRITE_BIO(lib);
}

static int _cffi_const_PEM_F_PEM_X509_INFO_READ_BIO(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_X509_INFO_READ_BIO);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_X509_INFO_READ_BIO", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_X509_INFO_READ(lib);
}

static int _cffi_const_PEM_F_PEM_X509_INFO_WRITE_BIO(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_F_PEM_X509_INFO_WRITE_BIO);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_F_PEM_X509_INFO_WRITE_BIO", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_X509_INFO_READ_BIO(lib);
}

static int _cffi_const_PEM_R_BAD_BASE64_DECODE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_BAD_BASE64_DECODE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_BAD_BASE64_DECODE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_F_PEM_X509_INFO_WRITE_BIO(lib);
}

static int _cffi_const_PEM_R_BAD_DECRYPT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_BAD_DECRYPT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_BAD_DECRYPT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_BAD_BASE64_DECODE(lib);
}

static int _cffi_const_PEM_R_BAD_END_LINE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_BAD_END_LINE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_BAD_END_LINE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_BAD_DECRYPT(lib);
}

static int _cffi_const_PEM_R_BAD_IV_CHARS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_BAD_IV_CHARS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_BAD_IV_CHARS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_BAD_END_LINE(lib);
}

static int _cffi_const_PEM_R_BAD_PASSWORD_READ(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_BAD_PASSWORD_READ);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_BAD_PASSWORD_READ", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_BAD_IV_CHARS(lib);
}

static int _cffi_const_PEM_R_ERROR_CONVERTING_PRIVATE_KEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_ERROR_CONVERTING_PRIVATE_KEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_ERROR_CONVERTING_PRIVATE_KEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_BAD_PASSWORD_READ(lib);
}

static int _cffi_const_PEM_R_NOT_DEK_INFO(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_NOT_DEK_INFO);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_NOT_DEK_INFO", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_ERROR_CONVERTING_PRIVATE_KEY(lib);
}

static int _cffi_const_PEM_R_NOT_ENCRYPTED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_NOT_ENCRYPTED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_NOT_ENCRYPTED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_NOT_DEK_INFO(lib);
}

static int _cffi_const_PEM_R_NOT_PROC_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_NOT_PROC_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_NOT_PROC_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_NOT_ENCRYPTED(lib);
}

static int _cffi_const_PEM_R_NO_START_LINE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_NO_START_LINE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_NO_START_LINE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_NOT_PROC_TYPE(lib);
}

static int _cffi_const_PEM_R_PROBLEMS_GETTING_PASSWORD(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_PROBLEMS_GETTING_PASSWORD);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_PROBLEMS_GETTING_PASSWORD", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_NO_START_LINE(lib);
}

static int _cffi_const_PEM_R_PUBLIC_KEY_NO_RSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_PUBLIC_KEY_NO_RSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_PUBLIC_KEY_NO_RSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_PROBLEMS_GETTING_PASSWORD(lib);
}

static int _cffi_const_PEM_R_READ_KEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_READ_KEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_READ_KEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_PUBLIC_KEY_NO_RSA(lib);
}

static int _cffi_const_PEM_R_SHORT_HEADER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_SHORT_HEADER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_SHORT_HEADER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_READ_KEY(lib);
}

static int _cffi_const_PEM_R_UNSUPPORTED_CIPHER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_UNSUPPORTED_CIPHER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_UNSUPPORTED_CIPHER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_SHORT_HEADER(lib);
}

static int _cffi_const_PEM_R_UNSUPPORTED_ENCRYPTION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PEM_R_UNSUPPORTED_ENCRYPTION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PEM_R_UNSUPPORTED_ENCRYPTION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_UNSUPPORTED_CIPHER(lib);
}

static int _cffi_const_PKCS12_F_PKCS12_PBE_CRYPT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PKCS12_F_PKCS12_PBE_CRYPT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PKCS12_F_PKCS12_PBE_CRYPT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PEM_R_UNSUPPORTED_ENCRYPTION(lib);
}

static int _cffi_const_PKCS12_R_PKCS12_CIPHERFINAL_ERROR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PKCS12_R_PKCS12_CIPHERFINAL_ERROR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PKCS12_R_PKCS12_CIPHERFINAL_ERROR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PKCS12_F_PKCS12_PBE_CRYPT(lib);
}

static int _cffi_const_PKCS7_BINARY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PKCS7_BINARY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PKCS7_BINARY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PKCS12_R_PKCS12_CIPHERFINAL_ERROR(lib);
}

static int _cffi_const_PKCS7_DETACHED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PKCS7_DETACHED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PKCS7_DETACHED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PKCS7_BINARY(lib);
}

static int _cffi_const_PKCS7_NOATTR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PKCS7_NOATTR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PKCS7_NOATTR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PKCS7_DETACHED(lib);
}

static int _cffi_const_PKCS7_NOCERTS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PKCS7_NOCERTS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PKCS7_NOCERTS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PKCS7_NOATTR(lib);
}

static int _cffi_const_PKCS7_NOCHAIN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PKCS7_NOCHAIN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PKCS7_NOCHAIN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PKCS7_NOCERTS(lib);
}

static int _cffi_const_PKCS7_NOINTERN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PKCS7_NOINTERN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PKCS7_NOINTERN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PKCS7_NOCHAIN(lib);
}

static int _cffi_const_PKCS7_NOSIGS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PKCS7_NOSIGS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PKCS7_NOSIGS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PKCS7_NOINTERN(lib);
}

static int _cffi_const_PKCS7_NOSMIMECAP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PKCS7_NOSMIMECAP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PKCS7_NOSMIMECAP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PKCS7_NOSIGS(lib);
}

static int _cffi_const_PKCS7_NOVERIFY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PKCS7_NOVERIFY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PKCS7_NOVERIFY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PKCS7_NOSMIMECAP(lib);
}

static int _cffi_const_PKCS7_STREAM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PKCS7_STREAM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PKCS7_STREAM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PKCS7_NOVERIFY(lib);
}

static int _cffi_const_PKCS7_TEXT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(PKCS7_TEXT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "PKCS7_TEXT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PKCS7_STREAM(lib);
}

static int _cffi_const_RSA_F4(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(RSA_F4);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "RSA_F4", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_PKCS7_TEXT(lib);
}

static int _cffi_const_RSA_NO_PADDING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(RSA_NO_PADDING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "RSA_NO_PADDING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_RSA_F4(lib);
}

static int _cffi_const_RSA_PKCS1_OAEP_PADDING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(RSA_PKCS1_OAEP_PADDING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "RSA_PKCS1_OAEP_PADDING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_RSA_NO_PADDING(lib);
}

static int _cffi_const_RSA_PKCS1_PADDING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(RSA_PKCS1_PADDING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "RSA_PKCS1_PADDING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_RSA_PKCS1_OAEP_PADDING(lib);
}

static int _cffi_const_RSA_PKCS1_PSS_PADDING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(RSA_PKCS1_PSS_PADDING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "RSA_PKCS1_PSS_PADDING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_RSA_PKCS1_PADDING(lib);
}

static int _cffi_const_RSA_R_BLOCK_TYPE_IS_NOT_01(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(RSA_R_BLOCK_TYPE_IS_NOT_01);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "RSA_R_BLOCK_TYPE_IS_NOT_01", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_RSA_PKCS1_PSS_PADDING(lib);
}

static int _cffi_const_RSA_R_BLOCK_TYPE_IS_NOT_02(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(RSA_R_BLOCK_TYPE_IS_NOT_02);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "RSA_R_BLOCK_TYPE_IS_NOT_02", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_RSA_R_BLOCK_TYPE_IS_NOT_01(lib);
}

static int _cffi_const_RSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(RSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "RSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_RSA_R_BLOCK_TYPE_IS_NOT_02(lib);
}

static int _cffi_const_RSA_R_DIGEST_TOO_BIG_FOR_RSA_KEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(RSA_R_DIGEST_TOO_BIG_FOR_RSA_KEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "RSA_R_DIGEST_TOO_BIG_FOR_RSA_KEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_RSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE(lib);
}

static int _cffi_const_RSA_R_PKCS_DECODING_ERROR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(RSA_R_PKCS_DECODING_ERROR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "RSA_R_PKCS_DECODING_ERROR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_RSA_R_DIGEST_TOO_BIG_FOR_RSA_KEY(lib);
}

static int _cffi_const_RSA_SSLV23_PADDING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(RSA_SSLV23_PADDING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "RSA_SSLV23_PADDING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_RSA_R_PKCS_DECODING_ERROR(lib);
}

static int _cffi_const_RSA_X931_PADDING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(RSA_X931_PADDING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "RSA_X931_PADDING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_RSA_SSLV23_PADDING(lib);
}

static int _cffi_const_SN_X9_62_c2onb191v4(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2onb191v4);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2onb191v4", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_RSA_X931_PADDING(lib);
}

static int _cffi_const_SN_X9_62_c2onb191v5(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2onb191v5);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2onb191v5", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2onb191v4(lib);
}

static int _cffi_const_SN_X9_62_c2onb239v4(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2onb239v4);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2onb239v4", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2onb191v5(lib);
}

static int _cffi_const_SN_X9_62_c2onb239v5(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2onb239v5);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2onb239v5", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2onb239v4(lib);
}

static int _cffi_const_SN_X9_62_c2pnb163v1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2pnb163v1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2pnb163v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2onb239v5(lib);
}

static int _cffi_const_SN_X9_62_c2pnb163v2(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2pnb163v2);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2pnb163v2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2pnb163v1(lib);
}

static int _cffi_const_SN_X9_62_c2pnb163v3(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2pnb163v3);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2pnb163v3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2pnb163v2(lib);
}

static int _cffi_const_SN_X9_62_c2pnb176v1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2pnb176v1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2pnb176v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2pnb163v3(lib);
}

static int _cffi_const_SN_X9_62_c2pnb208w1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2pnb208w1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2pnb208w1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2pnb176v1(lib);
}

static int _cffi_const_SN_X9_62_c2pnb272w1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2pnb272w1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2pnb272w1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2pnb208w1(lib);
}

static int _cffi_const_SN_X9_62_c2pnb304w1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2pnb304w1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2pnb304w1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2pnb272w1(lib);
}

static int _cffi_const_SN_X9_62_c2pnb368w1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2pnb368w1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2pnb368w1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2pnb304w1(lib);
}

static int _cffi_const_SN_X9_62_c2tnb191v1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2tnb191v1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2tnb191v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2pnb368w1(lib);
}

static int _cffi_const_SN_X9_62_c2tnb191v2(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2tnb191v2);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2tnb191v2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2tnb191v1(lib);
}

static int _cffi_const_SN_X9_62_c2tnb191v3(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2tnb191v3);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2tnb191v3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2tnb191v2(lib);
}

static int _cffi_const_SN_X9_62_c2tnb239v1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2tnb239v1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2tnb239v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2tnb191v3(lib);
}

static int _cffi_const_SN_X9_62_c2tnb239v2(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2tnb239v2);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2tnb239v2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2tnb239v1(lib);
}

static int _cffi_const_SN_X9_62_c2tnb239v3(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2tnb239v3);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2tnb239v3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2tnb239v2(lib);
}

static int _cffi_const_SN_X9_62_c2tnb359v1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2tnb359v1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2tnb359v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2tnb239v3(lib);
}

static int _cffi_const_SN_X9_62_c2tnb431r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_c2tnb431r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_c2tnb431r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2tnb359v1(lib);
}

static int _cffi_const_SN_X9_62_prime192v1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_prime192v1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_prime192v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_c2tnb431r1(lib);
}

static int _cffi_const_SN_X9_62_prime192v2(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_prime192v2);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_prime192v2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_prime192v1(lib);
}

static int _cffi_const_SN_X9_62_prime192v3(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_prime192v3);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_prime192v3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_prime192v2(lib);
}

static int _cffi_const_SN_X9_62_prime239v1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_prime239v1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_prime239v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_prime192v3(lib);
}

static int _cffi_const_SN_X9_62_prime239v2(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_prime239v2);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_prime239v2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_prime239v1(lib);
}

static int _cffi_const_SN_X9_62_prime239v3(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_prime239v3);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_prime239v3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_prime239v2(lib);
}

static int _cffi_const_SN_X9_62_prime256v1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_X9_62_prime256v1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_X9_62_prime256v1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_prime239v3(lib);
}

static int _cffi_const_SN_ipsec3(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_ipsec3);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_ipsec3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_X9_62_prime256v1(lib);
}

static int _cffi_const_SN_ipsec4(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_ipsec4);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_ipsec4", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_ipsec3(lib);
}

static int _cffi_const_SN_secp112r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_secp112r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_secp112r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_ipsec4(lib);
}

static int _cffi_const_SN_secp112r2(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_secp112r2);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_secp112r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_secp112r1(lib);
}

static int _cffi_const_SN_secp128r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_secp128r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_secp128r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_secp112r2(lib);
}

static int _cffi_const_SN_secp128r2(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_secp128r2);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_secp128r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_secp128r1(lib);
}

static int _cffi_const_SN_secp160k1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_secp160k1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_secp160k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_secp128r2(lib);
}

static int _cffi_const_SN_secp160r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_secp160r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_secp160r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_secp160k1(lib);
}

static int _cffi_const_SN_secp160r2(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_secp160r2);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_secp160r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_secp160r1(lib);
}

static int _cffi_const_SN_secp192k1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_secp192k1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_secp192k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_secp160r2(lib);
}

static int _cffi_const_SN_secp224k1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_secp224k1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_secp224k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_secp192k1(lib);
}

static int _cffi_const_SN_secp224r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_secp224r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_secp224r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_secp224k1(lib);
}

static int _cffi_const_SN_secp256k1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_secp256k1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_secp256k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_secp224r1(lib);
}

static int _cffi_const_SN_secp384r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_secp384r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_secp384r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_secp256k1(lib);
}

static int _cffi_const_SN_secp521r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_secp521r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_secp521r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_secp384r1(lib);
}

static int _cffi_const_SN_sect113r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect113r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect113r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_secp521r1(lib);
}

static int _cffi_const_SN_sect113r2(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect113r2);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect113r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect113r1(lib);
}

static int _cffi_const_SN_sect131r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect131r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect131r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect113r2(lib);
}

static int _cffi_const_SN_sect131r2(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect131r2);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect131r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect131r1(lib);
}

static int _cffi_const_SN_sect163k1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect163k1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect163k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect131r2(lib);
}

static int _cffi_const_SN_sect163r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect163r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect163r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect163k1(lib);
}

static int _cffi_const_SN_sect163r2(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect163r2);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect163r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect163r1(lib);
}

static int _cffi_const_SN_sect193r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect193r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect193r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect163r2(lib);
}

static int _cffi_const_SN_sect193r2(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect193r2);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect193r2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect193r1(lib);
}

static int _cffi_const_SN_sect233k1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect233k1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect233k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect193r2(lib);
}

static int _cffi_const_SN_sect233r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect233r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect233r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect233k1(lib);
}

static int _cffi_const_SN_sect239k1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect239k1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect239k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect233r1(lib);
}

static int _cffi_const_SN_sect283k1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect283k1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect283k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect239k1(lib);
}

static int _cffi_const_SN_sect283r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect283r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect283r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect283k1(lib);
}

static int _cffi_const_SN_sect409k1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect409k1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect409k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect283r1(lib);
}

static int _cffi_const_SN_sect409r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect409r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect409r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect409k1(lib);
}

static int _cffi_const_SN_sect571k1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect571k1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect571k1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect409r1(lib);
}

static int _cffi_const_SN_sect571r1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_sect571r1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_sect571r1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect571k1(lib);
}

static int _cffi_const_SN_wap_wsg_idm_ecid_wtls1(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_wap_wsg_idm_ecid_wtls1);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_wap_wsg_idm_ecid_wtls1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_sect571r1(lib);
}

static int _cffi_const_SN_wap_wsg_idm_ecid_wtls10(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_wap_wsg_idm_ecid_wtls10);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_wap_wsg_idm_ecid_wtls10", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_wap_wsg_idm_ecid_wtls1(lib);
}

static int _cffi_const_SN_wap_wsg_idm_ecid_wtls11(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_wap_wsg_idm_ecid_wtls11);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_wap_wsg_idm_ecid_wtls11", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_wap_wsg_idm_ecid_wtls10(lib);
}

static int _cffi_const_SN_wap_wsg_idm_ecid_wtls12(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_wap_wsg_idm_ecid_wtls12);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_wap_wsg_idm_ecid_wtls12", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_wap_wsg_idm_ecid_wtls11(lib);
}

static int _cffi_const_SN_wap_wsg_idm_ecid_wtls3(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_wap_wsg_idm_ecid_wtls3);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_wap_wsg_idm_ecid_wtls3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_wap_wsg_idm_ecid_wtls12(lib);
}

static int _cffi_const_SN_wap_wsg_idm_ecid_wtls4(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_wap_wsg_idm_ecid_wtls4);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_wap_wsg_idm_ecid_wtls4", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_wap_wsg_idm_ecid_wtls3(lib);
}

static int _cffi_const_SN_wap_wsg_idm_ecid_wtls5(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_wap_wsg_idm_ecid_wtls5);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_wap_wsg_idm_ecid_wtls5", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_wap_wsg_idm_ecid_wtls4(lib);
}

static int _cffi_const_SN_wap_wsg_idm_ecid_wtls6(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_wap_wsg_idm_ecid_wtls6);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_wap_wsg_idm_ecid_wtls6", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_wap_wsg_idm_ecid_wtls5(lib);
}

static int _cffi_const_SN_wap_wsg_idm_ecid_wtls7(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_wap_wsg_idm_ecid_wtls7);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_wap_wsg_idm_ecid_wtls7", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_wap_wsg_idm_ecid_wtls6(lib);
}

static int _cffi_const_SN_wap_wsg_idm_ecid_wtls8(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_wap_wsg_idm_ecid_wtls8);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_wap_wsg_idm_ecid_wtls8", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_wap_wsg_idm_ecid_wtls7(lib);
}

static int _cffi_const_SN_wap_wsg_idm_ecid_wtls9(PyObject *lib)
{
  PyObject *o;
  int res;
  char const * i;
  i = (SN_wap_wsg_idm_ecid_wtls9);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(0));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SN_wap_wsg_idm_ecid_wtls9", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_wap_wsg_idm_ecid_wtls8(lib);
}

static int _cffi_const_SSL3_RANDOM_SIZE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL3_RANDOM_SIZE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL3_RANDOM_SIZE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SN_wap_wsg_idm_ecid_wtls9(lib);
}

static int _cffi_const_SSLEAY_BUILT_ON(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSLEAY_BUILT_ON);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSLEAY_BUILT_ON", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL3_RANDOM_SIZE(lib);
}

static int _cffi_const_SSLEAY_CFLAGS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSLEAY_CFLAGS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSLEAY_CFLAGS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSLEAY_BUILT_ON(lib);
}

static int _cffi_const_SSLEAY_DIR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSLEAY_DIR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSLEAY_DIR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSLEAY_CFLAGS(lib);
}

static int _cffi_const_SSLEAY_PLATFORM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSLEAY_PLATFORM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSLEAY_PLATFORM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSLEAY_DIR(lib);
}

static int _cffi_const_SSLEAY_VERSION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSLEAY_VERSION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSLEAY_VERSION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSLEAY_PLATFORM(lib);
}

static int _cffi_const_SSL_CB_ACCEPT_EXIT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_CB_ACCEPT_EXIT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_CB_ACCEPT_EXIT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSLEAY_VERSION(lib);
}

static int _cffi_const_SSL_CB_ACCEPT_LOOP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_CB_ACCEPT_LOOP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_CB_ACCEPT_LOOP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_CB_ACCEPT_EXIT(lib);
}

static int _cffi_const_SSL_CB_ALERT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_CB_ALERT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_CB_ALERT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_CB_ACCEPT_LOOP(lib);
}

static int _cffi_const_SSL_CB_CONNECT_EXIT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_CB_CONNECT_EXIT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_CB_CONNECT_EXIT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_CB_ALERT(lib);
}

static int _cffi_const_SSL_CB_CONNECT_LOOP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_CB_CONNECT_LOOP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_CB_CONNECT_LOOP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_CB_CONNECT_EXIT(lib);
}

static int _cffi_const_SSL_CB_EXIT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_CB_EXIT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_CB_EXIT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_CB_CONNECT_LOOP(lib);
}

static int _cffi_const_SSL_CB_HANDSHAKE_DONE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_CB_HANDSHAKE_DONE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_CB_HANDSHAKE_DONE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_CB_EXIT(lib);
}

static int _cffi_const_SSL_CB_HANDSHAKE_START(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_CB_HANDSHAKE_START);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_CB_HANDSHAKE_START", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_CB_HANDSHAKE_DONE(lib);
}

static int _cffi_const_SSL_CB_LOOP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_CB_LOOP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_CB_LOOP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_CB_HANDSHAKE_START(lib);
}

static int _cffi_const_SSL_CB_READ(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_CB_READ);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_CB_READ", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_CB_LOOP(lib);
}

static int _cffi_const_SSL_CB_READ_ALERT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_CB_READ_ALERT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_CB_READ_ALERT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_CB_READ(lib);
}

static int _cffi_const_SSL_CB_WRITE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_CB_WRITE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_CB_WRITE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_CB_READ_ALERT(lib);
}

static int _cffi_const_SSL_CB_WRITE_ALERT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_CB_WRITE_ALERT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_CB_WRITE_ALERT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_CB_WRITE(lib);
}

static int _cffi_const_SSL_ERROR_NONE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ERROR_NONE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ERROR_NONE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_CB_WRITE_ALERT(lib);
}

static int _cffi_const_SSL_ERROR_SSL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ERROR_SSL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ERROR_SSL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ERROR_NONE(lib);
}

static int _cffi_const_SSL_ERROR_SYSCALL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ERROR_SYSCALL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ERROR_SYSCALL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ERROR_SSL(lib);
}

static int _cffi_const_SSL_ERROR_WANT_READ(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ERROR_WANT_READ);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ERROR_WANT_READ", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ERROR_SYSCALL(lib);
}

static int _cffi_const_SSL_ERROR_WANT_WRITE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ERROR_WANT_WRITE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ERROR_WANT_WRITE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ERROR_WANT_READ(lib);
}

static int _cffi_const_SSL_ERROR_WANT_X509_LOOKUP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ERROR_WANT_X509_LOOKUP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ERROR_WANT_X509_LOOKUP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ERROR_WANT_WRITE(lib);
}

static int _cffi_const_SSL_ERROR_ZERO_RETURN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ERROR_ZERO_RETURN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ERROR_ZERO_RETURN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ERROR_WANT_X509_LOOKUP(lib);
}

static int _cffi_const_SSL_FILETYPE_ASN1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_FILETYPE_ASN1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_FILETYPE_ASN1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ERROR_ZERO_RETURN(lib);
}

static int _cffi_const_SSL_FILETYPE_PEM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_FILETYPE_PEM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_FILETYPE_PEM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_FILETYPE_ASN1(lib);
}

static int _cffi_const_SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_FILETYPE_PEM(lib);
}

static int _cffi_const_SSL_MODE_AUTO_RETRY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_MODE_AUTO_RETRY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_MODE_AUTO_RETRY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER(lib);
}

static int _cffi_const_SSL_MODE_ENABLE_PARTIAL_WRITE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_MODE_ENABLE_PARTIAL_WRITE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_MODE_ENABLE_PARTIAL_WRITE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_MODE_AUTO_RETRY(lib);
}

static int _cffi_const_SSL_MODE_RELEASE_BUFFERS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_MODE_RELEASE_BUFFERS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_MODE_RELEASE_BUFFERS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_MODE_ENABLE_PARTIAL_WRITE(lib);
}

static int _cffi_const_SSL_OP_ALL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_ALL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_ALL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_MODE_RELEASE_BUFFERS(lib);
}

static int _cffi_const_SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_ALL(lib);
}

static int _cffi_const_SSL_OP_CIPHER_SERVER_PREFERENCE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_CIPHER_SERVER_PREFERENCE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_CIPHER_SERVER_PREFERENCE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION(lib);
}

static int _cffi_const_SSL_OP_COOKIE_EXCHANGE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_COOKIE_EXCHANGE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_COOKIE_EXCHANGE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_CIPHER_SERVER_PREFERENCE(lib);
}

static int _cffi_const_SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_COOKIE_EXCHANGE(lib);
}

static int _cffi_const_SSL_OP_EPHEMERAL_RSA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_EPHEMERAL_RSA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_EPHEMERAL_RSA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS(lib);
}

static int _cffi_const_SSL_OP_LEGACY_SERVER_CONNECT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_LEGACY_SERVER_CONNECT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_LEGACY_SERVER_CONNECT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_EPHEMERAL_RSA(lib);
}

static int _cffi_const_SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_LEGACY_SERVER_CONNECT(lib);
}

static int _cffi_const_SSL_OP_MICROSOFT_SESS_ID_BUG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_MICROSOFT_SESS_ID_BUG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_MICROSOFT_SESS_ID_BUG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER(lib);
}

static int _cffi_const_SSL_OP_MSIE_SSLV2_RSA_PADDING(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_MSIE_SSLV2_RSA_PADDING);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_MSIE_SSLV2_RSA_PADDING", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_MICROSOFT_SESS_ID_BUG(lib);
}

static int _cffi_const_SSL_OP_NETSCAPE_CA_DN_BUG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_NETSCAPE_CA_DN_BUG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_NETSCAPE_CA_DN_BUG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_MSIE_SSLV2_RSA_PADDING(lib);
}

static int _cffi_const_SSL_OP_NETSCAPE_CHALLENGE_BUG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_NETSCAPE_CHALLENGE_BUG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_NETSCAPE_CHALLENGE_BUG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_NETSCAPE_CA_DN_BUG(lib);
}

static int _cffi_const_SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_NETSCAPE_CHALLENGE_BUG(lib);
}

static int _cffi_const_SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG(lib);
}

static int _cffi_const_SSL_OP_NO_COMPRESSION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_NO_COMPRESSION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_NO_COMPRESSION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG(lib);
}

static int _cffi_const_SSL_OP_NO_QUERY_MTU(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_NO_QUERY_MTU);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_NO_QUERY_MTU", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_NO_COMPRESSION(lib);
}

static int _cffi_const_SSL_OP_NO_SSLv2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_NO_SSLv2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_NO_SSLv2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_NO_QUERY_MTU(lib);
}

static int _cffi_const_SSL_OP_NO_SSLv3(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_NO_SSLv3);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_NO_SSLv3", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_NO_SSLv2(lib);
}

static int _cffi_const_SSL_OP_NO_TICKET(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_NO_TICKET);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_NO_TICKET", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_NO_SSLv3(lib);
}

static int _cffi_const_SSL_OP_NO_TLSv1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_NO_TLSv1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_NO_TLSv1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_NO_TICKET(lib);
}

static int _cffi_const_SSL_OP_NO_TLSv1_1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_NO_TLSv1_1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_NO_TLSv1_1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_NO_TLSv1(lib);
}

static int _cffi_const_SSL_OP_NO_TLSv1_2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_NO_TLSv1_2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_NO_TLSv1_2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_NO_TLSv1_1(lib);
}

static int _cffi_const_SSL_OP_PKCS1_CHECK_1(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_PKCS1_CHECK_1);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_PKCS1_CHECK_1", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_NO_TLSv1_2(lib);
}

static int _cffi_const_SSL_OP_PKCS1_CHECK_2(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_PKCS1_CHECK_2);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_PKCS1_CHECK_2", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_PKCS1_CHECK_1(lib);
}

static int _cffi_const_SSL_OP_SINGLE_DH_USE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_SINGLE_DH_USE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_SINGLE_DH_USE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_PKCS1_CHECK_2(lib);
}

static int _cffi_const_SSL_OP_SINGLE_ECDH_USE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_SINGLE_ECDH_USE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_SINGLE_ECDH_USE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_SINGLE_DH_USE(lib);
}

static int _cffi_const_SSL_OP_SSLEAY_080_CLIENT_DH_BUG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_SSLEAY_080_CLIENT_DH_BUG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_SSLEAY_080_CLIENT_DH_BUG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_SINGLE_ECDH_USE(lib);
}

static int _cffi_const_SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_SSLEAY_080_CLIENT_DH_BUG(lib);
}

static int _cffi_const_SSL_OP_TLS_BLOCK_PADDING_BUG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_TLS_BLOCK_PADDING_BUG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_TLS_BLOCK_PADDING_BUG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG(lib);
}

static int _cffi_const_SSL_OP_TLS_D5_BUG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_TLS_D5_BUG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_TLS_D5_BUG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_TLS_BLOCK_PADDING_BUG(lib);
}

static int _cffi_const_SSL_OP_TLS_ROLLBACK_BUG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_OP_TLS_ROLLBACK_BUG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_OP_TLS_ROLLBACK_BUG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_TLS_D5_BUG(lib);
}

static int _cffi_const_SSL_RECEIVED_SHUTDOWN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_RECEIVED_SHUTDOWN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_RECEIVED_SHUTDOWN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_OP_TLS_ROLLBACK_BUG(lib);
}

static int _cffi_const_SSL_SENT_SHUTDOWN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_SENT_SHUTDOWN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_SENT_SHUTDOWN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_RECEIVED_SHUTDOWN(lib);
}

static int _cffi_const_SSL_SESS_CACHE_BOTH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_SESS_CACHE_BOTH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_SESS_CACHE_BOTH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_SENT_SHUTDOWN(lib);
}

static int _cffi_const_SSL_SESS_CACHE_CLIENT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_SESS_CACHE_CLIENT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_SESS_CACHE_CLIENT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_SESS_CACHE_BOTH(lib);
}

static int _cffi_const_SSL_SESS_CACHE_NO_AUTO_CLEAR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_SESS_CACHE_NO_AUTO_CLEAR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_SESS_CACHE_NO_AUTO_CLEAR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_SESS_CACHE_CLIENT(lib);
}

static int _cffi_const_SSL_SESS_CACHE_NO_INTERNAL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_SESS_CACHE_NO_INTERNAL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_SESS_CACHE_NO_INTERNAL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_SESS_CACHE_NO_AUTO_CLEAR(lib);
}

static int _cffi_const_SSL_SESS_CACHE_NO_INTERNAL_LOOKUP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_SESS_CACHE_NO_INTERNAL_LOOKUP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_SESS_CACHE_NO_INTERNAL_LOOKUP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_SESS_CACHE_NO_INTERNAL(lib);
}

static int _cffi_const_SSL_SESS_CACHE_NO_INTERNAL_STORE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_SESS_CACHE_NO_INTERNAL_STORE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_SESS_CACHE_NO_INTERNAL_STORE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_SESS_CACHE_NO_INTERNAL_LOOKUP(lib);
}

static int _cffi_const_SSL_SESS_CACHE_OFF(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_SESS_CACHE_OFF);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_SESS_CACHE_OFF", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_SESS_CACHE_NO_INTERNAL_STORE(lib);
}

static int _cffi_const_SSL_SESS_CACHE_SERVER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_SESS_CACHE_SERVER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_SESS_CACHE_SERVER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_SESS_CACHE_OFF(lib);
}

static int _cffi_const_SSL_ST_ACCEPT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ST_ACCEPT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ST_ACCEPT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_SESS_CACHE_SERVER(lib);
}

static int _cffi_const_SSL_ST_BEFORE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ST_BEFORE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ST_BEFORE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ST_ACCEPT(lib);
}

static int _cffi_const_SSL_ST_CONNECT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ST_CONNECT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ST_CONNECT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ST_BEFORE(lib);
}

static int _cffi_const_SSL_ST_INIT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ST_INIT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ST_INIT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ST_CONNECT(lib);
}

static int _cffi_const_SSL_ST_MASK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ST_MASK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ST_MASK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ST_INIT(lib);
}

static int _cffi_const_SSL_ST_OK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ST_OK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ST_OK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ST_MASK(lib);
}

static int _cffi_const_SSL_ST_RENEGOTIATE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_ST_RENEGOTIATE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_ST_RENEGOTIATE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ST_OK(lib);
}

static int _cffi_const_SSL_VERIFY_CLIENT_ONCE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_VERIFY_CLIENT_ONCE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_VERIFY_CLIENT_ONCE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_ST_RENEGOTIATE(lib);
}

static int _cffi_const_SSL_VERIFY_FAIL_IF_NO_PEER_CERT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_VERIFY_FAIL_IF_NO_PEER_CERT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_VERIFY_FAIL_IF_NO_PEER_CERT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_VERIFY_CLIENT_ONCE(lib);
}

static int _cffi_const_SSL_VERIFY_NONE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_VERIFY_NONE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_VERIFY_NONE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_VERIFY_FAIL_IF_NO_PEER_CERT(lib);
}

static int _cffi_const_SSL_VERIFY_PEER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(SSL_VERIFY_PEER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "SSL_VERIFY_PEER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_VERIFY_NONE(lib);
}

static int _cffi_const_TLSEXT_NAMETYPE_host_name(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(TLSEXT_NAMETYPE_host_name);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "TLSEXT_NAMETYPE_host_name", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_SSL_VERIFY_PEER(lib);
}

static int _cffi_const_V_ASN1_GENERALIZEDTIME(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(V_ASN1_GENERALIZEDTIME);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "V_ASN1_GENERALIZEDTIME", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_TLSEXT_NAMETYPE_host_name(lib);
}

static int _cffi_const_X509_FLAG_COMPAT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_FLAG_COMPAT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_FLAG_COMPAT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_V_ASN1_GENERALIZEDTIME(lib);
}

static int _cffi_const_X509_FLAG_NO_ATTRIBUTES(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_FLAG_NO_ATTRIBUTES);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_FLAG_NO_ATTRIBUTES", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_FLAG_COMPAT(lib);
}

static int _cffi_const_X509_FLAG_NO_AUX(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_FLAG_NO_AUX);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_FLAG_NO_AUX", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_FLAG_NO_ATTRIBUTES(lib);
}

static int _cffi_const_X509_FLAG_NO_EXTENSIONS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_FLAG_NO_EXTENSIONS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_FLAG_NO_EXTENSIONS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_FLAG_NO_AUX(lib);
}

static int _cffi_const_X509_FLAG_NO_HEADER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_FLAG_NO_HEADER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_FLAG_NO_HEADER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_FLAG_NO_EXTENSIONS(lib);
}

static int _cffi_const_X509_FLAG_NO_ISSUER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_FLAG_NO_ISSUER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_FLAG_NO_ISSUER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_FLAG_NO_HEADER(lib);
}

static int _cffi_const_X509_FLAG_NO_PUBKEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_FLAG_NO_PUBKEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_FLAG_NO_PUBKEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_FLAG_NO_ISSUER(lib);
}

static int _cffi_const_X509_FLAG_NO_SERIAL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_FLAG_NO_SERIAL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_FLAG_NO_SERIAL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_FLAG_NO_PUBKEY(lib);
}

static int _cffi_const_X509_FLAG_NO_SIGDUMP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_FLAG_NO_SIGDUMP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_FLAG_NO_SIGDUMP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_FLAG_NO_SERIAL(lib);
}

static int _cffi_const_X509_FLAG_NO_SIGNAME(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_FLAG_NO_SIGNAME);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_FLAG_NO_SIGNAME", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_FLAG_NO_SIGDUMP(lib);
}

static int _cffi_const_X509_FLAG_NO_SUBJECT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_FLAG_NO_SUBJECT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_FLAG_NO_SUBJECT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_FLAG_NO_SIGNAME(lib);
}

static int _cffi_const_X509_FLAG_NO_VALIDITY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_FLAG_NO_VALIDITY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_FLAG_NO_VALIDITY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_FLAG_NO_SUBJECT(lib);
}

static int _cffi_const_X509_FLAG_NO_VERSION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_FLAG_NO_VERSION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_FLAG_NO_VERSION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_FLAG_NO_VALIDITY(lib);
}

static int _cffi_const_X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_FLAG_NO_VERSION(lib);
}

static int _cffi_const_X509_V_ERR_AKID_SKID_MISMATCH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_AKID_SKID_MISMATCH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_AKID_SKID_MISMATCH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH(lib);
}

static int _cffi_const_X509_V_ERR_APPLICATION_VERIFICATION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_APPLICATION_VERIFICATION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_APPLICATION_VERIFICATION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_AKID_SKID_MISMATCH(lib);
}

static int _cffi_const_X509_V_ERR_CERT_CHAIN_TOO_LONG(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_CERT_CHAIN_TOO_LONG);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_CERT_CHAIN_TOO_LONG", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_APPLICATION_VERIFICATION(lib);
}

static int _cffi_const_X509_V_ERR_CERT_HAS_EXPIRED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_CERT_HAS_EXPIRED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_CERT_HAS_EXPIRED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_CERT_CHAIN_TOO_LONG(lib);
}

static int _cffi_const_X509_V_ERR_CERT_NOT_YET_VALID(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_CERT_NOT_YET_VALID);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_CERT_NOT_YET_VALID", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_CERT_HAS_EXPIRED(lib);
}

static int _cffi_const_X509_V_ERR_CERT_REJECTED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_CERT_REJECTED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_CERT_REJECTED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_CERT_NOT_YET_VALID(lib);
}

static int _cffi_const_X509_V_ERR_CERT_REVOKED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_CERT_REVOKED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_CERT_REVOKED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_CERT_REJECTED(lib);
}

static int _cffi_const_X509_V_ERR_CERT_SIGNATURE_FAILURE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_CERT_SIGNATURE_FAILURE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_CERT_SIGNATURE_FAILURE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_CERT_REVOKED(lib);
}

static int _cffi_const_X509_V_ERR_CERT_UNTRUSTED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_CERT_UNTRUSTED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_CERT_UNTRUSTED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_CERT_SIGNATURE_FAILURE(lib);
}

static int _cffi_const_X509_V_ERR_CRL_HAS_EXPIRED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_CRL_HAS_EXPIRED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_CRL_HAS_EXPIRED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_CERT_UNTRUSTED(lib);
}

static int _cffi_const_X509_V_ERR_CRL_NOT_YET_VALID(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_CRL_NOT_YET_VALID);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_CRL_NOT_YET_VALID", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_CRL_HAS_EXPIRED(lib);
}

static int _cffi_const_X509_V_ERR_CRL_PATH_VALIDATION_ERROR(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_CRL_PATH_VALIDATION_ERROR);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_CRL_PATH_VALIDATION_ERROR", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_CRL_NOT_YET_VALID(lib);
}

static int _cffi_const_X509_V_ERR_CRL_SIGNATURE_FAILURE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_CRL_SIGNATURE_FAILURE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_CRL_SIGNATURE_FAILURE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_CRL_PATH_VALIDATION_ERROR(lib);
}

static int _cffi_const_X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_CRL_SIGNATURE_FAILURE(lib);
}

static int _cffi_const_X509_V_ERR_DIFFERENT_CRL_SCOPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_DIFFERENT_CRL_SCOPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_DIFFERENT_CRL_SCOPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT(lib);
}

static int _cffi_const_X509_V_ERR_EMAIL_MISMATCH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_EMAIL_MISMATCH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_EMAIL_MISMATCH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_DIFFERENT_CRL_SCOPE(lib);
}

static int _cffi_const_X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_EMAIL_MISMATCH(lib);
}

static int _cffi_const_X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD(lib);
}

static int _cffi_const_X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD(lib);
}

static int _cffi_const_X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD(lib);
}

static int _cffi_const_X509_V_ERR_EXCLUDED_VIOLATION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_EXCLUDED_VIOLATION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_EXCLUDED_VIOLATION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD(lib);
}

static int _cffi_const_X509_V_ERR_HOSTNAME_MISMATCH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_HOSTNAME_MISMATCH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_HOSTNAME_MISMATCH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_EXCLUDED_VIOLATION(lib);
}

static int _cffi_const_X509_V_ERR_INVALID_CA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_INVALID_CA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_INVALID_CA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_HOSTNAME_MISMATCH(lib);
}

static int _cffi_const_X509_V_ERR_INVALID_EXTENSION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_INVALID_EXTENSION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_INVALID_EXTENSION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_INVALID_CA(lib);
}

static int _cffi_const_X509_V_ERR_INVALID_NON_CA(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_INVALID_NON_CA);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_INVALID_NON_CA", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_INVALID_EXTENSION(lib);
}

static int _cffi_const_X509_V_ERR_INVALID_POLICY_EXTENSION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_INVALID_POLICY_EXTENSION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_INVALID_POLICY_EXTENSION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_INVALID_NON_CA(lib);
}

static int _cffi_const_X509_V_ERR_INVALID_PURPOSE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_INVALID_PURPOSE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_INVALID_PURPOSE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_INVALID_POLICY_EXTENSION(lib);
}

static int _cffi_const_X509_V_ERR_IP_ADDRESS_MISMATCH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_IP_ADDRESS_MISMATCH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_IP_ADDRESS_MISMATCH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_INVALID_PURPOSE(lib);
}

static int _cffi_const_X509_V_ERR_KEYUSAGE_NO_CERTSIGN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_KEYUSAGE_NO_CERTSIGN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_KEYUSAGE_NO_CERTSIGN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_IP_ADDRESS_MISMATCH(lib);
}

static int _cffi_const_X509_V_ERR_KEYUSAGE_NO_CRL_SIGN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_KEYUSAGE_NO_CRL_SIGN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_KEYUSAGE_NO_CRL_SIGN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_KEYUSAGE_NO_CERTSIGN(lib);
}

static int _cffi_const_X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_KEYUSAGE_NO_CRL_SIGN(lib);
}

static int _cffi_const_X509_V_ERR_NO_EXPLICIT_POLICY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_NO_EXPLICIT_POLICY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_NO_EXPLICIT_POLICY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE(lib);
}

static int _cffi_const_X509_V_ERR_OUT_OF_MEM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_OUT_OF_MEM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_OUT_OF_MEM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_NO_EXPLICIT_POLICY(lib);
}

static int _cffi_const_X509_V_ERR_PATH_LENGTH_EXCEEDED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_PATH_LENGTH_EXCEEDED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_PATH_LENGTH_EXCEEDED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_OUT_OF_MEM(lib);
}

static int _cffi_const_X509_V_ERR_PERMITTED_VIOLATION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_PERMITTED_VIOLATION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_PERMITTED_VIOLATION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_PATH_LENGTH_EXCEEDED(lib);
}

static int _cffi_const_X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_PERMITTED_VIOLATION(lib);
}

static int _cffi_const_X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED(lib);
}

static int _cffi_const_X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED(lib);
}

static int _cffi_const_X509_V_ERR_SUBJECT_ISSUER_MISMATCH(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_SUBJECT_ISSUER_MISMATCH);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_SUBJECT_ISSUER_MISMATCH", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN(lib);
}

static int _cffi_const_X509_V_ERR_SUBTREE_MINMAX(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_SUBTREE_MINMAX);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_SUBTREE_MINMAX", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_SUBJECT_ISSUER_MISMATCH(lib);
}

static int _cffi_const_X509_V_ERR_SUITE_B_CANNOT_SIGN_P_384_WITH_P_256(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_SUITE_B_CANNOT_SIGN_P_384_WITH_P_256);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_SUITE_B_CANNOT_SIGN_P_384_WITH_P_256", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_SUBTREE_MINMAX(lib);
}

static int _cffi_const_X509_V_ERR_SUITE_B_INVALID_ALGORITHM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_SUITE_B_INVALID_ALGORITHM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_SUITE_B_INVALID_ALGORITHM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_SUITE_B_CANNOT_SIGN_P_384_WITH_P_256(lib);
}

static int _cffi_const_X509_V_ERR_SUITE_B_INVALID_CURVE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_SUITE_B_INVALID_CURVE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_SUITE_B_INVALID_CURVE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_SUITE_B_INVALID_ALGORITHM(lib);
}

static int _cffi_const_X509_V_ERR_SUITE_B_INVALID_SIGNATURE_ALGORITHM(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_SUITE_B_INVALID_SIGNATURE_ALGORITHM);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_SUITE_B_INVALID_SIGNATURE_ALGORITHM", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_SUITE_B_INVALID_CURVE(lib);
}

static int _cffi_const_X509_V_ERR_SUITE_B_INVALID_VERSION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_SUITE_B_INVALID_VERSION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_SUITE_B_INVALID_VERSION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_SUITE_B_INVALID_SIGNATURE_ALGORITHM(lib);
}

static int _cffi_const_X509_V_ERR_SUITE_B_LOS_NOT_ALLOWED(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_SUITE_B_LOS_NOT_ALLOWED);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_SUITE_B_LOS_NOT_ALLOWED", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_SUITE_B_INVALID_VERSION(lib);
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_SUITE_B_LOS_NOT_ALLOWED(lib);
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY(lib);
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE(lib);
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_GET_CRL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNABLE_TO_GET_CRL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNABLE_TO_GET_CRL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE(lib);
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNABLE_TO_GET_CRL(lib);
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER(lib);
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT(lib);
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY(lib);
}

static int _cffi_const_X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE(lib);
}

static int _cffi_const_X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION(lib);
}

static int _cffi_const_X509_V_ERR_UNNESTED_RESOURCE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNNESTED_RESOURCE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNNESTED_RESOURCE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION(lib);
}

static int _cffi_const_X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNNESTED_RESOURCE(lib);
}

static int _cffi_const_X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX(lib);
}

static int _cffi_const_X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE(lib);
}

static int _cffi_const_X509_V_ERR_UNSUPPORTED_NAME_SYNTAX(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_ERR_UNSUPPORTED_NAME_SYNTAX);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_ERR_UNSUPPORTED_NAME_SYNTAX", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE(lib);
}

static int _cffi_const_X509_V_FLAG_ALLOW_PROXY_CERTS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_ALLOW_PROXY_CERTS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_ALLOW_PROXY_CERTS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_ERR_UNSUPPORTED_NAME_SYNTAX(lib);
}

static int _cffi_const_X509_V_FLAG_CB_ISSUER_CHECK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_CB_ISSUER_CHECK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_CB_ISSUER_CHECK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_ALLOW_PROXY_CERTS(lib);
}

static int _cffi_const_X509_V_FLAG_CHECK_SS_SIGNATURE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_CHECK_SS_SIGNATURE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_CHECK_SS_SIGNATURE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_CB_ISSUER_CHECK(lib);
}

static int _cffi_const_X509_V_FLAG_CRL_CHECK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_CRL_CHECK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_CRL_CHECK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_CHECK_SS_SIGNATURE(lib);
}

static int _cffi_const_X509_V_FLAG_CRL_CHECK_ALL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_CRL_CHECK_ALL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_CRL_CHECK_ALL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_CRL_CHECK(lib);
}

static int _cffi_const_X509_V_FLAG_EXPLICIT_POLICY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_EXPLICIT_POLICY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_EXPLICIT_POLICY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_CRL_CHECK_ALL(lib);
}

static int _cffi_const_X509_V_FLAG_EXTENDED_CRL_SUPPORT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_EXTENDED_CRL_SUPPORT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_EXTENDED_CRL_SUPPORT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_EXPLICIT_POLICY(lib);
}

static int _cffi_const_X509_V_FLAG_IGNORE_CRITICAL(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_IGNORE_CRITICAL);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_IGNORE_CRITICAL", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_EXTENDED_CRL_SUPPORT(lib);
}

static int _cffi_const_X509_V_FLAG_INHIBIT_ANY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_INHIBIT_ANY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_INHIBIT_ANY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_IGNORE_CRITICAL(lib);
}

static int _cffi_const_X509_V_FLAG_INHIBIT_MAP(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_INHIBIT_MAP);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_INHIBIT_MAP", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_INHIBIT_ANY(lib);
}

static int _cffi_const_X509_V_FLAG_NOTIFY_POLICY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_NOTIFY_POLICY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_NOTIFY_POLICY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_INHIBIT_MAP(lib);
}

static int _cffi_const_X509_V_FLAG_PARTIAL_CHAIN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_PARTIAL_CHAIN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_PARTIAL_CHAIN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_NOTIFY_POLICY(lib);
}

static int _cffi_const_X509_V_FLAG_POLICY_CHECK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_POLICY_CHECK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_POLICY_CHECK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_PARTIAL_CHAIN(lib);
}

static int _cffi_const_X509_V_FLAG_SUITEB_128_LOS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_SUITEB_128_LOS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_SUITEB_128_LOS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_POLICY_CHECK(lib);
}

static int _cffi_const_X509_V_FLAG_SUITEB_128_LOS_ONLY(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_SUITEB_128_LOS_ONLY);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_SUITEB_128_LOS_ONLY", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_SUITEB_128_LOS(lib);
}

static int _cffi_const_X509_V_FLAG_SUITEB_192_LOS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_SUITEB_192_LOS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_SUITEB_192_LOS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_SUITEB_128_LOS_ONLY(lib);
}

static int _cffi_const_X509_V_FLAG_TRUSTED_FIRST(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_TRUSTED_FIRST);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_TRUSTED_FIRST", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_SUITEB_192_LOS(lib);
}

static int _cffi_const_X509_V_FLAG_USE_CHECK_TIME(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_USE_CHECK_TIME);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_USE_CHECK_TIME", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_TRUSTED_FIRST(lib);
}

static int _cffi_const_X509_V_FLAG_USE_DELTAS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_USE_DELTAS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_USE_DELTAS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_USE_CHECK_TIME(lib);
}

static int _cffi_const_X509_V_FLAG_X509_STRICT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_FLAG_X509_STRICT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_FLAG_X509_STRICT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_USE_DELTAS(lib);
}

static int _cffi_const_X509_V_OK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(X509_V_OK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "X509_V_OK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_FLAG_X509_STRICT(lib);
}

static int _cffi_const_XN_FLAG_COMPAT(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_COMPAT);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_COMPAT", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_X509_V_OK(lib);
}

static int _cffi_const_XN_FLAG_DN_REV(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_DN_REV);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_DN_REV", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_COMPAT(lib);
}

static int _cffi_const_XN_FLAG_DUMP_UNKNOWN_FIELDS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_DUMP_UNKNOWN_FIELDS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_DUMP_UNKNOWN_FIELDS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_DN_REV(lib);
}

static int _cffi_const_XN_FLAG_FN_ALIGN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_FN_ALIGN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_FN_ALIGN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_DUMP_UNKNOWN_FIELDS(lib);
}

static int _cffi_const_XN_FLAG_FN_LN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_FN_LN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_FN_LN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_FN_ALIGN(lib);
}

static int _cffi_const_XN_FLAG_FN_MASK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_FN_MASK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_FN_MASK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_FN_LN(lib);
}

static int _cffi_const_XN_FLAG_FN_NONE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_FN_NONE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_FN_NONE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_FN_MASK(lib);
}

static int _cffi_const_XN_FLAG_FN_OID(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_FN_OID);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_FN_OID", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_FN_NONE(lib);
}

static int _cffi_const_XN_FLAG_FN_SN(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_FN_SN);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_FN_SN", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_FN_OID(lib);
}

static int _cffi_const_XN_FLAG_MULTILINE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_MULTILINE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_MULTILINE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_FN_SN(lib);
}

static int _cffi_const_XN_FLAG_ONELINE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_ONELINE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_ONELINE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_MULTILINE(lib);
}

static int _cffi_const_XN_FLAG_RFC2253(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_RFC2253);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_RFC2253", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_ONELINE(lib);
}

static int _cffi_const_XN_FLAG_SEP_COMMA_PLUS(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_SEP_COMMA_PLUS);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_SEP_COMMA_PLUS", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_RFC2253(lib);
}

static int _cffi_const_XN_FLAG_SEP_CPLUS_SPC(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_SEP_CPLUS_SPC);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_SEP_CPLUS_SPC", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_SEP_COMMA_PLUS(lib);
}

static int _cffi_const_XN_FLAG_SEP_MASK(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_SEP_MASK);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_SEP_MASK", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_SEP_CPLUS_SPC(lib);
}

static int _cffi_const_XN_FLAG_SEP_MULTILINE(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_SEP_MULTILINE);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_SEP_MULTILINE", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_SEP_MASK(lib);
}

static int _cffi_const_XN_FLAG_SEP_SPLUS_SPC(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_SEP_SPLUS_SPC);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_SEP_SPLUS_SPC", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_SEP_MULTILINE(lib);
}

static int _cffi_const_XN_FLAG_SPC_EQ(PyObject *lib)
{
  PyObject *o;
  int res;
  o = _cffi_from_c_int_const(XN_FLAG_SPC_EQ);
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "XN_FLAG_SPC_EQ", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_SEP_SPLUS_SPC(lib);
}

static PyObject *
_cffi_f_AES_ctr128_encrypt(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  unsigned char * x1;
  size_t x2;
  AES_KEY const * x3;
  unsigned char * x4;
  unsigned char * x5;
  unsigned int * x6;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_ParseTuple(args, "OOOOOOO:AES_ctr128_encrypt", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(1), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(3), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(2), arg4) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = alloca(datasize);
    memset((void *)x5, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(2), arg5) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = alloca(datasize);
    memset((void *)x6, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(4), arg6) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { AES_ctr128_encrypt(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_AES_set_decrypt_key(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  AES_KEY * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:AES_set_decrypt_key", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(1), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(6), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = AES_set_decrypt_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_AES_set_encrypt_key(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  AES_KEY * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:AES_set_encrypt_key", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(1), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(6), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = AES_set_encrypt_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_AES_unwrap_key(PyObject *self, PyObject *args)
{
  AES_KEY * x0;
  unsigned char const * x1;
  unsigned char * x2;
  unsigned char const * x3;
  unsigned int x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:AES_unwrap_key", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(6), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(2), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = AES_unwrap_key(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_AES_wrap_key(PyObject *self, PyObject *args)
{
  AES_KEY * x0;
  unsigned char const * x1;
  unsigned char * x2;
  unsigned char const * x3;
  unsigned int x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:AES_wrap_key", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(6), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(2), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = AES_wrap_key(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_BIT_STRING_free(PyObject *self, PyObject *arg0)
{
  ASN1_BIT_STRING * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(7), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ASN1_BIT_STRING_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ASN1_BIT_STRING_get_bit(PyObject *self, PyObject *args)
{
  ASN1_BIT_STRING * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_BIT_STRING_get_bit", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(7), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_BIT_STRING_get_bit(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_BIT_STRING_set_bit(PyObject *self, PyObject *args)
{
  ASN1_BIT_STRING * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:ASN1_BIT_STRING_set_bit", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(7), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_BIT_STRING_set_bit(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_ENUMERATED_free(PyObject *self, PyObject *arg0)
{
  ASN1_ENUMERATED * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(8), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ASN1_ENUMERATED_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ASN1_ENUMERATED_new(PyObject *self, PyObject *no_arg)
{
  ASN1_ENUMERATED * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_ENUMERATED_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(8));
}

static PyObject *
_cffi_f_ASN1_ENUMERATED_set(PyObject *self, PyObject *args)
{
  ASN1_ENUMERATED * x0;
  long x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_ENUMERATED_set", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(8), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_ENUMERATED_set(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_GENERALIZEDTIME_check(PyObject *self, PyObject *arg0)
{
  ASN1_GENERALIZEDTIME * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(9), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_GENERALIZEDTIME_check(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_GENERALIZEDTIME_free(PyObject *self, PyObject *arg0)
{
  ASN1_GENERALIZEDTIME * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(9), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ASN1_GENERALIZEDTIME_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ASN1_GENERALIZEDTIME_set_string(PyObject *self, PyObject *args)
{
  ASN1_GENERALIZEDTIME * x0;
  char const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_GENERALIZEDTIME_set_string", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(9), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_GENERALIZEDTIME_set_string(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_INTEGER_cmp(PyObject *self, PyObject *args)
{
  ASN1_INTEGER * x0;
  ASN1_INTEGER * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_INTEGER_cmp", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(10), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(10), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_INTEGER_cmp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_INTEGER_dup(PyObject *self, PyObject *arg0)
{
  ASN1_INTEGER * x0;
  Py_ssize_t datasize;
  ASN1_INTEGER * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(10), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_INTEGER_dup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(10));
}

static PyObject *
_cffi_f_ASN1_INTEGER_free(PyObject *self, PyObject *arg0)
{
  ASN1_INTEGER * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(10), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ASN1_INTEGER_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ASN1_INTEGER_get(PyObject *self, PyObject *arg0)
{
  ASN1_INTEGER * x0;
  Py_ssize_t datasize;
  long result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(10), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_INTEGER_get(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_ASN1_INTEGER_new(PyObject *self, PyObject *no_arg)
{
  ASN1_INTEGER * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_INTEGER_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(10));
}

static PyObject *
_cffi_f_ASN1_INTEGER_set(PyObject *self, PyObject *args)
{
  ASN1_INTEGER * x0;
  long x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_INTEGER_set", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(10), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_INTEGER_set(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_INTEGER_to_BN(PyObject *self, PyObject *args)
{
  ASN1_INTEGER * x0;
  BIGNUM * x1;
  Py_ssize_t datasize;
  BIGNUM * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_INTEGER_to_BN", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(10), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(11), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_INTEGER_to_BN(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(11));
}

static PyObject *
_cffi_f_ASN1_ITEM_ptr(PyObject *self, PyObject *arg0)
{
  ASN1_ITEM_EXP * x0;
  Py_ssize_t datasize;
  ASN1_ITEM const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(12), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_ITEM_ptr(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(13));
}

static PyObject *
_cffi_f_ASN1_OBJECT_free(PyObject *self, PyObject *arg0)
{
  ASN1_OBJECT * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(14), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ASN1_OBJECT_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ASN1_OBJECT_new(PyObject *self, PyObject *no_arg)
{
  ASN1_OBJECT * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_OBJECT_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(14));
}

static PyObject *
_cffi_f_ASN1_OCTET_STRING_cmp(PyObject *self, PyObject *args)
{
  ASN1_OCTET_STRING * x0;
  ASN1_OCTET_STRING * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_OCTET_STRING_cmp", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(15), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(15), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_OCTET_STRING_cmp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_OCTET_STRING_dup(PyObject *self, PyObject *arg0)
{
  ASN1_OCTET_STRING * x0;
  Py_ssize_t datasize;
  ASN1_OCTET_STRING * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(15), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_OCTET_STRING_dup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(15));
}

static PyObject *
_cffi_f_ASN1_OCTET_STRING_free(PyObject *self, PyObject *arg0)
{
  ASN1_OCTET_STRING * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(15), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ASN1_OCTET_STRING_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ASN1_OCTET_STRING_new(PyObject *self, PyObject *no_arg)
{
  ASN1_OCTET_STRING * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_OCTET_STRING_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(15));
}

static PyObject *
_cffi_f_ASN1_OCTET_STRING_set(PyObject *self, PyObject *args)
{
  ASN1_OCTET_STRING * x0;
  unsigned char const * x1;
  int x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:ASN1_OCTET_STRING_set", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(15), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_OCTET_STRING_set(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_STRING_cmp(PyObject *self, PyObject *args)
{
  ASN1_STRING * x0;
  ASN1_STRING * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_STRING_cmp", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(16), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(16), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_cmp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_STRING_data(PyObject *self, PyObject *arg0)
{
  ASN1_STRING * x0;
  Py_ssize_t datasize;
  unsigned char * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(16), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_data(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(2));
}

static PyObject *
_cffi_f_ASN1_STRING_dup(PyObject *self, PyObject *arg0)
{
  ASN1_STRING * x0;
  Py_ssize_t datasize;
  ASN1_STRING * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(16), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_dup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(16));
}

static PyObject *
_cffi_f_ASN1_STRING_free(PyObject *self, PyObject *arg0)
{
  ASN1_STRING * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(16), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ASN1_STRING_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ASN1_STRING_length(PyObject *self, PyObject *arg0)
{
  ASN1_STRING * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(16), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_STRING_new(PyObject *self, PyObject *no_arg)
{
  ASN1_STRING * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(16));
}

static PyObject *
_cffi_f_ASN1_STRING_set(PyObject *self, PyObject *args)
{
  ASN1_STRING * x0;
  void const * x1;
  int x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:ASN1_STRING_set", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(16), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(17), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_set(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_STRING_set_default_mask_asc(PyObject *self, PyObject *arg0)
{
  char * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(18), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_set_default_mask_asc(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_STRING_to_UTF8(PyObject *self, PyObject *args)
{
  unsigned char * * x0;
  ASN1_STRING * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_STRING_to_UTF8", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(19), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(16), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_to_UTF8(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_STRING_type(PyObject *self, PyObject *arg0)
{
  ASN1_STRING * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(16), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_STRING_type_new(PyObject *self, PyObject *arg0)
{
  int x0;
  ASN1_STRING * result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_type_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(16));
}

static PyObject *
_cffi_f_ASN1_TIME_free(PyObject *self, PyObject *arg0)
{
  ASN1_TIME * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(20), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ASN1_TIME_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ASN1_TIME_new(PyObject *self, PyObject *no_arg)
{
  ASN1_TIME * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_TIME_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(20));
}

static PyObject *
_cffi_f_ASN1_TIME_print(PyObject *self, PyObject *args)
{
  BIO * x0;
  ASN1_TIME * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_TIME_print", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(20), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_TIME_print(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_TIME_to_generalizedtime(PyObject *self, PyObject *args)
{
  ASN1_TIME * x0;
  ASN1_GENERALIZEDTIME * * x1;
  Py_ssize_t datasize;
  ASN1_GENERALIZEDTIME * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_TIME_to_generalizedtime", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(20), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(22), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_TIME_to_generalizedtime(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(9));
}

static PyObject *
_cffi_f_ASN1_UTCTIME_check(PyObject *self, PyObject *arg0)
{
  ASN1_UTCTIME * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(23), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_UTCTIME_check(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_UTCTIME_cmp_time_t(PyObject *self, PyObject *args)
{
  ASN1_UTCTIME const * x0;
  intptr_t x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_UTCTIME_cmp_time_t", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(24), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, intptr_t);
  if (x1 == (intptr_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_UTCTIME_cmp_time_t(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_UTCTIME_free(PyObject *self, PyObject *arg0)
{
  ASN1_UTCTIME * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(23), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ASN1_UTCTIME_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ASN1_UTCTIME_new(PyObject *self, PyObject *no_arg)
{
  ASN1_UTCTIME * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_UTCTIME_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(23));
}

static PyObject *
_cffi_f_ASN1_UTCTIME_print(PyObject *self, PyObject *args)
{
  BIO * x0;
  ASN1_UTCTIME * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_UTCTIME_print", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(23), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_UTCTIME_print(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ASN1_UTCTIME_set(PyObject *self, PyObject *args)
{
  ASN1_UTCTIME * x0;
  intptr_t x1;
  Py_ssize_t datasize;
  ASN1_UTCTIME * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ASN1_UTCTIME_set", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(23), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, intptr_t);
  if (x1 == (intptr_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_UTCTIME_set(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(23));
}

static PyObject *
_cffi_f_ASN1_item_d2i(PyObject *self, PyObject *args)
{
  ASN1_VALUE * * x0;
  unsigned char const * * x1;
  long x2;
  ASN1_ITEM const * x3;
  Py_ssize_t datasize;
  ASN1_VALUE * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:ASN1_item_d2i", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(25), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(26), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, long);
  if (x2 == (long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(13), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_item_d2i(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(27));
}

static PyObject *
_cffi_f_AUTHORITY_KEYID_free(PyObject *self, PyObject *arg0)
{
  AUTHORITY_KEYID * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(28), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { AUTHORITY_KEYID_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_BASIC_CONSTRAINTS_free(PyObject *self, PyObject *arg0)
{
  BASIC_CONSTRAINTS * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(29), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { BASIC_CONSTRAINTS_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_BIO_append_filename(PyObject *self, PyObject *args)
{
  BIO * x0;
  char * x1;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_append_filename", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(18), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_append_filename(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_callback_ctrl(PyObject *self, PyObject *args)
{
  BIO * x0;
  int x1;
  void(* x2)(BIO *, int, char const *, int, long, long);
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BIO_callback_ctrl", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (void(*)(BIO *, int, char const *, int, long, long))_cffi_to_c_pointer(arg2, _cffi_type(30));
  if (x2 == (void(*)(BIO *, int, char const *, int, long, long))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_callback_ctrl(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_ctrl(PyObject *self, PyObject *args)
{
  BIO * x0;
  int x1;
  long x2;
  void * x3;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:BIO_ctrl", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, long);
  if (x2 == (long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_ctrl(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_ctrl_pending(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  size_t result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_ctrl_pending(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, size_t);
}

static PyObject *
_cffi_f_BIO_ctrl_wpending(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  size_t result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_ctrl_wpending(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, size_t);
}

static PyObject *
_cffi_f_BIO_eof(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_eof(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_f_buffer(PyObject *self, PyObject *no_arg)
{
  BIO_METHOD * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_f_buffer(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(32));
}

static PyObject *
_cffi_f_BIO_f_null(PyObject *self, PyObject *no_arg)
{
  BIO_METHOD * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_f_null(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(32));
}

static PyObject *
_cffi_f_BIO_find_type(PyObject *self, PyObject *args)
{
  BIO * x0;
  int x1;
  Py_ssize_t datasize;
  BIO * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_find_type", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_find_type(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(21));
}

static PyObject *
_cffi_f_BIO_flush(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_flush(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_free(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_free_all(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { BIO_free_all(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_BIO_get_buffer_num_lines(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  long result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_get_buffer_num_lines(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_get_close(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_get_close(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_get_fd(PyObject *self, PyObject *args)
{
  BIO * x0;
  char * x1;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_get_fd", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(18), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_get_fd(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_get_fp(PyObject *self, PyObject *args)
{
  BIO * x0;
  FILE * * x1;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_get_fp", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(33), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_get_fp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_get_info_callback(PyObject *self, PyObject *args)
{
  BIO * x0;
  void(* * x1)(BIO *, int, char const *, int, long, long);
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_get_info_callback", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(34), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(34), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_get_info_callback(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_get_mem_data(PyObject *self, PyObject *args)
{
  BIO * x0;
  char * * x1;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_get_mem_data", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(35), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_get_mem_data(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_get_mem_ptr(PyObject *self, PyObject *args)
{
  BIO * x0;
  BUF_MEM * * x1;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_get_mem_ptr", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(36), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_get_mem_ptr(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_gets(PyObject *self, PyObject *args)
{
  BIO * x0;
  char * x1;
  int x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BIO_gets", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(18), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_gets(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_int_ctrl(PyObject *self, PyObject *args)
{
  BIO * x0;
  int x1;
  long x2;
  int x3;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:BIO_int_ctrl", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, long);
  if (x2 == (long)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_int_ctrl(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_method_type(PyObject *self, PyObject *arg0)
{
  BIO const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(37), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_method_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_new(PyObject *self, PyObject *arg0)
{
  BIO_METHOD * x0;
  Py_ssize_t datasize;
  BIO * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(32), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(32), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(21));
}

static PyObject *
_cffi_f_BIO_new_CMS(PyObject *self, PyObject *args)
{
  BIO * x0;
  CMS_ContentInfo * x1;
  Py_ssize_t datasize;
  BIO * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_new_CMS", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(38), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_new_CMS(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(21));
}

static PyObject *
_cffi_f_BIO_new_fd(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  BIO * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_new_fd", &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_new_fd(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(21));
}

static PyObject *
_cffi_f_BIO_new_file(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * x1;
  Py_ssize_t datasize;
  BIO * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_new_file", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_new_file(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(21));
}

static PyObject *
_cffi_f_BIO_new_fp(PyObject *self, PyObject *args)
{
  FILE * x0;
  int x1;
  Py_ssize_t datasize;
  BIO * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_new_fp", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_new_fp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(21));
}

static PyObject *
_cffi_f_BIO_new_mem_buf(PyObject *self, PyObject *args)
{
  void * x0;
  int x1;
  Py_ssize_t datasize;
  BIO * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_new_mem_buf", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(31), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_new_mem_buf(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(21));
}

static PyObject *
_cffi_f_BIO_new_socket(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  BIO * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_new_socket", &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_new_socket(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(21));
}

static PyObject *
_cffi_f_BIO_next(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  BIO * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(21));
}

static PyObject *
_cffi_f_BIO_pending(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_pending(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_pop(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  BIO * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_pop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(21));
}

static PyObject *
_cffi_f_BIO_ptr_ctrl(PyObject *self, PyObject *args)
{
  BIO * x0;
  int x1;
  long x2;
  Py_ssize_t datasize;
  char * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BIO_ptr_ctrl", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, long);
  if (x2 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_ptr_ctrl(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(18));
}

static PyObject *
_cffi_f_BIO_push(PyObject *self, PyObject *args)
{
  BIO * x0;
  BIO * x1;
  Py_ssize_t datasize;
  BIO * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_push", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(21), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_push(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(21));
}

static PyObject *
_cffi_f_BIO_puts(PyObject *self, PyObject *args)
{
  BIO * x0;
  char const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_puts", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_puts(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_read(PyObject *self, PyObject *args)
{
  BIO * x0;
  void * x1;
  int x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BIO_read", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(31), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_read(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_read_filename(PyObject *self, PyObject *args)
{
  BIO * x0;
  char * x1;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_read_filename", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(18), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_read_filename(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_reset(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_reset(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_retry_type(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_retry_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_rw_filename(PyObject *self, PyObject *args)
{
  BIO * x0;
  char * x1;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_rw_filename", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(18), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_rw_filename(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_s_fd(PyObject *self, PyObject *no_arg)
{
  BIO_METHOD * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_s_fd(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(32));
}

static PyObject *
_cffi_f_BIO_s_file(PyObject *self, PyObject *no_arg)
{
  BIO_METHOD * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_s_file(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(32));
}

static PyObject *
_cffi_f_BIO_s_mem(PyObject *self, PyObject *no_arg)
{
  BIO_METHOD * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_s_mem(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(32));
}

static PyObject *
_cffi_f_BIO_s_null(PyObject *self, PyObject *no_arg)
{
  BIO_METHOD * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_s_null(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(32));
}

static PyObject *
_cffi_f_BIO_s_socket(PyObject *self, PyObject *no_arg)
{
  BIO_METHOD * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_s_socket(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(32));
}

static PyObject *
_cffi_f_BIO_seek(PyObject *self, PyObject *args)
{
  BIO * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_seek", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_seek(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_set(PyObject *self, PyObject *args)
{
  BIO * x0;
  BIO_METHOD * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_set", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(32), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(32), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_set(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_set_buffer_read_data(PyObject *self, PyObject *args)
{
  BIO * x0;
  void * x1;
  long x2;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BIO_set_buffer_read_data", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(31), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, long);
  if (x2 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_set_buffer_read_data(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_set_buffer_size(PyObject *self, PyObject *args)
{
  BIO * x0;
  long x1;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_set_buffer_size", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_set_buffer_size(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_set_close(PyObject *self, PyObject *args)
{
  BIO * x0;
  long x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_set_close", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_set_close(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_set_fd(PyObject *self, PyObject *args)
{
  BIO * x0;
  long x1;
  int x2;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BIO_set_fd", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_set_fd(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_set_fp(PyObject *self, PyObject *args)
{
  BIO * x0;
  FILE * x1;
  int x2;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BIO_set_fp", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(39), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_set_fp(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_set_info_callback(PyObject *self, PyObject *args)
{
  BIO * x0;
  void(* x1)(BIO *, int, char const *, int, long, long);
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_set_info_callback", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  x1 = (void(*)(BIO *, int, char const *, int, long, long))_cffi_to_c_pointer(arg1, _cffi_type(30));
  if (x1 == (void(*)(BIO *, int, char const *, int, long, long))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_set_info_callback(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_set_mem_buf(PyObject *self, PyObject *args)
{
  BIO * x0;
  BUF_MEM * x1;
  int x2;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BIO_set_mem_buf", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(40), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_set_mem_buf(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_set_mem_eof_return(PyObject *self, PyObject *args)
{
  BIO * x0;
  int x1;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_set_mem_eof_return", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_set_mem_eof_return(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_set_read_buffer_size(PyObject *self, PyObject *args)
{
  BIO * x0;
  long x1;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_set_read_buffer_size", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_set_read_buffer_size(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_set_write_buffer_size(PyObject *self, PyObject *args)
{
  BIO * x0;
  long x1;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_set_write_buffer_size", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_set_write_buffer_size(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BIO_should_io_special(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_should_io_special(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_should_read(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_should_read(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_should_retry(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_should_retry(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_should_write(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_should_write(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_tell(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_tell(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_vfree(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { BIO_vfree(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_BIO_wpending(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_wpending(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_write(PyObject *self, PyObject *args)
{
  BIO * x0;
  void const * x1;
  int x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BIO_write", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(17), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_write(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BIO_write_filename(PyObject *self, PyObject *args)
{
  BIO * x0;
  char * x1;
  Py_ssize_t datasize;
  long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BIO_write_filename", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(18), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_write_filename(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, long);
}

static PyObject *
_cffi_f_BN_CTX_end(PyObject *self, PyObject *arg0)
{
  BN_CTX * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(41), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { BN_CTX_end(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_BN_CTX_free(PyObject *self, PyObject *arg0)
{
  BN_CTX * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(41), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { BN_CTX_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_BN_CTX_get(PyObject *self, PyObject *arg0)
{
  BN_CTX * x0;
  Py_ssize_t datasize;
  BIGNUM * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(41), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_CTX_get(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(11));
}

static PyObject *
_cffi_f_BN_CTX_new(PyObject *self, PyObject *no_arg)
{
  BN_CTX * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_CTX_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(41));
}

static PyObject *
_cffi_f_BN_CTX_start(PyObject *self, PyObject *arg0)
{
  BN_CTX * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(41), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { BN_CTX_start(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_BN_add(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BN_add", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_add(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_bin2bn(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  BIGNUM * x2;
  Py_ssize_t datasize;
  BIGNUM * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BN_bin2bn", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(1), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(11), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_bin2bn(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(11));
}

static PyObject *
_cffi_f_BN_bn2bin(PyObject *self, PyObject *args)
{
  BIGNUM const * x0;
  unsigned char * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BN_bn2bin", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(42), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_bn2bin(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_bn2hex(PyObject *self, PyObject *arg0)
{
  BIGNUM const * x0;
  Py_ssize_t datasize;
  char * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(42), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_bn2hex(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(18));
}

static PyObject *
_cffi_f_BN_clear_bit(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BN_clear_bit", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_clear_bit(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_cmp(PyObject *self, PyObject *args)
{
  BIGNUM const * x0;
  BIGNUM const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BN_cmp", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(42), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_cmp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_copy(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  Py_ssize_t datasize;
  BIGNUM * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BN_copy", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_copy(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(11));
}

static PyObject *
_cffi_f_BN_dec2bn(PyObject *self, PyObject *args)
{
  BIGNUM * * x0;
  char const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BN_dec2bn", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(43), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_dec2bn(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_div(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM * x1;
  BIGNUM const * x2;
  BIGNUM const * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:BN_div", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(11), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(42), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_div(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_dup(PyObject *self, PyObject *arg0)
{
  BIGNUM const * x0;
  Py_ssize_t datasize;
  BIGNUM * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(42), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_dup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(11));
}

static PyObject *
_cffi_f_BN_exp(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:BN_exp", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_exp(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_free(PyObject *self, PyObject *arg0)
{
  BIGNUM * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { BN_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_BN_gcd(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:BN_gcd", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_gcd(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_get_word(PyObject *self, PyObject *arg0)
{
  BIGNUM const * x0;
  Py_ssize_t datasize;
  uintptr_t result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(42), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_get_word(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, uintptr_t);
}

static PyObject *
_cffi_f_BN_hex2bn(PyObject *self, PyObject *args)
{
  BIGNUM * * x0;
  char const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BN_hex2bn", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(43), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_hex2bn(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_is_bit_set(PyObject *self, PyObject *args)
{
  BIGNUM const * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BN_is_bit_set", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(42), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_is_bit_set(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_lshift(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  int x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BN_lshift", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_lshift(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_lshift1(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BN_lshift1", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(11), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_lshift1(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_mask_bits(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BN_mask_bits", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_mask_bits(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_mod(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:BN_mod", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_mod(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_mod_add(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BIGNUM const * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:BN_mod_add", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(42), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_mod_add(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_mod_exp(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BIGNUM const * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:BN_mod_exp", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(42), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_mod_exp(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_mod_inverse(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  BIGNUM * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:BN_mod_inverse", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_mod_inverse(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(11));
}

static PyObject *
_cffi_f_BN_mod_mul(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BIGNUM const * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:BN_mod_mul", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(42), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_mod_mul(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_mod_sqr(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:BN_mod_sqr", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_mod_sqr(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_mod_sub(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BIGNUM const * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:BN_mod_sub", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(42), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_mod_sub(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_mul(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:BN_mul", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_mul(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_new(PyObject *self, PyObject *no_arg)
{
  BIGNUM * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(11));
}

static PyObject *
_cffi_f_BN_nnmod(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:BN_nnmod", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_nnmod(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_num_bits(PyObject *self, PyObject *arg0)
{
  BIGNUM const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(42), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_num_bits(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_one(PyObject *self, PyObject *arg0)
{
  BIGNUM * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_one(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_rshift(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM * x1;
  int x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BN_rshift", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(11), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_rshift(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_rshift1(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BN_rshift1", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(11), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_rshift1(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_set_bit(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BN_set_bit", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_set_bit(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_set_word(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  uintptr_t x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BN_set_word", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uintptr_t);
  if (x1 == (uintptr_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_set_word(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_sqr(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BN_CTX * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BN_sqr", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(41), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_sqr(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_sub(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:BN_sub", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_sub(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_BN_to_ASN1_INTEGER(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  ASN1_INTEGER * x1;
  Py_ssize_t datasize;
  ASN1_INTEGER * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:BN_to_ASN1_INTEGER", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(10), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_to_ASN1_INTEGER(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(10));
}

static PyObject *
_cffi_f_BN_value_one(PyObject *self, PyObject *no_arg)
{
  BIGNUM const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_value_one(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(42));
}

static PyObject *
_cffi_f_BN_zero(PyObject *self, PyObject *arg0)
{
  BIGNUM * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(11), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_zero(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_CMAC_CTX_copy(PyObject *self, PyObject *args)
{
  CMAC_CTX * x0;
  CMAC_CTX const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:CMAC_CTX_copy", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(44), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(44), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(45), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CMAC_CTX_copy(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_CMAC_CTX_free(PyObject *self, PyObject *arg0)
{
  CMAC_CTX * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(44), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(44), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { CMAC_CTX_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_CMAC_CTX_new(PyObject *self, PyObject *no_arg)
{
  CMAC_CTX * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CMAC_CTX_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(44));
}

static PyObject *
_cffi_f_CMAC_Final(PyObject *self, PyObject *args)
{
  CMAC_CTX * x0;
  unsigned char * x1;
  size_t * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:CMAC_Final", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(44), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(44), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(46), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CMAC_Final(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_CMAC_Init(PyObject *self, PyObject *args)
{
  CMAC_CTX * x0;
  void const * x1;
  size_t x2;
  EVP_CIPHER const * x3;
  ENGINE * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:CMAC_Init", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(44), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(44), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(17), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(47), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(48), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CMAC_Init(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_CMAC_Update(PyObject *self, PyObject *args)
{
  CMAC_CTX * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:CMAC_Update", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(44), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(44), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(17), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CMAC_Update(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_CMS_add1_signer(PyObject *self, PyObject *args)
{
  CMS_ContentInfo * x0;
  X509 * x1;
  EVP_PKEY * x2;
  EVP_MD const * x3;
  unsigned int x4;
  Py_ssize_t datasize;
  CMS_SignerInfo * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:CMS_add1_signer", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(38), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(49), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(50), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(51), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CMS_add1_signer(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(52));
}

static PyObject *
_cffi_f_CMS_decrypt(PyObject *self, PyObject *args)
{
  CMS_ContentInfo * x0;
  EVP_PKEY * x1;
  X509 * x2;
  BIO * x3;
  BIO * x4;
  unsigned int x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:CMS_decrypt", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(38), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(50), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(49), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(21), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(21), arg4) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CMS_decrypt(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_CMS_encrypt(PyObject *self, PyObject *args)
{
  Cryptography_STACK_OF_X509 * x0;
  BIO * x1;
  EVP_CIPHER const * x2;
  unsigned int x3;
  Py_ssize_t datasize;
  CMS_ContentInfo * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:CMS_encrypt", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(53), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(53), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(21), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(47), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CMS_encrypt(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(38));
}

static PyObject *
_cffi_f_CMS_final(PyObject *self, PyObject *args)
{
  CMS_ContentInfo * x0;
  BIO * x1;
  BIO * x2;
  unsigned int x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:CMS_final", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(38), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(21), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(21), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned int);
  if (x3 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CMS_final(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_CMS_sign(PyObject *self, PyObject *args)
{
  X509 * x0;
  EVP_PKEY * x1;
  Cryptography_STACK_OF_X509 * x2;
  BIO * x3;
  unsigned int x4;
  Py_ssize_t datasize;
  CMS_ContentInfo * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:CMS_sign", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(49), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(50), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(53), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(53), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(21), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CMS_sign(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(38));
}

static PyObject *
_cffi_f_CMS_verify(PyObject *self, PyObject *args)
{
  CMS_ContentInfo * x0;
  Cryptography_STACK_OF_X509 * x1;
  X509_STORE * x2;
  BIO * x3;
  BIO * x4;
  unsigned int x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:CMS_verify", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(38), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(53), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(53), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(54), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(21), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(21), arg4) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CMS_verify(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_CRYPTO_add(PyObject *self, PyObject *args)
{
  int * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:CRYPTO_add", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(55), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { CRYPTO_add(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_CRYPTO_cleanup_all_ex_data(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { CRYPTO_cleanup_all_ex_data(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_CRYPTO_free(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(31), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { CRYPTO_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_CRYPTO_get_id_callback(PyObject *self, PyObject *no_arg)
{
  unsigned long(* result)(void);

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CRYPTO_get_id_callback(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(56));
}

static PyObject *
_cffi_f_CRYPTO_get_locking_callback(PyObject *self, PyObject *no_arg)
{
  void(* result)(int, int, char const *, int);

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CRYPTO_get_locking_callback(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(57));
}

static PyObject *
_cffi_f_CRYPTO_is_mem_check_on(PyObject *self, PyObject *no_arg)
{
  int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CRYPTO_is_mem_check_on(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_CRYPTO_lock(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  char const * x2;
  int x3;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:CRYPTO_lock", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(0), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { CRYPTO_lock(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_CRYPTO_malloc_debug_init(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { CRYPTO_malloc_debug_init(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_CRYPTO_malloc_init(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { CRYPTO_malloc_init(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_CRYPTO_mem_ctrl(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CRYPTO_mem_ctrl(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_CRYPTO_mem_leaks(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { CRYPTO_mem_leaks(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_CRYPTO_num_locks(PyObject *self, PyObject *no_arg)
{
  int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CRYPTO_num_locks(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_CRYPTO_set_id_callback(PyObject *self, PyObject *arg0)
{
  unsigned long(* x0)(void);

  x0 = (unsigned long(*)(void))_cffi_to_c_pointer(arg0, _cffi_type(56));
  if (x0 == (unsigned long(*)(void))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { CRYPTO_set_id_callback(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_CRYPTO_set_locking_callback(PyObject *self, PyObject *arg0)
{
  void(* x0)(int, int, char const *, int);

  x0 = (void(*)(int, int, char const *, int))_cffi_to_c_pointer(arg0, _cffi_type(57));
  if (x0 == (void(*)(int, int, char const *, int))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { CRYPTO_set_locking_callback(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_Cryptography_EVP_PKEY_decrypt(PyObject *self, PyObject *args)
{
  EVP_PKEY_CTX * x0;
  unsigned char * x1;
  size_t * x2;
  unsigned char const * x3;
  size_t x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:Cryptography_EVP_PKEY_decrypt", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(46), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Cryptography_EVP_PKEY_decrypt(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_Cryptography_EVP_PKEY_encrypt(PyObject *self, PyObject *args)
{
  EVP_PKEY_CTX * x0;
  unsigned char * x1;
  size_t * x2;
  unsigned char const * x3;
  size_t x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:Cryptography_EVP_PKEY_encrypt", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(46), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Cryptography_EVP_PKEY_encrypt(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_Cryptography_HMAC_CTX_copy(PyObject *self, PyObject *args)
{
  HMAC_CTX * x0;
  HMAC_CTX * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:Cryptography_HMAC_CTX_copy", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(59), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(59), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Cryptography_HMAC_CTX_copy(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_Cryptography_HMAC_Final(PyObject *self, PyObject *args)
{
  HMAC_CTX * x0;
  unsigned char * x1;
  unsigned int * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:Cryptography_HMAC_Final", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(59), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(4), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Cryptography_HMAC_Final(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_Cryptography_HMAC_Init_ex(PyObject *self, PyObject *args)
{
  HMAC_CTX * x0;
  void const * x1;
  int x2;
  EVP_MD const * x3;
  ENGINE * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:Cryptography_HMAC_Init_ex", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(59), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(17), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(51), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(48), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Cryptography_HMAC_Init_ex(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_Cryptography_HMAC_Update(PyObject *self, PyObject *args)
{
  HMAC_CTX * x0;
  unsigned char const * x1;
  size_t x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:Cryptography_HMAC_Update", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(59), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Cryptography_HMAC_Update(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_Cryptography_SSL_CTX_get_method(PyObject *self, PyObject *arg0)
{
  SSL_CTX const * x0;
  Py_ssize_t datasize;
  SSL_METHOD const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(60), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(60), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Cryptography_SSL_CTX_get_method(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(61));
}

static PyObject *
_cffi_f_Cryptography_add_osrandom_engine(PyObject *self, PyObject *no_arg)
{
  int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Cryptography_add_osrandom_engine(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DH_check(PyObject *self, PyObject *args)
{
  DH const * x0;
  int * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:DH_check", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(62), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(55), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DH_check(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DH_check_pub_key(PyObject *self, PyObject *args)
{
  DH const * x0;
  BIGNUM const * x1;
  int * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:DH_check_pub_key", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(62), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(55), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DH_check_pub_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DH_compute_key(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  BIGNUM const * x1;
  DH * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:DH_compute_key", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(63), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DH_compute_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DH_free(PyObject *self, PyObject *arg0)
{
  DH * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(63), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { DH_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_DH_generate_key(PyObject *self, PyObject *arg0)
{
  DH * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(63), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DH_generate_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DH_generate_parameters(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  void(* x2)(int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  DH * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:DH_generate_parameters", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (void(*)(int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(64));
  if (x2 == (void(*)(int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DH_generate_parameters(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(63));
}

static PyObject *
_cffi_f_DH_generate_parameters_ex(PyObject *self, PyObject *args)
{
  DH * x0;
  int x1;
  int x2;
  BN_GENCB * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:DH_generate_parameters_ex", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(63), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(65), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DH_generate_parameters_ex(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DH_get_ex_data(PyObject *self, PyObject *args)
{
  DH * x0;
  int x1;
  Py_ssize_t datasize;
  void * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:DH_get_ex_data", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(63), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DH_get_ex_data(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(31));
}

static PyObject *
_cffi_f_DH_new(PyObject *self, PyObject *no_arg)
{
  DH * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DH_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(63));
}

static PyObject *
_cffi_f_DH_set_ex_data(PyObject *self, PyObject *args)
{
  DH * x0;
  int x1;
  void * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:DH_set_ex_data", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(63), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(31), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DH_set_ex_data(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DH_size(PyObject *self, PyObject *arg0)
{
  DH const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(62), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DH_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DHparams_print(PyObject *self, PyObject *args)
{
  BIO * x0;
  DH const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:DHparams_print", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(62), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DHparams_print(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DHparams_print_fp(PyObject *self, PyObject *args)
{
  FILE * x0;
  DH const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:DHparams_print_fp", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(62), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DHparams_print_fp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DSA_SIG_free(PyObject *self, PyObject *arg0)
{
  DSA_SIG * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(66), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { DSA_SIG_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_DSA_SIG_new(PyObject *self, PyObject *no_arg)
{
  DSA_SIG * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DSA_SIG_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(66));
}

static PyObject *
_cffi_f_DSA_free(PyObject *self, PyObject *arg0)
{
  DSA * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(67), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { DSA_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_DSA_generate_key(PyObject *self, PyObject *arg0)
{
  DSA * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(67), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DSA_generate_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DSA_generate_parameters(PyObject *self, PyObject *args)
{
  int x0;
  unsigned char * x1;
  int x2;
  int * x3;
  unsigned long * x4;
  void(* x5)(int, int, void *);
  void * x6;
  Py_ssize_t datasize;
  DSA * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_ParseTuple(args, "OOOOOOO:DSA_generate_parameters", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(55), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(68), arg4) < 0)
      return NULL;
  }

  x5 = (void(*)(int, int, void *))_cffi_to_c_pointer(arg5, _cffi_type(64));
  if (x5 == (void(*)(int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = alloca(datasize);
    memset((void *)x6, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(31), arg6) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DSA_generate_parameters(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(67));
}

static PyObject *
_cffi_f_DSA_generate_parameters_ex(PyObject *self, PyObject *args)
{
  DSA * x0;
  int x1;
  unsigned char * x2;
  int x3;
  int * x4;
  unsigned long * x5;
  BN_GENCB * x6;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_ParseTuple(args, "OOOOOOO:DSA_generate_parameters_ex", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(67), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(2), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(55), arg4) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = alloca(datasize);
    memset((void *)x5, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(68), arg5) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = alloca(datasize);
    memset((void *)x6, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(65), arg6) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DSA_generate_parameters_ex(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DSA_new(PyObject *self, PyObject *no_arg)
{
  DSA * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DSA_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(67));
}

static PyObject *
_cffi_f_DSA_sign(PyObject *self, PyObject *args)
{
  int x0;
  unsigned char const * x1;
  int x2;
  unsigned char * x3;
  unsigned int * x4;
  DSA * x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:DSA_sign", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(2), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(4), arg4) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = alloca(datasize);
    memset((void *)x5, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(67), arg5) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DSA_sign(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DSA_size(PyObject *self, PyObject *arg0)
{
  DSA const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(69), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DSA_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DSA_verify(PyObject *self, PyObject *args)
{
  int x0;
  unsigned char const * x1;
  int x2;
  unsigned char const * x3;
  int x4;
  DSA * x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:DSA_verify", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = alloca(datasize);
    memset((void *)x5, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(67), arg5) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DSA_verify(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_DTLSv1_client_method(PyObject *self, PyObject *no_arg)
{
  SSL_METHOD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DTLSv1_client_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(61));
}

static PyObject *
_cffi_f_DTLSv1_method(PyObject *self, PyObject *no_arg)
{
  SSL_METHOD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DTLSv1_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(61));
}

static PyObject *
_cffi_f_DTLSv1_server_method(PyObject *self, PyObject *no_arg)
{
  SSL_METHOD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DTLSv1_server_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(61));
}

static PyObject *
_cffi_f_ECDH_compute_key(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  EC_POINT const * x2;
  EC_KEY * x3;
  void *(* x4)(void const *, size_t, void *, size_t *);
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:ECDH_compute_key", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(31), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(70), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(71), arg3) < 0)
      return NULL;
  }

  x4 = (void *(*)(void const *, size_t, void *, size_t *))_cffi_to_c_pointer(arg4, _cffi_type(72));
  if (x4 == (void *(*)(void const *, size_t, void *, size_t *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDH_compute_key(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ECDH_get_ex_data(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  int x1;
  Py_ssize_t datasize;
  void * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ECDH_get_ex_data", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDH_get_ex_data(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(31));
}

static PyObject *
_cffi_f_ECDH_get_ex_new_index(PyObject *self, PyObject *args)
{
  long x0;
  void * x1;
  CRYPTO_EX_new * x2;
  CRYPTO_EX_dup * x3;
  CRYPTO_EX_free * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:ECDH_get_ex_new_index", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  x0 = _cffi_to_c_int(arg0, long);
  if (x0 == (long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(31), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(73), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(73), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(74), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(74), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(75), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDH_get_ex_new_index(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ECDH_set_ex_data(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  int x1;
  void * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:ECDH_set_ex_data", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(31), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDH_set_ex_data(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ECDSA_OpenSSL(PyObject *self, PyObject *no_arg)
{
  ECDSA_METHOD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_OpenSSL(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(76));
}

static PyObject *
_cffi_f_ECDSA_SIG_free(PyObject *self, PyObject *arg0)
{
  ECDSA_SIG * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(77), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(77), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ECDSA_SIG_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ECDSA_SIG_new(PyObject *self, PyObject *no_arg)
{
  ECDSA_SIG * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_SIG_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(77));
}

static PyObject *
_cffi_f_ECDSA_do_sign(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  EC_KEY * x2;
  Py_ssize_t datasize;
  ECDSA_SIG * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:ECDSA_do_sign", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(1), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(71), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_do_sign(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(77));
}

static PyObject *
_cffi_f_ECDSA_do_sign_ex(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  BIGNUM const * x2;
  BIGNUM const * x3;
  EC_KEY * x4;
  Py_ssize_t datasize;
  ECDSA_SIG * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:ECDSA_do_sign_ex", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(1), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(42), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(71), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_do_sign_ex(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(77));
}

static PyObject *
_cffi_f_ECDSA_do_verify(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  ECDSA_SIG const * x2;
  EC_KEY * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:ECDSA_do_verify", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(1), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(78), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(71), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_do_verify(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ECDSA_get_default_method(PyObject *self, PyObject *no_arg)
{
  ECDSA_METHOD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_get_default_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(76));
}

static PyObject *
_cffi_f_ECDSA_get_ex_data(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  int x1;
  Py_ssize_t datasize;
  void * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ECDSA_get_ex_data", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_get_ex_data(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(31));
}

static PyObject *
_cffi_f_ECDSA_get_ex_new_index(PyObject *self, PyObject *args)
{
  long x0;
  void * x1;
  CRYPTO_EX_new * x2;
  CRYPTO_EX_dup * x3;
  CRYPTO_EX_free * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:ECDSA_get_ex_new_index", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  x0 = _cffi_to_c_int(arg0, long);
  if (x0 == (long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(31), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(73), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(73), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(74), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(74), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(75), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_get_ex_new_index(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ECDSA_set_default_method(PyObject *self, PyObject *arg0)
{
  ECDSA_METHOD const * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(76), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ECDSA_set_default_method(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ECDSA_set_ex_data(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  int x1;
  void * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:ECDSA_set_ex_data", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(31), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_set_ex_data(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ECDSA_set_method(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  ECDSA_METHOD const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ECDSA_set_method", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(76), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_set_method(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ECDSA_sign(PyObject *self, PyObject *args)
{
  int x0;
  unsigned char const * x1;
  int x2;
  unsigned char * x3;
  unsigned int * x4;
  EC_KEY * x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:ECDSA_sign", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(2), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(4), arg4) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = alloca(datasize);
    memset((void *)x5, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(71), arg5) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_sign(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ECDSA_sign_ex(PyObject *self, PyObject *args)
{
  int x0;
  unsigned char const * x1;
  int x2;
  unsigned char * x3;
  unsigned int * x4;
  BIGNUM const * x5;
  BIGNUM const * x6;
  EC_KEY * x7;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_ParseTuple(args, "OOOOOOOO:ECDSA_sign_ex", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(2), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(4), arg4) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = alloca(datasize);
    memset((void *)x5, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(42), arg5) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = alloca(datasize);
    memset((void *)x6, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(42), arg6) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg7, (char **)&x7);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x7 = alloca(datasize);
    memset((void *)x7, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x7, _cffi_type(71), arg7) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_sign_ex(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ECDSA_sign_setup(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  BN_CTX * x1;
  BIGNUM * * x2;
  BIGNUM * * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:ECDSA_sign_setup", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(43), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(43), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_sign_setup(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ECDSA_size(PyObject *self, PyObject *arg0)
{
  EC_KEY const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(79), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(79), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ECDSA_verify(PyObject *self, PyObject *args)
{
  int x0;
  unsigned char const * x1;
  int x2;
  unsigned char const * x3;
  int x4;
  EC_KEY * x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:ECDSA_verify", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = alloca(datasize);
    memset((void *)x5, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(71), arg5) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ECDSA_verify(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_GF2m_simple_method(PyObject *self, PyObject *no_arg)
{
  EC_METHOD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GF2m_simple_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(80));
}

static PyObject *
_cffi_f_EC_GFp_mont_method(PyObject *self, PyObject *no_arg)
{
  EC_METHOD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GFp_mont_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(80));
}

static PyObject *
_cffi_f_EC_GFp_nist_method(PyObject *self, PyObject *no_arg)
{
  EC_METHOD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GFp_nist_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(80));
}

static PyObject *
_cffi_f_EC_GFp_nistp224_method(PyObject *self, PyObject *no_arg)
{
  EC_METHOD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GFp_nistp224_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(80));
}

static PyObject *
_cffi_f_EC_GFp_nistp256_method(PyObject *self, PyObject *no_arg)
{
  EC_METHOD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GFp_nistp256_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(80));
}

static PyObject *
_cffi_f_EC_GFp_nistp521_method(PyObject *self, PyObject *no_arg)
{
  EC_METHOD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GFp_nistp521_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(80));
}

static PyObject *
_cffi_f_EC_GFp_simple_method(PyObject *self, PyObject *no_arg)
{
  EC_METHOD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GFp_simple_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(80));
}

static PyObject *
_cffi_f_EC_GROUP_clear_free(PyObject *self, PyObject *arg0)
{
  EC_GROUP * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(81), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EC_GROUP_clear_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EC_GROUP_free(PyObject *self, PyObject *arg0)
{
  EC_GROUP * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(81), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EC_GROUP_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EC_GROUP_get0_generator(PyObject *self, PyObject *arg0)
{
  EC_GROUP const * x0;
  Py_ssize_t datasize;
  EC_POINT const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_get0_generator(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(70));
}

static PyObject *
_cffi_f_EC_GROUP_get_curve_GF2m(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  BIGNUM * x1;
  BIGNUM * x2;
  BIGNUM * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_GROUP_get_curve_GF2m", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(11), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(11), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(11), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_get_curve_GF2m(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_GROUP_get_curve_GFp(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  BIGNUM * x1;
  BIGNUM * x2;
  BIGNUM * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_GROUP_get_curve_GFp", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(11), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(11), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(11), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_get_curve_GFp(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_GROUP_get_curve_name(PyObject *self, PyObject *arg0)
{
  EC_GROUP const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_get_curve_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_GROUP_get_degree(PyObject *self, PyObject *arg0)
{
  EC_GROUP const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_get_degree(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_GROUP_get_order(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  BIGNUM * x1;
  BN_CTX * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EC_GROUP_get_order", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(11), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(41), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_get_order(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_GROUP_have_precompute_mult(PyObject *self, PyObject *arg0)
{
  EC_GROUP const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_have_precompute_mult(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_GROUP_method_of(PyObject *self, PyObject *arg0)
{
  EC_GROUP const * x0;
  Py_ssize_t datasize;
  EC_METHOD const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_method_of(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(80));
}

static PyObject *
_cffi_f_EC_GROUP_new(PyObject *self, PyObject *arg0)
{
  EC_METHOD const * x0;
  Py_ssize_t datasize;
  EC_GROUP * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(80), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(81));
}

static PyObject *
_cffi_f_EC_GROUP_new_by_curve_name(PyObject *self, PyObject *arg0)
{
  int x0;
  EC_GROUP * result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_new_by_curve_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(81));
}

static PyObject *
_cffi_f_EC_GROUP_new_curve_GF2m(PyObject *self, PyObject *args)
{
  BIGNUM const * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  EC_GROUP * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:EC_GROUP_new_curve_GF2m", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(42), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_new_curve_GF2m(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(81));
}

static PyObject *
_cffi_f_EC_GROUP_new_curve_GFp(PyObject *self, PyObject *args)
{
  BIGNUM const * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  EC_GROUP * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:EC_GROUP_new_curve_GFp", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(42), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_new_curve_GFp(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(81));
}

static PyObject *
_cffi_f_EC_GROUP_precompute_mult(PyObject *self, PyObject *args)
{
  EC_GROUP * x0;
  BN_CTX * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_GROUP_precompute_mult", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(81), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_precompute_mult(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_GROUP_set_curve_GF2m(PyObject *self, PyObject *args)
{
  EC_GROUP * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BIGNUM const * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_GROUP_set_curve_GF2m", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(81), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(42), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_set_curve_GF2m(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_GROUP_set_curve_GFp(PyObject *self, PyObject *args)
{
  EC_GROUP * x0;
  BIGNUM const * x1;
  BIGNUM const * x2;
  BIGNUM const * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_GROUP_set_curve_GFp", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(81), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(42), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_GROUP_set_curve_GFp(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_KEY_check_key(PyObject *self, PyObject *arg0)
{
  EC_KEY const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(79), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(79), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_check_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_KEY_clear_flags(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  int x1;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_KEY_clear_flags", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EC_KEY_clear_flags(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EC_KEY_copy(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  EC_KEY const * x1;
  Py_ssize_t datasize;
  EC_KEY * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_KEY_copy", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(79), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(79), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_copy(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(71));
}

static PyObject *
_cffi_f_EC_KEY_dup(PyObject *self, PyObject *arg0)
{
  EC_KEY const * x0;
  Py_ssize_t datasize;
  EC_KEY * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(79), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(79), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_dup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(71));
}

static PyObject *
_cffi_f_EC_KEY_free(PyObject *self, PyObject *arg0)
{
  EC_KEY * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EC_KEY_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EC_KEY_generate_key(PyObject *self, PyObject *arg0)
{
  EC_KEY * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_generate_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_KEY_get0_group(PyObject *self, PyObject *arg0)
{
  EC_KEY const * x0;
  Py_ssize_t datasize;
  EC_GROUP const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(79), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(79), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_get0_group(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(82));
}

static PyObject *
_cffi_f_EC_KEY_get0_private_key(PyObject *self, PyObject *arg0)
{
  EC_KEY const * x0;
  Py_ssize_t datasize;
  BIGNUM const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(79), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(79), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_get0_private_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(42));
}

static PyObject *
_cffi_f_EC_KEY_get0_public_key(PyObject *self, PyObject *arg0)
{
  EC_KEY const * x0;
  Py_ssize_t datasize;
  EC_POINT const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(79), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(79), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_get0_public_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(70));
}

static PyObject *
_cffi_f_EC_KEY_get_conv_form(PyObject *self, PyObject *arg0)
{
  EC_KEY const * x0;
  Py_ssize_t datasize;
  point_conversion_form_t result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(79), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(79), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_get_conv_form(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_deref((char *)&result, _cffi_type(83));
}

static PyObject *
_cffi_f_EC_KEY_get_enc_flags(PyObject *self, PyObject *arg0)
{
  EC_KEY const * x0;
  Py_ssize_t datasize;
  unsigned int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(79), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(79), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_get_enc_flags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, unsigned int);
}

static PyObject *
_cffi_f_EC_KEY_get_flags(PyObject *self, PyObject *arg0)
{
  EC_KEY const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(79), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(79), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_get_flags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_KEY_get_key_method_data(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  void *(* x1)(void *);
  void(* x2)(void *);
  void(* x3)(void *);
  Py_ssize_t datasize;
  void * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:EC_KEY_get_key_method_data", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  x1 = (void *(*)(void *))_cffi_to_c_pointer(arg1, _cffi_type(84));
  if (x1 == (void *(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  x2 = (void(*)(void *))_cffi_to_c_pointer(arg2, _cffi_type(85));
  if (x2 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  x3 = (void(*)(void *))_cffi_to_c_pointer(arg3, _cffi_type(85));
  if (x3 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_get_key_method_data(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(31));
}

static PyObject *
_cffi_f_EC_KEY_insert_key_method_data(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  void * x1;
  void *(* x2)(void *);
  void(* x3)(void *);
  void(* x4)(void *);
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_KEY_insert_key_method_data", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(31), arg1) < 0)
      return NULL;
  }

  x2 = (void *(*)(void *))_cffi_to_c_pointer(arg2, _cffi_type(84));
  if (x2 == (void *(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  x3 = (void(*)(void *))_cffi_to_c_pointer(arg3, _cffi_type(85));
  if (x3 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  x4 = (void(*)(void *))_cffi_to_c_pointer(arg4, _cffi_type(85));
  if (x4 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EC_KEY_insert_key_method_data(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EC_KEY_new_by_curve_name(PyObject *self, PyObject *arg0)
{
  int x0;
  EC_KEY * result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_new_by_curve_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(71));
}

static PyObject *
_cffi_f_EC_KEY_precompute_mult(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  BN_CTX * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_KEY_precompute_mult", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_precompute_mult(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_KEY_set_asn1_flag(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  int x1;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_KEY_set_asn1_flag", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EC_KEY_set_asn1_flag(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EC_KEY_set_conv_form(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  point_conversion_form_t x1;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_KEY_set_conv_form", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(83), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EC_KEY_set_conv_form(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EC_KEY_set_enc_flags(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_KEY_set_enc_flags", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EC_KEY_set_enc_flags(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EC_KEY_set_flags(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  int x1;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_KEY_set_flags", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EC_KEY_set_flags(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EC_KEY_set_group(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  EC_GROUP const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_KEY_set_group", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(82), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_set_group(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_KEY_set_private_key(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  BIGNUM const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_KEY_set_private_key", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_set_private_key(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_KEY_set_public_key(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  EC_POINT const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_KEY_set_public_key", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(70), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_set_public_key(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_KEY_set_public_key_affine_coordinates(PyObject *self, PyObject *args)
{
  EC_KEY * x0;
  BIGNUM * x1;
  BIGNUM * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EC_KEY_set_public_key_affine_coordinates", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(11), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(11), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_set_public_key_affine_coordinates(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_KEY_up_ref(PyObject *self, PyObject *arg0)
{
  EC_KEY * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(71), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_up_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_METHOD_get_field_type(PyObject *self, PyObject *arg0)
{
  EC_METHOD const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(80), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_METHOD_get_field_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_add(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT * x1;
  EC_POINT const * x2;
  EC_POINT const * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_POINT_add", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(86), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(70), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(70), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_add(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_bn2point(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  BIGNUM const * x1;
  EC_POINT * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  EC_POINT * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:EC_POINT_bn2point", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(42), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(86), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_bn2point(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(86));
}

static PyObject *
_cffi_f_EC_POINT_clear_free(PyObject *self, PyObject *arg0)
{
  EC_POINT * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(86), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EC_POINT_clear_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EC_POINT_cmp(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT const * x1;
  EC_POINT const * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:EC_POINT_cmp", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(70), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(70), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_cmp(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_copy(PyObject *self, PyObject *args)
{
  EC_POINT * x0;
  EC_POINT const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_POINT_copy", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(86), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(70), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_copy(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_dbl(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT * x1;
  EC_POINT const * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:EC_POINT_dbl", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(86), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(70), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_dbl(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_dup(PyObject *self, PyObject *args)
{
  EC_POINT const * x0;
  EC_GROUP const * x1;
  Py_ssize_t datasize;
  EC_POINT * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_POINT_dup", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(70), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(82), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_dup(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(86));
}

static PyObject *
_cffi_f_EC_POINT_free(PyObject *self, PyObject *arg0)
{
  EC_POINT * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(86), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EC_POINT_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EC_POINT_get_Jprojective_coordinates_GFp(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT const * x1;
  BIGNUM * x2;
  BIGNUM * x3;
  BIGNUM * x4;
  BN_CTX * x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:EC_POINT_get_Jprojective_coordinates_GFp", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(70), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(11), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(11), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(11), arg4) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = alloca(datasize);
    memset((void *)x5, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(41), arg5) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_get_Jprojective_coordinates_GFp(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_get_affine_coordinates_GF2m(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT const * x1;
  BIGNUM * x2;
  BIGNUM * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_POINT_get_affine_coordinates_GF2m", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(70), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(11), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(11), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_get_affine_coordinates_GF2m(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_get_affine_coordinates_GFp(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT const * x1;
  BIGNUM * x2;
  BIGNUM * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_POINT_get_affine_coordinates_GFp", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(70), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(11), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(11), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_get_affine_coordinates_GFp(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_hex2point(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  char const * x1;
  EC_POINT * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  EC_POINT * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:EC_POINT_hex2point", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(86), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_hex2point(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(86));
}

static PyObject *
_cffi_f_EC_POINT_invert(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT * x1;
  BN_CTX * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EC_POINT_invert", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(86), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(41), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_invert(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_is_at_infinity(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_POINT_is_at_infinity", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(70), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_is_at_infinity(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_is_on_curve(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT const * x1;
  BN_CTX * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EC_POINT_is_on_curve", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(70), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(41), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_is_on_curve(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_make_affine(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT * x1;
  BN_CTX * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EC_POINT_make_affine", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(86), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(41), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_make_affine(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_method_of(PyObject *self, PyObject *arg0)
{
  EC_POINT const * x0;
  Py_ssize_t datasize;
  EC_METHOD const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(70), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_method_of(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(80));
}

static PyObject *
_cffi_f_EC_POINT_mul(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT * x1;
  BIGNUM const * x2;
  EC_POINT const * x3;
  BIGNUM const * x4;
  BN_CTX * x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:EC_POINT_mul", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(86), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(70), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(42), arg4) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = alloca(datasize);
    memset((void *)x5, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(41), arg5) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_mul(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_new(PyObject *self, PyObject *arg0)
{
  EC_GROUP const * x0;
  Py_ssize_t datasize;
  EC_POINT * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(86));
}

static PyObject *
_cffi_f_EC_POINT_oct2point(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT * x1;
  unsigned char const * x2;
  size_t x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_POINT_oct2point", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(86), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(1), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_oct2point(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_point2bn(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT const * x1;
  point_conversion_form_t x2;
  BIGNUM * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  BIGNUM * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_POINT_point2bn", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(70), arg1) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(83), arg2) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(11), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_point2bn(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(11));
}

static PyObject *
_cffi_f_EC_POINT_point2hex(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT const * x1;
  point_conversion_form_t x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  char * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:EC_POINT_point2hex", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(70), arg1) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(83), arg2) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_point2hex(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(18));
}

static PyObject *
_cffi_f_EC_POINT_point2oct(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT const * x1;
  point_conversion_form_t x2;
  unsigned char * x3;
  size_t x4;
  BN_CTX * x5;
  Py_ssize_t datasize;
  size_t result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:EC_POINT_point2oct", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(70), arg1) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(83), arg2) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(2), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = alloca(datasize);
    memset((void *)x5, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(41), arg5) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_point2oct(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, size_t);
}

static PyObject *
_cffi_f_EC_POINT_set_Jprojective_coordinates_GFp(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT * x1;
  BIGNUM const * x2;
  BIGNUM const * x3;
  BIGNUM const * x4;
  BN_CTX * x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:EC_POINT_set_Jprojective_coordinates_GFp", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(86), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(42), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(42), arg4) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = alloca(datasize);
    memset((void *)x5, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(41), arg5) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_set_Jprojective_coordinates_GFp(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_set_affine_coordinates_GF2m(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT * x1;
  BIGNUM const * x2;
  BIGNUM const * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_POINT_set_affine_coordinates_GF2m", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(86), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(42), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_set_affine_coordinates_GF2m(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_set_affine_coordinates_GFp(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT * x1;
  BIGNUM const * x2;
  BIGNUM const * x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_POINT_set_affine_coordinates_GFp", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(86), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(42), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_set_affine_coordinates_GFp(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_set_compressed_coordinates_GF2m(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT * x1;
  BIGNUM const * x2;
  int x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_POINT_set_compressed_coordinates_GF2m", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(86), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_set_compressed_coordinates_GF2m(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_set_compressed_coordinates_GFp(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT * x1;
  BIGNUM const * x2;
  int x3;
  BN_CTX * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EC_POINT_set_compressed_coordinates_GFp", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(86), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_set_compressed_coordinates_GFp(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINT_set_to_infinity(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_POINT_set_to_infinity", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(86), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINT_set_to_infinity(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINTs_make_affine(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  size_t x1;
  EC_POINT * * x2;
  BN_CTX * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:EC_POINTs_make_affine", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(87), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINTs_make_affine(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_POINTs_mul(PyObject *self, PyObject *args)
{
  EC_GROUP const * x0;
  EC_POINT * x1;
  BIGNUM const * x2;
  size_t x3;
  EC_POINT const * * x4;
  BIGNUM const * * x5;
  BN_CTX * x6;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_ParseTuple(args, "OOOOOOO:EC_POINTs_mul", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(82), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(86), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(42), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(88), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(88), arg4) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = alloca(datasize);
    memset((void *)x5, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(89), arg5) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = alloca(datasize);
    memset((void *)x6, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(41), arg6) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_POINTs_mul(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EC_curve_nid2nist(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_curve_nid2nist(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(0));
}

static PyObject *
_cffi_f_EC_get_builtin_curves(PyObject *self, PyObject *args)
{
  EC_builtin_curve * x0;
  size_t x1;
  Py_ssize_t datasize;
  size_t result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EC_get_builtin_curves", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(90), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(90), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_get_builtin_curves(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, size_t);
}

static PyObject *
_cffi_f_ENGINE_add(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_add(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_add_conf_module(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_add_conf_module(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_by_id(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  ENGINE * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_by_id(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_cleanup(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_cleanup(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_cmd_is_executable(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_cmd_is_executable", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_cmd_is_executable(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_ctrl(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  int x1;
  long x2;
  void * x3;
  void(* x4)(void);
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:ENGINE_ctrl", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, long);
  if (x2 == (long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  x4 = (void(*)(void))_cffi_to_c_pointer(arg4, _cffi_type(91));
  if (x4 == (void(*)(void))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_ctrl(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_ctrl_cmd(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  char const * x1;
  long x2;
  void * x3;
  void(* x4)(void);
  int x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:ENGINE_ctrl_cmd", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, long);
  if (x2 == (long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  x4 = (void(*)(void))_cffi_to_c_pointer(arg4, _cffi_type(91));
  if (x4 == (void(*)(void))NULL && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_ctrl_cmd(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_ctrl_cmd_string(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  char const * x1;
  char const * x2;
  int x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:ENGINE_ctrl_cmd_string", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(0), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_ctrl_cmd_string(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_finish(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_free(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_get_DH(PyObject *self, PyObject *arg0)
{
  ENGINE const * x0;
  Py_ssize_t datasize;
  DH_METHOD const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(92), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(92), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_DH(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(93));
}

static PyObject *
_cffi_f_ENGINE_get_DSA(PyObject *self, PyObject *arg0)
{
  ENGINE const * x0;
  Py_ssize_t datasize;
  DSA_METHOD const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(92), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(92), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_DSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(94));
}

static PyObject *
_cffi_f_ENGINE_get_ECDH(PyObject *self, PyObject *arg0)
{
  ENGINE const * x0;
  Py_ssize_t datasize;
  ECDH_METHOD const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(92), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(92), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_ECDH(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(95));
}

static PyObject *
_cffi_f_ENGINE_get_ECDSA(PyObject *self, PyObject *arg0)
{
  ENGINE const * x0;
  Py_ssize_t datasize;
  ECDSA_METHOD const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(92), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(92), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_ECDSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(76));
}

static PyObject *
_cffi_f_ENGINE_get_RAND(PyObject *self, PyObject *arg0)
{
  ENGINE const * x0;
  Py_ssize_t datasize;
  RAND_METHOD const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(92), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(92), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_RAND(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(96));
}

static PyObject *
_cffi_f_ENGINE_get_RSA(PyObject *self, PyObject *arg0)
{
  ENGINE const * x0;
  Py_ssize_t datasize;
  RSA_METHOD const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(92), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(92), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_RSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(97));
}

static PyObject *
_cffi_f_ENGINE_get_STORE(PyObject *self, PyObject *arg0)
{
  ENGINE const * x0;
  Py_ssize_t datasize;
  STORE_METHOD const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(92), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(92), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_STORE(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(98));
}

static PyObject *
_cffi_f_ENGINE_get_cipher(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  int x1;
  Py_ssize_t datasize;
  EVP_CIPHER const * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_get_cipher", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_cipher(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(47));
}

static PyObject *
_cffi_f_ENGINE_get_cipher_engine(PyObject *self, PyObject *arg0)
{
  int x0;
  ENGINE * result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_cipher_engine(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_get_cmd_defns(PyObject *self, PyObject *arg0)
{
  ENGINE const * x0;
  Py_ssize_t datasize;
  ENGINE_CMD_DEFN const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(92), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(92), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_cmd_defns(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(99));
}

static PyObject *
_cffi_f_ENGINE_get_default_DH(PyObject *self, PyObject *no_arg)
{
  ENGINE * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_default_DH(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_get_default_DSA(PyObject *self, PyObject *no_arg)
{
  ENGINE * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_default_DSA(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_get_default_ECDH(PyObject *self, PyObject *no_arg)
{
  ENGINE * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_default_ECDH(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_get_default_ECDSA(PyObject *self, PyObject *no_arg)
{
  ENGINE * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_default_ECDSA(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_get_default_RAND(PyObject *self, PyObject *no_arg)
{
  ENGINE * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_default_RAND(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_get_default_RSA(PyObject *self, PyObject *no_arg)
{
  ENGINE * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_default_RSA(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_get_digest(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  int x1;
  Py_ssize_t datasize;
  EVP_MD const * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_get_digest", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_digest(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(51));
}

static PyObject *
_cffi_f_ENGINE_get_digest_engine(PyObject *self, PyObject *arg0)
{
  int x0;
  ENGINE * result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_digest_engine(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_get_first(PyObject *self, PyObject *no_arg)
{
  ENGINE * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_first(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_get_flags(PyObject *self, PyObject *arg0)
{
  ENGINE const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(92), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(92), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_flags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_get_id(PyObject *self, PyObject *arg0)
{
  ENGINE const * x0;
  Py_ssize_t datasize;
  char const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(92), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(92), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_id(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(0));
}

static PyObject *
_cffi_f_ENGINE_get_last(PyObject *self, PyObject *no_arg)
{
  ENGINE * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_last(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_get_name(PyObject *self, PyObject *arg0)
{
  ENGINE const * x0;
  Py_ssize_t datasize;
  char const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(92), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(92), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(0));
}

static PyObject *
_cffi_f_ENGINE_get_next(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  ENGINE * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_get_prev(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  ENGINE * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_prev(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_get_table_flags(PyObject *self, PyObject *no_arg)
{
  unsigned int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_table_flags(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, unsigned int);
}

static PyObject *
_cffi_f_ENGINE_init(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_load_builtin_engines(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_load_builtin_engines(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_load_cryptodev(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_load_cryptodev(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_load_dynamic(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_load_dynamic(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_load_openssl(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_load_openssl(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_load_private_key(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  char const * x1;
  UI_METHOD * x2;
  void * x3;
  Py_ssize_t datasize;
  EVP_PKEY * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:ENGINE_load_private_key", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(100), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(100), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_load_private_key(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(50));
}

static PyObject *
_cffi_f_ENGINE_load_public_key(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  char const * x1;
  UI_METHOD * x2;
  void * x3;
  Py_ssize_t datasize;
  EVP_PKEY * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:ENGINE_load_public_key", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(100), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(100), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_load_public_key(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(50));
}

static PyObject *
_cffi_f_ENGINE_new(PyObject *self, PyObject *no_arg)
{
  ENGINE * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(48));
}

static PyObject *
_cffi_f_ENGINE_register_DH(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_register_DH(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_register_DSA(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_register_DSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_register_ECDH(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_register_ECDH(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_register_ECDSA(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_register_ECDSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_register_RAND(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_register_RAND(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_register_RSA(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_register_RSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_register_STORE(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_register_STORE(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_register_all_DH(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_register_all_DH(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_register_all_DSA(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_register_all_DSA(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_register_all_ECDH(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_register_all_ECDH(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_register_all_ECDSA(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_register_all_ECDSA(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_register_all_RAND(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_register_all_RAND(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_register_all_RSA(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_register_all_RSA(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_register_all_STORE(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_register_all_STORE(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_register_all_ciphers(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_register_all_ciphers(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_register_all_complete(PyObject *self, PyObject *no_arg)
{
  int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_register_all_complete(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_register_all_digests(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_register_all_digests(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_register_ciphers(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_register_ciphers(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_register_complete(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_register_complete(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_register_digests(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_register_digests(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_remove(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_remove(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_DH(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  DH_METHOD const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_DH", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(93), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(93), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_DH(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_DSA(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  DSA_METHOD const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_DSA", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(94), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_DSA(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_ECDH(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  ECDH_METHOD const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_ECDH", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(95), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(95), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_ECDH(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_ECDSA(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  ECDSA_METHOD const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_ECDSA", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(76), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(76), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_ECDSA(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_RAND(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  RAND_METHOD const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_RAND", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(96), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_RAND(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_RSA(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  RSA_METHOD const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_RSA", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(97), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(97), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_RSA(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_STORE(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  STORE_METHOD const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_STORE", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(98), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_STORE(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_ciphers(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  ENGINE_CIPHERS_PTR x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_ciphers", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(101), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(101), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_ciphers(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_cmd_defns(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  ENGINE_CMD_DEFN const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_cmd_defns", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(99), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(99), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_cmd_defns(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_ctrl_function(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  ENGINE_CTRL_FUNC_PTR x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_ctrl_function", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(102), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(102), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_ctrl_function(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_default(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_default", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_default(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_default_DH(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_default_DH(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_default_DSA(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_default_DSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_default_ECDH(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_default_ECDH(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_default_ECDSA(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_default_ECDSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_default_RAND(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_default_RAND(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_default_RSA(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_default_RSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_default_ciphers(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_default_ciphers(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_default_digests(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_default_digests(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_default_string(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  char const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_default_string", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_default_string(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_destroy_function(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  ENGINE_GEN_INT_FUNC_PTR x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_destroy_function", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(103), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(103), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_destroy_function(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_digests(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  ENGINE_DIGESTS_PTR x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_digests", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(104), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(104), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_digests(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_finish_function(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  ENGINE_GEN_INT_FUNC_PTR x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_finish_function", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(103), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(103), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_finish_function(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_flags(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_flags", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_flags(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_id(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  char const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_id", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_id(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_init_function(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  ENGINE_GEN_INT_FUNC_PTR x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_init_function", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(103), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(103), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_init_function(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_load_privkey_function(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  ENGINE_LOAD_KEY_PTR x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_load_privkey_function", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(105), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(105), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_load_privkey_function(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_load_pubkey_function(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  ENGINE_LOAD_KEY_PTR x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_load_pubkey_function", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(105), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(105), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_load_pubkey_function(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_name(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  char const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ENGINE_set_name", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ENGINE_set_table_flags(PyObject *self, PyObject *arg0)
{
  unsigned int x0;

  x0 = _cffi_to_c_int(arg0, unsigned int);
  if (x0 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_set_table_flags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_unregister_DH(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_unregister_DH(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_unregister_DSA(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_unregister_DSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_unregister_ECDH(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_unregister_ECDH(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_unregister_ECDSA(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_unregister_ECDSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_unregister_RAND(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_unregister_RAND(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_unregister_RSA(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_unregister_RSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_unregister_STORE(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_unregister_STORE(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_unregister_ciphers(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_unregister_ciphers(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_unregister_digests(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_unregister_digests(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ENGINE_up_ref(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(48), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_up_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ERR_FATAL_ERROR(PyObject *self, PyObject *arg0)
{
  unsigned long x0;
  int result;

  x0 = _cffi_to_c_int(arg0, unsigned long);
  if (x0 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_FATAL_ERROR(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ERR_GET_FUNC(PyObject *self, PyObject *arg0)
{
  unsigned long x0;
  int result;

  x0 = _cffi_to_c_int(arg0, unsigned long);
  if (x0 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_GET_FUNC(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ERR_GET_LIB(PyObject *self, PyObject *arg0)
{
  unsigned long x0;
  int result;

  x0 = _cffi_to_c_int(arg0, unsigned long);
  if (x0 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_GET_LIB(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ERR_GET_REASON(PyObject *self, PyObject *arg0)
{
  unsigned long x0;
  int result;

  x0 = _cffi_to_c_int(arg0, unsigned long);
  if (x0 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_GET_REASON(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ERR_PACK(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  int x2;
  unsigned long result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:ERR_PACK", &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_PACK(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, unsigned long);
}

static int _cffi_const_ERR_add_error_data(PyObject *lib)
{
  PyObject *o;
  int res;
  void(* i)(int, ...);
  i = (ERR_add_error_data);
  o = _cffi_from_c_pointer((char *)i, _cffi_type(106));
  if (o == NULL)
    return -1;
  res = PyObject_SetAttrString(lib, "ERR_add_error_data", o);
  Py_DECREF(o);
  if (res < 0)
    return -1;
  return _cffi_const_XN_FLAG_SPC_EQ(lib);
}

static PyObject *
_cffi_f_ERR_error_string(PyObject *self, PyObject *args)
{
  unsigned long x0;
  char * x1;
  Py_ssize_t datasize;
  char * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ERR_error_string", &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, unsigned long);
  if (x0 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(18), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_error_string(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(18));
}

static PyObject *
_cffi_f_ERR_error_string_n(PyObject *self, PyObject *args)
{
  unsigned long x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:ERR_error_string_n", &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, unsigned long);
  if (x0 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(18), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ERR_error_string_n(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ERR_free_strings(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ERR_free_strings(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ERR_func_error_string(PyObject *self, PyObject *arg0)
{
  unsigned long x0;
  char const * result;

  x0 = _cffi_to_c_int(arg0, unsigned long);
  if (x0 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_func_error_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(0));
}

static PyObject *
_cffi_f_ERR_get_error(PyObject *self, PyObject *no_arg)
{
  unsigned long result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_get_error(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, unsigned long);
}

static PyObject *
_cffi_f_ERR_get_error_line(PyObject *self, PyObject *args)
{
  char const * * x0;
  int * x1;
  Py_ssize_t datasize;
  unsigned long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ERR_get_error_line", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(107), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(55), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_get_error_line(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, unsigned long);
}

static PyObject *
_cffi_f_ERR_get_error_line_data(PyObject *self, PyObject *args)
{
  char const * * x0;
  int * x1;
  char const * * x2;
  int * x3;
  Py_ssize_t datasize;
  unsigned long result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:ERR_get_error_line_data", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(107), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(55), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(107), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(55), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_get_error_line_data(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, unsigned long);
}

static PyObject *
_cffi_f_ERR_get_next_error_library(PyObject *self, PyObject *no_arg)
{
  int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_get_next_error_library(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_ERR_lib_error_string(PyObject *self, PyObject *arg0)
{
  unsigned long x0;
  char const * result;

  x0 = _cffi_to_c_int(arg0, unsigned long);
  if (x0 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_lib_error_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(0));
}

static PyObject *
_cffi_f_ERR_load_RAND_strings(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ERR_load_RAND_strings(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ERR_load_SSL_strings(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ERR_load_SSL_strings(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ERR_load_crypto_strings(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ERR_load_crypto_strings(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ERR_peek_error(PyObject *self, PyObject *no_arg)
{
  unsigned long result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_peek_error(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, unsigned long);
}

static PyObject *
_cffi_f_ERR_peek_error_line(PyObject *self, PyObject *args)
{
  char const * * x0;
  int * x1;
  Py_ssize_t datasize;
  unsigned long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ERR_peek_error_line", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(107), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(55), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_peek_error_line(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, unsigned long);
}

static PyObject *
_cffi_f_ERR_peek_error_line_data(PyObject *self, PyObject *args)
{
  char const * * x0;
  int * x1;
  char const * * x2;
  int * x3;
  Py_ssize_t datasize;
  unsigned long result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:ERR_peek_error_line_data", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(107), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(55), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(107), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(55), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_peek_error_line_data(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, unsigned long);
}

static PyObject *
_cffi_f_ERR_peek_last_error(PyObject *self, PyObject *no_arg)
{
  unsigned long result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_peek_last_error(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, unsigned long);
}

static PyObject *
_cffi_f_ERR_peek_last_error_line(PyObject *self, PyObject *args)
{
  char const * * x0;
  int * x1;
  Py_ssize_t datasize;
  unsigned long result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:ERR_peek_last_error_line", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(107), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(55), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_peek_last_error_line(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, unsigned long);
}

static PyObject *
_cffi_f_ERR_peek_last_error_line_data(PyObject *self, PyObject *args)
{
  char const * * x0;
  int * x1;
  char const * * x2;
  int * x3;
  Py_ssize_t datasize;
  unsigned long result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:ERR_peek_last_error_line_data", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(107), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(55), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(107), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(55), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_peek_last_error_line_data(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, unsigned long);
}

static PyObject *
_cffi_f_ERR_print_errors(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ERR_print_errors(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ERR_print_errors_fp(PyObject *self, PyObject *arg0)
{
  FILE * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ERR_print_errors_fp(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ERR_put_error(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  int x2;
  char const * x3;
  int x4;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:ERR_put_error", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(0), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ERR_put_error(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_ERR_reason_error_string(PyObject *self, PyObject *arg0)
{
  unsigned long x0;
  char const * result;

  x0 = _cffi_to_c_int(arg0, unsigned long);
  if (x0 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_reason_error_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(0));
}

static PyObject *
_cffi_f_ERR_remove_thread_state(PyObject *self, PyObject *arg0)
{
  CRYPTO_THREADID const * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(108), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(108), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ERR_remove_thread_state(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EVP_CIPHER_CTX_block_size(PyObject *self, PyObject *arg0)
{
  EVP_CIPHER_CTX const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(109), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(109), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_CTX_block_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_CIPHER_CTX_cipher(PyObject *self, PyObject *arg0)
{
  EVP_CIPHER_CTX const * x0;
  Py_ssize_t datasize;
  EVP_CIPHER const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(109), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(109), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_CTX_cipher(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(47));
}

static PyObject *
_cffi_f_EVP_CIPHER_CTX_cleanup(PyObject *self, PyObject *arg0)
{
  EVP_CIPHER_CTX * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_CTX_cleanup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_CIPHER_CTX_ctrl(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  int x1;
  int x2;
  void * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:EVP_CIPHER_CTX_ctrl", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_CTX_ctrl(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_CIPHER_CTX_free(PyObject *self, PyObject *arg0)
{
  EVP_CIPHER_CTX * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EVP_CIPHER_CTX_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EVP_CIPHER_CTX_init(PyObject *self, PyObject *arg0)
{
  EVP_CIPHER_CTX * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EVP_CIPHER_CTX_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EVP_CIPHER_CTX_new(PyObject *self, PyObject *no_arg)
{
  EVP_CIPHER_CTX * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_CTX_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(110));
}

static PyObject *
_cffi_f_EVP_CIPHER_CTX_set_key_length(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_CIPHER_CTX_set_key_length", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_CTX_set_key_length(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_CIPHER_CTX_set_padding(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_CIPHER_CTX_set_padding", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_CTX_set_padding(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_CIPHER_block_size(PyObject *self, PyObject *arg0)
{
  EVP_CIPHER const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(47), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_block_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_CipherFinal_ex(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  unsigned char * x1;
  int * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EVP_CipherFinal_ex", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(55), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CipherFinal_ex(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_CipherInit_ex(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  EVP_CIPHER const * x1;
  ENGINE * x2;
  unsigned char const * x3;
  unsigned char const * x4;
  int x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:EVP_CipherInit_ex", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(47), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(48), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(1), arg4) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CipherInit_ex(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_CipherUpdate(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  unsigned char * x1;
  int * x2;
  unsigned char const * x3;
  int x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EVP_CipherUpdate", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(55), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CipherUpdate(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_DecryptFinal_ex(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  unsigned char * x1;
  int * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EVP_DecryptFinal_ex", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(55), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_DecryptFinal_ex(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_DecryptInit_ex(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  EVP_CIPHER const * x1;
  ENGINE * x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EVP_DecryptInit_ex", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(47), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(48), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(1), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_DecryptInit_ex(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_DecryptUpdate(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  unsigned char * x1;
  int * x2;
  unsigned char const * x3;
  int x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EVP_DecryptUpdate", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(55), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_DecryptUpdate(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_DigestFinal_ex(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  unsigned char * x1;
  unsigned int * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EVP_DigestFinal_ex", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(111), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(111), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(4), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_DigestFinal_ex(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_DigestInit_ex(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  EVP_MD const * x1;
  ENGINE * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EVP_DigestInit_ex", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(111), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(111), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(51), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(48), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_DigestInit_ex(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_DigestUpdate(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EVP_DigestUpdate", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(111), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(111), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(17), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_DigestUpdate(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_EncryptFinal_ex(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  unsigned char * x1;
  int * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EVP_EncryptFinal_ex", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(55), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_EncryptFinal_ex(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_EncryptInit_ex(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  EVP_CIPHER const * x1;
  ENGINE * x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EVP_EncryptInit_ex", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(47), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(48), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(1), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_EncryptInit_ex(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_EncryptUpdate(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  unsigned char * x1;
  int * x2;
  unsigned char const * x3;
  int x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EVP_EncryptUpdate", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(55), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_EncryptUpdate(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_MD_CTX_cleanup(PyObject *self, PyObject *arg0)
{
  EVP_MD_CTX * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(111), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(111), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_MD_CTX_cleanup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_MD_CTX_copy_ex(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  EVP_MD_CTX const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_MD_CTX_copy_ex", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(111), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(111), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(112), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(112), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_MD_CTX_copy_ex(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_MD_CTX_create(PyObject *self, PyObject *no_arg)
{
  EVP_MD_CTX * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_MD_CTX_create(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(111));
}

static PyObject *
_cffi_f_EVP_MD_CTX_destroy(PyObject *self, PyObject *arg0)
{
  EVP_MD_CTX * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(111), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(111), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EVP_MD_CTX_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EVP_MD_CTX_md(PyObject *self, PyObject *arg0)
{
  EVP_MD_CTX const * x0;
  Py_ssize_t datasize;
  EVP_MD const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(112), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(112), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_MD_CTX_md(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(51));
}

static PyObject *
_cffi_f_EVP_MD_size(PyObject *self, PyObject *arg0)
{
  EVP_MD const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(51), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_MD_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKCS82PKEY(PyObject *self, PyObject *arg0)
{
  PKCS8_PRIV_KEY_INFO * x0;
  Py_ssize_t datasize;
  EVP_PKEY * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(113), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKCS82PKEY(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(50));
}

static PyObject *
_cffi_f_EVP_PKEY_CTX_dup(PyObject *self, PyObject *arg0)
{
  EVP_PKEY_CTX * x0;
  Py_ssize_t datasize;
  EVP_PKEY_CTX * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_CTX_dup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(58));
}

static PyObject *
_cffi_f_EVP_PKEY_CTX_free(PyObject *self, PyObject *arg0)
{
  EVP_PKEY_CTX * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EVP_PKEY_CTX_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EVP_PKEY_CTX_new(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  ENGINE * x1;
  Py_ssize_t datasize;
  EVP_PKEY_CTX * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_CTX_new", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(48), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_CTX_new(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(58));
}

static PyObject *
_cffi_f_EVP_PKEY_CTX_new_id(PyObject *self, PyObject *args)
{
  int x0;
  ENGINE * x1;
  Py_ssize_t datasize;
  EVP_PKEY_CTX * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_CTX_new_id", &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(48), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_CTX_new_id(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(58));
}

static PyObject *
_cffi_f_EVP_PKEY_CTX_set_rsa_mgf1_md(PyObject *self, PyObject *args)
{
  EVP_PKEY_CTX * x0;
  EVP_MD * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_CTX_set_rsa_mgf1_md", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(114), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_CTX_set_rsa_mgf1_md(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_CTX_set_rsa_padding(PyObject *self, PyObject *args)
{
  EVP_PKEY_CTX * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_CTX_set_rsa_padding", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_CTX_set_rsa_padding(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_CTX_set_rsa_pss_saltlen(PyObject *self, PyObject *args)
{
  EVP_PKEY_CTX * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_CTX_set_rsa_pss_saltlen", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_CTX_set_rsa_pss_saltlen(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_CTX_set_signature_md(PyObject *self, PyObject *args)
{
  EVP_PKEY_CTX * x0;
  EVP_MD const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_CTX_set_signature_md", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(51), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_CTX_set_signature_md(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_add1_attr(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  X509_ATTRIBUTE * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_add1_attr", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(115), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_add1_attr(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_add1_attr_by_NID(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  int x1;
  int x2;
  unsigned char const * x3;
  int x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EVP_PKEY_add1_attr_by_NID", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_add1_attr_by_NID(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_add1_attr_by_OBJ(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  ASN1_OBJECT const * x1;
  int x2;
  unsigned char const * x3;
  int x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EVP_PKEY_add1_attr_by_OBJ", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(116), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_add1_attr_by_OBJ(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_add1_attr_by_txt(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  char const * x1;
  int x2;
  unsigned char const * x3;
  int x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EVP_PKEY_add1_attr_by_txt", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_add1_attr_by_txt(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_assign_DSA(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  DSA * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_assign_DSA", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(67), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_assign_DSA(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_assign_EC_KEY(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  EC_KEY * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_assign_EC_KEY", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(71), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_assign_EC_KEY(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_assign_RSA(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  RSA * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_assign_RSA", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(117), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(117), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_assign_RSA(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_bits(PyObject *self, PyObject *arg0)
{
  EVP_PKEY * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_bits(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_cmp(PyObject *self, PyObject *args)
{
  EVP_PKEY const * x0;
  EVP_PKEY const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_cmp", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(118), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(118), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(118), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(118), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_cmp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_decrypt_init(PyObject *self, PyObject *arg0)
{
  EVP_PKEY_CTX * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_decrypt_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_delete_attr(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  int x1;
  Py_ssize_t datasize;
  X509_ATTRIBUTE * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_delete_attr", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_delete_attr(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(115));
}

static PyObject *
_cffi_f_EVP_PKEY_encrypt_init(PyObject *self, PyObject *arg0)
{
  EVP_PKEY_CTX * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_encrypt_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_free(PyObject *self, PyObject *arg0)
{
  EVP_PKEY * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EVP_PKEY_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_EVP_PKEY_get1_DH(PyObject *self, PyObject *arg0)
{
  EVP_PKEY * x0;
  Py_ssize_t datasize;
  DH * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_get1_DH(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(63));
}

static PyObject *
_cffi_f_EVP_PKEY_get1_DSA(PyObject *self, PyObject *arg0)
{
  EVP_PKEY * x0;
  Py_ssize_t datasize;
  DSA * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_get1_DSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(67));
}

static PyObject *
_cffi_f_EVP_PKEY_get1_EC_KEY(PyObject *self, PyObject *arg0)
{
  EVP_PKEY * x0;
  Py_ssize_t datasize;
  EC_KEY * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_get1_EC_KEY(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(71));
}

static PyObject *
_cffi_f_EVP_PKEY_get1_RSA(PyObject *self, PyObject *arg0)
{
  EVP_PKEY * x0;
  Py_ssize_t datasize;
  RSA * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_get1_RSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(117));
}

static PyObject *
_cffi_f_EVP_PKEY_get_attr(PyObject *self, PyObject *args)
{
  EVP_PKEY const * x0;
  int x1;
  Py_ssize_t datasize;
  X509_ATTRIBUTE * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_get_attr", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(118), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(118), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_get_attr(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(115));
}

static PyObject *
_cffi_f_EVP_PKEY_get_attr_by_NID(PyObject *self, PyObject *args)
{
  EVP_PKEY const * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EVP_PKEY_get_attr_by_NID", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(118), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(118), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_get_attr_by_NID(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_get_attr_by_OBJ(PyObject *self, PyObject *args)
{
  EVP_PKEY const * x0;
  ASN1_OBJECT * x1;
  int x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EVP_PKEY_get_attr_by_OBJ", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(118), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(118), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(14), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_get_attr_by_OBJ(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_get_attr_count(PyObject *self, PyObject *arg0)
{
  EVP_PKEY const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(118), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(118), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_get_attr_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_id(PyObject *self, PyObject *arg0)
{
  EVP_PKEY const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(118), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(118), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_id(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_new(PyObject *self, PyObject *no_arg)
{
  EVP_PKEY * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(50));
}

static PyObject *
_cffi_f_EVP_PKEY_set1_DH(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  DH * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_set1_DH", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(63), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_set1_DH(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_set1_DSA(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  DSA * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_set1_DSA", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(67), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_set1_DSA(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_set1_EC_KEY(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  EC_KEY * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_set1_EC_KEY", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(71), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_set1_EC_KEY(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_set1_RSA(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  RSA * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_PKEY_set1_RSA", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(117), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(117), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_set1_RSA(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_sign(PyObject *self, PyObject *args)
{
  EVP_PKEY_CTX * x0;
  unsigned char * x1;
  size_t * x2;
  unsigned char const * x3;
  size_t x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EVP_PKEY_sign", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(46), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_sign(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_sign_init(PyObject *self, PyObject *arg0)
{
  EVP_PKEY_CTX * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_sign_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_size(PyObject *self, PyObject *arg0)
{
  EVP_PKEY * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(50), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_type(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_verify(PyObject *self, PyObject *args)
{
  EVP_PKEY_CTX * x0;
  unsigned char const * x1;
  size_t x2;
  unsigned char const * x3;
  size_t x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:EVP_PKEY_verify", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_verify(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_PKEY_verify_init(PyObject *self, PyObject *arg0)
{
  EVP_PKEY_CTX * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(58), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_verify_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_SignFinal(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  unsigned char * x1;
  unsigned int * x2;
  EVP_PKEY * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:EVP_SignFinal", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(111), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(111), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(4), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(50), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_SignFinal(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_SignInit(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  EVP_MD const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_SignInit", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(111), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(111), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(51), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_SignInit(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_SignUpdate(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EVP_SignUpdate", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(111), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(111), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(17), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_SignUpdate(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_VerifyFinal(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  unsigned char const * x1;
  unsigned int x2;
  EVP_PKEY * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:EVP_VerifyFinal", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(111), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(111), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(50), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_VerifyFinal(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_VerifyInit(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  EVP_MD const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:EVP_VerifyInit", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(111), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(111), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(51), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_VerifyInit(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_VerifyUpdate(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:EVP_VerifyUpdate", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(111), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(111), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(17), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_VerifyUpdate(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_EVP_get_cipherbyname(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  EVP_CIPHER const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_get_cipherbyname(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(47));
}

static PyObject *
_cffi_f_EVP_get_digestbyname(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  EVP_MD const * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_get_digestbyname(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(51));
}

static PyObject *
_cffi_f_EVP_md5(PyObject *self, PyObject *no_arg)
{
  EVP_MD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_md5(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(51));
}

static PyObject *
_cffi_f_EVP_ripemd160(PyObject *self, PyObject *no_arg)
{
  EVP_MD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_ripemd160(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(51));
}

static PyObject *
_cffi_f_EVP_sha1(PyObject *self, PyObject *no_arg)
{
  EVP_MD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_sha1(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(51));
}

static PyObject *
_cffi_f_EVP_sha224(PyObject *self, PyObject *no_arg)
{
  EVP_MD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_sha224(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(51));
}

static PyObject *
_cffi_f_EVP_sha256(PyObject *self, PyObject *no_arg)
{
  EVP_MD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_sha256(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(51));
}

static PyObject *
_cffi_f_EVP_sha384(PyObject *self, PyObject *no_arg)
{
  EVP_MD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_sha384(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(51));
}

static PyObject *
_cffi_f_EVP_sha512(PyObject *self, PyObject *no_arg)
{
  EVP_MD const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_sha512(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(51));
}

static PyObject *
_cffi_f_GENERAL_NAMES_free(PyObject *self, PyObject *arg0)
{
  GENERAL_NAMES * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(119), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(119), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { GENERAL_NAMES_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_GENERAL_NAME_print(PyObject *self, PyObject *args)
{
  BIO * x0;
  GENERAL_NAME * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:GENERAL_NAME_print", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(120), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = GENERAL_NAME_print(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_HMAC_CTX_cleanup(PyObject *self, PyObject *arg0)
{
  HMAC_CTX * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(59), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { HMAC_CTX_cleanup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_HMAC_CTX_init(PyObject *self, PyObject *arg0)
{
  HMAC_CTX * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(59), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(59), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { HMAC_CTX_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_M_ASN1_TIME_dup(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  ASN1_TIME * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(31), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = M_ASN1_TIME_dup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(20));
}

static PyObject *
_cffi_f_NETSCAPE_SPKI_b64_decode(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  Py_ssize_t datasize;
  NETSCAPE_SPKI * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:NETSCAPE_SPKI_b64_decode", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = NETSCAPE_SPKI_b64_decode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(121));
}

static PyObject *
_cffi_f_NETSCAPE_SPKI_b64_encode(PyObject *self, PyObject *arg0)
{
  NETSCAPE_SPKI * x0;
  Py_ssize_t datasize;
  char * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(121), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = NETSCAPE_SPKI_b64_encode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(18));
}

static PyObject *
_cffi_f_NETSCAPE_SPKI_free(PyObject *self, PyObject *arg0)
{
  NETSCAPE_SPKI * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(121), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { NETSCAPE_SPKI_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_NETSCAPE_SPKI_get_pubkey(PyObject *self, PyObject *arg0)
{
  NETSCAPE_SPKI * x0;
  Py_ssize_t datasize;
  EVP_PKEY * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(121), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = NETSCAPE_SPKI_get_pubkey(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(50));
}

static PyObject *
_cffi_f_NETSCAPE_SPKI_new(PyObject *self, PyObject *no_arg)
{
  NETSCAPE_SPKI * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = NETSCAPE_SPKI_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(121));
}

static PyObject *
_cffi_f_NETSCAPE_SPKI_set_pubkey(PyObject *self, PyObject *args)
{
  NETSCAPE_SPKI * x0;
  EVP_PKEY * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:NETSCAPE_SPKI_set_pubkey", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(121), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(50), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = NETSCAPE_SPKI_set_pubkey(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_NETSCAPE_SPKI_sign(PyObject *self, PyObject *args)
{
  NETSCAPE_SPKI * x0;
  EVP_PKEY * x1;
  EVP_MD const * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:NETSCAPE_SPKI_sign", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(121), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(50), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(51), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = NETSCAPE_SPKI_sign(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_NETSCAPE_SPKI_verify(PyObject *self, PyObject *args)
{
  NETSCAPE_SPKI * x0;
  EVP_PKEY * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:NETSCAPE_SPKI_verify", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(121), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(50), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = NETSCAPE_SPKI_verify(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_OBJ_cleanup(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { OBJ_cleanup(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_OBJ_cmp(PyObject *self, PyObject *args)
{
  ASN1_OBJECT const * x0;
  ASN1_OBJECT const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:OBJ_cmp", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(116), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(116), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_cmp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_OBJ_create(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:OBJ_create", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(0), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_create(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_OBJ_dup(PyObject *self, PyObject *arg0)
{
  ASN1_OBJECT const * x0;
  Py_ssize_t datasize;
  ASN1_OBJECT * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(116), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_dup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(14));
}

static PyObject *
_cffi_f_OBJ_ln2nid(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_ln2nid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_OBJ_nid2ln(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_nid2ln(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(0));
}

static PyObject *
_cffi_f_OBJ_nid2obj(PyObject *self, PyObject *arg0)
{
  int x0;
  ASN1_OBJECT * result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_nid2obj(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(14));
}

static PyObject *
_cffi_f_OBJ_nid2sn(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_nid2sn(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(0));
}

static PyObject *
_cffi_f_OBJ_obj2nid(PyObject *self, PyObject *arg0)
{
  ASN1_OBJECT const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(116), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_obj2nid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_OBJ_obj2txt(PyObject *self, PyObject *args)
{
  char * x0;
  int x1;
  ASN1_OBJECT const * x2;
  int x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:OBJ_obj2txt", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(18), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(116), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_obj2txt(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_OBJ_sn2nid(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_sn2nid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_OBJ_txt2nid(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_txt2nid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_OBJ_txt2obj(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  Py_ssize_t datasize;
  ASN1_OBJECT * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:OBJ_txt2obj", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_txt2obj(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(14));
}

static PyObject *
_cffi_f_OPENSSL_config(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { OPENSSL_config(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_OPENSSL_free(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(31), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { OPENSSL_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_OPENSSL_no_config(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { OPENSSL_no_config(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_OpenSSL_add_all_algorithms(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { OpenSSL_add_all_algorithms(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_PEM_read_bio_DHparams(PyObject *self, PyObject *args)
{
  BIO * x0;
  DH * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  DH * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:PEM_read_bio_DHparams", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(122), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(122), arg1) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(123));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_DHparams(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(63));
}

static PyObject *
_cffi_f_PEM_read_bio_DSAPrivateKey(PyObject *self, PyObject *args)
{
  BIO * x0;
  DSA * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  DSA * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:PEM_read_bio_DSAPrivateKey", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(124), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(124), arg1) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(123));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_DSAPrivateKey(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(67));
}

static PyObject *
_cffi_f_PEM_read_bio_DSA_PUBKEY(PyObject *self, PyObject *args)
{
  BIO * x0;
  DSA * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  DSA * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:PEM_read_bio_DSA_PUBKEY", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(124), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(124), arg1) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(123));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_DSA_PUBKEY(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(67));
}

static PyObject *
_cffi_f_PEM_read_bio_PKCS7(PyObject *self, PyObject *args)
{
  BIO * x0;
  PKCS7 * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  PKCS7 * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:PEM_read_bio_PKCS7", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(125), arg1) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(123));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_PKCS7(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(126));
}

static PyObject *
_cffi_f_PEM_read_bio_PUBKEY(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  EVP_PKEY * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:PEM_read_bio_PUBKEY", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(127), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(127), arg1) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(123));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_PUBKEY(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(50));
}

static PyObject *
_cffi_f_PEM_read_bio_PrivateKey(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  EVP_PKEY * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:PEM_read_bio_PrivateKey", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(127), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(127), arg1) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(123));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_PrivateKey(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(50));
}

static PyObject *
_cffi_f_PEM_read_bio_RSAPrivateKey(PyObject *self, PyObject *args)
{
  BIO * x0;
  RSA * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  RSA * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:PEM_read_bio_RSAPrivateKey", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(128), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(128), arg1) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(123));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_RSAPrivateKey(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(117));
}

static PyObject *
_cffi_f_PEM_read_bio_RSAPublicKey(PyObject *self, PyObject *args)
{
  BIO * x0;
  RSA * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  RSA * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:PEM_read_bio_RSAPublicKey", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(128), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(128), arg1) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(123));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_RSAPublicKey(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(117));
}

static PyObject *
_cffi_f_PEM_read_bio_X509(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509 * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  X509 * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:PEM_read_bio_X509", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(129), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(129), arg1) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(123));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_X509(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(49));
}

static PyObject *
_cffi_f_PEM_read_bio_X509_CRL(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_CRL * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  X509_CRL * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:PEM_read_bio_X509_CRL", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(130), arg1) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(123));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_X509_CRL(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(131));
}

static PyObject *
_cffi_f_PEM_read_bio_X509_REQ(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_REQ * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  X509_REQ * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:PEM_read_bio_X509_REQ", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(132), arg1) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(123));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(31), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_X509_REQ(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(133));
}

static PyObject *
_cffi_f_PEM_write_bio_CMS_stream(PyObject *self, PyObject *args)
{
  BIO * x0;
  CMS_ContentInfo * x1;
  BIO * x2;
  int x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:PEM_write_bio_CMS_stream", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(38), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(21), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_CMS_stream(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PEM_write_bio_DSAPrivateKey(PyObject *self, PyObject *args)
{
  BIO * x0;
  DSA * x1;
  EVP_CIPHER const * x2;
  unsigned char * x3;
  int x4;
  int(* x5)(char *, int, int, void *);
  void * x6;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_ParseTuple(args, "OOOOOOO:PEM_write_bio_DSAPrivateKey", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(67), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(47), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(2), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg5, _cffi_type(123));
  if (x5 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = alloca(datasize);
    memset((void *)x6, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(31), arg6) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_DSAPrivateKey(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PEM_write_bio_DSA_PUBKEY(PyObject *self, PyObject *args)
{
  BIO * x0;
  DSA * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:PEM_write_bio_DSA_PUBKEY", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(67), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_DSA_PUBKEY(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PEM_write_bio_ECPrivateKey(PyObject *self, PyObject *args)
{
  BIO * x0;
  EC_KEY * x1;
  EVP_CIPHER const * x2;
  unsigned char * x3;
  int x4;
  int(* x5)(char *, int, int, void *);
  void * x6;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_ParseTuple(args, "OOOOOOO:PEM_write_bio_ECPrivateKey", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(71), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(47), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(2), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg5, _cffi_type(123));
  if (x5 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = alloca(datasize);
    memset((void *)x6, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(31), arg6) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_ECPrivateKey(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PEM_write_bio_PKCS7(PyObject *self, PyObject *args)
{
  BIO * x0;
  PKCS7 * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:PEM_write_bio_PKCS7", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(126), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_PKCS7(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PEM_write_bio_PKCS8PrivateKey(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * x1;
  EVP_CIPHER const * x2;
  char * x3;
  int x4;
  int(* x5)(char *, int, int, void *);
  void * x6;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_ParseTuple(args, "OOOOOOO:PEM_write_bio_PKCS8PrivateKey", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(50), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(47), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(18), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg5, _cffi_type(123));
  if (x5 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = alloca(datasize);
    memset((void *)x6, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(31), arg6) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_PKCS8PrivateKey(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PEM_write_bio_PKCS8PrivateKey_nid(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * x1;
  int x2;
  char * x3;
  int x4;
  int(* x5)(char *, int, int, void *);
  void * x6;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_ParseTuple(args, "OOOOOOO:PEM_write_bio_PKCS8PrivateKey_nid", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(50), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(18), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg5, _cffi_type(123));
  if (x5 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = alloca(datasize);
    memset((void *)x6, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(31), arg6) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_PKCS8PrivateKey_nid(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PEM_write_bio_PUBKEY(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:PEM_write_bio_PUBKEY", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(50), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_PUBKEY(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PEM_write_bio_PrivateKey(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * x1;
  EVP_CIPHER const * x2;
  unsigned char * x3;
  int x4;
  int(* x5)(char *, int, int, void *);
  void * x6;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_ParseTuple(args, "OOOOOOO:PEM_write_bio_PrivateKey", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(50), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(47), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(2), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg5, _cffi_type(123));
  if (x5 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = alloca(datasize);
    memset((void *)x6, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(31), arg6) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_PrivateKey(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PEM_write_bio_RSAPrivateKey(PyObject *self, PyObject *args)
{
  BIO * x0;
  RSA * x1;
  EVP_CIPHER const * x2;
  unsigned char * x3;
  int x4;
  int(* x5)(char *, int, int, void *);
  void * x6;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_ParseTuple(args, "OOOOOOO:PEM_write_bio_RSAPrivateKey", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(117), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(117), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(47), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(2), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg5, _cffi_type(123));
  if (x5 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = alloca(datasize);
    memset((void *)x6, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(31), arg6) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_RSAPrivateKey(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PEM_write_bio_RSAPublicKey(PyObject *self, PyObject *args)
{
  BIO * x0;
  RSA const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:PEM_write_bio_RSAPublicKey", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(134), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_RSAPublicKey(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PEM_write_bio_X509(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509 * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:PEM_write_bio_X509", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(49), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_X509(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PEM_write_bio_X509_CRL(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_CRL * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:PEM_write_bio_X509_CRL", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(131), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(131), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_X509_CRL(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PEM_write_bio_X509_REQ(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_REQ * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:PEM_write_bio_X509_REQ", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(21), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(133), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(133), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_X509_REQ(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PKCS12_create(PyObject *self, PyObject *args)
{
  char * x0;
  char * x1;
  EVP_PKEY * x2;
  X509 * x3;
  Cryptography_STACK_OF_X509 * x4;
  int x5;
  int x6;
  int x7;
  int x8;
  int x9;
  Py_ssize_t datasize;
  PKCS12 * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_ParseTuple(args, "OOOOOOOOOO:PKCS12_create", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(18), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(18), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(50), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(49), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(53), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(53), arg4) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, int);
  if (x6 == (int)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, int);
  if (x7 == (int)-1 && PyErr_Occurred())
    return NULL;

  x8 = _cffi_to_c_int(arg8, int);
  if (x8 == (int)-1 && PyErr_Occurred())
    return NULL;

  x9 = _cffi_to_c_int(arg9, int);
  if (x9 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS12_create(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(135));
}

static PyObject *
_cffi_f_PKCS12_free(PyObject *self, PyObject *arg0)
{
  PKCS12 * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(135), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(135), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { PKCS12_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_PKCS12_parse(PyObject *self, PyObject *args)
{
  PKCS12 * x0;
  char const * x1;
  EVP_PKEY * * x2;
  X509 * * x3;
  Cryptography_STACK_OF_X509 * * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:PKCS12_parse", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(135), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(135), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(0), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(127), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(127), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(129), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(129), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(136), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(136), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS12_parse(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PKCS5_PBKDF2_HMAC(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  unsigned char const * x2;
  int x3;
  int x4;
  EVP_MD const * x5;
  int x6;
  unsigned char * x7;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_ParseTuple(args, "OOOOOOOO:PKCS5_PBKDF2_HMAC", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(1), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = alloca(datasize);
    memset((void *)x5, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(51), arg5) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, int);
  if (x6 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg7, (char **)&x7);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x7 = alloca(datasize);
    memset((void *)x7, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x7, _cffi_type(2), arg7) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS5_PBKDF2_HMAC(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PKCS5_PBKDF2_HMAC_SHA1(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  unsigned char const * x2;
  int x3;
  int x4;
  int x5;
  unsigned char * x6;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_ParseTuple(args, "OOOOOOO:PKCS5_PBKDF2_HMAC_SHA1", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(1), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = alloca(datasize);
    memset((void *)x6, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(2), arg6) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS5_PBKDF2_HMAC_SHA1(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PKCS7_decrypt(PyObject *self, PyObject *args)
{
  PKCS7 * x0;
  EVP_PKEY * x1;
  X509 * x2;
  BIO * x3;
  int x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:PKCS7_decrypt", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(126), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(50), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(49), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(21), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS7_decrypt(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PKCS7_encrypt(PyObject *self, PyObject *args)
{
  Cryptography_STACK_OF_X509 * x0;
  BIO * x1;
  EVP_CIPHER const * x2;
  int x3;
  Py_ssize_t datasize;
  PKCS7 * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:PKCS7_encrypt", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(53), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(53), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(21), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(47), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS7_encrypt(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(126));
}

static PyObject *
_cffi_f_PKCS7_free(PyObject *self, PyObject *arg0)
{
  PKCS7 * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(126), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { PKCS7_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_PKCS7_get0_signers(PyObject *self, PyObject *args)
{
  PKCS7 * x0;
  Cryptography_STACK_OF_X509 * x1;
  int x2;
  Py_ssize_t datasize;
  Cryptography_STACK_OF_X509 * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:PKCS7_get0_signers", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(126), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(53), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(53), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS7_get0_signers(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(53));
}

static PyObject *
_cffi_f_PKCS7_sign(PyObject *self, PyObject *args)
{
  X509 * x0;
  EVP_PKEY * x1;
  Cryptography_STACK_OF_X509 * x2;
  BIO * x3;
  int x4;
  Py_ssize_t datasize;
  PKCS7 * result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:PKCS7_sign", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(49), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(50), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(53), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(53), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(21), arg3) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS7_sign(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(126));
}

static PyObject *
_cffi_f_PKCS7_type_is_data(PyObject *self, PyObject *arg0)
{
  PKCS7 * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(126), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS7_type_is_data(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PKCS7_type_is_enveloped(PyObject *self, PyObject *arg0)
{
  PKCS7 * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(126), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS7_type_is_enveloped(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PKCS7_type_is_signed(PyObject *self, PyObject *arg0)
{
  PKCS7 * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(126), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS7_type_is_signed(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PKCS7_type_is_signedAndEnveloped(PyObject *self, PyObject *arg0)
{
  PKCS7 * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(126), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS7_type_is_signedAndEnveloped(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PKCS7_verify(PyObject *self, PyObject *args)
{
  PKCS7 * x0;
  Cryptography_STACK_OF_X509 * x1;
  X509_STORE * x2;
  BIO * x3;
  BIO * x4;
  int x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:PKCS7_verify", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(126), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(53), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(53), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(54), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(21), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(21), arg4) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS7_verify(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_PKCS8_PRIV_KEY_INFO_free(PyObject *self, PyObject *arg0)
{
  PKCS8_PRIV_KEY_INFO * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(113), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { PKCS8_PRIV_KEY_INFO_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_RAND_add(PyObject *self, PyObject *args)
{
  void const * x0;
  int x1;
  double x2;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:RAND_add", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(17), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { RAND_add(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_RAND_bytes(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:RAND_bytes", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RAND_bytes(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_RAND_cleanup(PyObject *self, PyObject *no_arg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { RAND_cleanup(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_RAND_egd(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RAND_egd(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_RAND_egd_bytes(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:RAND_egd_bytes", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RAND_egd_bytes(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_RAND_file_name(PyObject *self, PyObject *args)
{
  char * x0;
  size_t x1;
  Py_ssize_t datasize;
  char const * result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:RAND_file_name", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(18), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RAND_file_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(0));
}

static PyObject *
_cffi_f_RAND_load_file(PyObject *self, PyObject *args)
{
  char const * x0;
  long x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:RAND_load_file", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RAND_load_file(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_RAND_pseudo_bytes(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:RAND_pseudo_bytes", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RAND_pseudo_bytes(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_RAND_query_egd_bytes(PyObject *self, PyObject *args)
{
  char const * x0;
  unsigned char * x1;
  int x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_ParseTuple(args, "OOO:RAND_query_egd_bytes", &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RAND_query_egd_bytes(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_RAND_seed(PyObject *self, PyObject *args)
{
  void const * x0;
  int x1;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:RAND_seed", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(17), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { RAND_seed(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_RAND_status(PyObject *self, PyObject *no_arg)
{
  int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RAND_status(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_RAND_write_file(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(0), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(0), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RAND_write_file(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_RSAPublicKey_dup(PyObject *self, PyObject *arg0)
{
  RSA * x0;
  Py_ssize_t datasize;
  RSA * result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(117), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(117), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RSAPublicKey_dup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(117));
}

static PyObject *
_cffi_f_RSA_blinding_off(PyObject *self, PyObject *arg0)
{
  RSA * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(117), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(117), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { RSA_blinding_off(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_RSA_blinding_on(PyObject *self, PyObject *args)
{
  RSA * x0;
  BN_CTX * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_ParseTuple(args, "OO:RSA_blinding_on", &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(117), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(117), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RSA_blinding_on(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_RSA_check_key(PyObject *self, PyObject *arg0)
{
  RSA const * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(134), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RSA_check_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_RSA_free(PyObject *self, PyObject *arg0)
{
  RSA * x0;
  Py_ssize_t datasize;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(117), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(117), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { RSA_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
_cffi_f_RSA_generate_key_ex(PyObject *self, PyObject *args)
{
  RSA * x0;
  int x1;
  BIGNUM * x2;
  BN_GENCB * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_ParseTuple(args, "OOOO:RSA_generate_key_ex", &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(117), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(117), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(11), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = alloca(datasize);
    memset((void *)x3, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(65), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RSA_generate_key_ex(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_RSA_new(PyObject *self, PyObject *no_arg)
{
  RSA * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RSA_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_pointer((char *)result, _cffi_type(117));
}

static PyObject *
_cffi_f_RSA_padding_add_PKCS1_OAEP(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  int x1;
  unsigned char const * x2;
  int x3;
  unsigned char const * x4;
  int x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_ParseTuple(args, "OOOOOO:RSA_padding_add_PKCS1_OAEP", &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(2), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = alloca(datasize);
    memset((void *)x2, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(1), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = alloca(datasize);
    memset((void *)x4, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(1), arg4) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RSA_padding_add_PKCS1_OAEP(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  return _cffi_from_c_int(result, int);
}

static PyObject *
_cffi_f_RSA_padding_add_PKCS1_PSS(PyObject *self, PyObject *args)
{
  RSA * x0;
  unsigned char * x1;
  unsigned char const * x2;
  EVP_MD const * x3;
  int x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_ParseTuple(args, "OOOOO:RSA_padding_add_PKCS1_PSS", &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(117), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = alloca(datasize);
    memset((void *)x0, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(117), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = alloca(datasize);
    memset((void *)x1, 0, datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(2), arg1) < 0)
      return NULL;
  }

 