/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.holidays;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.nachocalendar.holidays.HoliDay;
import net.sf.nachocalendar.model.DataModel;

public class HoliDayModel
implements DataModel {
    private LinkedList holidays = new LinkedList();
    private Comparator sorter;
    private Calendar cal;
    private Calendar check;
    private int currentmonth;
    private LinkedList minimumlist = new LinkedList();

    public HoliDayModel() {
        this.cal = Calendar.getInstance();
        this.check = Calendar.getInstance();
        this.sorter = new Comparator(){

            public int compare(Object o1, Object o2) {
                HoliDay h1 = (HoliDay)o1;
                HoliDay h2 = (HoliDay)o2;
                return (int)(h1.getDate().getTime() - h2.getDate().getTime());
            }
        };
    }

    private void changeMonth(int month) {
        this.currentmonth = month;
        this.minimumlist.clear();
        Iterator it = this.holidays.iterator();
        while (it.hasNext()) {
            HoliDay h = (HoliDay)it.next();
            this.check.setTime(h.getDate());
            if (this.check.get(2) != month) continue;
            this.minimumlist.add(h);
        }
    }

    private boolean compare(HoliDay h, int year, int month, int day) {
        this.cal.setTime(h.getDate());
        if (!h.isRecurrent() && year != this.cal.get(1)) {
            return false;
        }
        if (month != this.cal.get(2)) {
            return false;
        }
        return day == this.cal.get(5);
    }

    public void addHoliDay(HoliDay day) {
        this.holidays.add(day);
        if (this.holidays.size() > 1) {
            Collections.sort(this.holidays, this.sorter);
        }
    }

    public void removeHoliDay(HoliDay day) {
        this.holidays.remove(day);
    }

    public int getSize() {
        return this.holidays.size();
    }

    public Collection getAll() {
        return (Collection)this.holidays.clone();
    }

    public void clear() {
        this.holidays.clear();
    }

    public Object getData(Date date) {
        return this.getHoliDay(date);
    }

    public HoliDay getHoliDay(Date date) {
        this.cal.setTime(date);
        int day = this.cal.get(5);
        int month = this.cal.get(2);
        int year = this.cal.get(1);
        if (month != this.currentmonth) {
            this.changeMonth(month);
        }
        Iterator it = this.minimumlist.iterator();
        while (it.hasNext()) {
            HoliDay h = (HoliDay)it.next();
            if (!this.compare(h, year, month, day)) continue;
            return h;
        }
        return null;
    }
}

