/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JTable;
import net.sf.nachocalendar.components.CalendarUtils;
import net.sf.nachocalendar.components.DayRenderer;
import net.sf.nachocalendar.components.MoonCalculation;

public class DayPanel
extends JComponent {
    private Date date;
    private Object data;
    JTable d;
    private boolean antiAliased;
    private DayRenderer renderer;
    private boolean working;
    private boolean componentEnabled;
    private boolean enabled;
    private boolean selected;
    private int index;
    private MoonCalculation moonCalculator;
    private int moonSize = 7;
    private boolean printMoon;

    public DayPanel(DayRenderer renderer, int index) {
        this.renderer = renderer;
        this.index = index;
        this.componentEnabled = true;
        this.setBorder(null);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.date = new Date();
        this.setFocusable(true);
        this.moonCalculator = new MoonCalculation();
    }

    public void setDate(Date d) {
        this.date = d;
        this.repaint();
    }

    public Date getDate() {
        return this.date;
    }

    public void setData(Object d) {
        this.data = d;
        this.repaint();
    }

    public Object getData() {
        return this.data;
    }

    public DayRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(DayRenderer renderer) {
        this.renderer = renderer;
    }

    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean working) {
        this.working = working;
    }

    public void paint(Graphics g) {
        Component comp = this.renderer.getDayRenderer(this, this.date, this.data, this.isSelected(), this.working, this.isEnabled() && this.isComponentEnabled());
        comp.setBounds(this.getBounds());
        Graphics2D g2 = (Graphics2D)g;
        if (this.isAntiAliased()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        comp.paint(g);
        if (this.isEnabled()) {
            if (CalendarUtils.isToday(this.date)) {
                g.setColor(Color.red);
                g.drawOval(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            }
            if (this.printMoon && this.getWidth() > this.moonSize && this.getHeight() > this.moonSize) {
                g = this.moonCalculator.drawMoon(g, this.date, this.getWidth() - this.moonSize - 1, 0, this.moonSize);
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isComponentEnabled() {
        return this.componentEnabled;
    }

    public void setComponentEnabled(boolean componentEnabled) {
        this.componentEnabled = componentEnabled;
        super.setEnabled(this.enabled && componentEnabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        super.setEnabled(enabled && this.componentEnabled);
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        this.antiAliased = antiAliased;
    }

    public boolean isPrintMoon() {
        return this.printMoon;
    }

    public void setPrintMoon(boolean printMoon) {
        this.printMoon = printMoon;
    }
}

