/*
 * Decompiled with CFR 0.152.
 */
package com.projity.contrib.calendar;

import com.projity.contrib.calendar.ContribIntervals;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.commons.lang.time.DateUtils;
import org.jdesktop.swing.calendar.DateSpan;

public class JXXMonthView
extends JComponent {
    public static final int NO_SELECTION = 0;
    public static final int SINGLE_SELECTION = 1;
    public static final int MULTIPLE_SELECTION = 2;
    public static final int WEEK_SELECTION = 3;
    protected Insets _monthStringInsets = new Insets(0, 8, 0, 8);
    private static final int MONTH_DROP_SHADOW = 1;
    private static final int MONTH_LINE_DROP_SHADOW = 2;
    private static final int WEEK_DROP_SHADOW = 4;
    private int _boxPaddingX = 3;
    private int _boxPaddingY = 3;
    private static final int CALENDAR_SPACING = 10;
    private static final int DAYS_IN_WEEK = 7;
    private static final int MONTHS_IN_YEAR = 12;
    private long _firstDisplayedDate;
    private int _firstDisplayedMonth;
    private int _firstDisplayedYear;
    private long _lastDisplayedDate;
    private Font _derivedFont;
    private Font _baselineFont;
    private Color _newColor;
    private long _pivotDate = -1L;
    private Rectangle _selectedDateRect = new Rectangle();
    private int _numCalCols = 1;
    private int _numCalRows = 1;
    private int _minCalCols = 1;
    private int _minCalRows = 1;
    private long _today;
    private long[] _flaggedDates;
    private long[] _coloredDates;
    private boolean[] _flaggedWeekDates;
    private boolean[] _coloredWeekDates;
    private boolean[] _selectedWeekDays = new boolean[7];
    private int _selectionMode = 2;
    private int _boxHeight;
    private int _boxWidth;
    private int _calendarWidth;
    private int _calendarHeight;
    private int _firstDayOfWeek = 1;
    private int _startX;
    private int _startY;
    private int _dropShadowMask = 1;
    private boolean _dirty = false;
    private boolean _antiAlias = false;
    private boolean _ltr;
    private boolean _asKirkWouldSay_FIRE = false;
    private Calendar _cal;
    private String[] _daysOfTheWeek;
    private static String[] _monthsOfTheYear;
    private Dimension _dim = new Dimension();
    private Rectangle _bounds = new Rectangle();
    private Rectangle _dirtyRect = new Rectangle();
    private Color _todayBackgroundColor;
    private Color _monthStringBackground = Color.WHITE;
    private Color _selectedBackground = Color.LIGHT_GRAY;
    private SimpleDateFormat _dayOfMonthFormatter = JXXMonthView.dateFormatInstance("d");
    private String _actionCommand = "selectionChanged";
    private Timer _todayTimer = null;
    private ContribIntervals intervals = new ContribIntervals();
    private static long WEEKDAY_OFFSET;

    public JXXMonthView() {
        this(new Date().getTime());
    }

    public JXXMonthView(long l) {
        this._ltr = this.getComponentOrientation().isLeftToRight();
        this._cal = JXXMonthView.calendarInstance();
        this._cal.setFirstDayOfWeek(this._firstDayOfWeek);
        this._cal.setMinimalDaysInFirstWeek(1);
        this._cal.set(11, 0);
        this._cal.set(12, 0);
        this._cal.set(13, 0);
        this._cal.set(14, 0);
        this._today = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(l);
        this.setFirstDisplayedDate(this._cal.getTimeInMillis());
        this._cal.set(2, this._cal.getMinimum(2));
        this._cal.set(5, this._cal.getActualMinimum(5));
        _monthsOfTheYear = new String[12];
        SimpleDateFormat simpleDateFormat = JXXMonthView.dateFormatInstance("MMMM");
        for (int i = 0; i < 12; ++i) {
            JXXMonthView._monthsOfTheYear[i] = simpleDateFormat.format(this._cal.getTime());
            this._cal.add(2, 1);
        }
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setFont(new Font("Dialog", 0, 12));
        this._todayBackgroundColor = this.getForeground();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.updateUI();
    }

    public void updateUI() {
        Serializable serializable;
        super.updateUI();
        String[] stringArray = (String[])UIManager.get("JXMonthView.daysOfTheWeek");
        int n = 0;
        int n2 = 1;
        if (JXXMonthView.isChinese()) {
            n = 2;
            n2 = 3;
        }
        if (stringArray == null) {
            stringArray = new String[7];
            serializable = JXXMonthView.calendarInstance();
            SimpleDateFormat simpleDateFormat = JXXMonthView.dateFormatInstance("E");
            for (int i = 0; i < 7; ++i) {
                ((Calendar)serializable).set(7, i + 1);
                stringArray[i] = simpleDateFormat.format(((Calendar)serializable).getTime()).substring(n, n2).toUpperCase();
            }
        }
        this.setDaysOfTheWeek(stringArray);
        serializable = UIManager.getColor("JXMonthView.monthStringBackground");
        if (serializable == null) {
            serializable = Color.WHITE;
        }
        this.setMonthStringBackground((Color)serializable);
        serializable = UIManager.getColor("JXMonthView.selectedBackground");
        if (serializable == null) {
            serializable = Color.LIGHT_GRAY;
        }
        this.setSelectedBackground((Color)serializable);
    }

    public long getFirstDisplayedDate() {
        return this._firstDisplayedDate;
    }

    public void setFirstDisplayedDate(long l) {
        long l2 = this._firstDisplayedDate;
        this._cal.setTimeInMillis(l);
        this._cal.set(5, 1);
        this._cal.set(11, 0);
        this._cal.set(12, 0);
        this._cal.set(13, 0);
        this._cal.set(14, 0);
        this._firstDisplayedDate = this._cal.getTimeInMillis();
        this._firstDisplayedMonth = this._cal.get(2);
        this._firstDisplayedYear = this._cal.get(1);
        this.calculateLastDisplayedDate();
        this.firePropertyChange("firstDisplayedDate", l2, this._firstDisplayedDate);
        this.repaint();
    }

    public long getLastDisplayedDate() {
        return this._lastDisplayedDate;
    }

    private void calculateLastDisplayedDate() {
        long l = this._lastDisplayedDate;
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this._cal.add(2, this._numCalCols * this._numCalRows - 1);
        this._cal.set(5, this._cal.getActualMaximum(5));
        this._cal.set(11, 23);
        this._cal.set(12, 59);
        this._cal.set(13, 59);
        this._lastDisplayedDate = this._cal.getTimeInMillis();
        this.firePropertyChange("lastDisplayedDate", l, this._lastDisplayedDate);
    }

    public void ensureDateVisible(long l) {
    }

    public boolean[] getSelectedWeekDays() {
        return this._selectedWeekDays;
    }

    public ContribIntervals getSelectedIntervals() {
        return this.intervals;
    }

    public int getSelectionMode() {
        return this._selectionMode;
    }

    public void setSelectionMode(int n) throws IllegalArgumentException {
        if (n != 1 && n != 2 && n != 3 && n != 0) {
            throw new IllegalArgumentException(n + " is not a valid selection mode");
        }
        this._selectionMode = n;
    }

    private long roundToDay(long l) {
        if (this.isWeekDay(l)) {
            return l;
        }
        this._cal.setTimeInMillis(l);
        this._cal.set(11, 0);
        this._cal.set(12, 0);
        this._cal.set(13, 0);
        this._cal.set(14, 0);
        return this._cal.getTimeInMillis();
    }

    public void setFlaggedDates(long[] lArray) {
        this._flaggedDates = lArray;
        if (this._flaggedDates == null) {
            this.repaint();
            return;
        }
        for (int i = 0; i < this._flaggedDates.length; ++i) {
            this._flaggedDates[i] = this.roundToDay(this._flaggedDates[i]);
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.repaint();
    }

    public void setColorDates(long[] lArray) {
        this._coloredDates = lArray;
        if (this._coloredDates == null) {
            this.repaint();
            return;
        }
        for (int i = 0; i < this._coloredDates.length; ++i) {
            this._coloredDates[i] = this.roundToDay(this._coloredDates[i]);
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.repaint();
    }

    public void setFlaggedWeekDates(boolean[] blArray) {
        this._flaggedWeekDates = blArray;
        if (this._flaggedWeekDates == null) {
            this.repaint();
        }
    }

    public void setColorWeekDates(boolean[] blArray) {
        this._coloredWeekDates = blArray;
        if (this._coloredWeekDates == null) {
            this.repaint();
        }
    }

    public int getBoxPaddingX() {
        return this._boxPaddingX;
    }

    public void setBoxPaddingX(int n) {
        this._boxPaddingX = n;
        this._dirty = true;
    }

    public int getBoxPaddingY() {
        return this._boxPaddingY;
    }

    public void setBoxPaddingY(int n) {
        this._boxPaddingY = n;
        this._dirty = true;
    }

    public void setDaysOfTheWeek(String[] stringArray) throws IllegalArgumentException, NullPointerException {
        if (stringArray == null) {
            throw new NullPointerException("Array of days is null.");
        }
        if (stringArray.length != 7) {
            throw new IllegalArgumentException("Array of days is not of length 7 as expected.");
        }
        this._daysOfTheWeek = stringArray;
    }

    public String[] getDaysOfTheWeek() {
        String[] stringArray = new String[7];
        System.arraycopy(this._daysOfTheWeek, 0, stringArray, 0, 7);
        return stringArray;
    }

    public int getFirstDayOfWeek() {
        return this._firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int n) {
        if (n == this._firstDayOfWeek) {
            return;
        }
        this._firstDayOfWeek = n;
        this._cal.setFirstDayOfWeek(this._firstDayOfWeek);
        this.repaint();
    }

    public TimeZone getTimeZone() {
        return this._cal.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this._cal.setTimeZone(timeZone);
    }

    public boolean getAntialiased() {
        return this._antiAlias;
    }

    public void setAntialiased(boolean bl) {
        if (this._antiAlias == bl) {
            return;
        }
        this._antiAlias = bl;
        this.repaint();
    }

    public Color getSelectedBackground() {
        return this._selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        this._selectedBackground = color;
    }

    public Color getTodayBackground() {
        return this._todayBackgroundColor;
    }

    public void setTodayBackground(Color color) {
        this._todayBackgroundColor = color;
        this.repaint();
    }

    public Color getMonthStringBackground() {
        return this._monthStringBackground;
    }

    public void setMonthStringBackground(Color color) {
        this._monthStringBackground = color;
        this.repaint();
    }

    public Insets getMonthStringInsets() {
        return (Insets)this._monthStringInsets.clone();
    }

    public void setMonthStringInsets(Insets insets) {
        if (insets == null) {
            this._monthStringInsets.top = 0;
            this._monthStringInsets.left = 0;
            this._monthStringInsets.bottom = 0;
            this._monthStringInsets.right = 0;
        } else {
            this._monthStringInsets.top = insets.top;
            this._monthStringInsets.left = insets.left;
            this._monthStringInsets.bottom = insets.bottom;
            this._monthStringInsets.right = insets.right;
        }
        this.repaint();
    }

    public int getPreferredCols() {
        return this._minCalCols;
    }

    public void setPreferredCols(int n) {
        if (n <= 0) {
            return;
        }
        this._minCalCols = n;
        this._dirty = true;
        this.revalidate();
        this.repaint();
    }

    public int getPreferredRows() {
        return this._minCalRows;
    }

    public void setPreferredRows(int n) {
        if (n <= 0) {
            return;
        }
        this._minCalRows = n;
        this._dirty = true;
        this.revalidate();
        this.repaint();
    }

    private void updateIfNecessary() {
        if (this._dirty) {
            this.update();
            this._dirty = false;
        }
    }

    private void update() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this._derivedFont = this.getFont().deriveFont(1);
        this._baselineFont = this.getFont().deriveFont(2);
        FontMetrics fontMetrics = this.getFontMetrics(this._derivedFont);
        this._cal.set(2, this._cal.getMinimum(2));
        this._cal.set(5, this._cal.getActualMinimum(5));
        for (n2 = 0; n2 < this._cal.getMaximum(2); ++n2) {
            int n6;
            n = fontMetrics.stringWidth(_monthsOfTheYear[n2]);
            if (n > n5) {
                n5 = n;
            }
            if ((n6 = this._cal.getActualMaximum(5)) > n4) {
                n3 = this._cal.get(2);
                n4 = n6;
            }
            this._cal.add(2, 1);
        }
        this._cal.set(2, n3);
        this._cal.set(5, this._cal.getActualMinimum(5));
        this._boxHeight = fontMetrics.getHeight();
        for (n2 = 0; n2 < n4; ++n2) {
            n = fontMetrics.stringWidth(this._dayOfMonthFormatter.format(this._cal.getTime()));
            if (n > this._boxWidth) {
                this._boxWidth = n;
            }
            this._cal.add(5, 1);
        }
        this._dim.width = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        if (this._dim.width < n5) {
            double d = n5 - this._dim.width;
            this._boxWidth = (int)((double)this._boxWidth + Math.ceil(d / 7.0));
            this._dim.width = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        }
        this._calendarWidth = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        this._calendarHeight = (this._boxPaddingY + this._boxHeight + this._boxPaddingY) * 8;
        this._dim.height = this._calendarHeight * this._minCalRows + 10 * (this._minCalRows - 1);
        this._dim.width = this._calendarWidth * this._minCalCols + 10 * (this._minCalCols - 1);
        Insets insets = this.getInsets();
        this._dim.width += insets.left + insets.right;
        this._dim.height += insets.top + insets.bottom;
        this._cal.setTimeInMillis(this._firstDisplayedDate);
    }

    private void updateToday() {
        this._cal.setTimeInMillis(this._today);
        this._cal.add(5, 1);
        this._today = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        this.updateIfNecessary();
        return new Dimension(this._dim);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this.calculateNumDisplayedCals();
        this.calculateStartPosition();
        this._dirty = true;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.calculateNumDisplayedCals();
        this.calculateStartPosition();
        long l = this.intervals.getStart();
        long l2 = this.intervals.getEnd();
        if (l != -1L || l2 != -1L) {
            if (l > this._lastDisplayedDate || l < this._firstDisplayedDate) {
                this.ensureDateVisible(l);
            } else {
                this.calculateDirtyRectForSelection();
            }
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        this._ltr = componentOrientation.isLeftToRight();
        this.calculateStartPosition();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._dirty = true;
    }

    public void removeNotify() {
        this._todayTimer.stop();
        super.removeNotify();
    }

    public void addNotify() {
        super.addNotify();
        int n = 86400;
        if (this._todayTimer == null) {
            this._todayTimer = new Timer(n * 1000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JXXMonthView.this.updateToday();
                }
            });
        }
        n = n - this._cal.get(11) * 3600 - this._cal.get(12) * 60 - this._cal.get(13);
        this._todayTimer.setInitialDelay(n * 1000);
        this._todayTimer.start();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D;
        Object object = null;
        Graphics2D graphics2D2 = graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        if (graphics2D != null && this._antiAlias) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle rectangle = graphics.getClipBounds();
        this.updateIfNecessary();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(this.getForeground());
        Color color = graphics.getColor();
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 51);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        int n = this._startY;
        for (int i = 0; i < this._numCalRows; ++i) {
            int n2 = this._startX;
            this._bounds.x = 0;
            this._bounds.y = this._startY + i * (this._calendarHeight + 10);
            this._bounds.width = this.getWidth();
            this._bounds.height = this._calendarHeight;
            if (!this._bounds.intersects(rectangle)) {
                this._cal.add(2, this._numCalCols);
                n += this._calendarHeight + 10;
                continue;
            }
            for (int j = 0; j < this._numCalCols; ++j) {
                int n3;
                int n4;
                String string = _monthsOfTheYear[this._cal.get(2)];
                string = string + " " + this._cal.get(1);
                this._bounds.x = this._ltr ? n2 : n2 - this._calendarWidth;
                this._bounds.y = n + this._boxPaddingY;
                this._bounds.width = this._calendarWidth;
                this._bounds.height = this._boxHeight;
                if (this._bounds.intersects(rectangle)) {
                    this.paintMonthStringBackground(graphics, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                    graphics.setColor(this.getForeground());
                    n4 = this._ltr ? n2 + this._calendarWidth / 2 - fontMetrics.stringWidth(string) / 2 : n2 - this._calendarWidth / 2 - fontMetrics.stringWidth(string) / 2 - 1;
                    n3 = n + this._boxPaddingY + this._boxHeight - fontMetrics.getDescent();
                    graphics.drawString(string, n4, n3);
                    if ((this._dropShadowMask & 1) != 0) {
                        graphics.setColor(color);
                        graphics.drawString(string, n4 + 1, n3 + 1);
                        graphics.setColor(this.getForeground());
                    }
                }
                this._bounds.x = this._ltr ? n2 : n2 - this._calendarWidth;
                this._bounds.y = n + this._boxPaddingY + this._boxHeight + this._boxPaddingY + this._boxPaddingY;
                this._bounds.width = this._calendarWidth;
                this._bounds.height = this._boxHeight;
                if (this._bounds.intersects(rectangle)) {
                    int n5;
                    this._cal.set(5, this._cal.getActualMinimum(5));
                    Calendar calendar = (Calendar)this._cal.clone();
                    int n6 = this._firstDayOfWeek - 1;
                    int n7 = calendar.get(2);
                    for (n5 = 0; n5 < 7; ++n5) {
                        calendar.set(7, n6 + 1);
                        if (calendar.get(2) != n7) {
                            calendar.roll(6, 7);
                        }
                        n4 = this._ltr ? n2 + n5 * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) + this._boxPaddingX + this._boxWidth / 2 - fontMetrics.stringWidth(this._daysOfTheWeek[n6]) / 2 : n2 - n5 * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) - this._boxPaddingX - this._boxWidth / 2 - fontMetrics.stringWidth(this._daysOfTheWeek[n6]) / 2;
                        n3 = n + this._boxPaddingY + this._boxHeight + this._boxPaddingY + this._boxPaddingY + fontMetrics.getAscent();
                        boolean bl = this._flaggedWeekDates[n6];
                        boolean bl2 = this._coloredWeekDates[n6];
                        this.calculateBoundsForDay(this._bounds, calendar, true);
                        this.drawDay(bl2, bl, false, graphics, this._daysOfTheWeek[n6], n4, n3);
                        if (this._selectedWeekDays[n6]) {
                            this.paintSelectedDayBackground(graphics, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                        }
                        if (++n6 != 7) continue;
                        n6 = 0;
                    }
                    n5 = 2;
                    graphics.drawLine(this._ltr ? n2 + 2 : n2 - 3, n5 + n + this._boxPaddingY * 3 + this._boxHeight * 2, this._ltr ? n2 + this._calendarWidth - 3 : n2 - this._calendarWidth + 2, n5 + n + this._boxPaddingY * 3 + this._boxHeight * 2);
                    if ((this._dropShadowMask & 2) != 0) {
                        graphics.setColor(color);
                        graphics.drawLine(this._ltr ? n2 + 3 : n2 - 2, n + this._boxPaddingY * 3 + this._boxHeight * 2 + 1, this._ltr ? n2 + this._calendarWidth - 2 : n2 - this._calendarWidth + 3, n + this._boxPaddingY * 3 + this._boxHeight * 2 + 1);
                        graphics.setColor(this.getForeground());
                    }
                }
                this._bounds.x = this._startX + (this._ltr ? j * (this._calendarWidth + 10) : -(j * (this._calendarWidth + 10) + this._calendarWidth));
                this._bounds.y = this._startY + i * (this._calendarHeight + 10);
                this._bounds.width = this._calendarWidth;
                this._bounds.height = this._calendarHeight;
                if (this._bounds.intersects(rectangle)) {
                    this.paintMonth(graphics, j, i);
                } else {
                    this._cal.add(2, 1);
                }
                n2 += this._ltr ? this._calendarWidth + 10 : -(this._calendarWidth + 10);
            }
            n += this._calendarHeight + 10;
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        if (graphics2D != null && this._antiAlias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    private void paintMonth(Graphics graphics, int n, int n2) {
        int n3 = this._cal.getActualMaximum(5);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = graphics.getClipBounds();
        long l = -1L;
        int n4 = 0;
        if (this._flaggedDates != null && this._flaggedDates.length > 0) {
            l = this._flaggedDates[n4];
        }
        long l2 = -1L;
        int n5 = 0;
        if (this._coloredDates != null && this._coloredDates.length > 0) {
            l2 = this._coloredDates[n5];
        }
        for (int i = 0; i < n3; ++i) {
            this.calculateBoundsForDay(this._bounds, this._cal, false);
            if (this._bounds.intersects(rectangle)) {
                boolean bl;
                String string = this._dayOfMonthFormatter.format(this._cal.getTime());
                boolean bl2 = bl = this._cal.getTimeInMillis() == this._today;
                while (l != -1L && l < this._cal.getTimeInMillis()) {
                    if (++n4 < this._flaggedDates.length) {
                        l = this._flaggedDates[n4];
                        continue;
                    }
                    l = -1L;
                }
                while (l2 != -1L && l2 < this._cal.getTimeInMillis()) {
                    if (++n5 < this._coloredDates.length) {
                        l2 = this._coloredDates[n5];
                        continue;
                    }
                    l2 = -1L;
                }
                boolean bl3 = l != -1L && this._cal.getTimeInMillis() == l;
                boolean bl4 = l2 != -1L && this._cal.getTimeInMillis() == l2;
                this.drawDay(bl4, bl3, bl, graphics, string, this._ltr ? this._bounds.x + this._boxPaddingX + this._boxWidth - fontMetrics.stringWidth(string) : this._bounds.x + this._boxPaddingX + this._boxWidth - fontMetrics.stringWidth(string) - 1, this._bounds.y + this._boxPaddingY + fontMetrics.getAscent());
                if (this.isSelectedDate(this._cal.getTimeInMillis())) {
                    if (this._selectionMode == 1) {
                        this._dirtyRect.x = this._bounds.x;
                        this._dirtyRect.y = this._bounds.y;
                        this._dirtyRect.width = this._bounds.width;
                        this._dirtyRect.height = this._bounds.height;
                    }
                    this.paintSelectedDayBackground(graphics, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                    graphics.setColor(this.getForeground());
                }
            }
            this._cal.add(5, 1);
        }
    }

    private void drawDay(boolean bl, boolean bl2, boolean bl3, Graphics graphics, String string, int n, int n2) {
        Color color = graphics.getColor();
        Font font = this.getFont();
        if (bl) {
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.fillRect(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
            graphics.setColor(color);
        }
        if (bl3) {
            graphics.setColor(Color.BLUE);
        }
        if (bl2) {
            graphics.setColor(Color.RED);
            graphics.setFont(this._derivedFont);
        }
        graphics.drawString(string, n, n2);
        graphics.setColor(color);
        graphics.setFont(font);
    }

    protected void paintMonthStringBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        n = this._ltr ? n + this._monthStringInsets.left : n + this._monthStringInsets.left;
        n3 = n3 - this._monthStringInsets.left - this._monthStringInsets.right;
        n4 = n4 - this._monthStringInsets.top - this._monthStringInsets.bottom;
        graphics.setColor(this._monthStringBackground);
        graphics.fillRect(n, n2 += this._monthStringInsets.top, n3, n4);
    }

    protected void paintTodayBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this._todayBackgroundColor);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
    }

    protected void paintSelectedDayBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this._todayBackgroundColor);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
    }

    private boolean isSelectedDate(long l) {
        GregorianCalendar gregorianCalendar = JXXMonthView.calendarInstance();
        gregorianCalendar.setTimeInMillis(l);
        int n = gregorianCalendar.get(7) - 1;
        if (this._selectedWeekDays[n]) {
            return true;
        }
        return this.intervals.containsDate(l);
    }

    private void calculateNumDisplayedCals() {
        int n = this._numCalCols;
        int n2 = this._numCalRows;
        this._numCalCols = 1;
        this._numCalCols += (this.getWidth() - this._calendarWidth) / (this._calendarWidth + 10);
        this._numCalRows = 1;
        this._numCalRows += (this.getHeight() - this._calendarHeight) / (this._calendarHeight + 10);
        if (n != this._numCalCols || n2 != this._numCalRows) {
            this.calculateLastDisplayedDate();
        }
    }

    private void calculateStartPosition() {
        this._startX = (this.getWidth() - (this._calendarWidth * this._numCalCols + 10 * (this._numCalCols - 1))) / 2;
        if (!this._ltr) {
            this._startX = this.getWidth() - this._startX;
        }
        this._startY = (this.getHeight() - (this._calendarHeight * this._numCalRows + 10 * (this._numCalRows - 1))) / 2;
    }

    private void calculateBoundsForDay(Rectangle rectangle, Calendar calendar, boolean bl) {
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(7);
        int n4 = calendar.get(4);
        int n5 = n2 - this._firstDisplayedMonth + (n - this._firstDisplayedYear) * 12;
        int n6 = n5 / this._numCalCols;
        int n7 = n5 - n6 * this._numCalCols;
        rectangle.x = n3 - this._firstDayOfWeek;
        if (rectangle.x < 0) {
            rectangle.x += 7;
        }
        rectangle.x = this._ltr ? rectangle.x * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) : (rectangle.x + 1) * (this._boxPaddingX + this._boxWidth + this._boxPaddingX);
        rectangle.x += n7 * (this._calendarWidth + 10);
        int n8 = rectangle.x = this._ltr ? this._startX + rectangle.x : this._startX - rectangle.x;
        if (bl) {
            n4 = 0;
        }
        rectangle.y = 2 * (this._boxPaddingY + this._boxHeight + this._boxPaddingY);
        rectangle.y += this._startY + n6 * (this._calendarHeight + 10);
        rectangle.y += (n4 - 1) * (this._boxPaddingY + this._boxHeight + this._boxPaddingY);
        rectangle.width = this._boxPaddingX + this._boxWidth + this._boxPaddingX;
        rectangle.height = this._boxPaddingY + this._boxHeight + this._boxPaddingY;
    }

    public long getDayAt(int n, int n2) {
        int n3;
        if (this._ltr ? this._startX > n : this._startX < n || this._startY > n2) {
            return -1L;
        }
        int n4 = (this._ltr ? n - this._startX : this._startX - n) / (this._calendarWidth + 10);
        int n5 = (n2 - this._startY) / (this._calendarHeight + 10);
        if (n5 > this._numCalRows - 1 || n4 > this._numCalCols - 1) {
            return -1L;
        }
        int n6 = (n2 - this._startY - n5 * (this._calendarHeight + 10)) / (this._boxPaddingY + this._boxHeight + this._boxPaddingY);
        if ((n6 -= 2) < -1 || n6 > 5) {
            return -1L;
        }
        int n7 = ((this._ltr ? n - this._startX : this._startX - n) - n4 * (this._calendarWidth + 10)) / (this._boxPaddingX + this._boxWidth + this._boxPaddingX);
        if (n7 > 6) {
            return -1L;
        }
        if (n6 == -1) {
            return WEEKDAY_OFFSET - (long)n7;
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this._cal.add(2, n4 + n5 * this._numCalCols);
        int n8 = this._cal.get(7);
        int n9 = n8 - this._firstDayOfWeek;
        if (n9 < 0) {
            n9 += 7;
        }
        if ((n3 = n6 * 7 + (n7 - n9)) < 0 || n3 > this._cal.getActualMaximum(5) - 1) {
            return -1L;
        }
        this._cal.add(5, n3);
        long l = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        return l;
    }

    private void calculateDirtyRectForSelection() {
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            this.calculateDirtyRectForSelection((DateSpan)iterator.next());
        }
    }

    private boolean isWeekDay(long l) {
        return l < WEEKDAY_OFFSET;
    }

    private void calculateDirtyRectForSelection(DateSpan dateSpan) {
        long l = dateSpan.getStart();
        long l2 = dateSpan.getEnd();
        if (this.isWeekDay(l)) {
            // empty if block
        }
        if (l == -1L || l == -1L) {
            this._dirtyRect.x = 0;
            this._dirtyRect.y = 0;
            this._dirtyRect.width = 0;
            this._dirtyRect.height = 0;
        } else {
            this._cal.setTimeInMillis(l);
            this.calculateBoundsForDay(this._dirtyRect, this._cal, false);
            this._cal.add(5, 1);
            while (this._cal.getTimeInMillis() <= l2) {
                this.calculateBoundsForDay(this._bounds, this._cal, false);
                Rectangle rectangle = this._dirtyRect.union(this._bounds);
                this._dirtyRect.x = rectangle.x;
                this._dirtyRect.y = rectangle.y;
                this._dirtyRect.width = rectangle.width;
                this._dirtyRect.height = rectangle.height;
                this._cal.add(5, 1);
            }
            this._cal.setTimeInMillis(this._firstDisplayedDate);
        }
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public void setActionCommand(String string) {
        this._actionCommand = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed() {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, this._actionCommand);
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    public void clearSelection() {
        this._pivotDate = -1L;
        this.intervals.clear();
        for (int i = 0; i < 7; ++i) {
            this._selectedWeekDays[i] = false;
        }
        this.repaint();
    }

    protected void select(DateSpan dateSpan) {
        this.repaint(this._dirtyRect);
        this.intervals.add(dateSpan);
        this.intervals.eliminateWeekdayDuplicates(this._selectedWeekDays);
        this.calculateDirtyRectForSelection(dateSpan);
        this.repaint(this._dirtyRect);
        this.firePropertyChange("selectedDates", null, this.intervals);
    }

    protected void selectWeekDay(int n) {
        this.repaint(this._dirtyRect);
        this._selectedWeekDays[n] = true;
        this.intervals.eliminateWeekdayDuplicates(this._selectedWeekDays);
        this.repaint();
        this.firePropertyChange("selectedDates", null, this.intervals);
    }

    protected void selectFromEvent(MouseEvent mouseEvent) {
        int n;
        boolean bl = (mouseEvent.getModifiersEx() & 0x40) == 64;
        boolean bl2 = (mouseEvent.getModifiersEx() & 0x80) == 128;
        int n2 = mouseEvent.getX();
        long l = this.getDayAt(n2, n = mouseEvent.getY());
        if (l == -1L) {
            return;
        }
        if (!bl2 && !bl) {
            this.clearSelection();
        }
        if (l <= WEEKDAY_OFFSET) {
            int n3 = (int)(-l + WEEKDAY_OFFSET);
            this.selectWeekDay(n3);
            this._asKirkWouldSay_FIRE = true;
            return;
        }
        DateSpan dateSpan = this._pivotDate == -1L || !bl ? new DateSpan(l, l) : new DateSpan(Math.min(this._pivotDate, l), Math.max(this._pivotDate, l));
        this.select(dateSpan);
        this._pivotDate = l;
        this._asKirkWouldSay_FIRE = true;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.selectFromEvent(mouseEvent);
        } else if (mouseEvent.getID() == 502) {
            if (this._asKirkWouldSay_FIRE) {
                this.fireActionPerformed();
            }
            this._asKirkWouldSay_FIRE = false;
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            this.selectFromEvent(mouseEvent);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public static GregorianCalendar calendarInstance() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(DateUtils.UTC_TIME_ZONE);
        return gregorianCalendar;
    }

    public static SimpleDateFormat dateFormatInstance(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(DateUtils.UTC_TIME_ZONE);
        return simpleDateFormat;
    }

    public static boolean isChinese() {
        Locale locale = Locale.getDefault();
        return locale.equals(Locale.SIMPLIFIED_CHINESE) || locale.equals(Locale.TRADITIONAL_CHINESE);
    }

    static {
        WEEKDAY_OFFSET = -100L;
    }
}

