/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRBaseElementGroup
implements Serializable,
JRElementGroup {
    private static final long serialVersionUID = 10001L;
    protected List children = new ArrayList();
    protected JRElementGroup elementGroup = null;

    protected JRBaseElementGroup() {
    }

    protected JRBaseElementGroup(JRElementGroup elementGrp, JRBaseObjectFactory factory) {
        factory.put(elementGrp, this);
        List list = elementGrp.getChildren();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                JRChild child = (JRChild)list.get(i);
                child = child.getCopy(factory);
                this.children.add(child);
            }
        }
        this.elementGroup = factory.getElementGroup(elementGrp.getElementGroup());
    }

    public List getChildren() {
        return this.children;
    }

    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    public JRElement[] getElements() {
        JRElement[] elements = null;
        if (this.children != null) {
            ArrayList<JRElement> allElements = new ArrayList<JRElement>();
            Object child = null;
            JRElement[] childElementArray = null;
            for (int i = 0; i < this.children.size(); ++i) {
                child = this.children.get(i);
                if (child instanceof JRElement) {
                    allElements.add((JRElement)child);
                    continue;
                }
                if (!(child instanceof JRElementGroup) || (childElementArray = ((JRElementGroup)child).getElements()) == null) continue;
                allElements.addAll(Arrays.asList(childElementArray));
            }
            elements = new JRElement[allElements.size()];
            allElements.toArray(elements);
        }
        return elements;
    }

    public JRElement getElementByKey(String key) {
        JRElement[] elements;
        JRElement element = null;
        if (key != null && (elements = this.getElements()) != null) {
            for (int i = 0; element == null && i < elements.length; ++i) {
                if (!key.equals(elements[i].getKey())) continue;
                element = elements[i];
            }
        }
        return element;
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getElementGroup(this);
    }

    public void writeXml(JRXmlWriter xmlWriter) {
        xmlWriter.writeElementGroup(this);
    }
}

