/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.views;

import com.projity.configuration.Dictionary;
import com.projity.graphic.configuration.BarStyles;
import com.projity.grouping.core.model.NodeModel;
import com.projity.help.HelpUtil;
import com.projity.menu.MenuManager;
import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projity.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projity.pm.graphic.pert.Pert;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.views.BaseView;
import com.projity.pm.task.Project;
import com.projity.undo.UndoController;
import com.projity.workspace.WorkspaceSetting;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class PertView
extends JScrollPane
implements BaseView {
    private static final long serialVersionUID = 1493530627188782732L;
    protected Pert pert;
    protected NodeModel model;
    protected Project project;
    DocumentFrame documentFrame;
    protected NodeModelCache cache;

    public PertView(DocumentFrame documentFrame, MenuManager menuManager) {
        HelpUtil.addDocHelp(this, "Network_Diagram");
        this.documentFrame = documentFrame;
        this.project = documentFrame.getProject();
    }

    public void init(ReferenceNodeModelCache referenceNodeModelCache, NodeModel nodeModel) {
        this.pert = new Pert(this.project, "Network");
        this.cache = NodeModelCacheFactory.getInstance().createAntiAssignmentFilteredCache(referenceNodeModelCache, this.getViewName(), null);
        this.pert.setCache(this.cache);
        this.pert.setBarStyles((BarStyles)Dictionary.get("BarStylesCategory", "pert"));
        JViewport jViewport = this.createViewport();
        jViewport.setView(this.pert);
        this.setViewport(jViewport);
        if (this.project.isReadOnly()) {
            this.pert.setEnabled(false);
        }
        referenceNodeModelCache.update();
    }

    public void cleanUp() {
        this.pert.cleanUp();
        this.pert = null;
        this.model = null;
        this.project = null;
        this.documentFrame = null;
    }

    public UndoController getUndoController() {
        return this.project.getUndoController();
    }

    public void zoomIn() {
        this.pert.zoomIn();
    }

    public void zoomOut() {
        this.pert.zoomOut();
    }

    public boolean canZoomIn() {
        return this.pert.canZoomIn();
    }

    public boolean canZoomOut() {
        return this.pert.canZoomOut();
    }

    public int getScale() {
        return this.pert.getZoom();
    }

    public SpreadSheet getSpreadSheet() {
        return null;
    }

    public boolean hasNormalMinWidth() {
        return true;
    }

    public String getViewName() {
        return "Network";
    }

    public boolean showsTasks() {
        return true;
    }

    public boolean showsResources() {
        return false;
    }

    public void onActivate(boolean bl) {
    }

    public boolean isPrintable() {
        return true;
    }

    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.pert.restoreWorkspace(workspace.network, n);
    }

    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.network = this.pert.createWorkspace(n);
        return workspace;
    }

    public boolean canScrollToTask() {
        return false;
    }

    public void scrollToTask() {
    }

    public NodeModelCache getCache() {
        return this.cache;
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = 3364215160357571230L;
        WorkspaceSetting network;

        public WorkspaceSetting getNetwork() {
            return this.network;
        }

        public void setNetwork(WorkspaceSetting workspaceSetting) {
            this.network = workspaceSetting;
        }
    }
}

