/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ProcEntry;
import net.sourceforge.jtds.jdbc.SavepointImpl;

public class ConnectionJDBC3
extends ConnectionJDBC2 {
    private ArrayList savepoints;
    private Map savepointProcInTran;
    private int savepointId;

    ConnectionJDBC3(String url, Properties props) throws SQLException {
        super(url, props);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setSavepoint(SavepointImpl savepoint) throws SQLException {
        block5: {
            Statement statement = null;
            try {
                statement = this.createStatement();
                statement.execute("IF @@TRANCOUNT=0 BEGIN TRAN SAVE TRAN jtds" + savepoint.getId());
                Object var4_3 = null;
                if (statement == null) break block5;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            statement.close();
        }
        ConnectionJDBC3 connectionJDBC3 = this;
        synchronized (connectionJDBC3) {
            if (this.savepoints == null) {
                this.savepoints = new ArrayList();
            }
            this.savepoints.add(savepoint);
            return;
        }
    }

    synchronized void clearSavepoints() {
        if (this.savepoints != null) {
            this.savepoints.clear();
        }
        if (this.savepointProcInTran != null) {
            this.savepointProcInTran.clear();
        }
        this.savepointId = 0;
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        if (this.savepoints == null) {
            throw new SQLException(Messages.get("error.connection.badsavep"), "25000");
        }
        int index = this.savepoints.indexOf(savepoint);
        if (index == -1) {
            throw new SQLException(Messages.get("error.connection.badsavep"), "25000");
        }
        Object tmpSavepoint = this.savepoints.remove(index);
        if (this.savepointProcInTran != null) {
            List keys;
            if (index != 0 && (keys = (List)this.savepointProcInTran.get(savepoint)) != null) {
                Savepoint wrapping = (Savepoint)this.savepoints.get(index - 1);
                ArrayList wrappingKeys = (ArrayList)this.savepointProcInTran.get(wrapping);
                if (wrappingKeys == null) {
                    wrappingKeys = new ArrayList();
                }
                wrappingKeys.addAll(keys);
                this.savepointProcInTran.put(wrapping, wrappingKeys);
            }
            this.savepointProcInTran.remove(tmpSavepoint);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        int index;
        block10: {
            this.checkOpen();
            this.checkLocal("rollback");
            if (this.savepoints == null) {
                throw new SQLException(Messages.get("error.connection.badsavep"), "25000");
            }
            index = this.savepoints.indexOf(savepoint);
            if (index == -1) {
                throw new SQLException(Messages.get("error.connection.badsavep"), "25000");
            }
            if (this.getAutoCommit()) {
                throw new SQLException(Messages.get("error.connection.savenorollback"), "25000");
            }
            Statement statement = null;
            try {
                statement = this.createStatement();
                statement.execute("ROLLBACK TRAN jtds" + ((SavepointImpl)savepoint).getId());
                Object var5_4 = null;
                if (statement == null) break block10;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
            statement.close();
        }
        int size = this.savepoints.size();
        int i = size - 1;
        while (i >= index) {
            List keys;
            Object tmpSavepoint = this.savepoints.remove(i);
            if (this.savepointProcInTran != null && (keys = (List)this.savepointProcInTran.get(tmpSavepoint)) != null) {
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    this.removeCachedProcedure(key);
                }
            }
            --i;
        }
        return;
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        this.checkLocal("setSavepoint");
        if (this.getAutoCommit()) {
            throw new SQLException(Messages.get("error.connection.savenoset"), "25000");
        }
        SavepointImpl savepoint = new SavepointImpl(this.getNextSavepointId());
        this.setSavepoint(savepoint);
        return savepoint;
    }

    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        this.checkOpen();
        this.checkLocal("setSavepoint");
        if (this.getAutoCommit()) {
            throw new SQLException(Messages.get("error.connection.savenoset"), "25000");
        }
        if (name == null) {
            throw new SQLException(Messages.get("error.connection.savenullname", "savepoint"), "25000");
        }
        SavepointImpl savepoint = new SavepointImpl(this.getNextSavepointId(), name);
        this.setSavepoint(savepoint);
        return savepoint;
    }

    private int getNextSavepointId() {
        return ++this.savepointId;
    }

    void addCachedProcedure(String key, ProcEntry proc) {
        super.addCachedProcedure(key, proc);
        if (this.getServerType() == 1 && proc.getType() == 1) {
            this.addCachedProcedure(key);
        }
    }

    synchronized void addCachedProcedure(String key) {
        Object savepoint;
        ArrayList<String> keys;
        if (this.savepoints == null || this.savepoints.size() == 0) {
            return;
        }
        if (this.savepointProcInTran == null) {
            this.savepointProcInTran = new HashMap();
        }
        if ((keys = (ArrayList<String>)this.savepointProcInTran.get(savepoint = this.savepoints.get(this.savepoints.size() - 1))) == null) {
            keys = new ArrayList<String>();
        }
        keys.add(key);
        this.savepointProcInTran.put(savepoint, keys);
    }
}

