/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.callgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmCondition;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.CallModel;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.navigation.callgraph.CallImpl;
import org.netbeans.modules.cnd.navigation.callgraph.FunctionImpl;

public class CallModelImpl
implements CallModel {
    private CsmReferenceRepository repository = CsmReferenceRepository.getDefault();
    private CsmFileReferences references = CsmFileReferences.getDefault();
    private CsmProject project;
    private String name;
    private FunctionUIN uin;

    public CallModelImpl(CsmProject project, CsmFunction root) {
        this.project = project;
        this.uin = new FunctionUIN(project, root);
        this.name = ((Object)root.getName()).toString();
    }

    public Function getRoot() {
        CsmFunction root = this.uin.getFunction();
        if (root != null) {
            return new FunctionImpl(root);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setRoot(Function newRoot) {
        FunctionImpl impl;
        CsmFunction f;
        if (newRoot instanceof FunctionImpl && (f = (impl = (FunctionImpl)newRoot).getDefinition()) != null) {
            this.uin = new FunctionUIN(this.project, f);
            this.name = ((Object)f.getName()).toString();
        }
    }

    public List<Call> getCallers(Function declaration, boolean showOverriding) {
        FunctionImpl functionImpl = (FunctionImpl)declaration;
        CsmFunction owner = functionImpl.getDeclaration();
        ArrayList<CsmFunction> functions = new ArrayList<CsmFunction>();
        functions.add(owner);
        if (showOverriding && CsmKindUtilities.isMethodDeclaration((CsmObject)owner)) {
            Collection overrides = CsmVirtualInfoQuery.getDefault().getAllBaseDeclarations((CsmMethod)owner);
            functions.addAll(overrides);
        }
        EnumSet<CsmReferenceKind> kinds = EnumSet.of(CsmReferenceKind.DIRECT_USAGE, CsmReferenceKind.AFTER_DEREFERENCE_USAGE, CsmReferenceKind.UNKNOWN);
        ArrayList<Call> res = new ArrayList<Call>();
        HashMap<CsmFunction, CsmReference> set = new HashMap<CsmFunction, CsmReference>();
        for (CsmFunction csmFunction : functions) {
            if (!CsmKindUtilities.isFunction((CsmObject)csmFunction) || !csmFunction.getContainingFile().isValid()) continue;
            for (CsmReference r : this.repository.getReferences((CsmObject)csmFunction, this.project, CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE, null)) {
                CsmFunction o;
                if (r == null || !CsmReferenceResolver.getDefault().isKindOf(r, kinds) || (o = this.getFunctionDeclaration(this.getOwner(r))) == null || set.containsKey(o)) continue;
                set.put(o, r);
            }
        }
        for (Map.Entry entry : set.entrySet()) {
            res.add(new CallImpl((CsmFunction)entry.getKey(), (CsmReference)entry.getValue(), this.getFunctionDeclaration(owner), true));
        }
        return res;
    }

    public List<Call> getCallees(Function definition, boolean showOverriding) {
        FunctionImpl definitionImpl = (FunctionImpl)definition;
        CsmFunction owner = definitionImpl.getDefinition();
        ArrayList<CsmFunction> functions = new ArrayList<CsmFunction>();
        functions.add(owner);
        if (showOverriding && CsmKindUtilities.isMethodDeclaration((CsmObject)owner)) {
            Collection overrides = CsmVirtualInfoQuery.getDefault().getOverriddenMethods((CsmMethod)owner, false);
            functions.addAll(overrides);
        }
        ArrayList<Call> res = new ArrayList<Call>();
        final HashMap set = new HashMap();
        for (CsmFunction csmFunction : functions) {
            if (!CsmKindUtilities.isFunctionDefinition((CsmObject)csmFunction) || !csmFunction.getContainingFile().isValid()) continue;
            final List list = CsmFileInfoQuery.getDefault().getUnusedCodeBlocks(csmFunction.getContainingFile());
            this.references.accept((CsmScope)csmFunction, new CsmFileReferences.Visitor(){

                public void visit(CsmReferenceContext context) {
                    CsmReference r = context.getReference();
                    if (r == null) {
                        return;
                    }
                    for (CsmOffsetable offset : list) {
                        if (offset.getStartOffset() > r.getStartOffset() || offset.getEndOffset() < r.getEndOffset()) continue;
                        return;
                    }
                    try {
                        CsmObject o = r.getReferencedObject();
                        if (CsmKindUtilities.isFunction((CsmObject)o) && !CsmKindUtilities.isFunction((CsmObject)r.getOwner()) && !set.containsKey((CsmFunction)(o = CallModelImpl.this.getFunctionDeclaration((CsmFunction)o)))) {
                            set.put((CsmFunction)o, r);
                        }
                    }
                    catch (AssertionError e) {
                        ((Throwable)((Object)e)).printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE);
        }
        for (Map.Entry entry : set.entrySet()) {
            res.add(new CallImpl(this.getFunctionDeclaration(owner), (CsmReference)entry.getValue(), (CsmFunction)entry.getKey(), false));
        }
        return res;
    }

    private CsmFunction getFunctionDeclaration(CsmFunction definition) {
        if (definition != null && CsmKindUtilities.isFunctionDefinition((CsmObject)definition)) {
            return ((CsmFunctionDefinition)definition).getDeclaration();
        }
        return definition;
    }

    private CsmFunction getOwner(CsmReference ref) {
        CsmObject o = ref.getOwner();
        if (CsmKindUtilities.isExpression((CsmObject)o)) {
            o = ((CsmExpression)o).getScope();
        } else if (o instanceof CsmCondition) {
            o = ((CsmCondition)o).getScope();
        } else {
            CsmVariable var;
            if (CsmKindUtilities.isFunction((CsmObject)o)) {
                return (CsmFunction)o;
            }
            if (CsmKindUtilities.isVariable((CsmObject)o) && CsmKindUtilities.isFunction((CsmObject)(o = (var = (CsmVariable)o).getScope()))) {
                return (CsmFunction)o;
            }
        }
        if (CsmKindUtilities.isStatement((CsmObject)o)) {
            CsmScope scope = ((CsmStatement)o).getScope();
            while (scope != null) {
                if (CsmKindUtilities.isFunction((CsmObject)scope)) {
                    return (CsmFunction)scope;
                }
                if (CsmKindUtilities.isStatement((CsmObject)scope)) {
                    scope = ((CsmStatement)scope).getScope();
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    private static class FunctionUIN {
        private CsmProject project;
        private CharSequence functionUin;
        private CsmUID<CsmFile> fileUid;

        private FunctionUIN(CsmProject project, CsmFunction root) {
            this.project = project;
            this.functionUin = root.getUniqueName();
            this.fileUid = UIDs.get((Object)root.getContainingFile());
        }

        private CsmFunction getFunction() {
            if (!this.project.isValid()) {
                return null;
            }
            CsmFunction root = (CsmFunction)this.project.findDeclaration(this.functionUin);
            if (root != null) {
                return root;
            }
            CsmFile file = (CsmFile)this.fileUid.getObject();
            if (!file.isValid()) {
                return null;
            }
            for (CsmOffsetableDeclaration d : file.getDeclarations()) {
                root = this.findFunction((CsmDeclaration)d);
                if (root == null) continue;
                return root;
            }
            return null;
        }

        private CsmFunction findFunction(CsmDeclaration element) {
            if (CsmKindUtilities.isTypedef((CsmObject)element)) {
                CsmClassifier cls;
                CsmTypedef def = (CsmTypedef)element;
                if (def.isTypeUnnamed() && (cls = def.getType().getClassifier()) != null && cls.getName().length() == 0 && cls instanceof CsmCompoundClassifier) {
                    return this.findFunction((CsmDeclaration)((CsmCompoundClassifier)cls));
                }
                return null;
            }
            if (CsmKindUtilities.isClassifier((CsmObject)element)) {
                Collection list;
                String name = ((Object)((CsmClassifier)element).getName()).toString();
                if (name.length() == 0 && element instanceof CsmCompoundClassifier && (list = ((CsmCompoundClassifier)element).getEnclosingTypedefs()).size() > 0) {
                    return null;
                }
                if (CsmKindUtilities.isClass((CsmObject)element)) {
                    CsmFunction res;
                    CsmClass cls = (CsmClass)element;
                    for (CsmMember m : cls.getMembers()) {
                        res = this.findFunction((CsmDeclaration)m);
                        if (res == null) continue;
                        return res;
                    }
                    for (CsmMember m : cls.getFriends()) {
                        res = this.findFunction((CsmDeclaration)m);
                        if (res == null) continue;
                        return res;
                    }
                }
                return null;
            }
            if (CsmKindUtilities.isNamespaceDefinition((CsmObject)element)) {
                for (CsmOffsetableDeclaration d : ((CsmNamespaceDefinition)element).getDeclarations()) {
                    CsmFunction res = this.findFunction((CsmDeclaration)d);
                    if (res == null) continue;
                    return res;
                }
            } else if (CsmKindUtilities.isFunction((CsmObject)element) && element.getUniqueName().equals(this.functionUin)) {
                return (CsmFunction)element;
            }
            return null;
        }
    }
}

