/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.export;

import java.io.File;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.export.Export;
import org.netbeans.modules.subversion.util.CheckoutCompleted;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class ExportAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Export";
    }

    @Override
    protected int getFileEnabledStatus() {
        return -4;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return nodes != null && nodes.length == 1 && this.getCachedContext(nodes).getRoots().size() > 0;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = this.getContext(nodes);
        File[] roots = SvnUtils.getActionRoots(ctx);
        if (roots == null || roots.length != 1) {
            return;
        }
        File[] files = Subversion.getInstance().getStatusCache().listFiles(ctx, 22996);
        File fromFile = roots[0];
        RequestProcessor rp = this.createRequestProcessor(nodes);
        boolean hasChanges = files.length > 0;
        Export export = new Export(fromFile, hasChanges);
        if (export.showDialog()) {
            this.performExport(export, rp, nodes, roots);
        }
    }

    private void performExport(final Export export, final RequestProcessor rp, final Node[] nodes, File[] roots) {
        rp.post(new Runnable(){

            @Override
            public void run() {
                ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(ExportAction.this, nodes){

                    @Override
                    public void perform() {
                        File fromFile = export.getFromFile();
                        File toFile = export.getToFile();
                        toFile.mkdir();
                        if (this.isCanceled()) {
                            return;
                        }
                        try {
                            SvnClient client = Subversion.getInstance().getClient(fromFile);
                            client.doExport(fromFile, toFile, true);
                        }
                        catch (SVNClientException ex) {
                            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                            return;
                        }
                        if (export.getScanAfterExport()) {
                            CheckoutCompleted cc = new CheckoutCompleted(toFile, new String[]{"."});
                            if (this.isCanceled()) {
                                return;
                            }
                            cc.scanForProjects(this, CheckoutCompleted.Type.EXPORT);
                        }
                    }
                };
                support.start(rp);
            }
        });
    }
}

