/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.bindings.ruby;

import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.spellchecker.bindings.ruby.Pair;
import org.netbeans.modules.spellchecker.spi.language.TokenList;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRubyTokenList
implements TokenList {
    protected BaseDocument doc;
    private int currentBlockStart;
    private int nextBlockStart;
    private String currentBlockText;
    private int currentOffsetInComment;
    private int currentWordOffset;
    private CharSequence currentWord;
    private int startOffset;

    AbstractRubyTokenList(BaseDocument doc) {
        this.doc = doc;
    }

    public void setStartOffset(int offset) {
        this.currentBlockText = null;
        this.currentOffsetInComment = -1;
        this.startOffset = this.nextBlockStart = offset;
    }

    public int getCurrentWordStartOffset() {
        return this.currentWordOffset;
    }

    public CharSequence getCurrentWordText() {
        return this.currentWord;
    }

    public boolean nextWord() {
        boolean hasNext = this.nextWordImpl();
        while (hasNext && this.currentWordOffset + this.currentWord.length() < this.startOffset) {
            hasNext = this.nextWordImpl();
        }
        return hasNext;
    }

    private int[] findNextSpellSpan() throws BadLocationException {
        TokenHierarchy h = TokenHierarchy.get((Document)this.doc);
        TokenSequence ts = h.tokenSequence();
        return this.findNextSpellSpan((TokenSequence<? extends TokenId>)ts, this.nextBlockStart);
    }

    protected abstract int[] findNextSpellSpan(TokenSequence<? extends TokenId> var1, int var2) throws BadLocationException;

    private boolean nextWordImpl() {
        try {
            while (true) {
                if (this.currentBlockText == null) {
                    int[] span = this.findNextSpellSpan();
                    if (span[0] == -1) {
                        return false;
                    }
                    this.currentBlockStart = span[0];
                    this.currentBlockText = this.doc.getText(span[0], span[1] - span[0]);
                    this.currentOffsetInComment = 0;
                    this.nextBlockStart = span[1];
                }
                String pairTag = null;
                Pair<CharSequence, Integer> data = AbstractRubyTokenList.wordBroker(this.currentBlockText, this.currentOffsetInComment, false);
                while (data != null) {
                    this.currentOffsetInComment = (Integer)data.b + ((CharSequence)data.a).length();
                    if (pairTag == null) {
                        if (Character.isLetter(((CharSequence)data.a).charAt(0)) && !AbstractRubyTokenList.isIdentifierLike((CharSequence)data.a)) {
                            this.currentWordOffset = this.currentBlockStart + (Integer)data.b;
                            this.currentWord = (CharSequence)data.a;
                            return true;
                        }
                        switch (((CharSequence)data.a).charAt(0)) {
                            case '<': {
                                if (AbstractRubyTokenList.startsWith((CharSequence)data.a, "<a ")) {
                                    pairTag = "</a>";
                                }
                                if (AbstractRubyTokenList.startsWith((CharSequence)data.a, "<code>")) {
                                    pairTag = "</code>";
                                }
                                if (!AbstractRubyTokenList.startsWith((CharSequence)data.a, "<pre>")) break;
                                pairTag = "</pre>";
                                break;
                            }
                            case '{': {
                                pairTag = "}";
                            }
                        }
                    } else if (pairTag.contentEquals((CharSequence)data.a)) {
                        pairTag = null;
                    }
                    data = AbstractRubyTokenList.wordBroker(this.currentBlockText, this.currentOffsetInComment, false);
                }
                this.currentBlockText = null;
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return false;
        }
    }

    static boolean startsWith(CharSequence where, String withWhat) {
        if (where.length() >= withWhat.length()) {
            return withWhat.contentEquals(where.subSequence(0, withWhat.length()));
        }
        return false;
    }

    static boolean isIdentifierLike(CharSequence s) {
        boolean hasCapitalsInside = false;
        boolean hasUnderlinesInside = false;
        for (int offset = 1; offset < s.length() && !hasCapitalsInside; ++offset) {
            char c = s.charAt(offset);
            if (c == '_') {
                hasUnderlinesInside = true;
                continue;
            }
            hasCapitalsInside |= Character.isUpperCase(s.charAt(offset));
        }
        return hasCapitalsInside || hasUnderlinesInside;
    }

    static boolean isLetter(char c) {
        return Character.isLetter(c) || c == '\'' || c == '_';
    }

    static Pair<CharSequence, Integer> wordBroker(CharSequence start, int offset, boolean treatSpecialCharactersAsLetterInsideWords) {
        int state = 0;
        int offsetStart = offset;
        while (start.length() > offset) {
            char current = start.charAt(offset);
            switch (state) {
                case 0: {
                    if (current == ':') {
                        state = 5;
                        offsetStart = offset;
                        break;
                    }
                    if (AbstractRubyTokenList.isLetter(current)) {
                        state = 1;
                        offsetStart = offset;
                        break;
                    }
                    if (current == '@' || current == '#') {
                        state = 2;
                        offsetStart = offset;
                        break;
                    }
                    if (current == '<') {
                        state = 3;
                        offsetStart = offset;
                        break;
                    }
                    if (current == '\n' || current == '}') {
                        return new Pair<CharSequence, Integer>(start.subSequence(offset, offset + 1), offset);
                    }
                    if (current != '{') break;
                    state = 4;
                    offsetStart = offset;
                    break;
                }
                case 1: {
                    if (AbstractRubyTokenList.isLetter(current) || (current == '.' || current == '#') && treatSpecialCharactersAsLetterInsideWords) break;
                    return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset), offsetStart);
                }
                case 2: {
                    if (AbstractRubyTokenList.isLetter(current)) break;
                    return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset), offsetStart);
                }
                case 3: {
                    if (current != '>') break;
                    return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset + 1), offsetStart);
                }
                case 4: {
                    if (current == '@') {
                        state = 2;
                        break;
                    }
                    --offset;
                    state = 0;
                    break;
                }
                case 5: {
                    if (!Character.isWhitespace(current)) break;
                    state = 0;
                }
            }
            ++offset;
        }
        if (offset > offsetStart) {
            return new Pair<CharSequence, Integer>(start.subSequence(offsetStart, offset), offsetStart);
        }
        return null;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

