/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analyzer;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.java.hints.analyzer.Analyzer;
import org.netbeans.modules.java.hints.analyzer.OverridePreferences;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public final class AnalyzeFolder
extends AbstractAction
implements ContextAwareAction {
    private final boolean def;
    private final Lookup context;
    private static final Set<String> SUPPORTED_IDS = new HashSet<String>(Arrays.asList("create-javadoc", "error-in-javadoc"));

    public AnalyzeFolder() {
        this.context = Utilities.actionsGlobalContext();
        this.def = true;
        this.putValue("Name", NbBundle.getMessage(AnalyzeFolder.class, (String)"CTL_AnalyzeFolder"));
    }

    @Override
    public boolean isEnabled() {
        if (!this.def) {
            return super.isEnabled();
        }
        return Analyzer.normalizeLookup(this.context) != null;
    }

    public AnalyzeFolder(Lookup lookup) {
        this.context = lookup;
        this.def = false;
        this.setEnabled(Analyzer.normalizeLookup(lookup) != null);
        this.putValue("Name", NbBundle.getMessage(AnalyzeFolder.class, (String)"CTL_AnalyzeFolder"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        HashMap<String, Preferences> hashMap = new HashMap<String, Preferences>();
        for (HintMetadata hintMetadata : RulesManager.getInstance().allHints.keySet()) {
            String string = hintMetadata.id;
            if (hashMap.containsKey(string)) continue;
            Preferences preferences = RulesManager.getPreferences(string, HintsSettings.getCurrentProfileId());
            OverridePreferences overridePreferences = new OverridePreferences(preferences);
            hashMap.put(string, overridePreferences);
            HintsSettings.setEnabled(overridePreferences, SUPPORTED_IDS.contains(string));
            HintsSettings.setSeverity(overridePreferences, AbstractHint.HintSeverity.WARNING);
        }
        Analyzer.process(Analyzer.normalizeLookup(this.context), hashMap);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new AnalyzeFolder(lookup);
    }

    public static final class ToolsAction
    extends SystemAction
    implements ContextAwareAction {
        private Action delegate = new AnalyzeFolder();

        public ToolsAction() {
            this.putValue("noIconInMenu", Boolean.TRUE);
        }

        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.delegate.actionPerformed(actionEvent);
        }

        public Action createContextAwareInstance(Lookup lookup) {
            return new AnalyzeFolder(lookup);
        }

        public String getName() {
            return NbBundle.getMessage(AnalyzeFolder.class, (String)"CTL_AnalyzeFolder");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }
}

