/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.vmd.api.model.AccessController;
import org.netbeans.modules.vmd.api.model.AccessControllerFactoryRegistry;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.netbeans.modules.vmd.api.model.DynamicPresenter;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresenterEventManager;
import org.netbeans.modules.vmd.api.model.PresenterListener;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TransactionManager;
import org.netbeans.modules.vmd.api.model.common.ValidatorPresenter;
import org.openide.ErrorManager;

public final class ListenerManager {
    private static final boolean INVOKE_VALIDATORS = true;
    private volatile long eventID = 0L;
    private final DesignDocument document;
    private final WeakHashMap<DesignListener, DesignEventFilter> listeners = new WeakHashMap();
    private HashSet<DesignComponent> descriptorChangedComponents;
    private ArrayList<PresenterItem> presenterItems;
    private HashSet<DesignComponent> fullyComponents;
    private HashSet<DesignComponent> fullyHierarchies;
    private HashSet<DesignComponent> partlyComponents;
    private HashSet<DesignComponent> partlyHieararchies;
    private boolean selectionChanged;
    private HashMap<DesignComponent, HashMap<String, PropertyValue>> oldPropertyValues;
    private Set<DesignComponent> createdComponents;
    private List<AccessController> controllers;
    private PresenterEventManager presenterEventManager;

    public long getDocumentState() {
        return this.eventID;
    }

    ListenerManager(DesignDocument document) {
        this.document = document;
        this.clearCaches();
        this.controllers = AccessControllerFactoryRegistry.createAccessControllers(document);
        this.presenterEventManager = new PresenterEventManager();
    }

    private void clearCaches() {
        this.descriptorChangedComponents = new HashSet();
        this.presenterItems = new ArrayList(100);
        this.fullyComponents = new HashSet(100);
        this.fullyHierarchies = new HashSet(100);
        this.partlyComponents = new HashSet(100);
        this.partlyHieararchies = new HashSet(100);
        this.oldPropertyValues = new HashMap(100);
        this.createdComponents = new HashSet<DesignComponent>(100);
        this.selectionChanged = false;
    }

    public <T extends AccessController> T getAccessController(Class<T> controllerClass) {
        if (controllerClass != null) {
            for (AccessController controller : this.controllers) {
                if (!controllerClass.isInstance(controller)) continue;
                return (T)controller;
            }
        }
        return null;
    }

    public void addDesignListener(DesignListener listener, DesignEventFilter filter) {
        assert (listener != null && filter != null);
        this.listeners.put(listener, filter);
    }

    public void removeDesignListener(DesignListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    void addComponentDescriptorChanged(DesignComponent component, Collection<? extends Presenter> presentersToRemove, Collection<Presenter> presentersToAdd) {
        assert (Debug.isFriend(TransactionManager.class, "componentDescriptorChangeHappened"));
        this.descriptorChangedComponents.add(component);
        if (presentersToAdd != null) {
            for (Presenter presenter : presentersToAdd) {
                presenter.setNotifyAttached(component);
            }
        }
        this.presenterItems.add(new PresenterItem(component, presentersToRemove));
    }

    void addAffectedDesignComponent(DesignComponent component, String propertyName, PropertyValue oldPropertyValue) {
        assert (Debug.isFriend(TransactionManager.class, "writePropertyHappened"));
        this.fullyComponents.add(component);
        HashMap<String, PropertyValue> properties = this.oldPropertyValues.get(component);
        if (properties == null) {
            properties = new HashMap(100);
            this.oldPropertyValues.put(component, properties);
        }
        if (!properties.containsKey(propertyName)) {
            properties.put(propertyName, oldPropertyValue);
        }
    }

    void addAffectedComponentHierarchy(DesignComponent component) {
        assert (Debug.isFriend(TransactionManager.class, "rootChangeHappened") || Debug.isFriend(TransactionManager.class, "parentChangeHappened"));
        this.fullyHierarchies.add(component);
    }

    void notifyComponentCreated(DesignComponent component) {
        assert (Debug.isFriend(DesignDocument.class, "createRawComponent"));
        this.createdComponents.add(component);
    }

    void setSelectionChanged() {
        assert (Debug.isFriend(TransactionManager.class, "selectComponentsHappened"));
        this.selectionChanged = true;
    }

    long getEventID() {
        return this.eventID;
    }

    DesignEvent fireEvent() {
        DesignComponent component;
        assert (Debug.isFriend(TransactionManager.class, "writeAccessRootEnd"));
        if (!this.selectionChanged && this.descriptorChangedComponents.isEmpty() && this.fullyComponents.isEmpty() && this.fullyHierarchies.isEmpty()) {
            return null;
        }
        Iterator<DesignComponent> i$ = this.fullyComponents.iterator();
        while (i$.hasNext()) {
            for (component = i$.next(); component != null && this.partlyComponents.add(component); component = component.getParentComponent()) {
            }
        }
        i$ = this.fullyHierarchies.iterator();
        while (i$.hasNext()) {
            for (component = i$.next(); component != null && this.partlyHieararchies.add(component); component = component.getParentComponent()) {
            }
        }
        Set<DesignComponent> fullyComponentsUm = Collections.unmodifiableSet(this.fullyComponents);
        Set<DesignComponent> partlyComponentsUm = Collections.unmodifiableSet(this.partlyComponents);
        Set<DesignComponent> fullyHierarchiesUm = Collections.unmodifiableSet(this.fullyHierarchies);
        Set<DesignComponent> partlyHierarchiesUm = Collections.unmodifiableSet(this.partlyHieararchies);
        Set<DesignComponent> descriptorChangedComponentsUm = Collections.unmodifiableSet(this.descriptorChangedComponents);
        Set<DesignComponent> createdComponentsUm = Collections.unmodifiableSet(this.createdComponents);
        final DesignEvent event = new DesignEvent(++this.eventID, fullyComponentsUm, partlyComponentsUm, fullyHierarchiesUm, partlyHierarchiesUm, descriptorChangedComponentsUm, createdComponentsUm, this.oldPropertyValues, this.selectionChanged);
        this.fireEventInWriteAccess(event, new Runnable(){

            @Override
            public void run() {
                ListenerManager.this.fireEventCore(event);
            }
        });
        return event;
    }

    private void fireEventInWriteAccess(DesignEvent event, final Runnable runnable) {
        final boolean[] runStatus = new boolean[1];
        final int[] index = new int[1];
        final Runnable[] exec = new Runnable[1];
        runStatus[0] = false;
        index[0] = 0;
        exec[0] = new Runnable(){

            @Override
            public void run() {
                if (runStatus[0]) {
                    Debug.warning("AccessController.writeAccess must run the runnable no more than once", ListenerManager.this.controllers.get(index[0] - 1));
                    return;
                }
                if (index[0] >= ListenerManager.this.controllers.size()) {
                    runStatus[0] = true;
                    runnable.run();
                    return;
                }
                AccessController current = (AccessController)ListenerManager.this.controllers.get(index[0]);
                index[0] = index[0] + 1;
                try {
                    current.writeAccess(exec[0]);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    ErrorManager.getDefault().notify(th);
                }
                if (!runStatus[0]) {
                    Debug.warning("AccessController.writeAccess must run the runnable once", current);
                    index[0] = index[0] + 1;
                    this.run();
                }
            }
        };
        for (AccessController controller : this.controllers) {
            try {
                controller.notifyEventFiring(event);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                ErrorManager.getDefault().notify(th);
            }
        }
        exec[0].run();
        for (AccessController controller : this.controllers) {
            try {
                controller.notifyEventFired(event);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                ErrorManager.getDefault().notify(th);
            }
        }
    }

    private void fireEventCore(DesignEvent designEvent) {
        for (PresenterItem item : this.presenterItems) {
            DesignComponent component = item.component;
            if (item.presentersToRemove == null) continue;
            for (Presenter presenter : item.presentersToRemove) {
                try {
                    presenter.setNotifyDetached(component);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    ErrorManager.getDefault().notify(th);
                }
            }
        }
        Collection<DesignComponent> addedComponentsUm = Collections.unmodifiableCollection(this.createdComponents);
        for (AccessController controller : this.controllers) {
            try {
                controller.notifyComponentsCreated(addedComponentsUm);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                ErrorManager.getDefault().notify(th);
            }
        }
        ArrayList<DesignListener> affectedListeners = new ArrayList<DesignListener>();
        for (Map.Entry<DesignListener, DesignEventFilter> entry : this.listeners.entrySet()) {
            DesignEventFilter filter;
            DesignListener listener = entry.getKey();
            if (listener == null || !(filter = entry.getValue()).isAffected(this.document, designEvent)) continue;
            affectedListeners.add(listener);
        }
        boolean forcePresenterEventManagerUpdate = !this.presenterItems.isEmpty();
        this.clearCaches();
        ListenerManager.invokeValidators(designEvent);
        this.presenterEventManager.prepare(forcePresenterEventManagerUpdate);
        for (DesignListener designListener : affectedListeners) {
            try {
                designListener.designChanged(designEvent);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                ErrorManager.getDefault().notify(th);
            }
        }
        this.presenterEventManager.execute();
    }

    private static void invokeValidators(DesignEvent event) {
        HashSet<DesignComponent> validated = new HashSet<DesignComponent>();
        ListenerManager.invokeValidatorsCore(event.getPartlyAffectedComponents(), validated);
        ListenerManager.invokeValidatorsCore(event.getPartlyAffectedHierarchies(), validated);
        ListenerManager.invokeValidatorsCore(event.getDescriptorChangedComponents(), validated);
    }

    private static void invokeValidatorsCore(Set<DesignComponent> components, HashSet<DesignComponent> validated) {
        for (DesignComponent component : components) {
            if (validated.contains(component)) continue;
            ValidatorPresenter presenter = component.getPresenter(ValidatorPresenter.class);
            try {
                if (presenter != null) {
                    presenter.checkValidity();
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                // empty catch block
            }
            validated.add(component);
        }
    }

    public void addPresenterListener(DesignComponent component, Class<? extends Presenter> presenterClass, PresenterListener listener) {
        this.presenterEventManager.addPresenterListener(component, presenterClass, listener);
    }

    public void removePresenterListener(DesignComponent component, Class<? extends Presenter> presenterClass, PresenterListener listener) {
        this.presenterEventManager.removePresenterListener(component, presenterClass, listener);
    }

    void firePresenterChanged(DynamicPresenter presenter) {
        assert (Debug.isFriend(DynamicPresenter.class, "firePresenterChanged"));
        this.presenterEventManager.firePresenterChanged(presenter.getPresenterListener());
    }

    private static final class PresenterItem {
        private final DesignComponent component;
        private final Collection<? extends Presenter> presentersToRemove;

        PresenterItem(DesignComponent designComponent, Collection<? extends Presenter> presentersToRemove) {
            this.component = designComponent;
            this.presentersToRemove = presentersToRemove;
        }
    }
}

