/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.completion.util.CatalogModelProvider;
import org.netbeans.modules.xml.schema.completion.util.CompletionContextImpl;
import org.netbeans.modules.xml.schema.completion.util.CompletionModelEx;
import org.netbeans.modules.xml.schema.completion.util.CompletionUtil;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class DefaultModelProvider
extends CompletionModelProvider {
    private CompletionContextImpl context;

    public DefaultModelProvider() {
    }

    public DefaultModelProvider(CompletionContextImpl context) {
        this.context = context;
    }

    @Override
    public synchronized List<CompletionModelProvider.CompletionModel> getModels(CompletionContext context) {
        if (context.getPrimaryFile() == null) {
            return null;
        }
        this.context = (CompletionContextImpl)context;
        List<URI> uris = this.context.getSchemas();
        if (uris == null || uris.size() == 0) {
            return null;
        }
        ArrayList<CompletionModelProvider.CompletionModel> models = new ArrayList<CompletionModelProvider.CompletionModel>();
        for (URI uri : uris) {
            CompletionModelProvider.CompletionModel model = this.getCompletionModel(uri, true);
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    CompletionModelProvider.CompletionModel getCompletionModel(URI schemaURI, boolean fetch) {
        CompletionModelEx model = null;
        try {
            ModelSource modelSource = null;
            CatalogModel catalogModel = null;
            CatalogModelProvider catalogModelProvider = this.getCatalogModelProvider();
            if (catalogModelProvider == null) {
                modelSource = Utilities.getModelSource((FileObject)this.context.getPrimaryFile(), (boolean)true);
                CatalogModelFactory factory = CatalogModelFactory.getDefault();
                catalogModel = factory.getCatalogModel(modelSource);
            } else {
                modelSource = catalogModelProvider.getModelSource(this.context.getPrimaryFile(), true);
                catalogModel = catalogModelProvider.getCatalogModel();
            }
            URI uri = new URI(schemaURI.toString() + "?fetch=" + fetch + "&&sync=" + true);
            ModelSource schemaModelSource = catalogModel.getModelSource(uri, modelSource);
            SchemaModel sm = null;
            sm = schemaModelSource.getLookup().lookup(FileObject.class) == null ? (SchemaModel)SchemaModelFactory.getDefault().createFreshModel(schemaModelSource) : SchemaModelFactory.getDefault().getModel(schemaModelSource);
            String tns = sm.getSchema().getTargetNamespace();
            List<String> prefixes = CompletionUtil.getPrefixesAgainstNamespace(this.context, tns);
            model = prefixes != null && prefixes.size() > 0 ? new CompletionModelEx(this.context, prefixes.get(0), sm) : new CompletionModelEx(this.context, this.context.suggestPrefix(tns), sm);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return model;
    }

    private CatalogModelProvider getCatalogModelProvider() {
        Lookup.Template templ = new Lookup.Template(CatalogModelProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(templ);
        Collection impls = result.allInstances();
        if (impls == null || impls.size() == 0) {
            return null;
        }
        return (CatalogModelProvider)impls.iterator().next();
    }
}

