/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.schema.completion.CompletionResultItem;
import org.netbeans.modules.xml.schema.model.Attribute;

public abstract class CompletionPaintComponent
extends JPanel {
    public static final int DEFAULT_ICON_WIDTH = 16;
    public static final int DEFAULT_ICON_TEXT_GAP = 5;
    protected int drawX;
    protected int drawY;
    protected int drawHeight;
    private Font drawFont;
    private int iconTextGap = 5;
    private int fontHeight;
    private int ascent;
    private FontMetrics fontMetrics;
    private boolean isSelected;
    private CompletionResultItem completionItem;
    private static final String THROWS = " throws ";
    private static String str;

    public CompletionPaintComponent(CompletionResultItem item) {
        this.completionItem = item;
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        Rectangle r = g.getClipBounds();
        g.fillRect(r.x, r.y, r.width, r.height);
        this.draw(g);
    }

    protected void draw(Graphics g) {
        this.drawIcon(g, this.completionItem.getIcon());
        this.drawString(g, this.completionItem.getDisplayText(), this.completionItem.getPaintColor(), this.getDrawFont());
    }

    protected void drawIcon(Graphics g, Icon icon) {
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX = i.left;
            this.drawY = i.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (g != null) {
                icon.paintIcon(this, g, this.drawX, this.drawY);
            }
            this.drawX += icon.getIconWidth() + this.iconTextGap;
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            int extraPaintGap = this.completionItem.getExtraPaintGap();
            this.drawX += extraPaintGap + this.iconTextGap;
            this.drawHeight = this.fontHeight;
        }
        if (i != null) {
            this.drawHeight += i.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected void drawString(Graphics g, String s, Color c, Font font) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
            g.setFont(font);
        }
        this.drawStringToGraphics(g, s, font);
    }

    protected void drawStringToGraphics(Graphics g, String s, Font font) {
        if (g != null) {
            g.drawString(s, this.drawX, this.drawY);
        }
        this.drawX += this.getWidth(s, font);
    }

    protected int getWidth(String s, Font font) {
        if (font != null) {
            return this.getFontMetrics(this.getDrawFont()).stringWidth(s) * 2;
        }
        return s == null ? this.fontMetrics.stringWidth("") : this.fontMetrics.stringWidth(s) * 2;
    }

    protected Color getColor(String s, Color defaultColor) {
        return this.isSelected ? this.getForeground() : defaultColor;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    @Override
    public Dimension getPreferredSize() {
        this.draw(null);
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX += i.right;
        }
        if (this.drawX > this.getMaximumSize().width) {
            this.drawX = this.getMaximumSize().width;
        }
        return new Dimension(this.drawX, this.drawHeight);
    }

    CompletionResultItem getCompletionItem() {
        return this.completionItem;
    }

    public static class ValuePaintComponent
    extends CompletionPaintComponent {
        public ValuePaintComponent(CompletionResultItem item) {
            super(item);
        }
    }

    public static class ElementPaintComponent
    extends CompletionPaintComponent {
        public ElementPaintComponent(CompletionResultItem item) {
            super(item);
        }
    }

    public static class DefaultCompletionPaintComponent
    extends CompletionPaintComponent {
        public DefaultCompletionPaintComponent(CompletionResultItem item) {
            super(item);
        }
    }

    public static class AttributePaintComponent
    extends CompletionPaintComponent {
        public AttributePaintComponent(CompletionResultItem item) {
            super(item);
        }

        @Override
        protected Font getDrawFont() {
            AbstractAttribute aa = (AbstractAttribute)this.getCompletionItem().getAXIComponent();
            if (aa instanceof Attribute && ((Attribute)aa).getUse() == Attribute.Use.REQUIRED) {
                return super.getDrawFont().deriveFont(1);
            }
            return super.getFont();
        }
    }
}

