/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Set;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;

final class ActiveRecordQueryIndexer {
    private static final String[] RELATION_METHODS = new String[]{"includes", "eager_load", "preload", "select", "group", "order", "joins", "where", "having", "limit", "offset", "lock", "readonly", "create_with", "from"};
    private static final RubyType RELATION_TYPE = RubyType.create("ActiveRecord::Relation");
    private final RubyIndex index;
    private final String prefix;
    private final QuerySupport.Kind kind;
    private final String classFqn;
    private final Set<IndexedMethod> methods;

    private ActiveRecordQueryIndexer(RubyIndex index, String prefix, QuerySupport.Kind kind, String classFqn, Set<IndexedMethod> methods) {
        this.index = index;
        this.prefix = prefix;
        this.kind = kind;
        this.classFqn = classFqn;
        this.methods = methods;
    }

    static void indexQueryMehods(RubyIndex index, String prefix, QuerySupport.Kind kind, String classFqn, Set<IndexedMethod> methods) {
        ActiveRecordQueryIndexer indexer = new ActiveRecordQueryIndexer(index, prefix, kind, classFqn, methods);
        indexer.addQueryMethods();
    }

    static boolean isQueryMethod(String name) {
        for (String each : RELATION_METHODS) {
            if (!each.equals(name)) continue;
            return true;
        }
        return false;
    }

    static RubyType getReturnType(String name) {
        assert (ActiveRecordQueryIndexer.isQueryMethod(name));
        return RELATION_TYPE;
    }

    private void addQueryMethods() {
        if (this.kind == QuerySupport.Kind.EXACT) {
            return;
        }
        for (String each : RELATION_METHODS) {
            if (!each.startsWith(this.prefix)) continue;
            int flags = 16;
            String attributes = IndexedElement.flagToString(flags) + ";;;" + "conditions";
            String fqn = this.classFqn + "#" + each;
            IndexedMethod method = IndexedMethod.create(this.index, each, fqn, this.classFqn, null, null, attributes, flags, this.index.getContext());
            method.setMethodType(IndexedMethod.MethodType.DYNAMIC_FINDER);
            method.setType(RELATION_TYPE);
            method.setInherited(false);
            method.setSmart(true);
            this.methods.add(method);
        }
    }
}

