/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.IndexSearcher;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.api.queries.SourceForBinaryQuery;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.modules.gsfret.navigation.Icons;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.RepositoryUpdater;
import org.netbeans.napi.gsfret.source.ClassIndex;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.UiUtils;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class GsfTypeProvider
implements TypeProvider,
IndexSearcher.Helper {
    private static final Logger LOGGER = Logger.getLogger(GsfTypeProvider.class.getName());
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    private Set<CacheItem> cache;
    private volatile boolean isCancelled = false;

    public void cleanup() {
        this.cache = null;
    }

    public void computeTypeNames(TypeProvider.Context context, TypeProvider.Result res) {
        NameKind indexNameKind;
        long time;
        this.isCancelled = false;
        String text = context.getText();
        SearchType nameKind = context.getSearchType();
        long sort = 0L;
        long add = 0L;
        long gtn = 0L;
        long sfb = 0L;
        long gsb = 0L;
        long gss = 0L;
        long cp = 0L;
        if (this.cache == null) {
            int i;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("GoToTypeAction.getTypeNames recreates cache\n");
            }
            time = System.currentTimeMillis();
            ClassPath scp = RepositoryUpdater.getDefault().getScannedSources();
            FileObject[] roots = scp.getRoots();
            gss += System.currentTimeMillis() - time;
            FileObject[] root = new FileObject[1];
            HashSet<CacheItem> sources = new HashSet<CacheItem>(roots.length);
            for (i = 0; i < roots.length; ++i) {
                root[0] = roots[i];
                time = System.currentTimeMillis();
                ClasspathInfo ci = ClasspathInfo.create(EMPTY_CLASSPATH, EMPTY_CLASSPATH, ClassPathSupport.createClassPath((FileObject[])root));
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("GoToTypeAction.getTypeNames created ClasspathInfo for source: " + FileUtil.getFileDisplayName((FileObject)roots[i]) + "\n");
                }
                if (this.isCancelled) {
                    return;
                }
                sources.add(new CacheItem(roots[i], ci, false));
                cp += System.currentTimeMillis() - time;
            }
            time = System.currentTimeMillis();
            scp = RepositoryUpdater.getDefault().getScannedBinaries();
            roots = scp.getRoots();
            gsb += System.currentTimeMillis() - time;
            root = new FileObject[1];
            for (i = 0; i < roots.length; ++i) {
                try {
                    time = System.currentTimeMillis();
                    SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)roots[i].getURL());
                    if (result.getRoots().length == 0) continue;
                    sfb += System.currentTimeMillis() - time;
                    time = System.currentTimeMillis();
                    root[0] = roots[i];
                    ClasspathInfo ci = ClasspathInfo.create(ClassPathSupport.createClassPath((FileObject[])root), EMPTY_CLASSPATH, EMPTY_CLASSPATH);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("GoToTypeAction.getTypeNames created ClasspathInfo for binary: " + FileUtil.getFileDisplayName((FileObject)roots[i]) + "\n");
                    }
                    sources.add(new CacheItem(roots[i], ci, true));
                    cp += System.currentTimeMillis() - time;
                    continue;
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
            }
            if (!this.isCancelled) {
                this.cache = sources;
            } else {
                return;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("GoToTypeAction.getTypeNames collected : " + this.cache.size() + " elements\n");
        }
        ArrayList<TypeDescriptor> types = new ArrayList<TypeDescriptor>(this.cache.size() * 20);
        switch (nameKind) {
            case CAMEL_CASE: {
                indexNameKind = NameKind.CAMEL_CASE;
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                indexNameKind = NameKind.CASE_INSENSITIVE_PREFIX;
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                indexNameKind = NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case PREFIX: {
                indexNameKind = NameKind.PREFIX;
                break;
            }
            case REGEXP: {
                indexNameKind = NameKind.REGEXP;
                break;
            }
            case EXACT_NAME: {
                indexNameKind = NameKind.EXACT_NAME;
                break;
            }
            case CASE_INSENSITIVE_EXACT_NAME: {
                indexNameKind = NameKind.EXACT_NAME;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected name kind: " + nameKind);
            }
        }
        for (CacheItem ci : this.cache) {
            String textForQuery;
            time = System.currentTimeMillis();
            switch (nameKind) {
                case CASE_INSENSITIVE_REGEXP: 
                case REGEXP: {
                    String pattern = text + "*";
                    textForQuery = pattern = pattern.replace("*", ".*").replace('?', '.');
                    break;
                }
                default: {
                    textForQuery = text;
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("GoToTypeAction.getTypeNames queries usages of: " + ci.classpathInfo + "\n");
            }
            Set<? extends TypeDescriptor> names = this.getTypes(ci.classpathInfo, textForQuery, indexNameKind, EnumSet.of(ci.isBinary ? Index.SearchScope.DEPENDENCIES : Index.SearchScope.SOURCE));
            if (this.isCancelled) {
                return;
            }
            gtn += System.currentTimeMillis() - time;
            time = System.currentTimeMillis();
            for (TypeDescriptor typeDescriptor : names) {
                types.add(typeDescriptor);
                if (!this.isCancelled) continue;
                return;
            }
            add += System.currentTimeMillis() - time;
        }
        if (!this.isCancelled) {
            time = System.currentTimeMillis();
            sort += System.currentTimeMillis() - time;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("PERF -  GSS:  " + gss + " GSB " + gsb + " CP: " + cp + " SFB: " + sfb + " GTN: " + gtn + "  ADD: " + add + "  SORT: " + sort);
            }
            res.addResult(types);
        }
    }

    private Set<? extends TypeDescriptor> getTypes(ClasspathInfo classpathInfo, String textForQuery, NameKind kind, EnumSet<Index.SearchScope> scope) {
        HashSet<GsfTypeDescriptor> items = new HashSet<GsfTypeDescriptor>();
        for (Language language : LanguageRegistry.getInstance()) {
            IndexSearcher searcher = language.getIndexSearcher();
            if (searcher == null) continue;
            ClassIndex index = classpathInfo.getClassIndex(language.getMimeType());
            try {
                Set set = searcher.getTypes((Index)index, textForQuery, kind, scope, (IndexSearcher.Helper)this);
                if (set == null) continue;
                for (IndexSearcher.Descriptor desc : set) {
                    GsfTypeDescriptor d = new GsfTypeDescriptor(desc);
                    items.add(d);
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return items;
    }

    public Icon getIcon(ElementHandle element) {
        return Icons.getElementIcon(element.getKind(), element.getModifiers());
    }

    public void open(FileObject fileObject, ElementHandle element) {
        Source js = Source.forFileObject(fileObject);
        if (js != null) {
            UiUtils.open(js, element);
        }
    }

    public String name() {
        return "GSF";
    }

    public String getDisplayName() {
        return LanguageRegistry.getInstance().getLanguagesDisplayName();
    }

    public void cancel() {
        this.isCancelled = true;
    }

    private class GsfTypeDescriptor
    extends TypeDescriptor {
        private IndexSearcher.Descriptor delegated;

        private GsfTypeDescriptor(IndexSearcher.Descriptor delegated) {
            this.delegated = delegated;
        }

        public String getSimpleName() {
            return this.delegated.getSimpleName();
        }

        public String getOuterName() {
            return this.delegated.getOuterName();
        }

        public String getTypeName() {
            return this.delegated.getTypeName();
        }

        public String getContextName() {
            String s = this.delegated.getContextName();
            if (s != null) {
                return " (" + s + ")";
            }
            return s;
        }

        public Icon getIcon() {
            return this.delegated.getIcon();
        }

        public String getProjectName() {
            return this.delegated.getProjectName();
        }

        public Icon getProjectIcon() {
            return this.delegated.getProjectIcon();
        }

        public FileObject getFileObject() {
            return this.delegated.getFileObject();
        }

        public int getOffset() {
            return this.delegated.getOffset();
        }

        public void open() {
            this.delegated.open();
        }
    }

    static class CacheItem {
        public final boolean isBinary;
        public final FileObject fileObject;
        public final ClasspathInfo classpathInfo;
        public String projectName;
        public Icon projectIcon;

        public CacheItem(FileObject fileObject, ClasspathInfo classpathInfo, boolean isBinary) {
            this.isBinary = isBinary;
            this.fileObject = fileObject;
            this.classpathInfo = classpathInfo;
        }

        public int hashCode() {
            return this.fileObject == null ? 0 : this.fileObject.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof CacheItem) {
                CacheItem otherItem = (CacheItem)other;
                return this.fileObject == null ? otherItem.fileObject == null : this.fileObject.equals(otherItem.fileObject);
            }
            return false;
        }

        public FileObject getRoot() {
            return this.fileObject;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        public synchronized String getProjectName() {
            if (this.projectName == null) {
                try {
                    URL url = this.fileObject.getURL();
                    if (ClassIndexManager.isBootRoot(url)) {
                        this.projectName = "Ruby Lib";
                    }
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (!this.isBinary && this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        public synchronized Icon getProjectIcon() {
            if (!this.isBinary && this.projectIcon == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        private void initProjectInfo() {
            Project p = FileOwnerQuery.getOwner((FileObject)this.fileObject);
            if (p != null) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                this.projectName = pi.getDisplayName();
                this.projectIcon = pi.getIcon();
            }
        }
    }
}

