/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathProvider;
import org.netbeans.modules.gsfret.hints.infrastructure.GsfHintsManager;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;

public class GsfTaskProvider
extends PushTaskScanner {
    private TaskScanningScope scope;
    private PushTaskScanner.Callback callback;
    private static final String TASKLIST_ERROR = "nb-tasklist-error";
    private static final String TASKLIST_WARNING = "nb-tasklist-warning";
    private static final String TASKLIST_ERROR_HINT = "nb-tasklist-errorhint";
    private static final String TASKLIST_WARNING_HINT = "nb-tasklist-warninghint";
    private static final Set<RequestProcessor.Task> TASKS = new HashSet<RequestProcessor.Task>();
    private static boolean clearing;
    private static final RequestProcessor WORKER;
    private static GsfTaskProvider INSTANCE;

    public GsfTaskProvider() {
        this(null);
        INSTANCE = this;
    }

    private GsfTaskProvider(String languageList) {
        super(NbBundle.getMessage(GsfTaskProvider.class, (String)"GsfTasks"), NbBundle.getMessage(GsfTaskProvider.class, (String)"GsfTasksDesc"), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setScope(TaskScanningScope scope, PushTaskScanner.Callback callback) {
        GsfTaskProvider.cancelAllCurrent();
        Set<RequestProcessor.Task> set = TASKS;
        synchronized (set) {
            this.scope = scope;
            this.callback = callback;
        }
        if (scope == null || callback == null) {
            return;
        }
        for (FileObject file : scope.getLookup().lookupAll(FileObject.class)) {
            GsfTaskProvider.enqueue(new Work(file, callback));
        }
        for (Project p : scope.getLookup().lookupAll(Project.class)) {
            ClassPath cp;
            ClassPathProvider provider = (ClassPathProvider)p.getLookup().lookup(ClassPathProvider.class);
            if (provider == null || (cp = provider.findClassPath(p.getProjectDirectory(), "classpath/source")) == null) continue;
            for (FileObject root : cp.getRoots()) {
                GsfTaskProvider.enqueue(new Work(root, callback));
            }
        }
    }

    public static void refresh(FileObject file) {
        if (INSTANCE != null) {
            INSTANCE.refreshImpl(file);
        }
    }

    private synchronized void refreshImpl(FileObject file) {
        if (this.scope == null || this.callback == null) {
            return;
        }
        if (!this.scope.isInScope(file)) {
            if (!file.isFolder()) {
                return;
            }
            for (FileObject inScope : this.scope.getLookup().lookupAll(FileObject.class)) {
                if (!FileUtil.isParentOf((FileObject)file, (FileObject)inScope)) continue;
                GsfTaskProvider.enqueue(new Work(inScope, this.callback));
            }
            return;
        }
        GsfTaskProvider.enqueue(new Work(file, this.callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enqueue(Work w) {
        Set<RequestProcessor.Task> set = TASKS;
        synchronized (set) {
            if (INSTANCE != null && TASKS.size() == 0 && GsfTaskProvider.INSTANCE.callback != null) {
                GsfTaskProvider.INSTANCE.callback.started();
            }
            RequestProcessor.Task task = WORKER.post((Runnable)w);
            TASKS.add(task);
            task.addTaskListener(new TaskListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(org.openide.util.Task task) {
                    Set set = TASKS;
                    synchronized (set) {
                        if (!clearing) {
                            TASKS.remove(task);
                            if (INSTANCE != null && TASKS.size() == 0 && INSTANCE.callback != null) {
                                INSTANCE.callback.finished();
                            }
                        }
                    }
                }
            });
            if (task.isFinished()) {
                TASKS.remove(task);
                if (INSTANCE != null && TASKS.size() == 0 && GsfTaskProvider.INSTANCE.callback != null) {
                    GsfTaskProvider.INSTANCE.callback.finished();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelAllCurrent() {
        Set<RequestProcessor.Task> set = TASKS;
        synchronized (set) {
            clearing = true;
            try {
                for (RequestProcessor.Task t : TASKS) {
                    t.cancel();
                }
                TASKS.clear();
            }
            finally {
                clearing = false;
            }
        }
    }

    private static String severityToTaskListString(org.netbeans.spi.editor.hints.Severity severity) {
        return severity == org.netbeans.spi.editor.hints.Severity.ERROR ? TASKLIST_ERROR_HINT : TASKLIST_WARNING_HINT;
    }

    static {
        WORKER = new RequestProcessor("GSF Task Provider");
    }

    private static final class Work
    implements Runnable {
        private FileObject fileOrRoot;
        private PushTaskScanner.Callback callback;

        public Work(FileObject fileOrRoot, PushTaskScanner.Callback callback) {
            this.fileOrRoot = fileOrRoot;
            this.callback = callback;
        }

        public FileObject getFileOrRoot() {
            return this.fileOrRoot;
        }

        public PushTaskScanner.Callback getCallback() {
            return this.callback;
        }

        @Override
        public void run() {
            FileObject file = this.getFileOrRoot();
            this.refreshFile(file);
        }

        private void refreshFile(final FileObject file) {
            if (!file.isValid()) {
                return;
            }
            if (file.isFolder()) {
                if (!VisibilityQuery.getDefault().isVisible(file)) {
                    return;
                }
                String name = file.getName();
                if (name.equals("vendor") && file.getParent().getFileObject("nbproject") != null) {
                    return;
                }
                for (FileObject child : file.getChildren()) {
                    this.refreshFile(child);
                }
                return;
            }
            final LanguageRegistry registry = LanguageRegistry.getInstance();
            List<Language> applicableLanguages = registry.getApplicableLanguages(file.getMIMEType());
            boolean applicable = false;
            for (Language language : applicableLanguages) {
                HintsProvider provider = language.getHintsProvider();
                if (provider != null) {
                    applicable = true;
                    break;
                }
                if (language.getParser() == null) continue;
                applicable = true;
                break;
            }
            if (!applicable) {
                return;
            }
            if (file.getSize() > 0x100000L) {
                return;
            }
            final ArrayList result = new ArrayList();
            Source source = Source.forFileObject(file);
            if (source == null) {
                return;
            }
            final ArrayList<Task> tasks = new ArrayList<Task>();
            CancellableTask<CompilationController> runner = new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController info) throws Exception {
                    GsfUtilities.getDocument((FileObject)info.getFileObject(), (boolean)true);
                    info.toPhase(Phase.RESOLVED);
                    for (String mimeType : info.getEmbeddedMimeTypes()) {
                        Collection<? extends ParserResult> embeddedResults = info.getEmbeddedResults(mimeType);
                        for (ParserResult parserResult : embeddedResults) {
                            Language language = registry.getLanguageByMimeType(mimeType);
                            HintsProvider provider = language.getHintsProvider();
                            ArrayList errors = new ArrayList();
                            if (provider == null) {
                                List parserErrors = parserResult.getDiagnostics();
                                if (parserErrors != null) {
                                    errors.addAll(parserErrors);
                                }
                            } else {
                                RuleContext ruleContext;
                                GsfHintsManager manager = language.getHintsManager();
                                if (manager == null || (ruleContext = manager.createRuleContext(info, language, -1, -1, -1)) == null) continue;
                                ArrayList hints = new ArrayList();
                                provider.computeErrors((HintsProvider.HintsManager)manager, ruleContext, hints, errors);
                                provider.computeHints((HintsProvider.HintsManager)manager, ruleContext, hints);
                                if (!file.isValid()) continue;
                                for (Hint desc : hints) {
                                    ErrorDescription errorDesc = manager.createDescription(desc, ruleContext, false);
                                    if (errorDesc == null) continue;
                                    result.add(errorDesc);
                                }
                            }
                            for (Error error : errors) {
                                int lexOffset;
                                StyledDocument doc = (StyledDocument)info.getDocument();
                                if (doc == null) continue;
                                int astOffset = error.getStartPosition();
                                if (parserResult.getTranslatedSource() != null) {
                                    lexOffset = parserResult.getTranslatedSource().getLexicalOffset(astOffset);
                                    if (lexOffset == -1) {
                                        continue;
                                    }
                                } else {
                                    lexOffset = astOffset;
                                }
                                int lineno = NbDocument.findLineNumber((StyledDocument)doc, (int)lexOffset) + 1;
                                Task task = Task.create((FileObject)file, (String)(error.getSeverity() == Severity.ERROR ? GsfTaskProvider.TASKLIST_ERROR : GsfTaskProvider.TASKLIST_WARNING), (String)error.getDisplayName(), (int)lineno);
                                tasks.add(task);
                            }
                        }
                    }
                }
            };
            try {
                source.runUserActionTask(runner, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            for (ErrorDescription hint : result) {
                try {
                    Task task = Task.create((FileObject)file, (String)GsfTaskProvider.severityToTaskListString(hint.getSeverity()), (String)hint.getDescription(), (int)(hint.getRange().getBegin().getLine() + 1));
                    tasks.add(task);
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
            this.callback.setTasks(file, tasks);
        }
    }
}

