/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.util;

import java.util.Vector;

public class JspNameUtil {
    private static final String[] javaKeywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throws", "transient", "try", "void", "volatile", "while"};
    private static final String JSP_PACKAGE_NAME = "org.apache.jsp";

    private static final String makeJavaPackage(String path) {
        String[] classNameComponents = JspNameUtil.split(path, "/");
        StringBuffer legalClassNames = new StringBuffer();
        for (int i = 0; i < classNameComponents.length; ++i) {
            legalClassNames.append(JspNameUtil.makeJavaIdentifier(classNameComponents[i]));
            if (i >= classNameComponents.length - 1) continue;
            legalClassNames.append('.');
        }
        return legalClassNames.toString();
    }

    private static final String[] split(String path, String pat) {
        Vector<String> comps = new Vector<String>();
        int pos = path.indexOf(pat);
        int start = 0;
        while (pos >= 0) {
            if (pos > start) {
                String comp = path.substring(start, pos);
                comps.add(comp);
            }
            start = pos + pat.length();
            pos = path.indexOf(pat, start);
        }
        if (start < path.length()) {
            comps.add(path.substring(start));
        }
        String[] result = new String[comps.size()];
        for (int i = 0; i < comps.size(); ++i) {
            result[i] = (String)comps.elementAt(i);
        }
        return result;
    }

    private static final String makeJavaIdentifier(String identifier) {
        StringBuffer modifiedIdentifier = new StringBuffer(identifier.length());
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            modifiedIdentifier.append('_');
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (Character.isJavaIdentifierPart(ch) && ch != '_') {
                modifiedIdentifier.append(ch);
                continue;
            }
            if (ch == '.') {
                modifiedIdentifier.append('_');
                continue;
            }
            modifiedIdentifier.append(JspNameUtil.mangleChar(ch));
        }
        if (JspNameUtil.isJavaKeyword(modifiedIdentifier.toString())) {
            modifiedIdentifier.append('_');
        }
        return modifiedIdentifier.toString();
    }

    private static final String mangleChar(char ch) {
        char[] result = new char[]{'_', Character.forDigit(ch >> 12 & 0xF, 16), Character.forDigit(ch >> 8 & 0xF, 16), Character.forDigit(ch >> 4 & 0xF, 16), Character.forDigit(ch & 0xF, 16)};
        return new String(result);
    }

    private static boolean isJavaKeyword(String key) {
        int i = 0;
        int j = javaKeywords.length;
        while (i < j) {
            int k = (i + j) / 2;
            int result = javaKeywords[k].compareTo(key);
            if (result == 0) {
                return true;
            }
            if (result < 0) {
                i = k + 1;
                continue;
            }
            j = k;
        }
        return false;
    }

    public static String getServletResourcePath(String moduleContextPath, String jspResourcePath) {
        return JspNameUtil.getServletPackageName(jspResourcePath).replace('.', '/') + '/' + JspNameUtil.getServletClassName(jspResourcePath) + ".java";
    }

    private static String getServletPackageName(String jspUri) {
        String dPackageName = JspNameUtil.getDerivedPackageName(jspUri);
        if (dPackageName.length() == 0) {
            return JSP_PACKAGE_NAME;
        }
        return "org.apache.jsp." + JspNameUtil.getDerivedPackageName(jspUri);
    }

    private static String getDerivedPackageName(String jspUri) {
        int iSep = jspUri.lastIndexOf(47);
        return iSep > 0 ? JspNameUtil.makeJavaPackage(jspUri.substring(0, iSep)) : "";
    }

    private static String getServletClassName(String jspUri) {
        int iSep = jspUri.lastIndexOf(47) + 1;
        return JspNameUtil.makeJavaIdentifier(jspUri.substring(iSep));
    }
}

