/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.util;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.model.PackageItem;
import com.sun.javacard.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XMLNode {
    public static final String JAVACARD_DEFAULT_XMLNS = "http://java.sun.com/xml/ns/javacard";
    public static final String WEB_DEFAULT_XMLNS = "http://java.sun.com/xml/ns/j2ee";
    public static final String SCHEMA_RESOURCE_PATH = "/com/sun/javacard/packager/schemas/";
    private static final Vector<String> EXCLUDE_ATTRIBUTES = new Vector<String>(){
        {
            this.addElement("xsi:schemaLocation");
            this.addElement("xmlns:xsi");
        }
    };
    private final PackageItem packageItem;
    private Node node;
    private String xmlString;
    private Hashtable<String, String> attributes;
    private ArrayList<XMLNode> allChildNodes;
    private Hashtable<String, ArrayList<XMLNode>> namedChildNodes;
    private Hashtable<String, XMLNode> singleChildNodes;
    private String cdata;
    private Document document;

    public XMLNode(PackageItem packageItem, File file, String string, String string2) throws Exception {
        this.packageItem = packageItem;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        FileInputStream fileInputStream = new FileInputStream(file);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.parse(fileInputStream);
        fileInputStream.close();
        this.node = this.document.getDocumentElement();
        String string3 = this.getAttribute("xmlns");
        if (string3 == null || string3.trim().length() <= 0) {
            packageItem.addWarning(ErrorKey.MissingXmlsns, new Object[0]);
        }
        if (string3 != null && !string2.equals(string3)) {
            packageItem.addError(ErrorKey.InvalidXmlsns, string3);
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(new MyLSResourceResolver());
        Schema schema = schemaFactory.newSchema(new StreamSource(this.getClass().getResourceAsStream(SCHEMA_RESOURCE_PATH + string)));
        schema.newValidator().validate(new DOMSource(this.document));
    }

    public XMLNode(PackageItem packageItem, Node node) {
        this.packageItem = packageItem;
        this.node = node;
    }

    public String getName() {
        return this.node.getNodeName();
    }

    public String getTextValue() {
        if (this.node.getFirstChild() == null) {
            return null;
        }
        String string = this.node.getFirstChild().getNodeValue();
        return string == null ? "" : string.trim();
    }

    public XMLNode getChildNode(String string) {
        XMLNode xMLNode;
        if (this.singleChildNodes == null) {
            this.singleChildNodes = new Hashtable();
        }
        if ((xMLNode = this.singleChildNodes.get(string)) == null) {
            NodeList nodeList = this.node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                if (!nodeList.item(i).getNodeName().equals(string)) continue;
                xMLNode = new XMLNode(this.packageItem, nodeList.item(i));
                this.singleChildNodes.put(string, xMLNode);
                break;
            }
        }
        return xMLNode;
    }

    public ArrayList<XMLNode> getChildNodes(String string) {
        ArrayList<XMLNode> arrayList;
        if (this.namedChildNodes == null) {
            this.namedChildNodes = new Hashtable();
        }
        if ((arrayList = this.namedChildNodes.get(string)) == null) {
            arrayList = new ArrayList();
            NodeList nodeList = this.node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                if (!nodeList.item(i).getNodeName().equals(string)) continue;
                arrayList.add(new XMLNode(this.packageItem, nodeList.item(i)));
            }
            this.namedChildNodes.put(string, arrayList);
        }
        return arrayList;
    }

    public ArrayList<XMLNode> getChildNodes() {
        if (this.allChildNodes == null) {
            this.allChildNodes = new ArrayList();
            NodeList nodeList = this.node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                if (nodeList.item(i).getNodeType() == 3 || nodeList.item(i).getNodeType() == 8) continue;
                this.allChildNodes.add(new XMLNode(this.packageItem, nodeList.item(i)));
            }
        }
        return this.allChildNodes;
    }

    public Hashtable<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
            NamedNodeMap namedNodeMap = this.node.getAttributes();
            if (namedNodeMap != null) {
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    this.attributes.put(namedNodeMap.item(i).getNodeName(), namedNodeMap.item(i).getNodeValue());
                }
            }
        }
        return this.attributes;
    }

    public Integer getIntegerAttribute(String string) {
        this.getAttributes();
        Integer n = null;
        String string2 = this.getAttribute(string);
        if (string2 != null && string2.trim().length() > 0) {
            try {
                n = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public Boolean getBooleanAttribute(String string) {
        this.getAttributes();
        Boolean bl = null;
        String string2 = this.getAttribute(string);
        if (string2 != null && string2.trim().length() > 0) {
            if (string2.equalsIgnoreCase("yes")) {
                string2 = "true";
            } else if (string2.equalsIgnoreCase("no")) {
                string2 = "false";
            }
            try {
                bl = string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false") ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public String getAttribute(String string) {
        this.getAttributes();
        return this.attributes.get(string);
    }

    public String getAttributeStrtingWith(String string) {
        this.getAttributes();
        ArrayList<String> arrayList = new ArrayList<String>(this.attributes.keySet());
        for (String string2 : arrayList) {
            if (!string2.startsWith(string)) continue;
            return this.attributes.get(string2);
        }
        return null;
    }

    public String getCDATA() {
        if (this.cdata == null) {
            Node node = null;
            NodeList nodeList = this.node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 4) continue;
                node = node2;
            }
            this.cdata = node == null ? "" : node.getNodeValue();
        }
        return this.cdata;
    }

    public String toString() {
        if (this.xmlString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.nodeToString(0));
            this.xmlString = stringBuffer.toString();
        }
        return this.xmlString;
    }

    private String nodeToString(int n) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.node.getNodeName();
        int n2 = string.indexOf(58);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        stringBuffer.append(StringUtils.indentString(n)).append("<").append(string);
        Hashtable<String, String> hashtable = this.getAttributes();
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>(hashtable.keySet());
        Collections.sort(arrayList);
        Object object3 = arrayList.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            if (EXCLUDE_ATTRIBUTES.contains(object2)) continue;
            object = hashtable.get(object2);
            stringBuffer.append(bl ? " " : "").append((String)object2).append("=\"").append((String)object).append("\"");
            bl = true;
        }
        stringBuffer.append(">");
        if (this.getTextValue() != null) {
            stringBuffer.append(this.getTextValue().trim());
        }
        if (((ArrayList)(object3 = this.getChildNodes())).size() > 0) {
            stringBuffer.append('\n');
        }
        object2 = ((ArrayList)object3).iterator();
        while (object2.hasNext()) {
            object = (XMLNode)object2.next();
            stringBuffer.append(super.nodeToString(n + 1));
        }
        stringBuffer.append(((ArrayList)object3).size() > 0 ? StringUtils.indentString(n) : "");
        stringBuffer.append("</").append(string).append(">\n");
        return stringBuffer.toString();
    }

    class MyLSInput
    implements LSInput {
        private Reader characterStream;
        private InputStream byteStream;
        private String stringData;
        private String systemId;
        private String publicId;
        private String baseURI;
        private String encoding;
        private boolean certifiedText;

        MyLSInput() {
        }

        @Override
        public Reader getCharacterStream() {
            return this.characterStream;
        }

        @Override
        public void setCharacterStream(Reader reader) {
            this.characterStream = reader;
        }

        @Override
        public InputStream getByteStream() {
            return this.byteStream;
        }

        @Override
        public void setByteStream(InputStream inputStream) {
            this.byteStream = inputStream;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public void setStringData(String string) {
            this.stringData = string;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String string) {
            this.systemId = string;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String string) {
            this.publicId = string;
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public void setBaseURI(String string) {
            this.baseURI = string;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public void setEncoding(String string) {
            this.encoding = string;
        }

        @Override
        public boolean getCertifiedText() {
            return this.certifiedText;
        }

        @Override
        public void setCertifiedText(boolean bl) {
            this.certifiedText = bl;
        }
    }

    class MyLSResourceResolver
    implements LSResourceResolver {
        MyLSResourceResolver() {
        }

        @Override
        public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
            String string6 = string4;
            int n = string4.lastIndexOf(47);
            if (n != -1) {
                string6 = string4.substring(n + 1);
            }
            String string7 = XMLNode.SCHEMA_RESOURCE_PATH + string6;
            InputStream inputStream = this.getClass().getResourceAsStream(string7);
            MyLSInput myLSInput = new MyLSInput();
            myLSInput.setByteStream(inputStream);
            myLSInput.setSystemId(this.getClass().getResource(string7).toString());
            return myLSInput;
        }
    }

    public class SchemaLoader
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String string, String string2) {
            String string3 = string2;
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string3 = string2.substring(n + 1);
            }
            String string4 = XMLNode.SCHEMA_RESOURCE_PATH + string3;
            InputStream inputStream = this.getClass().getResourceAsStream(string4);
            return new InputSource(inputStream);
        }
    }
}

