/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager.model;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.model.AppletInfo;
import com.sun.javacard.packager.model.PackageItem;
import com.sun.javacard.util.XMLNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class AppletXML
extends PackageItem {
    public static final String XSD_NAME = "applet-app_3_0.xsd";
    private String version;
    private File file;
    private XMLNode xmlNode;
    Vector<AppletInfo> applets = new Vector();

    public AppletXML(File file) {
        this.file = file;
    }

    @Override
    public String getItemDisplayName() {
        String string = "";
        if (this.getParent() != null) {
            string = this.getParent().getItemDisplayName() + "/";
        }
        string = string + "applet.xml";
        return string;
    }

    public Vector<String> getAppletInfo() {
        Vector<String> vector = new Vector<String>();
        for (AppletInfo appletInfo : this.applets) {
            vector.add(appletInfo.AID);
            vector.add(appletInfo.className);
        }
        return vector;
    }

    public String getPackageName() {
        String string = this.applets.elementAt((int)0).className;
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public void saveCanonicalizedTo(File file) throws Exception {
        if (!this.isOk()) {
            return;
        }
        String string = this.xmlNode.toString();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void initialize() {
        this.xmlNode = null;
        try {
            this.xmlNode = new XMLNode(this, this.file, XSD_NAME, "http://java.sun.com/xml/ns/javacard");
        }
        catch (Exception exception) {
            this.addError(ErrorKey.XMLParsingError, this.file, exception.getMessage());
            return;
        }
        ArrayList<XMLNode> arrayList = this.xmlNode.getChildNodes("applet");
        for (XMLNode xMLNode : arrayList) {
            String string = xMLNode.getChildNode("applet-class").getTextValue().trim();
            String string2 = xMLNode.getChildNode("applet-AID").getTextValue().trim();
            this.applets.add(new AppletInfo(string, string2));
        }
    }

    @Override
    public void processInternal() {
    }
}

