/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.SignaturePool;
import com.sun.javacard.jcasm.SortableVector;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcasm.cap.TypeDescriptorEntry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Map;

public class ClassComponent
extends Component {
    protected SortableVector<JCClass> classVector = new SortableVector();

    public ClassComponent(JCPackage jCPackage) {
        super(jCPackage);
    }

    void add(JCClass jCClass) {
        this.classVector.addElement(jCClass);
    }

    private int assignTempAddresses() {
        int n = 0;
        int n2 = 0;
        this.classVector.sort();
        for (JCClass jCClass : this.classVector) {
            jCClass.relocate(n);
            n += jCClass.size();
        }
        n2 = this.getParentPackage().getSignaturePool().getSize() + 2;
        return n2;
    }

    void assignAddresses() {
        int n = 0;
        if (this.getParentPackage().is22Package()) {
            n = this.assignTempAddresses();
        }
        this.classVector.sort();
        for (JCClass jCClass : this.classVector) {
            jCClass.relocate(n);
            n += jCClass.size();
            int n2 = 0;
            Enumeration<Field> enumeration = jCClass.fieldElements();
            while (enumeration.hasMoreElements()) {
                Field field = enumeration.nextElement();
                if (Modifier.isStatic(field.getAttributes())) continue;
                field.relocate(n2);
                n2 += Math.max(2, field.size());
            }
        }
    }

    @Override
    public int dataSize() {
        int n = 0;
        for (JCClass jCClass : this.classVector) {
            n += jCClass.size();
        }
        if (this.getParentPackage().is22Package()) {
            SignaturePool signaturePool = this.getParentPackage().getSignaturePool();
            short s = (short)signaturePool.getSize();
            n += s + 2;
        }
        return n;
    }

    @Override
    protected byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            if (this.getParentPackage().is22Package()) {
                this.getParentPackage().purgeSignaturePool();
                SignaturePool signaturePool = this.getParentPackage().getSignaturePool();
                short s = (short)signaturePool.getSize();
                dataOutputStream.writeShort(s);
                for (int i = 0; i < signaturePool.methodSignaturePool.size(); ++i) {
                    TypeDescriptorEntry typeDescriptorEntry = signaturePool.methodSignaturePool.elementAt(i);
                    byte[] byArray2 = typeDescriptorEntry.getData();
                    dataOutputStream.write(byArray2);
                }
            }
            for (JCClass jCClass : this.classVector) {
                byte[] byArray3 = jCClass.toByteArray();
                dataOutputStream.write(byArray3, 0, byArray3.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        assert (this.size() == byteArrayOutputStream.size()) : "size() != bos.size()";
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        for (JCClass jCClass : this.classVector) {
            byte[] byArray = jCClass.toByteArray();
            stringBuffer.append("Class: " + Msg.toHexString(byArray) + Msg.eol);
        }
        return stringBuffer.toString();
    }

    protected void getDebugOffsets(Map<String, Integer> map) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            if (this.getParentPackage().is22Package()) {
                this.getParentPackage().purgeSignaturePool();
                SignaturePool signaturePool = this.getParentPackage().getSignaturePool();
                short s = (short)signaturePool.getSize();
                dataOutputStream.writeShort(s);
                for (int i = 0; i < signaturePool.methodSignaturePool.size(); ++i) {
                    TypeDescriptorEntry typeDescriptorEntry = signaturePool.methodSignaturePool.elementAt(i);
                    byte[] byArray = typeDescriptorEntry.getData();
                    dataOutputStream.write(byArray);
                }
            }
            for (JCClass jCClass : this.classVector) {
                byte[] byArray = jCClass.toByteArray();
                map.put(jCClass.getName(), new Integer(dataOutputStream.size()));
                dataOutputStream.write(byArray, 0, byArray.length);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }
}

