/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

class Util {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.reglib.Util");

    Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String commandOutput(Process p) throws IOException {
        InputStreamReader r = null;
        InputStreamReader err = null;
        try {
            r = new InputStreamReader(p.getInputStream());
            err = new InputStreamReader(p.getErrorStream());
            String output = Util.commandOutput(r);
            String errorMsg = Util.commandOutput(err);
            p.waitFor();
            String string = output + errorMsg.trim();
            return string;
        }
        catch (InterruptedException e) {
            LOG.log(Level.INFO, "Interrupted:", e);
            String string = e.getMessage();
            return string;
        }
        finally {
            IOException exc = null;
            try {
                if (r != null) {
                    ((Reader)r).close();
                }
            }
            catch (IOException ex) {
                exc = ex;
            }
            if (err != null) {
                ((Reader)err).close();
            }
            if (exc != null) {
                throw exc;
            }
        }
    }

    static String commandOutput(Reader r) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = r.read()) > 0) {
            if (c == 13) continue;
            sb.append((char)c);
        }
        return sb.toString();
    }

    static String formatTimestamp(Date timestamp) {
        if (timestamp == null) {
            return "[No timestamp]";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(timestamp);
    }

    static Date parseTimestamp(String timestamp) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return df.parse(timestamp);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }
}

