/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class ShorterPaths
extends Task {
    private List<Replacement> replacements = new LinkedList<Replacement>();
    private Path in;
    String out;
    String extraLibs;
    File extraLibsDir;
    File testProperties;

    public Replacement createReplacement() {
        Replacement r = new Replacement();
        this.replacements.add(r);
        return r;
    }

    public void addReplacement(Replacement r) {
        this.replacements.add(r);
    }

    public void setIn(Path p) {
        if (this.in == null) {
            this.in = p.createPath();
        }
        this.in.append(p);
    }

    public Path createIn() {
        if (this.in == null) {
            this.in = new Path(this.getProject());
        }
        return this.in;
    }

    public void setinRef(Reference r) {
        this.createIn().setRefid(r);
    }

    public void setOut(String out) {
        this.out = out;
    }

    public void setExtraLibs(String extraLibs) {
        this.extraLibs = extraLibs;
    }

    public void setExtraLibsDir(File extraLibsDir) {
        this.extraLibsDir = extraLibsDir;
    }

    public void setTestProperties(File testProperties) {
        this.testProperties = testProperties;
    }

    public void execute() throws BuildException {
        String[] paths = this.in.list();
        StringBuffer nbLibBuff = new StringBuffer();
        StringBuffer externalLibBuf = new StringBuffer();
        try {
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                File file = new File(path);
                if (file.exists()) {
                    path = file.getCanonicalPath();
                    this.simplyPath(path, externalLibBuf, nbLibBuff);
                    continue;
                }
                this.log("Path element " + file + " doesn't exist.", 3);
            }
            if (this.out != null) {
                this.define(this.out, nbLibBuff.toString());
            }
            if (this.extraLibs != null) {
                this.define(this.extraLibs, externalLibBuf.toString());
            }
            if (this.testProperties != null) {
                PrintWriter pw = new PrintWriter(this.testProperties);
                Hashtable properties = this.getProject().getProperties();
                StringBuffer outProp = new StringBuffer();
                for (String name : properties.keySet()) {
                    if (name.matches("test-(unit|qa-functional)-sys-prop\\..+")) {
                        if (name.equals("test-unit-sys-prop.xtest.data")) continue;
                        outProp.setLength(0);
                        StringTokenizer tokenizer = new StringTokenizer(properties.get(name).toString(), ":;");
                        String nextToken = null;
                        while (nextToken != null || tokenizer.hasMoreTokens()) {
                            String path;
                            String token = nextToken;
                            nextToken = null;
                            if (token == null) {
                                token = tokenizer.nextToken();
                            }
                            if (tokenizer.hasMoreTokens()) {
                                nextToken = tokenizer.nextToken();
                            }
                            if (new File(path = token + ":" + nextToken).exists()) {
                                nextToken = null;
                            } else {
                                path = token;
                            }
                            this.simplyPath(path, externalLibBuf, outProp);
                        }
                        pw.println(name.replaceFirst("^test-(unit|qa-functional)-sys-prop\\.", "test-sys-prop.") + "=" + outProp);
                        continue;
                    }
                    if (!name.startsWith("test.config")) continue;
                    pw.println(name + "=" + properties.get(name));
                }
                pw.println("extra.test.libs=" + externalLibBuf.toString());
                pw.println("test.run.cp=" + nbLibBuff.toString());
                pw.close();
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void simplyPath(String path, StringBuffer externalLibBuf, StringBuffer nbLibBuff) throws IOException {
        boolean bAppend = false;
        File file = new File(path);
        if (file.exists()) {
            String fName;
            path = file.getAbsolutePath();
            for (Replacement repl : this.replacements) {
                String dirCan = repl.dir.getCanonicalPath();
                if (!path.startsWith(dirCan)) continue;
                if (nbLibBuff.length() > 0) {
                    nbLibBuff.append(":\\\n");
                }
                nbLibBuff.append("${" + repl.name + "}");
                nbLibBuff.append(path.substring(dirCan.length()).replace(File.separatorChar, '/'));
                bAppend = true;
                break;
            }
            if (!bAppend && (fName = this.copyExtraLib(file)) != null) {
                if (externalLibBuf.length() > 0) {
                    externalLibBuf.append(":\\\n");
                }
                externalLibBuf.append("${extra.test.libs.dir}/" + fName);
            }
        } else {
            if (nbLibBuff.length() > 0) {
                nbLibBuff.append(":\\\n");
            }
            nbLibBuff.append(path);
        }
    }

    private void define(String prop, String val) {
        this.log("Setting " + prop + "=" + val, 3);
        String old = this.getProject().getProperty(prop);
        if (old != null && !old.equals(val)) {
            this.getProject().log("Warning: " + prop + " was already set to " + old, 1);
        }
        this.getProject().setNewProperty(prop, val);
    }

    private String copyExtraLib(File file) throws IOException {
        String name = null;
        if (this.extraLibsDir != null && this.extraLibsDir.isDirectory() && file.isFile()) {
            this.log("Copying " + file + " to extralibs despite " + this.replacements);
            name = file.getName();
            byte[] buff = new byte[100000];
            FileInputStream fis = new FileInputStream(file);
            FileOutputStream fos = new FileOutputStream(new File(this.extraLibsDir, name));
            int size = 0;
            while ((size = fis.read(buff)) > 0) {
                fos.write(buff, 0, size);
            }
            fos.close();
            fis.close();
        }
        return name;
    }

    public static class Replacement {
        String name;
        File dir;

        public void setName(String name) {
            this.name = name;
        }

        public void setDir(File dir) {
            this.dir = dir;
        }

        public String toString() {
            return this.dir + " => ${" + this.name + "}";
        }
    }
}

