/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector.common;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.inspector.InspectorFolderPresenter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class RenameAction
extends SystemAction
implements ActionContext {
    public static final String DISPLAY_NAME = NbBundle.getMessage(RenameAction.class, (String)"NAME_RenameAction");
    private NotifyDescriptor.InputLine descriptor;
    private boolean canRename;
    private WeakReference<DesignComponent> component;

    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RenameAction.this.component == null) {
                    return;
                }
                final DesignComponent c = (DesignComponent)RenameAction.this.component.get();
                if (c == null) {
                    return;
                }
                c.getDocument().getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        InfoPresenter presenter = (InfoPresenter)c.getPresenter(InfoPresenter.class);
                        if (presenter == null) {
                            Debug.warning((Object[])new Object[]{"No necessary presenter for this operation - component: " + c});
                            return;
                        }
                        RenameAction.this.getDialogDescriptor().setInputText(presenter.getEditableName());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)RenameAction.this.getDialogDescriptor());
                        if ((Integer)RenameAction.this.descriptor.getValue() == 0 && RenameAction.this.descriptor.getInputText().trim().length() > 0) {
                            presenter.setEditableName(RenameAction.this.descriptor.getInputText().trim());
                        }
                    }
                });
            }
        });
    }

    private NotifyDescriptor.InputLine getDialogDescriptor() {
        if (this.descriptor != null) {
            return this.descriptor;
        }
        this.descriptor = new NotifyDescriptor.InputLine(NbBundle.getMessage(RenameAction.class, (String)"TITLE_RenameQuestion"), NbBundle.getMessage(RenameAction.class, (String)"TITLE_RenameDialog"));
        return this.descriptor;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled() {
        if (this.component == null) {
            return false;
        }
        final DesignComponent c = (DesignComponent)this.component.get();
        if (c == null) {
            return false;
        }
        c.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                if (c.getDocument().getSelectedComponents().size() > 1) {
                    RenameAction.this.canRename = false;
                    return;
                }
                InspectorFolderPresenter presenter = (InspectorFolderPresenter)c.getPresenter(InspectorFolderPresenter.class);
                if (presenter != null) {
                    RenameAction.this.canRename = presenter.getFolder().canRename();
                } else {
                    RenameAction.this.canRename = false;
                }
            }
        });
        return this.canRename;
    }

    public String getName() {
        return DISPLAY_NAME;
    }

    public void setComponent(DesignComponent component) {
        this.component = new WeakReference<DesignComponent>(component);
    }
}

