/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.parser;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.parser.CssParserTreeConstants;
import org.netbeans.modules.css.parser.Node;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.Token;

public class SimpleNodeUtil {
    public static OffsetRange getTrimmedNodeRange(SimpleNode node) {
        int to_diff;
        int from_diff;
        String text = node.image();
        for (from_diff = 0; from_diff < text.length() && Character.isWhitespace(text.charAt(from_diff)); ++from_diff) {
        }
        for (to_diff = 0; to_diff < text.length() - from_diff && Character.isWhitespace(text.charAt(text.length() - 1 - to_diff)); ++to_diff) {
        }
        return new OffsetRange(node.startOffset() + from_diff, node.endOffset() - to_diff);
    }

    public static Token getNodeToken(SimpleNode node, int tokenKind) {
        Token t = node.jjtGetFirstToken();
        if (t == null) {
            return null;
        }
        do {
            if (t.kind != tokenKind) continue;
            return t;
        } while ((t = t.next) != node.jjtGetLastToken());
        return null;
    }

    public static SimpleNode findDescendant(SimpleNode node, int astOffset) {
        int so = node.startOffset();
        int eo = node.endOffset();
        if (astOffset < so || astOffset > eo) {
            return null;
        }
        if (astOffset >= so && astOffset <= eo && node.jjtGetNumChildren() == 0) {
            return node;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(i);
            int ch_so = child.startOffset();
            int ch_eo = child.endOffset();
            if (astOffset < ch_so || astOffset > ch_eo) continue;
            return SimpleNodeUtil.findDescendant(child, astOffset);
        }
        return node;
    }

    public static SimpleNode getChildByType(SimpleNode node, int kind) {
        SimpleNode[] children = SimpleNodeUtil.getChildrenByType(node, kind);
        return children.length == 0 ? null : children[0];
    }

    public static SimpleNode getAncestorByType(SimpleNode node, final int kind) {
        final AtomicReference found = new AtomicReference();
        SimpleNodeUtil.visitAncestors(node, new NodeVisitor(){

            @Override
            public void visit(SimpleNode node) {
                if (found.get() == null && node.kind() == kind) {
                    found.set(node);
                }
            }
        });
        return (SimpleNode)found.get();
    }

    public static SimpleNode[] getChildrenByType(SimpleNode node, int kind) {
        int childrenCount = node.jjtGetNumChildren();
        if (childrenCount == 0) {
            return new SimpleNode[0];
        }
        ArrayList<SimpleNode> list = new ArrayList<SimpleNode>(childrenCount / 4);
        for (int i = 0; i < childrenCount; ++i) {
            SimpleNode child = (SimpleNode)node.children[i];
            if (child.kind() != kind) continue;
            list.add(child);
        }
        return list.toArray(new SimpleNode[0]);
    }

    public static void visitChildren(SimpleNode node, NodeVisitor visitor) {
        Node[] children = node.children;
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                SimpleNode n = (SimpleNode)children[i];
                if (n == null) continue;
                visitor.visit(n);
                n.visitChildren(visitor);
            }
        }
    }

    public static void visitAncestors(SimpleNode node, NodeVisitor visitor) {
        SimpleNode parent = (SimpleNode)node.parent;
        if (parent != null) {
            visitor.visit(parent);
            SimpleNodeUtil.visitAncestors(parent, visitor);
        }
    }

    public static SimpleNode getSibling(SimpleNode node, boolean before) {
        SimpleNode parent = (SimpleNode)node.jjtGetParent();
        if (parent == null) {
            return null;
        }
        if (parent.children == null) {
            return null;
        }
        SimpleNode sibling = null;
        for (int i = 0; i < parent.children.length; ++i) {
            SimpleNode child = (SimpleNode)parent.children[i];
            if (child != node) continue;
            if (before) {
                if (i == 0) {
                    return null;
                }
                return (SimpleNode)parent.children[i - 1];
            }
            if (i == parent.children.length - 1) {
                return null;
            }
            return (SimpleNode)parent.children[i + 1];
        }
        return sibling;
    }

    public static SimpleNode query(SimpleNode base, String path) {
        StringTokenizer st = new StringTokenizer(path, "/");
        SimpleNode found = base;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int indexDelim = token.indexOf(124);
            String nodeName = indexDelim >= 0 ? token.substring(0, indexDelim) : token;
            String sindex = indexDelim >= 0 ? token.substring(indexDelim + 1, token.length()) : "0";
            int index = Integer.parseInt(sindex);
            int count = 0;
            SimpleNode foundLocal = null;
            if (found.children != null) {
                for (Node _child : found.children) {
                    SimpleNode child = (SimpleNode)_child;
                    if (!CssParserTreeConstants.jjtNodeName[child.kind()].equals(nodeName) || count++ != index) continue;
                    foundLocal = child;
                    break;
                }
            }
            if (foundLocal != null) {
                found = foundLocal;
                if (st.hasMoreTokens()) continue;
                assert (CssParserTreeConstants.jjtNodeName[found.kind()].equals(nodeName));
                return found;
            }
            return null;
        }
        return null;
    }

    public static String getNodeImage(SimpleNode node) {
        String image;
        switch (node.kind()) {
            case 35: {
                image = node.image(4, 1);
                break;
            }
            default: {
                image = node.image();
            }
        }
        return image;
    }
}

