/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongMap;

class DominatorTree {
    private static final int BUFFER_SIZE = 8192;
    private HprofHeap heap;
    private LongBuffer multipleParents;
    private LongBuffer revertedMultipleParents;
    private LongBuffer currentMultipleParents;
    private Map map;
    private Set dirtySet = Collections.EMPTY_SET;
    private Map nearestGCRootCache = new NearestGCRootCache(400000);

    DominatorTree(HprofHeap h, LongBuffer multiParents) {
        this.heap = h;
        this.currentMultipleParents = this.multipleParents = multiParents;
        this.map = new HashMap(multiParents.getSize());
        try {
            this.revertedMultipleParents = multiParents.revertBuffer();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.getLocalizedMessage(), ex);
        }
    }

    synchronized void computeDominators() {
        boolean changed = true;
        try {
            boolean igonoreDirty;
            do {
                this.currentMultipleParents.rewind();
                igonoreDirty = !changed;
                changed = this.computeOneLevel(igonoreDirty);
                this.switchParents();
            } while (changed || !igonoreDirty);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.deleteBuffers();
        this.nearestGCRootCache = null;
        this.dirtySet = Collections.EMPTY_SET;
    }

    private boolean computeOneLevel(boolean ignoreDirty) throws IOException {
        long instanceId;
        boolean changed = false;
        HashSet<Long> newDirtySet = new HashSet<Long>(this.map.size() / 10);
        while ((instanceId = this.readLong()) != 0L) {
            Long instanceIdObj = new Long(instanceId);
            Long oldIdomObj = (Long)this.map.get(instanceIdObj);
            if (oldIdomObj != null && (oldIdomObj == 0L || !ignoreDirty && !this.dirtySet.contains(oldIdomObj))) continue;
            LongMap.Entry entry = this.heap.idToOffsetMap.get(instanceId);
            List refs = entry.getReferences();
            Iterator refIt = refs.iterator();
            Long newIdomIdObj = (Long)refIt.next();
            boolean dirty = false;
            while (refIt.hasNext() && newIdomIdObj != 0L) {
                Long refIdObj = (Long)refIt.next();
                newIdomIdObj = this.intersect(newIdomIdObj, refIdObj);
            }
            if (oldIdomObj == null) {
                this.map.put(instanceIdObj, newIdomIdObj);
                newDirtySet.add(newIdomIdObj);
                changed = true;
                continue;
            }
            if (oldIdomObj.longValue() == newIdomIdObj.longValue()) continue;
            newDirtySet.add(oldIdomObj);
            newDirtySet.add(newIdomIdObj);
            this.map.put(instanceIdObj, newIdomIdObj);
            changed = true;
        }
        this.dirtySet = newDirtySet;
        return changed;
    }

    private void deleteBuffers() {
        this.multipleParents.delete();
        this.revertedMultipleParents.delete();
    }

    private long readLong() throws IOException {
        return this.currentMultipleParents.readLong();
    }

    long getIdomId(long instanceId, LongMap.Entry entry) {
        Long idomEntry = (Long)this.map.get(new Long(instanceId));
        if (idomEntry != null) {
            return idomEntry;
        }
        if (entry == null) {
            entry = this.heap.idToOffsetMap.get(instanceId);
        }
        return entry.getNearestGCRootPointer();
    }

    private Long getNearestGCRootPointer(Long instanceIdLong) {
        Long nearestGCLong = (Long)this.nearestGCRootCache.get(instanceIdLong);
        if (nearestGCLong != null) {
            return nearestGCLong;
        }
        LongMap.Entry entry = this.heap.idToOffsetMap.get(instanceIdLong);
        Long nearestGC = entry.getNearestGCRootPointer();
        this.nearestGCRootCache.put(instanceIdLong, nearestGC);
        return nearestGC;
    }

    private Long getIdomId(Long instanceIdLong) {
        Long idomObj = (Long)this.map.get(instanceIdLong);
        if (idomObj != null) {
            return idomObj;
        }
        return this.getNearestGCRootPointer(instanceIdLong);
    }

    private Long intersect(Long idomIdObj, Long refIdObj) {
        if (idomIdObj.longValue() == refIdObj.longValue()) {
            return idomIdObj;
        }
        if (idomIdObj == 0L || refIdObj == 0L) {
            return 0L;
        }
        HashSet<Long> leftIdoms = new HashSet<Long>(200);
        HashSet<Long> rightIdoms = new HashSet<Long>(200);
        Long leftIdomObj = idomIdObj;
        Long rightIdomObj = refIdObj;
        leftIdoms.add(leftIdomObj);
        rightIdoms.add(rightIdomObj);
        while (true) {
            if (leftIdomObj != 0L) {
                if (rightIdoms.contains(leftIdomObj = this.getIdomId(leftIdomObj))) {
                    return leftIdomObj;
                }
                leftIdoms.add(leftIdomObj);
            }
            if (rightIdomObj == 0L) continue;
            if (leftIdoms.contains(rightIdomObj = this.getIdomId(rightIdomObj))) {
                return rightIdomObj;
            }
            rightIdoms.add(rightIdomObj);
        }
    }

    private void switchParents() {
        this.currentMultipleParents = this.currentMultipleParents == this.revertedMultipleParents ? this.multipleParents : this.revertedMultipleParents;
    }

    private static final class NearestGCRootCache
    extends LinkedHashMap {
        private final int maxSize;

        private NearestGCRootCache(int size) {
            super(size, 0.75f, true);
            this.maxSize = size;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }
    }
}

