/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.samples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.modules.j2ee.samples.JavaEESamplesWizardIterator;
import org.netbeans.modules.j2ee.samples.JavaEESamplesWizardPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DatabaseUsingSampleWizardIterator
extends JavaEESamplesWizardIterator {
    private static final String DB_RES_FILE = "CustomerCMP-ejb/setup/derby_netPool.sun-resource";

    @Override
    protected WizardDescriptor.Panel[] createPanels() {
        boolean specifyPrjName = "web".equals(Templates.getTemplate((WizardDescriptor)this.wiz).getAttribute("prjType"));
        return new WizardDescriptor.Panel[]{new JavaEESamplesWizardPanel(true, specifyPrjName)};
    }

    @Override
    public Set<FileObject> instantiate() throws IOException {
        String dbName = (String)this.wiz.getProperty("dbName");
        try {
            DerbyDatabases.createDatabase((String)dbName, (String)"app", (String)"app");
        }
        catch (IllegalStateException ex) {
            throw new RuntimeException(ex);
        }
        catch (DatabaseException ex) {
            throw new RuntimeException(ex);
        }
        Set<FileObject> r = super.instantiate();
        File projectDir = (File)this.wiz.getProperty("projdir");
        File dbResource = new File(projectDir, DB_RES_FILE);
        this.updateDBResource(dbResource, dbName);
        return r;
    }

    public static DatabaseUsingSampleWizardIterator createIterator() {
        return new DatabaseUsingSampleWizardIterator();
    }

    private void updateDBResource(File dbResource, String dbName) throws IOException {
        String xPathPath = "/resources/jdbc-connection-pool/property[@name='DatabaseName']/@value";
        DatabaseUsingSampleWizardIterator.setValueInXMLFile(dbResource, xPathPath, dbName);
    }

    private static void setValueInXMLFile(File srcFile, String xPathPath, String value) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(srcFile);
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node node = (Node)xPath.evaluate(xPathPath, document, XPathConstants.NODE);
            node.setTextContent(value);
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer aTransformer = tranFactory.newTransformer();
            DOMSource src = new DOMSource(document);
            FileOutputStream fos = new FileOutputStream(srcFile);
            StreamResult dest = new StreamResult(fos);
            aTransformer.transform(src, dest);
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

