/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Util;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public abstract class InputDialog
extends JDialog
implements HelpCtx.Provider {
    public static final int CANCEL_OPTION = 0;
    public static final int OK_OPTION = 1;
    public static final int HELP_OPTION = 2;
    private final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private int chosenOption;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton helpButton;
    private JPanel messagePanel;
    private List errorList;
    private List warningList;

    public InputDialog(JPanel panel, String title) {
        this(panel, title, false, false);
    }

    public InputDialog(JPanel panel, String title, boolean showRequiredNote) {
        this(panel, title, showRequiredNote, false);
    }

    public InputDialog(JPanel panel, String title, boolean showRequiredNote, boolean resizeMsg) {
        super(InputDialog.getFrame(panel), title, true);
        Object buttonPanelConstraints;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                InputDialog.this.chosenOption = 0;
            }
        });
        if (!resizeMsg) {
            this.getContentPane().setLayout(new BorderLayout());
            buttonPanelConstraints = "South";
        } else {
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 15;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            buttonPanelConstraints = constraints;
        }
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.messagePanel = new JPanel();
        this.messagePanel.setLayout(new GridBagLayout());
        this.messagePanel.getAccessibleContext().setAccessibleName(this.bundle.getString("ACSN_ErrorTextArea"));
        this.messagePanel.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_ErrorTextArea"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 12, 5, 11);
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.messagePanel, gridBagConstraints);
        if (showRequiredNote) {
            JLabel requiredNote = new JLabel();
            requiredNote.setText(this.bundle.getString("LBL_RequiredMessage"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(6, 12, 11, 5);
            gridBagConstraints.anchor = 16;
            this.buttonPanel.add((Component)requiredNote, gridBagConstraints);
        }
        this.okButton = new JButton(this.bundle.getString("LBL_OK"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 11, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputDialog.this.chosenOption = 1;
                InputDialog.this.actionOk();
            }
        });
        this.okButton.getAccessibleContext().setAccessibleName(this.bundle.getString("ACSN_OK"));
        this.okButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_OK"));
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        JButton cancelButton = new JButton(this.bundle.getString("LBL_Cancel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 0, 11, 5);
        gridBagConstraints.anchor = 13;
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputDialog.this.chosenOption = 0;
                InputDialog.this.actionCancel();
            }
        });
        cancelButton.getAccessibleContext().setAccessibleName(this.bundle.getString("ACSN_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_Cancel"));
        this.buttonPanel.add((Component)cancelButton, gridBagConstraints);
        this.helpButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.helpButton, (String)this.bundle.getString("LBL_Help"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(6, 0, 11, 11);
        gridBagConstraints.anchor = 13;
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputDialog.this.chosenOption = 2;
                InputDialog.this.actionHelp();
            }
        });
        this.helpButton.getAccessibleContext().setAccessibleName(this.bundle.getString("ACSN_Help"));
        this.helpButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_Help"));
        this.buttonPanel.add((Component)this.helpButton, gridBagConstraints);
        this.getContentPane().add((Component)this.buttonPanel, buttonPanelConstraints);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public int display() {
        this.setVisible(true);
        return this.chosenOption;
    }

    protected void actionOk() {
        super.dispose();
    }

    protected void actionCancel() {
        super.dispose();
    }

    protected void actionHelp() {
        Utils.invokeHelp(this.getHelpId());
    }

    protected abstract String getHelpId();

    public static Frame getFrame(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    protected void setLocationInside(JPanel panel) {
        Rectangle rect = this.getBounds();
        int width = rect.width;
        int height = rect.height;
        Rectangle panelRect = panel.getBounds();
        if (width > panelRect.width || height > panelRect.height) {
            this.setLocationRelativeTo(panel);
        } else {
            Point location = panel.getLocationOnScreen();
            this.setLocation(location.x + (panelRect.width - width) / 2, location.y + (panelRect.height - height) / 2);
        }
    }

    protected void setOkEnabled(boolean flag) {
        this.okButton.setEnabled(flag);
    }

    public void showErrors() {
        GridBagConstraints constraints;
        JLabel label;
        String message;
        Iterator iter;
        boolean hasErrors = false;
        this.messagePanel.removeAll();
        if (this.warningList != null && this.warningList.size() > 0) {
            iter = this.warningList.iterator();
            while (iter.hasNext()) {
                message = iter.next().toString();
                label = new JLabel();
                label.setIcon(Util.warningMessageIcon);
                label.setText("<html>" + message + "</html>");
                label.getAccessibleContext().setAccessibleName(this.bundle.getString("ASCN_WarningMessage"));
                label.getAccessibleContext().setAccessibleDescription(message);
                label.setForeground(Util.getWarningForegroundColor());
                constraints = new GridBagConstraints();
                constraints.gridwidth = 0;
                constraints.fill = 2;
                constraints.weightx = 1.0;
                this.messagePanel.add((Component)label, constraints);
            }
        }
        if (this.errorList != null && this.errorList.size() > 0) {
            hasErrors = true;
            iter = this.errorList.iterator();
            while (iter.hasNext()) {
                message = iter.next().toString();
                label = new JLabel();
                label.setIcon(Util.errorMessageIcon);
                label.setText("<html>" + message + "</html>");
                label.getAccessibleContext().setAccessibleName(this.bundle.getString("ASCN_ErrorMessage"));
                label.getAccessibleContext().setAccessibleDescription(message);
                label.setForeground(Util.getErrorForegroundColor());
                constraints = new GridBagConstraints();
                constraints.gridwidth = 0;
                constraints.fill = 2;
                constraints.weightx = 1.0;
                this.messagePanel.add((Component)label, constraints);
            }
        }
        this.pack();
        this.setOkEnabled(!hasErrors);
    }

    protected void setErrors(Collection errors, Collection warnings) {
        this.warningList = new ArrayList(warnings);
        this.errorList = new ArrayList(errors);
        this.showErrors();
    }

    protected void setErrors(Collection errors) {
        this.setErrors(errors, Collections.EMPTY_LIST);
    }

    public void addWarning(String warning) {
        if (this.warningList == null) {
            this.warningList = new ArrayList();
        }
        this.warningList.add(warning);
        this.showErrors();
    }

    protected void addWarnings(Collection warnings) {
        if (this.warningList == null) {
            this.warningList = new ArrayList(warnings);
        } else {
            this.warningList.addAll(warnings);
        }
        this.showErrors();
    }

    public void addError(String error) {
        if (this.errorList == null) {
            this.errorList = new ArrayList();
        }
        this.errorList.add(error);
        this.showErrors();
    }

    protected void addErrors(Collection errors) {
        if (this.errorList == null) {
            this.errorList = new ArrayList(errors);
        } else {
            this.errorList.addAll(errors);
        }
        this.showErrors();
    }

    protected void clearErrors() {
        this.warningList = null;
        this.errorList = null;
        this.showErrors();
    }

    public boolean hasErrors() {
        boolean result = false;
        if (this.errorList != null && this.errorList.size() > 0) {
            result = true;
        }
        return result;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getHelpId());
    }

    protected void setButtonPanelPreferredSize(Dimension dimension) {
        this.buttonPanel.setMinimumSize(dimension);
        this.buttonPanel.setPreferredSize(dimension);
    }
}

