/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.ui.views.VariablesViewButtons;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.SessionProvider;
import org.netbeans.spi.viewmodel.AsynchronousModelFilter;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Model;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TableRendererModel;
import org.netbeans.spi.viewmodel.TableRendererModelFilter;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeExpansionModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class ViewModelListener
extends DebuggerManagerAdapter {
    private String viewType;
    private JComponent view;
    private JComponent buttonsPane;
    private List models = new ArrayList(11);
    private List hyperModels;
    private List<? extends SessionProvider> sessionProviders;
    private Session currentSession;
    private List treeModels;
    private List treeModelFilters;
    private List treeExpansionModels;
    private List treeExpansionModelFilters;
    private List nodeModels;
    private List nodeModelFilters;
    private List tableModels;
    private List tableModelFilters;
    private List nodeActionsProviders;
    private List nodeActionsProviderFilters;
    private List columnModels;
    private List mm;
    private List asynchModelFilters;
    private List tableRenderers;
    private List tableRendererFilters;
    private List<AbstractButton> buttons;
    private JTabbedPane tabbedPane;
    private Image viewIcon;
    private SessionProvider providerToDisplay;
    private List<ViewModelListener> subListeners = new ArrayList<ViewModelListener>();
    private Preferences preferences = NbPreferences.forModule(ContextProvider.class).node("variables_view");
    private ViewPreferenceChangeListener prefListener = new ViewPreferenceChangeListener();
    private String propertiesHelpID = null;

    ViewModelListener(String viewType, JComponent view, JComponent buttonsPane, String propertiesHelpID, Image viewIcon) {
        this.viewType = viewType;
        this.view = view;
        this.buttonsPane = buttonsPane;
        this.propertiesHelpID = propertiesHelpID;
        this.viewIcon = viewIcon;
        this.setUp();
    }

    void setUp() {
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        this.preferences.addPreferenceChangeListener(this.prefListener);
        this.updateModel();
    }

    synchronized void destroy() {
        JComponent tree;
        boolean haveModels;
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        this.preferences.removePreferenceChangeListener(this.prefListener);
        boolean bl = haveModels = this.treeModels.size() > 0 || this.nodeModels.size() > 0 || this.tableModels.size() > 0;
        if (haveModels && this.view.getComponentCount() > 0 && !((tree = (JComponent)this.view.getComponent(0)) instanceof JTabbedPane)) {
            Models.setModelsToView((JComponent)tree, null);
        }
        this.models.clear();
        this.treeModels = null;
        this.treeModelFilters = null;
        this.treeExpansionModels = null;
        this.treeExpansionModelFilters = null;
        this.nodeModels = null;
        this.nodeModelFilters = null;
        this.tableModels = null;
        this.tableModelFilters = null;
        this.nodeActionsProviders = null;
        this.nodeActionsProviderFilters = null;
        this.columnModels = null;
        this.mm = null;
        this.asynchModelFilters = null;
        this.sessionProviders = null;
        this.currentSession = null;
        this.providerToDisplay = null;
        this.buttonsPane.removeAll();
        this.buttons = null;
        this.view.removeAll();
        for (ViewModelListener l : this.subListeners) {
            l.destroy();
        }
        this.subListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getNewValue() != null) {
            ViewModelListener viewModelListener = this;
            synchronized (viewModelListener) {
                this.providerToDisplay = null;
            }
        }
        this.updateModel();
    }

    private synchronized void updateModel() {
        String viewPath;
        DebuggerManager cp;
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        DebuggerEngine e = dm.getCurrentEngine();
        this.sessionProviders = e == null ? dm.lookup(this.viewType, SessionProvider.class) : DebuggerManager.join((ContextProvider)e, (ContextProvider)dm).lookup(this.viewType, SessionProvider.class);
        if (!this.sessionProviders.contains(this.providerToDisplay)) {
            this.providerToDisplay = null;
        }
        if (e == null && this.providerToDisplay == null && this.sessionProviders.size() > 0) {
            this.providerToDisplay = this.sessionProviders.get(0);
        }
        if (this.providerToDisplay != null) {
            e = null;
            cp = dm;
            viewPath = this.viewType + "/" + this.providerToDisplay.getTypeID();
        } else {
            cp = e != null ? DebuggerManager.join((ContextProvider)e, (ContextProvider)dm) : dm;
            viewPath = this.viewType;
        }
        this.currentSession = dm.getCurrentSession();
        this.treeModels = cp.lookup(viewPath, TreeModel.class);
        this.treeModelFilters = cp.lookup(viewPath, TreeModelFilter.class);
        this.treeExpansionModels = cp.lookup(viewPath, TreeExpansionModel.class);
        this.treeExpansionModelFilters = cp.lookup(this.viewType, TreeExpansionModelFilter.class);
        this.nodeModels = cp.lookup(viewPath, NodeModel.class);
        this.nodeModelFilters = cp.lookup(viewPath, NodeModelFilter.class);
        this.tableModels = cp.lookup(viewPath, TableModel.class);
        this.tableModelFilters = cp.lookup(viewPath, TableModelFilter.class);
        this.nodeActionsProviders = cp.lookup(viewPath, NodeActionsProvider.class);
        this.nodeActionsProviderFilters = cp.lookup(viewPath, NodeActionsProviderFilter.class);
        this.columnModels = cp.lookup(viewPath, ColumnModel.class);
        this.mm = cp.lookup(viewPath, Model.class);
        this.asynchModelFilters = cp.lookup(viewPath, AsynchronousModelFilter.class);
        this.tableRenderers = cp.lookup(viewPath, TableRendererModel.class);
        this.tableRendererFilters = cp.lookup(viewPath, TableRendererModelFilter.class);
        String searchPath = viewPath;
        while (this.asynchModelFilters.isEmpty() && searchPath != null) {
            int i = searchPath.lastIndexOf(47);
            searchPath = i > 0 ? searchPath.substring(0, i) : null;
            this.asynchModelFilters = cp.lookup(searchPath, AsynchronousModelFilter.class);
        }
        if ("LocalsView".equals(this.viewType) && (VariablesViewButtons.isResultsViewNested() || VariablesViewButtons.isWatchesViewNested())) {
            this.hyperModels = new ArrayList();
            if (VariablesViewButtons.isResultsViewNested()) {
                this.hyperModels.add(this.createCompound("ResultsView"));
            }
            if (VariablesViewButtons.isWatchesViewNested()) {
                this.hyperModels.add(this.createCompound("WatchesView"));
            }
            Models.CompoundModel main = this.createCompound("LocalsView");
            this.hyperModels.add(main);
            this.hyperModels.add(main);
            this.hyperModels.add(new TreeModelFilter(){

                public Object getRoot(TreeModel original) {
                    return original.getRoot();
                }

                public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
                    Object[] ch = original.getChildren(parent, from, to);
                    if (ch != null) {
                        for (int x = 0; x < ch.length; ++x) {
                            if (!"HistoryNode".equals(ch[x].getClass().getSimpleName())) continue;
                            Object[] nch = new Object[ch.length - 1];
                            System.arraycopy(ch, 0, nch, 0, x);
                            if (x + 1 < ch.length) {
                                System.arraycopy(ch, x + 1, nch, x, ch.length - x - 1);
                            }
                            ch = nch;
                        }
                    }
                    return ch;
                }

                public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
                    return original.getChildrenCount(node);
                }

                public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
                    return false;
                }

                public void addModelListener(ModelListener l) {
                }

                public void removeModelListener(ModelListener l) {
                }
            });
        } else {
            this.hyperModels = null;
        }
        List bList = cp.lookup(viewPath, AbstractButton.class);
        this.buttons = new ArrayList<AbstractButton>();
        ArrayList<AbstractButton> tempList = new ArrayList<AbstractButton>();
        for (AbstractButton b : bList) {
            if (b instanceof JToggleButton) {
                this.buttons.add(b);
                continue;
            }
            tempList.add(b);
        }
        this.buttons.addAll(tempList);
        this.tabbedPane = (JTabbedPane)cp.lookupFirst(viewPath, JTabbedPane.class);
        ModelsChangeRefresher mcr = new ModelsChangeRefresher();
        Customizer[] modelListCustomizers = new Customizer[]{(Customizer)((Object)this.treeModels), (Customizer)((Object)this.treeModelFilters), (Customizer)((Object)this.treeExpansionModels), (Customizer)((Object)this.treeExpansionModelFilters), (Customizer)((Object)this.nodeModels), (Customizer)((Object)this.nodeModelFilters), (Customizer)((Object)this.tableModels), (Customizer)((Object)this.tableModelFilters), (Customizer)((Object)this.nodeActionsProviders), (Customizer)((Object)this.nodeActionsProviderFilters), (Customizer)((Object)this.columnModels), (Customizer)((Object)this.mm), (Customizer)((Object)this.asynchModelFilters), (Customizer)((Object)this.tableRenderers), (Customizer)((Object)this.tableRendererFilters)};
        for (int i = 0; i < modelListCustomizers.length; ++i) {
            Customizer c = modelListCustomizers[i];
            if (c == null) continue;
            c.addPropertyChangeListener(mcr);
            c.setObject("load first");
            c.setObject("unload last");
        }
        this.refreshModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshModel() {
        boolean haveModels;
        JPanel buttonsSubPane;
        this.models.clear();
        if (this.treeModels == null) {
            return;
        }
        List list = this.treeModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.treeModels));
        }
        list = this.treeModelFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.treeModelFilters));
        }
        list = this.treeExpansionModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.treeExpansionModels));
        }
        list = this.nodeModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.nodeModels));
        }
        list = this.nodeModelFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.nodeModelFilters));
        }
        list = this.tableModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.tableModels));
        }
        list = this.tableModelFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.tableModelFilters));
        }
        list = this.nodeActionsProviders;
        synchronized (list) {
            this.models.add(new ArrayList(this.nodeActionsProviders));
        }
        list = this.nodeActionsProviderFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.nodeActionsProviderFilters));
        }
        list = this.columnModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.columnModels));
        }
        list = this.mm;
        synchronized (list) {
            this.models.add(new ArrayList(this.mm));
        }
        list = this.treeExpansionModelFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.treeExpansionModelFilters));
        }
        list = this.asynchModelFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.asynchModelFilters));
        }
        list = this.tableRenderers;
        synchronized (list) {
            this.models.add(new ArrayList(this.tableRenderers));
        }
        list = this.tableRendererFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.tableRendererFilters));
        }
        List<AbstractButton> list2 = this.buttons;
        synchronized (list2) {
            this.buttonsPane.removeAll();
            if (this.buttons.size() == 0 && this.sessionProviders.size() == 0) {
                this.buttonsPane.setVisible(false);
                buttonsSubPane = null;
            } else {
                this.buttonsPane.setVisible(true);
                int i = 0;
                if (this.sessionProviders.size() > 0) {
                    JButton b = this.createSessionsSwitchButton();
                    GridBagConstraints c = new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0);
                    this.buttonsPane.add((Component)b, c);
                    JSeparator s = new JSeparator(0);
                    c = new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 5, 0), 0, 0);
                    this.buttonsPane.add((Component)s, c);
                    ++i;
                }
                if (this.tabbedPane != null) {
                    buttonsSubPane = new JPanel();
                    buttonsSubPane.setLayout(new GridBagLayout());
                    GridBagConstraints c = new GridBagConstraints(0, i, 1, 1, 0.0, 1.0, 11, 3, new Insets(5, 0, 5, 0), 0, 0);
                    this.buttonsPane.add((Component)buttonsSubPane, c);
                    ++i;
                } else {
                    buttonsSubPane = null;
                    for (AbstractButton b : this.buttons) {
                        GridBagConstraints c = new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0);
                        this.buttonsPane.add((Component)b, c);
                        ++i;
                    }
                }
            }
        }
        boolean bl = haveModels = this.treeModels.size() > 0 || this.nodeModels.size() > 0 || this.tableModels.size() > 0 || this.hyperModels != null;
        final Models.CompoundModel newModel = this.hyperModels != null ? Models.createCompoundModel((List)this.hyperModels, (String)this.propertiesHelpID) : (haveModels ? Models.createCompoundModel((List)this.models, (String)this.propertiesHelpID) : null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ViewModelListener.this.view.getComponentCount() > 0) {
                    if (ViewModelListener.this.tabbedPane == null && ViewModelListener.this.view.getComponent(0) instanceof JTabbedPane) {
                        ViewModelListener.this.view.removeAll();
                    } else if (ViewModelListener.this.tabbedPane != null) {
                        ViewModelListener.this.view.removeAll();
                    }
                }
                if (ViewModelListener.this.view.getComponentCount() == 0) {
                    if (haveModels) {
                        ViewModelListener.this.view.add(Models.createView((Models.CompoundModel)newModel));
                        ViewModelListener.this.view.revalidate();
                        ViewModelListener.this.view.repaint();
                    } else if (ViewModelListener.this.tabbedPane != null) {
                        int n = ViewModelListener.this.tabbedPane.getTabCount();
                        for (int i = 0; i < n; ++i) {
                            Component c = ViewModelListener.this.tabbedPane.getComponentAt(i);
                            if (c instanceof JPanel) {
                                c = (Component)((JPanel)c).getClientProperty(JLabel.class.getName());
                            }
                            if (!(c instanceof JLabel)) continue;
                            String id = ((JLabel)c).getText();
                            if (ViewModelListener.this.providerToDisplay != null) {
                                id = ViewModelListener.this.providerToDisplay.getTypeID() + "/" + id;
                            }
                            JPanel contentComponent = new JPanel(new BorderLayout());
                            ViewModelListener.this.subListeners.add(new ViewModelListener(ViewModelListener.this.viewType + "/" + id, contentComponent, buttonsSubPane, ViewModelListener.this.propertiesHelpID, ViewModelListener.this.viewIcon));
                            ViewModelListener.this.tabbedPane.setComponentAt(i, contentComponent);
                            contentComponent.putClientProperty(JLabel.class.getName(), c);
                        }
                        ViewModelListener.this.view.add(ViewModelListener.this.tabbedPane);
                        ViewModelListener.this.view.revalidate();
                        ViewModelListener.this.view.repaint();
                    }
                } else if (ViewModelListener.this.tabbedPane == null) {
                    if (!haveModels) {
                        ViewModelListener.this.view.removeAll();
                        ViewModelListener.this.view.revalidate();
                        ViewModelListener.this.view.repaint();
                    } else {
                        JComponent tree = (JComponent)ViewModelListener.this.view.getComponent(0);
                        Models.setModelsToView((JComponent)tree, (Models.CompoundModel)newModel);
                    }
                }
            }
        });
    }

    private JButton createSessionsSwitchButton() {
        final JButton b = new JButton(new ImageIcon(this.viewIcon));
        b.setToolTipText(NbBundle.getMessage(ViewModelListener.class, (String)"Tooltip_SelectSrc"));
        b.setMargin(new Insets(2, 2, 2, 2));
        b.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == b) {
                    JPopupMenu m = new JPopupMenu();
                    if (ViewModelListener.this.currentSession != null) {
                        JMenuItem mi = new JMenuItem(ViewModelListener.this.currentSession.getName());
                        mi.putClientProperty("SESSION", ViewModelListener.this.currentSession);
                        mi.addActionListener(this);
                        m.add(mi);
                    }
                    for (SessionProvider sp : ViewModelListener.this.sessionProviders) {
                        JMenuItem mi = new JMenuItem(sp.getSessionName());
                        mi.putClientProperty("SESSION", sp);
                        mi.addActionListener(this);
                        m.add(mi);
                    }
                    Point pos = b.getMousePosition();
                    if (pos == null) {
                        pos = new Point(b.getWidth(), b.getHeight());
                    }
                    m.show(b, pos.x, pos.y);
                } else {
                    JMenuItem mi = (JMenuItem)e.getSource();
                    Object s = mi.getClientProperty("SESSION");
                    ViewModelListener viewModelListener = ViewModelListener.this;
                    synchronized (viewModelListener) {
                        if (s instanceof Session) {
                            ViewModelListener.this.providerToDisplay = null;
                        } else {
                            ViewModelListener.this.providerToDisplay = (SessionProvider)s;
                        }
                    }
                    ViewModelListener.this.updateModel();
                }
            }
        });
        return b;
    }

    private Models.CompoundModel createCompound(String viewName) {
        String viewPath;
        DebuggerManager cp;
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        DebuggerEngine e = dm.getCurrentEngine();
        List localSessionProviders = e == null ? dm.lookup(viewName, SessionProvider.class) : DebuggerManager.join((ContextProvider)e, (ContextProvider)dm).lookup(viewName, SessionProvider.class);
        if (!localSessionProviders.contains(this.providerToDisplay)) {
            this.providerToDisplay = null;
        }
        if (e == null && this.providerToDisplay == null && localSessionProviders.size() > 0) {
            this.providerToDisplay = (SessionProvider)localSessionProviders.get(0);
        }
        if (this.providerToDisplay != null) {
            e = null;
            cp = dm;
            viewPath = viewName + "/" + this.providerToDisplay.getTypeID();
        } else {
            cp = e != null ? DebuggerManager.join((ContextProvider)e, (ContextProvider)dm) : dm;
            viewPath = viewName;
        }
        List treeModels = cp.lookup(viewPath, TreeModel.class);
        List treeModelFilters = cp.lookup(viewPath, TreeModelFilter.class);
        List treeExpansionModels = cp.lookup(viewPath, TreeExpansionModel.class);
        List treeExpansionModelFilters = cp.lookup(viewPath, TreeExpansionModelFilter.class);
        List nodeModels = cp.lookup(viewPath, NodeModel.class);
        List nodeModelFilters = cp.lookup(viewPath, NodeModelFilter.class);
        List tableModels = cp.lookup(viewPath, TableModel.class);
        List tableModelFilters = cp.lookup(viewPath, TableModelFilter.class);
        List nodeActionsProviders = cp.lookup(viewPath, NodeActionsProvider.class);
        List nodeActionsProviderFilters = cp.lookup(viewPath, NodeActionsProviderFilter.class);
        List columnModels = cp.lookup(viewPath, ColumnModel.class);
        List mm = cp.lookup(viewPath, Model.class);
        List asynchModelFilters = cp.lookup(viewPath, AsynchronousModelFilter.class);
        List tableRenderers = cp.lookup(viewPath, TableRendererModel.class);
        List tableRendererFilters = cp.lookup(viewPath, TableRendererModelFilter.class);
        String searchPath = viewPath;
        while (asynchModelFilters.isEmpty() && searchPath != null) {
            int i = searchPath.lastIndexOf(47);
            searchPath = i > 0 ? searchPath.substring(0, i) : null;
            asynchModelFilters = cp.lookup(searchPath, AsynchronousModelFilter.class);
        }
        ArrayList<List> treeNodeModelsCompound = new ArrayList<List>(13);
        treeNodeModelsCompound.add(treeModels);
        treeNodeModelsCompound.add(treeModelFilters);
        treeNodeModelsCompound.add(treeExpansionModels);
        treeNodeModelsCompound.add(nodeModels);
        treeNodeModelsCompound.add(nodeModelFilters);
        treeNodeModelsCompound.add(tableModels);
        treeNodeModelsCompound.add(tableModelFilters);
        treeNodeModelsCompound.add(nodeActionsProviders);
        treeNodeModelsCompound.add(nodeActionsProviderFilters);
        treeNodeModelsCompound.add(columnModels);
        treeNodeModelsCompound.add(mm);
        treeNodeModelsCompound.add(treeExpansionModelFilters);
        treeNodeModelsCompound.add(asynchModelFilters);
        treeNodeModelsCompound.add(tableRenderers);
        treeNodeModelsCompound.add(tableRendererFilters);
        Models.CompoundModel treeNodeModel = Models.createCompoundModel(treeNodeModelsCompound);
        return treeNodeModel;
    }

    private class ViewPreferenceChangeListener
    implements PreferenceChangeListener {
        private ViewPreferenceChangeListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String key = evt.getKey();
            if ("show_watches".equals(key) || "show_evaluator_result".equals(key)) {
                ViewModelListener.this.updateModel();
            }
        }
    }

    private class ModelsChangeRefresher
    implements PropertyChangeListener,
    Runnable {
        private RequestProcessor.Task task;

        private ModelsChangeRefresher() {
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            if (this.task == null) {
                this.task = new RequestProcessor(ModelsChangeRefresher.class.getName(), 1).create((Runnable)this);
            }
            this.task.schedule(1);
        }

        @Override
        public void run() {
            ViewModelListener.this.refreshModel();
        }
    }
}

